/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.projects.NewProjectAction;
import org.netbeans.modules.projects.ProjectDataObject;
import org.netbeans.modules.projects.ProjectManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.ProjectCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

public class ProjectManagerPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    public static final String PROP_CLOSE_DIALOG = "PROP_CLOSE_DIALOG";
    private ExplorerManager manager;
    private JButton openButton;
    private JLabel projectListLabel;
    private JButton newButton;
    private JButton renameButton;
    private ListView projectList;
    private JButton saveAsButton;
    private JButton deleteButton;
    private JPanel controlPanel;
    private JButton importButton;
    static /* synthetic */ Class class$org$netbeans$modules$projects$importing$ImportProjectAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$netbeans$modules$projects$ProjectDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$projects$ProjectManagerPanel;

    public ProjectManagerPanel() {
        this.initComponents();
        this.initAccessibility();
        this.updateButtonState();
        this.getExplorerManager().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)this.getExplorerManager()));
        ProjectManager.getDefault().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)ProjectManager.getDefault()));
    }

    private void initAccessibility() {
        this.projectListLabel.setLabelFor((Component)this.projectList);
        this.projectListLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/projects/Bundle").getString("ACS_ProjectList"));
        this.newButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/projects/Bundle").getString("ACS_New"));
        this.openButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/projects/Bundle").getString("ACS_Open"));
        this.importButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/projects/Bundle").getString("ACS_Import"));
        this.saveAsButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/projects/Bundle").getString("ACS_SaveAs"));
        this.deleteButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/projects/Bundle").getString("ACS_Delete"));
        this.renameButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/projects/Bundle").getString("ACS_Rename"));
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/projects/Bundle").getString("ACSD_ProjectManager"));
    }

    private void initComponents() {
        this.projectListLabel = new JLabel();
        this.projectListLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/projects/Bundle").getString("CTL_ExistingProjects_Mnem").charAt(0));
        this.controlPanel = new JPanel();
        this.newButton = new JButton();
        this.openButton = new JButton();
        this.importButton = new JButton();
        this.saveAsButton = new JButton();
        this.deleteButton = new JButton();
        this.renameButton = new JButton();
        this.projectList = new ListView();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(400, 300));
        this.setMinimumSize(new Dimension(400, 300));
        this.setMaximumSize(new Dimension(600, 600));
        this.projectListLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/projects/Bundle").getString("CTL_ExistingProjects"));
        this.projectListLabel.setForeground(Color.black);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 5, 11);
        this.add((Component)this.projectListLabel, gridBagConstraints);
        this.controlPanel.setLayout(new GridLayout(6, 1, 0, 5));
        this.newButton.setMnemonic('N');
        this.newButton.setText(ResourceBundle.getBundle("org/netbeans/modules/projects/Bundle").getString("CTL_New"));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectManagerPanel.this.newButtonActionPerformed(actionEvent);
            }
        });
        this.controlPanel.add(this.newButton);
        this.openButton.setMnemonic('O');
        this.openButton.setText(ResourceBundle.getBundle("org/netbeans/modules/projects/Bundle").getString("CTL_Open"));
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectManagerPanel.this.openButtonActionPerformed(actionEvent);
            }
        });
        this.controlPanel.add(this.openButton);
        this.importButton.setMnemonic('I');
        this.importButton.setText(ResourceBundle.getBundle("org/netbeans/modules/projects/Bundle").getString("CTL_Import"));
        this.importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectManagerPanel.this.importButtonActionPerformed(actionEvent);
            }
        });
        this.controlPanel.add(this.importButton);
        this.saveAsButton.setMnemonic('V');
        this.saveAsButton.setText(ResourceBundle.getBundle("org/netbeans/modules/projects/Bundle").getString("CTL_SaveAs"));
        this.saveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectManagerPanel.this.saveAsButtonActionPerformed(actionEvent);
            }
        });
        this.controlPanel.add(this.saveAsButton);
        this.deleteButton.setMnemonic('D');
        this.deleteButton.setText(ResourceBundle.getBundle("org/netbeans/modules/projects/Bundle").getString("CTL_Delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectManagerPanel.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        this.controlPanel.add(this.deleteButton);
        this.renameButton.setMnemonic('R');
        this.renameButton.setText(ResourceBundle.getBundle("org/netbeans/modules/projects/Bundle").getString("CTL_Rename"));
        this.renameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectManagerPanel.this.renameButtonActionPerformed(actionEvent);
            }
        });
        this.controlPanel.add(this.renameButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 12, 12, 11);
        this.add((Component)this.controlPanel, gridBagConstraints);
        this.projectList.setTraversalAllowed(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.projectList, gridBagConstraints);
    }

    private void importButtonActionPerformed(ActionEvent actionEvent) {
        TopManager.getDefault().getActionManager().invokeAction((Action)SystemAction.get((Class)(class$org$netbeans$modules$projects$importing$ImportProjectAction == null ? (class$org$netbeans$modules$projects$importing$ImportProjectAction = ProjectManagerPanel.class$("org.netbeans.modules.projects.importing.ImportProjectAction")) : class$org$netbeans$modules$projects$importing$ImportProjectAction)), new ActionEvent(this, 1001, null));
    }

    private void renameButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray != null && nodeArray.length == 1) {
            TopManager.getDefault().getActionManager().invokeAction((Action)SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = ProjectManagerPanel.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)), new ActionEvent(nodeArray[0], 1001, null));
        }
        this.clearListSelection();
        this.updateButtonState();
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        final Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)ProjectManagerPanel.getString("MSG_ConfirmDelete"));
        if (NotifyDescriptor.YES_OPTION != TopManager.getDefault().notify((NotifyDescriptor)confirmation)) {
            return;
        }
        ProjectManager.getDefault().processTask(new Runnable(){
            static /* synthetic */ Class class$org$netbeans$modules$projects$ProjectDataObject;

            public void run() {
                try {
                    int n = 0;
                    while (n < nodeArray.length) {
                        ProjectDataObject projectDataObject = (ProjectDataObject)nodeArray[n].getCookie(class$org$netbeans$modules$projects$ProjectDataObject == null ? 7.class$("org.netbeans.modules.projects.ProjectDataObject") : class$org$netbeans$modules$projects$ProjectDataObject);
                        if (projectDataObject != null) {
                            projectDataObject.getPrimaryFile().delete();
                        }
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    private void saveAsButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray == null || nodeArray.length != 1) {
            return;
        }
        final ProjectDataObject projectDataObject = (ProjectDataObject)nodeArray[0].getCookie(class$org$netbeans$modules$projects$ProjectDataObject == null ? (class$org$netbeans$modules$projects$ProjectDataObject = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectDataObject")) : class$org$netbeans$modules$projects$ProjectDataObject);
        if (projectDataObject == null) {
            return;
        }
        final String string = NewProjectAction.getProjectName(projectDataObject.getName(), ProjectManagerPanel.getString("CTL_RenameLabel"), ProjectManagerPanel.getString("CTL_SaveAsDialogTitle"));
        if (string == null) {
            return;
        }
        ProjectManager.getDefault().processTask(new Runnable(){
            static /* synthetic */ Class class$org$openide$cookies$ProjectCookie;

            public void run() {
                try {
                    DataFolder dataFolder;
                    if (projectDataObject.isCurrentProject()) {
                        dataFolder = (ProjectCookie)projectDataObject.getCookie(class$org$openide$cookies$ProjectCookie == null ? (class$org$openide$cookies$ProjectCookie = 8.class$("org.openide.cookies.ProjectCookie")) : class$org$openide$cookies$ProjectCookie);
                        dataFolder.projectSave();
                    }
                    dataFolder = TopManager.getDefault().getPlaces().folders().projects();
                    ProjectDataObject projectDataObject2 = ProjectDataObject.createProject(dataFolder, string);
                    ProjectDataObject.copyProjectContent(projectDataObject, projectDataObject2);
                }
                catch (IOException iOException) {
                    TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
                }
            }

            static /* synthetic */ Class class$(String string2) {
                try {
                    return Class.forName(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        this.firePropertyChange(PROP_CLOSE_DIALOG, null, null);
        SwingUtilities.invokeLater(new Runnable(){
            static /* synthetic */ Class class$org$netbeans$modules$projects$NewProjectAction;

            public void run() {
                TopManager.getDefault().getActionManager().invokeAction((Action)SystemAction.get((Class)(class$org$netbeans$modules$projects$NewProjectAction == null ? (class$org$netbeans$modules$projects$NewProjectAction = 9.class$("org.netbeans.modules.projects.NewProjectAction")) : class$org$netbeans$modules$projects$NewProjectAction)), new ActionEvent(this, 1001, null));
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    private void openButtonActionPerformed(ActionEvent actionEvent) {
        final Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray == null || nodeArray.length != 1) {
            return;
        }
        ProjectManager.getDefault().processTask(new Runnable(){
            static /* synthetic */ Class class$org$openide$cookies$ProjectCookie;

            public void run() {
                try {
                    ProjectCookie projectCookie = (ProjectCookie)nodeArray[0].getCookie(class$org$openide$cookies$ProjectCookie == null ? (class$org$openide$cookies$ProjectCookie = 10.class$("org.openide.cookies.ProjectCookie")) : class$org$openide$cookies$ProjectCookie);
                    TopManager.getDefault().openProject(projectCookie);
                }
                catch (UserCancelException userCancelException) {
                }
                catch (IOException iOException) {
                    TopManager.getDefault().notifyException((Throwable)iOException);
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        this.firePropertyChange(PROP_CLOSE_DIALOG, null, null);
    }

    private void updateButtonState() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateButtonStateAWT();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectManagerPanel.this.updateButtonStateAWT();
                }
            });
        }
    }

    private void updateButtonStateAWT() {
        if (!ProjectManager.getDefault().isFinished()) {
            this.newButton.setEnabled(false);
            this.openButton.setEnabled(false);
            this.importButton.setEnabled(false);
            this.saveAsButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.renameButton.setEnabled(false);
            return;
        }
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        this.newButton.setEnabled(true);
        this.importButton.setEnabled(true);
        boolean bl = false;
        if (nodeArray != null && nodeArray.length > 0) {
            bl = true;
            int n = 0;
            while (n < nodeArray.length) {
                if (!nodeArray[n].canDestroy()) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        this.deleteButton.setEnabled(bl);
        bl = false;
        if (nodeArray != null && nodeArray.length == 1) {
            ProjectDataObject projectDataObject = (ProjectDataObject)nodeArray[0].getCookie(class$org$netbeans$modules$projects$ProjectDataObject == null ? (class$org$netbeans$modules$projects$ProjectDataObject = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectDataObject")) : class$org$netbeans$modules$projects$ProjectDataObject);
            bl = !projectDataObject.isCurrentProject();
        }
        this.openButton.setEnabled(bl);
        bl = nodeArray != null && nodeArray.length == 1;
        this.renameButton.setEnabled(bl);
        this.saveAsButton.setEnabled(bl);
    }

    private void clearListSelection() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ProjectManagerPanel.this.getExplorerManager().setSelectedNodes(new Node[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            ProjectManagerPanel projectManagerPanel = this;
            synchronized (projectManagerPanel) {
                if (this.manager == null) {
                    this.manager = new ExplorerManager();
                }
            }
        }
        return this.manager;
    }

    private static String getString(String string) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$ProjectManagerPanel == null ? (class$org$netbeans$modules$projects$ProjectManagerPanel = ProjectManagerPanel.class$("org.netbeans.modules.projects.ProjectManagerPanel")) : class$org$netbeans$modules$projects$ProjectManagerPanel), (String)string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("finished".equals(propertyChangeEvent.getPropertyName())) {
            this.clearListSelection();
        }
        this.updateButtonState();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

