/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.Action;
import org.netbeans.modules.projects.PSupport;
import org.netbeans.modules.projects.ProjectDataLoader;
import org.netbeans.modules.projects.ProjectDataNode;
import org.netbeans.modules.projects.settings.ProjectOption;
import org.openide.TopManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.cookies.CompilerCookie;
import org.openide.cookies.DebuggerCookie;
import org.openide.cookies.ExecCookie;
import org.openide.debugger.DebuggerException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;

public final class ProjectDataObject
extends DataFolder {
    static final long serialVersionUID = 3984322918015509710L;
    private static final String DEFAULT_PROJECT_NAME = "Default";
    private static final String PROJECT_LAYER_FOLDER = "system";
    static final String FILES_FOLDER = "Files";
    final PSupport support = new PSupport(this);
    private HashMap cookies = new HashMap(10);
    private static final Object LOCK = new Object();
    static /* synthetic */ Class class$org$netbeans$modules$projects$ProjectDataObject;
    static /* synthetic */ Class class$org$openide$cookies$ProjectCookie;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Clean;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Build;
    static /* synthetic */ Class class$org$openide$cookies$DebuggerCookie;
    static /* synthetic */ Class class$org$openide$cookies$ExecCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$loaders$DataObject$Container;

    static String getLocalizedString(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$projects$ProjectDataObject == null ? (class$org$netbeans$modules$projects$ProjectDataObject = ProjectDataObject.class$("org.netbeans.modules.projects.ProjectDataObject")) : class$org$netbeans$modules$projects$ProjectDataObject)).getString(string);
    }

    static String getLocalizedString(String string, Object object) {
        return MessageFormat.format(ProjectDataObject.getLocalizedString(string), object);
    }

    public static ProjectDataObject createProject(DataFolder dataFolder, String string) throws IOException {
        int n = string.lastIndexOf(46);
        String string2 = n <= 0 ? string : string.substring(0, n);
        String string3 = n <= 0 ? null : string.substring(n + 1);
        return ProjectDataObject.createProjectImpl(dataFolder, string2, string3, true);
    }

    private static ProjectDataObject createProjectImpl(DataFolder dataFolder, final String string, final String string2, boolean bl) throws IOException {
        final FileObject[] fileObjectArray = new FileObject[1];
        final FileObject fileObject = dataFolder.getPrimaryFile();
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject fileObject2;
                block4: {
                    String string3 = FileUtil.findFreeFileName((FileObject)fileObject, (String)string, (String)string2);
                    if (string2 != null && string2.length() > 0) {
                        string3 = string3 + "." + string2;
                    }
                    fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)string3);
                    if (ProjectDataObject.DEFAULT_PROJECT_NAME.equals(string)) {
                        try {
                            fileObject2.setAttribute("SystemFileSystem.localizingBundle", (Object)"org.netbeans.modules.projects.Bundle");
                        }
                        catch (IOException iOException) {
                            if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block4;
                            iOException.printStackTrace();
                        }
                    }
                }
                ProjectDataLoader.INSTANCE.markFile(fileObject2);
                fileObjectArray[0] = fileObject2;
            }
        });
        ProjectDataObject projectDataObject = ProjectDataObject.findPDO(fileObjectArray[0]);
        if (bl) {
            projectDataObject.support.setSave(4);
        }
        return projectDataObject;
    }

    private static ProjectDataObject findPDO(FileObject fileObject) throws IOException {
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        if (!(dataObject instanceof ProjectDataObject)) {
            try {
                ProjectDataLoader.INSTANCE.markFile(fileObject);
                dataObject.setValid(false);
            }
            catch (Exception exception) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
            }
            dataObject = DataObject.find((FileObject)fileObject);
            if (!(dataObject instanceof ProjectDataObject)) {
                throw new IOException("Project data object not recognized " + fileObject.getPackageNameExt('/', '.'));
            }
        }
        return (ProjectDataObject)dataObject;
    }

    public static ProjectDataObject createDefaultProject() throws IOException {
        DataFolder dataFolder = TopManager.getDefault().getPlaces().folders().projects();
        FileObject fileObject = dataFolder.getPrimaryFile();
        FileObject fileObject2 = fileObject.getFileObject(DEFAULT_PROJECT_NAME);
        ProjectDataObject projectDataObject = null;
        projectDataObject = fileObject2 != null && fileObject2.isFolder() ? ProjectDataObject.findPDO(fileObject2) : ProjectDataObject.createProject(dataFolder, DEFAULT_PROJECT_NAME);
        return projectDataObject;
    }

    public static void copyProjectContent(DataFolder dataFolder, DataFolder dataFolder2) throws IOException {
        FileSystem fileSystem = TopManager.getDefault().getRepository().getDefaultFileSystem();
        FileObject fileObject = dataFolder.getPrimaryFile();
        FileObject fileObject2 = dataFolder2.getPrimaryFile();
        boolean bl = false;
        if (fileObject.getFileSystem().equals(fileSystem)) {
            fileObject = ProjectDataObject.getLocalFromSFS(fileObject);
        } else if (fileObject.getFileSystem() instanceof MultiFileSystem) {
            bl = true;
        }
        if (fileObject2.getFileSystem().equals(fileSystem)) {
            fileObject2 = ProjectDataObject.getLocalFromSFS(fileObject2);
        } else if (fileObject2.getFileSystem() instanceof MultiFileSystem) {
            bl = true;
        }
        if (bl) {
            throw new IOException("Unable to copy project from/to MultiFileSystem, please file a bug in http://www.netbeans.org/issues/enter_bug.cgi against the projects module and attach this stack trace. Thanks.");
        }
        ProjectDataObject.copyContentR(fileObject, fileObject2);
        ProjectDataObject.copyAttributes(dataFolder.getPrimaryFile(), dataFolder2.getPrimaryFile());
        dataFolder2.getPrimaryFile().refresh();
    }

    public ProjectDataObject(FileObject fileObject, DataLoader dataLoader) throws DataObjectExistsException {
        super(fileObject, dataLoader);
        this.cookies.put(class$org$openide$cookies$ProjectCookie == null ? (class$org$openide$cookies$ProjectCookie = ProjectDataObject.class$("org.openide.cookies.ProjectCookie")) : class$org$openide$cookies$ProjectCookie, this.support);
        this.cookies.put(class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = ProjectDataObject.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile, new C(class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = ProjectDataObject.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile));
        this.cookies.put(class$org$openide$cookies$CompilerCookie$Clean == null ? (class$org$openide$cookies$CompilerCookie$Clean = ProjectDataObject.class$("org.openide.cookies.CompilerCookie$Clean")) : class$org$openide$cookies$CompilerCookie$Clean, new C(class$org$openide$cookies$CompilerCookie$Clean == null ? (class$org$openide$cookies$CompilerCookie$Clean = ProjectDataObject.class$("org.openide.cookies.CompilerCookie$Clean")) : class$org$openide$cookies$CompilerCookie$Clean));
        this.cookies.put(class$org$openide$cookies$CompilerCookie$Build == null ? (class$org$openide$cookies$CompilerCookie$Build = ProjectDataObject.class$("org.openide.cookies.CompilerCookie$Build")) : class$org$openide$cookies$CompilerCookie$Build, new C(class$org$openide$cookies$CompilerCookie$Build == null ? (class$org$openide$cookies$CompilerCookie$Build = ProjectDataObject.class$("org.openide.cookies.CompilerCookie$Build")) : class$org$openide$cookies$CompilerCookie$Build));
        this.cookies.put(class$org$openide$cookies$DebuggerCookie == null ? (class$org$openide$cookies$DebuggerCookie = ProjectDataObject.class$("org.openide.cookies.DebuggerCookie")) : class$org$openide$cookies$DebuggerCookie, new DE());
        this.cookies.put(class$org$openide$cookies$ExecCookie == null ? (class$org$openide$cookies$ExecCookie = ProjectDataObject.class$("org.openide.cookies.ExecCookie")) : class$org$openide$cookies$ExecCookie, new DE());
    }

    public void add(DataObject dataObject) throws IOException {
        dataObject.createShadow(this.getFilesFolder());
    }

    public boolean isCurrentProject() {
        Node node = TopManager.getDefault().getPlaces().nodes().projectDesktop();
        return node != null && node.getCookie(class$org$netbeans$modules$projects$ProjectDataObject == null ? (class$org$netbeans$modules$projects$ProjectDataObject = ProjectDataObject.class$("org.netbeans.modules.projects.ProjectDataObject")) : class$org$netbeans$modules$projects$ProjectDataObject) == this;
    }

    public boolean isDeleteAllowed() {
        return super.isDeleteAllowed() && !this.isCurrentProject();
    }

    public boolean isMoveAllowed() {
        return super.isMoveAllowed() && !this.isCurrentProject();
    }

    public Node.Cookie getCookie(Class clazz) {
        Object object = null;
        if (this.isValid()) {
            object = (class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = ProjectDataObject.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder).equals(clazz) || (class$org$openide$loaders$DataObject$Container == null ? (class$org$openide$loaders$DataObject$Container = ProjectDataObject.class$("org.openide.loaders.DataObject$Container")) : class$org$openide$loaders$DataObject$Container).equals(clazz) ? this.getFilesFolder() : (Node.Cookie)this.cookies.get(clazz);
        }
        if (object == null) {
            object = super.getCookie(clazz);
        }
        return object;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$projects$ProjectDataObject == null ? (class$org$netbeans$modules$projects$ProjectDataObject = ProjectDataObject.class$("org.netbeans.modules.projects.ProjectDataObject")) : class$org$netbeans$modules$projects$ProjectDataObject);
    }

    public boolean isAccessibleFromFolder(DataObject dataObject) {
        DataFolder dataFolder = this.getFilesFolder();
        return dataFolder == null ? false : this.findObject((DataObject.Container)dataFolder, dataObject);
    }

    public DataFolder getFilesFolder() {
        DataFolder dataFolder = null;
        try {
            final FileObject[] fileObjectArray = new FileObject[]{null};
            this.getPrimaryFile().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    Object object = LOCK;
                    synchronized (object) {
                        fileObjectArray[0] = ProjectDataObject.this.getPrimaryFile().getFileObject(ProjectDataObject.FILES_FOLDER);
                        if (fileObjectArray[0] == null) {
                            fileObjectArray[0] = ProjectDataObject.this.getPrimaryFile().createFolder(ProjectDataObject.FILES_FOLDER);
                        }
                    }
                }
            });
            if (fileObjectArray[0] != null) {
                dataFolder = DataFolder.findFolder((FileObject)fileObjectArray[0]);
            }
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
        }
        return dataFolder;
    }

    public FileObject getProjectLayerDir() throws IOException {
        FileObject fileObject = this.getPrimaryFile().getFileObject(PROJECT_LAYER_FOLDER);
        if (fileObject == null) {
            fileObject = this.getPrimaryFile().createFolder(PROJECT_LAYER_FOLDER);
        }
        return fileObject;
    }

    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        FileObject fileObject = this.getPrimaryFile();
        ProjectDataObject projectDataObject = ProjectDataObject.createProjectImpl(dataFolder, fileObject.getName(), fileObject.getExt(), false);
        ProjectDataObject.copyProjectContent(this, projectDataObject);
        return projectDataObject;
    }

    protected void handleDelete() throws IOException {
        if (!this.isCurrentProject()) {
            super.handleDelete();
        }
    }

    protected Node createNodeDelegate() {
        return new ProjectDataNode(this);
    }

    private static void copyAttributes(FileObject fileObject, FileObject fileObject2) throws IOException {
        Enumeration enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = fileObject.getAttribute(string);
            fileObject2.setAttribute(string, object);
        }
    }

    private static void copyContentR(FileObject fileObject, FileObject fileObject2) throws IOException {
        FileObject[] fileObjectArray = fileObject.getChildren();
        int n = 0;
        while (n < fileObjectArray.length) {
            FileObject fileObject3;
            if (fileObjectArray[n].isFolder()) {
                fileObject3 = fileObject2.getFileObject(fileObjectArray[n].getNameExt());
                if (fileObject3 == null) {
                    fileObject3 = fileObject2.createFolder(fileObjectArray[n].getNameExt());
                }
                ProjectDataObject.copyAttributes(fileObjectArray[n], fileObject3);
                ProjectDataObject.copyContentR(fileObjectArray[n], fileObject3);
            } else {
                fileObject3 = fileObjectArray[n].copy(fileObject2, fileObjectArray[n].getName(), fileObjectArray[n].getExt());
                ProjectDataObject.copyAttributes(fileObjectArray[n], fileObject3);
            }
            ++n;
        }
    }

    private static FileObject getLocalFromSFS(FileObject fileObject) {
        String string = null;
        LocalFileSystem localFileSystem = null;
        string = System.getProperty("netbeans.user");
        if (null == string) {
            string = System.getProperty("netbeans.home");
        }
        if (string != null) {
            try {
                localFileSystem = new LocalFileSystem();
                localFileSystem.setRootDirectory(new File(string, PROJECT_LAYER_FOLDER));
            }
            catch (Exception exception) {
                localFileSystem = null;
            }
        }
        return localFileSystem == null ? null : localFileSystem.findResource(fileObject.getPackageNameExt('/', '.'));
    }

    private boolean findObject(DataObject.Container container, DataObject dataObject) {
        DataObject[] dataObjectArray = container.getChildren();
        int n = 0;
        while (n < dataObjectArray.length) {
            if (dataObjectArray[n] instanceof DataObject.Container ? this.findObject((DataObject.Container)dataObjectArray[n], dataObject) : dataObject == dataObjectArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class DE
    implements DebuggerCookie,
    ExecCookie {
        static /* synthetic */ Class class$org$openide$cookies$DebuggerCookie;
        static /* synthetic */ Class class$org$openide$cookies$ExecCookie;
        static /* synthetic */ Class class$org$netbeans$modules$projects$settings$ProjectOption;
        static /* synthetic */ Class class$org$netbeans$modules$projects$SetMainClassAction;

        private DE() {
        }

        public void debug(boolean bl) throws DebuggerException {
            DebuggerCookie debuggerCookie;
            DataObject dataObject = this.getMainClassObject();
            if (dataObject != null && (debuggerCookie = (DebuggerCookie)dataObject.getCookie(class$org$openide$cookies$DebuggerCookie == null ? (class$org$openide$cookies$DebuggerCookie = DE.class$("org.openide.cookies.DebuggerCookie")) : class$org$openide$cookies$DebuggerCookie)) != null) {
                debuggerCookie.debug(bl);
            }
        }

        public void start() {
            ExecCookie execCookie;
            DataObject dataObject = this.getMainClassObject();
            if (dataObject != null && (execCookie = (ExecCookie)dataObject.getCookie(class$org$openide$cookies$ExecCookie == null ? (class$org$openide$cookies$ExecCookie = DE.class$("org.openide.cookies.ExecCookie")) : class$org$openide$cookies$ExecCookie)) != null) {
                execCookie.start();
            }
        }

        private DataObject getMainClassObject() {
            ProjectOption projectOption = (ProjectOption)SharedClassObject.findObject((Class)(class$org$netbeans$modules$projects$settings$ProjectOption == null ? (class$org$netbeans$modules$projects$settings$ProjectOption = DE.class$("org.netbeans.modules.projects.settings.ProjectOption")) : class$org$netbeans$modules$projects$settings$ProjectOption), (boolean)true);
            DataObject dataObject = projectOption.getMainClass();
            if (dataObject == null) {
                TopManager.getDefault().getActionManager().invokeAction((Action)SystemAction.get((Class)(class$org$netbeans$modules$projects$SetMainClassAction == null ? (class$org$netbeans$modules$projects$SetMainClassAction = DE.class$("org.netbeans.modules.projects.SetMainClassAction")) : class$org$netbeans$modules$projects$SetMainClassAction)), new ActionEvent(this, 1001, null));
                dataObject = projectOption.getMainClass();
            }
            return dataObject;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class C
    implements CompilerCookie.Compile,
    CompilerCookie.Build,
    CompilerCookie.Clean {
        private CompilerCookie cookie = null;

        public C(Class clazz) {
            try {
                this.cookie = (CompilerCookie)ProjectDataObject.this.getFilesFolder().getCookie(clazz);
            }
            catch (Exception exception) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
            }
        }

        public void addToJob(CompilerJob compilerJob, Compiler.Depth depth) {
            if (this.cookie != null) {
                this.cookie.addToJob(compilerJob, Compiler.DEPTH_INFINITE);
            }
        }

        public boolean isDepthSupported(Compiler.Depth depth) {
            return true;
        }
    }
}

