/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.List;
import koala.dynamicjava.tree.Allocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.visitor.Visitor;

public class ArrayAllocation
extends Allocation {
    private TypeDescriptor typeDescriptor;

    public int getDimension() {
        return this.typeDescriptor.dimension;
    }

    public List getSizes() {
        return this.typeDescriptor.sizes;
    }

    public ArrayInitializer getInitialization() {
        return this.typeDescriptor.initialization;
    }

    public Object acceptVisitor(Visitor visitor) {
        return visitor.visit(this);
    }

    public ArrayAllocation(Type type, TypeDescriptor typeDescriptor) {
        this(type, typeDescriptor, null, 0, 0, 0, 0);
    }

    public ArrayAllocation(Type type, TypeDescriptor typeDescriptor, String string, int n, int n2, int n3, int n4) {
        super(type, string, n, n2, n3, n4);
        if (typeDescriptor == null) {
            throw new IllegalArgumentException("td == null");
        }
        this.typeDescriptor = typeDescriptor;
        typeDescriptor.initialize(type);
    }

    public static class TypeDescriptor {
        List sizes;
        int dimension;
        ArrayInitializer initialization;
        public int endLine;
        public int endColumn;

        void initialize(Type type) {
            if (this.initialization != null) {
                Type type2 = this.dimension > 1 ? new ArrayType(type, this.dimension, type.getFilename(), type.getBeginLine(), type.getBeginColumn(), this.endLine, this.endColumn) : type;
                this.initialization.setElementType(type2);
            }
        }

        public TypeDescriptor(List list, int n, ArrayInitializer arrayInitializer, int n2, int n3) {
            this.sizes = list;
            this.dimension = n;
            this.initialization = arrayInitializer;
            this.endLine = n2;
            this.endColumn = n3;
        }
    }
}

