/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import koala.dynamicjava.interpreter.InterpreterUtilities;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.context.MethodModificationError;
import koala.dynamicjava.interpreter.context.NoSuchFunctionException;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.modifier.ArrayModifier;
import koala.dynamicjava.interpreter.modifier.InvalidModifier;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.BinaryExpression;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.FunctionCall;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.PrimitiveType;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.UnaryExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.visitor.VisitorObject;
import koala.dynamicjava.util.Constants;

public class TypeChecker
extends VisitorObject {
    private Context context;
    private static /* synthetic */ Class class$Ljava$lang$Throwable;
    private static /* synthetic */ Class class$Ljava$lang$Object;
    private static /* synthetic */ Class class$Ljava$lang$Class;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$Cloneable;

    public Object visit(PackageDeclaration packageDeclaration) {
        this.context.setCurrentPackage(packageDeclaration.getName());
        return null;
    }

    public Object visit(ImportDeclaration importDeclaration) {
        if (importDeclaration.isPackage()) {
            this.context.declarePackageImport(importDeclaration.getName());
        } else {
            try {
                this.context.declareClassImport(importDeclaration.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new CatchedExceptionError(classNotFoundException, (Node)importDeclaration);
            }
        }
        return null;
    }

    public Object visit(WhileStatement whileStatement) {
        if (whileStatement.getCondition().acceptVisitor(this) != Boolean.TYPE) {
            throw new ExecutionError("condition.type", whileStatement);
        }
        whileStatement.getBody().acceptVisitor(this);
        return null;
    }

    public Object visit(ForStatement forStatement) {
        Expression expression;
        this.context.enterScope();
        List list = forStatement.getInitialization();
        if (list != null) {
            this.checkList(list);
        }
        if ((expression = forStatement.getCondition()) != null && expression.acceptVisitor(this) != Boolean.TYPE) {
            throw new ExecutionError("condition.type", forStatement);
        }
        list = forStatement.getUpdate();
        if (list != null) {
            this.checkList(list);
        }
        forStatement.getBody().acceptVisitor(this);
        forStatement.setProperty("variables", this.context.leaveScope());
        return null;
    }

    public Object visit(DoStatement doStatement) {
        doStatement.getBody().acceptVisitor(this);
        if (doStatement.getCondition().acceptVisitor(this) != Boolean.TYPE) {
            throw new ExecutionError("condition.type", doStatement);
        }
        return null;
    }

    public Object visit(SwitchStatement switchStatement) {
        Class clazz = (Class)switchStatement.getSelector().acceptVisitor(this);
        if (clazz != Character.TYPE && clazz != Byte.TYPE && clazz != Short.TYPE && clazz != Integer.TYPE) {
            switchStatement.setProperty("errorStrings", new String[]{clazz.getName()});
            throw new ExecutionError("selector.type", switchStatement);
        }
        Iterator iterator = switchStatement.getBindings().iterator();
        while (iterator.hasNext()) {
            SwitchBlock switchBlock = (SwitchBlock)iterator.next();
            switchBlock.acceptVisitor(this);
            Expression expression = switchBlock.getExpression();
            if (expression == null) continue;
            Class clazz2 = NodeProperties.getType(expression);
            if (clazz2 != Character.TYPE && clazz2 != Byte.TYPE && clazz2 != Short.TYPE && clazz2 != Integer.TYPE) {
                switchStatement.setProperty("errorStrings", new String[]{clazz2.getName()});
                throw new ExecutionError("switch.label.type", switchStatement);
            }
            if (clazz == clazz2) continue;
            Number number = null;
            if (expression.hasProperty("value")) {
                Object object = expression.getProperty("value");
                number = clazz2 == Character.TYPE ? (Number)new Integer(((Character)object).charValue()) : (Number)((Number)object);
            }
            if (clazz == Byte.TYPE) {
                if (expression.hasProperty("value")) {
                    if (number.byteValue() == number.intValue()) continue;
                    switchStatement.setProperty("errorStrings", new String[]{clazz.getName()});
                    throw new ExecutionError("switch.label.type", switchStatement);
                }
                throw new ExecutionError("switch.label.type", switchStatement);
            }
            if (clazz != Short.TYPE && clazz != Character.TYPE) continue;
            if (expression.hasProperty("value")) {
                if (number.shortValue() == number.intValue()) continue;
                switchStatement.setProperty("errorStrings", new String[]{clazz.getName()});
                throw new ExecutionError("switch.label.type", switchStatement);
            }
            if (clazz2 != Integer.TYPE) continue;
            switchStatement.setProperty("errorStrings", new String[]{clazz.getName()});
            throw new ExecutionError("switch.label.type", switchStatement);
        }
        return null;
    }

    public Object visit(SwitchBlock switchBlock) {
        List list;
        Expression expression = switchBlock.getExpression();
        if (expression != null) {
            expression.acceptVisitor(this);
        }
        if ((list = switchBlock.getStatements()) != null) {
            this.checkList(list);
        }
        return null;
    }

    public Object visit(LabeledStatement labeledStatement) {
        labeledStatement.getStatement().acceptVisitor(this);
        return null;
    }

    public Object visit(TryStatement tryStatement) {
        tryStatement.getTryBlock().acceptVisitor(this);
        Iterator iterator = tryStatement.getCatchStatements().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).acceptVisitor(this);
        }
        Node node = tryStatement.getFinallyBlock();
        if (node != null) {
            node.acceptVisitor(this);
        }
        return null;
    }

    public Object visit(CatchStatement catchStatement) {
        this.context.enterScope();
        Class clazz = (Class)catchStatement.getException().acceptVisitor(this);
        if (!(class$Ljava$lang$Throwable != null ? class$Ljava$lang$Throwable : (class$Ljava$lang$Throwable = TypeChecker.class$("java.lang.Throwable"))).isAssignableFrom(clazz)) {
            catchStatement.setProperty("errorStrings", new String[]{clazz.getName()});
            throw new ExecutionError("catch.type", catchStatement);
        }
        catchStatement.getBlock().acceptVisitor(this);
        this.context.leaveScope();
        catchStatement.setProperty("type", clazz);
        return null;
    }

    public Object visit(ThrowStatement throwStatement) {
        Class clazz;
        if (!(class$Ljava$lang$Throwable != null ? class$Ljava$lang$Throwable : (class$Ljava$lang$Throwable = TypeChecker.class$("java.lang.Throwable"))).isAssignableFrom(clazz = (Class)throwStatement.getExpression().acceptVisitor(this))) {
            throwStatement.setProperty("errorStrings", new String[]{clazz.getName()});
            throw new ExecutionError("throw.type", throwStatement);
        }
        return null;
    }

    public Object visit(ReturnStatement returnStatement) {
        Expression expression = returnStatement.getExpression();
        if (expression != null) {
            expression.acceptVisitor(this);
        }
        return null;
    }

    public Object visit(IfThenStatement ifThenStatement) {
        if (ifThenStatement.getCondition().acceptVisitor(this) != Boolean.TYPE) {
            throw new ExecutionError("condition.type", ifThenStatement);
        }
        ifThenStatement.getThenStatement().acceptVisitor(this);
        return null;
    }

    public Object visit(IfThenElseStatement ifThenElseStatement) {
        if (ifThenElseStatement.getCondition().acceptVisitor(this) != Boolean.TYPE) {
            throw new ExecutionError("condition.type", ifThenElseStatement);
        }
        ifThenElseStatement.getThenStatement().acceptVisitor(this);
        ifThenElseStatement.getElseStatement().acceptVisitor(this);
        return null;
    }

    public Object visit(SynchronizedStatement synchronizedStatement) {
        if (((Class)synchronizedStatement.getLock().acceptVisitor(this)).isPrimitive()) {
            throw new ExecutionError("lock.type", synchronizedStatement);
        }
        synchronizedStatement.getBody().acceptVisitor(this);
        return null;
    }

    public Object visit(Literal literal) {
        Class clazz = literal.getType();
        literal.setProperty("value", literal.getValue());
        literal.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(VariableDeclaration variableDeclaration) {
        Class clazz = (Class)variableDeclaration.getType().acceptVisitor(this);
        if (variableDeclaration.isFinal()) {
            this.context.defineConstant(variableDeclaration.getName(), clazz);
        } else {
            this.context.define(variableDeclaration.getName(), clazz);
        }
        Expression expression = variableDeclaration.getInitializer();
        if (expression != null) {
            Class clazz2 = (Class)expression.acceptVisitor(this);
            TypeChecker.checkAssignmentStaticRules(clazz, clazz2, variableDeclaration, expression);
        }
        return null;
    }

    public Object visit(BlockStatement blockStatement) {
        this.context.enterScope();
        this.checkList(blockStatement.getStatements());
        blockStatement.setProperty("variables", this.context.leaveScope());
        return null;
    }

    public Object visit(ObjectFieldAccess objectFieldAccess) {
        Class<?> clazz = (Class<?>)objectFieldAccess.getExpression().acceptVisitor(this);
        if (!clazz.isArray()) {
            Field field = null;
            try {
                field = this.context.getField(clazz, objectFieldAccess.getFieldName());
            }
            catch (Exception exception) {
                throw new CatchedExceptionError(exception, (Node)objectFieldAccess);
            }
            objectFieldAccess.setProperty("field", field);
            clazz = field.getType();
            objectFieldAccess.setProperty("type", clazz);
            objectFieldAccess.setProperty("modifier", this.context.getModifier(objectFieldAccess));
            return clazz;
        }
        if (!objectFieldAccess.getFieldName().equals("length")) {
            String string = "length";
            String string2 = clazz.getComponentType().getName() + " array";
            objectFieldAccess.setProperty("errorStrings", new String[]{string, string2});
            throw new ExecutionError("no.such.field", objectFieldAccess);
        }
        objectFieldAccess.setProperty("type", Integer.TYPE);
        objectFieldAccess.setProperty("modifier", new InvalidModifier(objectFieldAccess));
        return Integer.TYPE;
    }

    public Object visit(SuperFieldAccess superFieldAccess) {
        Field field = null;
        try {
            field = this.context.getSuperField(superFieldAccess, superFieldAccess.getFieldName());
        }
        catch (Exception exception) {
            throw new CatchedExceptionError(exception, (Node)superFieldAccess);
        }
        superFieldAccess.setProperty("field", field);
        Class<?> clazz = field.getType();
        superFieldAccess.setProperty("type", clazz);
        superFieldAccess.setProperty("modifier", this.context.getModifier(superFieldAccess));
        return clazz;
    }

    public Object visit(StaticFieldAccess staticFieldAccess) {
        Class<?> clazz = (Class<?>)staticFieldAccess.getFieldType().acceptVisitor(this);
        Field field = null;
        try {
            field = this.context.getField(clazz, staticFieldAccess.getFieldName());
        }
        catch (Exception exception) {
            throw new CatchedExceptionError(exception, (Node)staticFieldAccess);
        }
        staticFieldAccess.setProperty("field", field);
        clazz = field.getType();
        staticFieldAccess.setProperty("type", clazz);
        staticFieldAccess.setProperty("modifier", this.context.getModifier(staticFieldAccess));
        return clazz;
    }

    public Object visit(ObjectMethodCall objectMethodCall) {
        Expression expression = objectMethodCall.getExpression();
        Class<?> clazz = (Class<?>)expression.acceptVisitor(this);
        String string = objectMethodCall.getMethodName();
        if (!clazz.isArray() || clazz.isArray() && !string.equals("clone")) {
            Object object;
            List list = objectMethodCall.getArguments();
            Class[] classArray = Constants.EMPTY_CLASS_ARRAY;
            if (list != null) {
                classArray = new Class[list.size()];
                object = list.iterator();
                int n = 0;
                while (object.hasNext()) {
                    classArray[n++] = (Class)((Node)object.next()).acceptVisitor(this);
                }
            }
            object = null;
            try {
                object = this.context.lookupMethod(expression, string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                String string2 = clazz.getName();
                objectMethodCall.setProperty("errorStrings", new String[]{string, string2});
                throw new ExecutionError("no.such.method", objectMethodCall);
            }
            catch (MethodModificationError methodModificationError) {
                Expression expression2 = methodModificationError.getExpression();
                expression2.acceptVisitor(this);
                objectMethodCall.setExpression(expression2);
                object = methodModificationError.getMethod();
            }
            objectMethodCall.setProperty("method", object);
            clazz = ((Method)object).getReturnType();
            objectMethodCall.setProperty("type", clazz);
            return clazz;
        }
        if (!string.equals("clone") || objectMethodCall.getArguments() != null) {
            String string3 = "clone";
            String string4 = clazz.getComponentType().getName() + " array";
            objectMethodCall.setProperty("errorStrings", new String[]{string3, string4});
            throw new ExecutionError("no.such.method", objectMethodCall);
        }
        clazz = class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = TypeChecker.class$("java.lang.Object"));
        objectMethodCall.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(MethodDeclaration methodDeclaration) {
        this.context.defineFunction(methodDeclaration);
        methodDeclaration.setProperty("type", methodDeclaration.getReturnType().acceptVisitor(this));
        methodDeclaration.setProperty("functions", this.context.getFunctions());
        methodDeclaration.setProperty("importationManager", this.context.getImportationManager().clone());
        this.context.enterScope();
        this.checkList(methodDeclaration.getParameters());
        this.context.leaveScope();
        return null;
    }

    public Object visit(FunctionCall functionCall) {
        Object object;
        List list = functionCall.getArguments();
        Class[] classArray = Constants.EMPTY_CLASS_ARRAY;
        if (list != null) {
            classArray = new Class[list.size()];
            object = list.iterator();
            int n = 0;
            while (object.hasNext()) {
                classArray[n++] = (Class)((Node)object.next()).acceptVisitor(this);
            }
        }
        object = null;
        try {
            object = this.context.lookupFunction(functionCall.getMethodName(), classArray);
        }
        catch (NoSuchFunctionException noSuchFunctionException) {
            String string = functionCall.getMethodName();
            functionCall.setProperty("errorStrings", new String[]{string});
            throw new ExecutionError("no.such.function", functionCall);
        }
        functionCall.setProperty("function", object);
        Class clazz = NodeProperties.getType((Node)object);
        functionCall.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(SuperMethodCall superMethodCall) {
        Object object;
        List list = superMethodCall.getArguments();
        Class[] classArray = Constants.EMPTY_CLASS_ARRAY;
        if (list != null) {
            classArray = new Class[list.size()];
            object = list.iterator();
            int n = 0;
            while (object.hasNext()) {
                classArray[n++] = (Class)((Node)object.next()).acceptVisitor(this);
            }
        }
        object = null;
        try {
            object = this.context.lookupSuperMethod(superMethodCall, superMethodCall.getMethodName(), classArray);
        }
        catch (Exception exception) {
            throw new CatchedExceptionError(exception, (Node)superMethodCall);
        }
        superMethodCall.setProperty("method", object);
        Class<?> clazz = ((Method)object).getReturnType();
        superMethodCall.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(StaticMethodCall staticMethodCall) {
        Object object;
        List list = staticMethodCall.getArguments();
        Class[] classArray = Constants.EMPTY_CLASS_ARRAY;
        if (list != null) {
            classArray = new Class[list.size()];
            object = list.iterator();
            int n = 0;
            while (object.hasNext()) {
                classArray[n++] = (Class)((Node)object.next()).acceptVisitor(this);
            }
        }
        object = null;
        ReferenceType referenceType = staticMethodCall.getMethodType();
        Class<?> clazz = (Class<?>)((Node)referenceType).acceptVisitor(this);
        try {
            object = this.context.lookupMethod(referenceType, staticMethodCall.getMethodName(), classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = staticMethodCall.getMethodName();
            String string2 = clazz.getName();
            staticMethodCall.setProperty("errorStrings", new String[]{string, string2});
            throw new ExecutionError("no.such.method", staticMethodCall);
        }
        staticMethodCall.setProperty("method", object);
        clazz = ((Method)object).getReturnType();
        staticMethodCall.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(SimpleAssignExpression simpleAssignExpression) {
        Object object;
        Expression expression = simpleAssignExpression.getLeftExpression();
        Expression expression2 = simpleAssignExpression.getRightExpression();
        Class clazz = (Class)expression2.acceptVisitor(this);
        if (expression instanceof QualifiedName && !this.context.exists((String)(object = ((QualifiedName)expression).getRepresentation()))) {
            this.context.define((String)object, clazz == null ? (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = TypeChecker.class$("java.lang.Object"))) : clazz);
        }
        object = (Class)expression.acceptVisitor(this);
        if (!expression.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", simpleAssignExpression);
        }
        TypeChecker.checkAssignmentStaticRules((Class)object, clazz, simpleAssignExpression, expression2);
        simpleAssignExpression.setProperty("type", object);
        return object;
    }

    public Object visit(QualifiedName qualifiedName) {
        String string = qualifiedName.getRepresentation();
        Class clazz = (Class)this.context.get(string);
        qualifiedName.setProperty("type", clazz);
        qualifiedName.setProperty("modifier", this.context.getModifier(qualifiedName));
        return clazz;
    }

    public Object visit(SimpleAllocation simpleAllocation) {
        Type type = simpleAllocation.getCreationType();
        Class clazz = (Class)type.acceptVisitor(this);
        List list = simpleAllocation.getArguments();
        Class[] classArray = Constants.EMPTY_CLASS_ARRAY;
        if (list != null) {
            classArray = new Class[list.size()];
            ListIterator listIterator = list.listIterator();
            int n = 0;
            while (listIterator.hasNext()) {
                classArray[n++] = (Class)((Node)listIterator.next()).acceptVisitor(this);
            }
        }
        return this.context.setProperties(simpleAllocation, clazz, classArray);
    }

    public Object visit(InnerAllocation innerAllocation) {
        Object object;
        Class clazz = (Class)innerAllocation.getExpression().acceptVisitor(this);
        Type type = innerAllocation.getCreationType();
        if (!(type instanceof ReferenceType)) {
            throw new ExecutionError("allocation.type", innerAllocation);
        }
        Object object2 = (ReferenceType)type;
        ((ReferenceType)object2).setRepresentation(clazz.getName() + "$" + ((ReferenceType)object2).getRepresentation());
        object2 = (Class)type.acceptVisitor(this);
        Class clazz2 = InterpreterUtilities.getDeclaringClass((Class)object2);
        List list = innerAllocation.getArguments();
        Class[] classArray = null;
        if (clazz2 != null && clazz2.isAssignableFrom(clazz)) {
            if (list != null) {
                classArray = new Class[list.size() + 1];
                classArray[0] = clazz;
                object = list.listIterator();
                int n = 1;
                while (object.hasNext()) {
                    classArray[n++] = (Class)((Node)object.next()).acceptVisitor(this);
                }
            } else {
                classArray = new Class[]{clazz};
            }
        } else {
            throw new ExecutionError("allocation.type", innerAllocation);
        }
        object = null;
        try {
            object = this.context.lookupConstructor((Class)object2, classArray);
        }
        catch (Exception exception) {
            throw new CatchedExceptionError(exception, (Node)innerAllocation);
        }
        innerAllocation.setProperty("type", object2);
        innerAllocation.setProperty("constructor", object);
        return object2;
    }

    public Object visit(ClassAllocation classAllocation) {
        if (classAllocation.hasProperty("type")) {
            return NodeProperties.getType(classAllocation);
        }
        Type type = classAllocation.getCreationType();
        Class clazz = (Class)type.acceptVisitor(this);
        List list = classAllocation.getArguments();
        Class[] classArray = Constants.EMPTY_CLASS_ARRAY;
        if (list != null) {
            classArray = new Class[list.size()];
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                classArray[n++] = (Class)((Node)iterator.next()).acceptVisitor(this);
            }
        }
        return this.context.setProperties(classAllocation, clazz, classArray, classAllocation.getMembers());
    }

    public Object visit(ArrayAllocation arrayAllocation) {
        Class clazz;
        Iterator iterator = arrayAllocation.getSizes().iterator();
        while (iterator.hasNext()) {
            clazz = (Class)((Node)iterator.next()).acceptVisitor(this);
            if (clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE) continue;
            throw new ExecutionError("array.dimension.type", arrayAllocation);
        }
        clazz = (Class)arrayAllocation.getCreationType().acceptVisitor(this);
        if (arrayAllocation.getInitialization() != null) {
            arrayAllocation.getInitialization().acceptVisitor(this);
        }
        Class<?> clazz2 = Array.newInstance(clazz, new int[arrayAllocation.getDimension()]).getClass();
        arrayAllocation.setProperty("type", clazz2);
        arrayAllocation.setProperty("componentType", clazz);
        return clazz2;
    }

    public Object visit(ArrayInitializer arrayInitializer) {
        arrayInitializer.getElementType().acceptVisitor(this);
        this.checkList(arrayInitializer.getCells());
        return null;
    }

    public Object visit(ArrayAccess arrayAccess) {
        Class clazz = (Class)arrayAccess.getExpression().acceptVisitor(this);
        if (!clazz.isArray()) {
            arrayAccess.setProperty("errorStrings", new String[]{clazz.getName()});
            throw new ExecutionError("array.required", arrayAccess);
        }
        Class<?> clazz2 = clazz.getComponentType();
        arrayAccess.setProperty("type", clazz2);
        arrayAccess.setProperty("modifier", new ArrayModifier(arrayAccess));
        clazz = (Class)arrayAccess.getCellNumber().acceptVisitor(this);
        if (clazz != Character.TYPE && clazz != Byte.TYPE && clazz != Short.TYPE && clazz != Integer.TYPE) {
            throw new ExecutionError("array.index.type", arrayAccess);
        }
        return clazz2;
    }

    public Object visit(PrimitiveType primitiveType) {
        Class clazz = primitiveType.getValue();
        primitiveType.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(ReferenceType referenceType) {
        Class clazz = null;
        try {
            clazz = this.context.lookupClass(referenceType.getRepresentation());
        }
        catch (ClassNotFoundException classNotFoundException) {
            referenceType.setProperty("errorStrings", new String[]{referenceType.getRepresentation()});
            throw new ExecutionError("undefined.class", referenceType);
        }
        referenceType.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(ArrayType arrayType) {
        Type type = arrayType.getElementType();
        Class clazz = (Class)type.acceptVisitor(this);
        Class<?> clazz2 = Array.newInstance(clazz, 0).getClass();
        arrayType.setProperty("type", clazz2);
        return clazz2;
    }

    public Object visit(TypeExpression typeExpression) {
        Class clazz = (Class)typeExpression.getType().acceptVisitor(this);
        typeExpression.setProperty("type", class$Ljava$lang$Class != null ? class$Ljava$lang$Class : (class$Ljava$lang$Class = TypeChecker.class$("java.lang.Class")));
        typeExpression.setProperty("value", clazz);
        return class$Ljava$lang$Class != null ? class$Ljava$lang$Class : (class$Ljava$lang$Class = TypeChecker.class$("java.lang.Class"));
    }

    public Object visit(NotExpression notExpression) {
        Expression expression = notExpression.getExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        if (clazz != Boolean.TYPE) {
            throw new ExecutionError("not.expression.type", notExpression);
        }
        notExpression.setProperty("type", clazz);
        if (expression.hasProperty("value")) {
            if (((Boolean)expression.getProperty("value")).booleanValue()) {
                notExpression.setProperty("value", Boolean.FALSE);
            } else {
                notExpression.setProperty("value", Boolean.TRUE);
            }
        }
        return clazz;
    }

    public Object visit(ComplementExpression complementExpression) {
        Expression expression = complementExpression.getExpression();
        Class<Integer> clazz = (Class<Integer>)expression.acceptVisitor(this);
        if (clazz == Character.TYPE || clazz == Byte.TYPE || clazz == Short.TYPE) {
            clazz = Integer.TYPE;
            complementExpression.setProperty("type", clazz);
        } else if (clazz == Integer.TYPE || clazz == Long.TYPE) {
            complementExpression.setProperty("type", clazz);
        } else {
            throw new ExecutionError("complement.expression.type", complementExpression);
        }
        if (expression.hasProperty("value")) {
            Object object = expression.getProperty("value");
            if (object instanceof Character) {
                object = new Integer(((Character)object).charValue());
            }
            object = clazz == Integer.TYPE ? (Number)new Integer(~((Number)object).intValue()) : (Number)new Long(((Number)object).longValue() ^ -1L);
            complementExpression.setProperty("value", object);
        }
        return clazz;
    }

    public Object visit(PlusExpression plusExpression) {
        Class clazz = this.visitUnaryOperation(plusExpression, "plus.expression.type");
        Expression expression = plusExpression.getExpression();
        if (expression.hasProperty("value")) {
            plusExpression.setProperty("value", InterpreterUtilities.plus(clazz, expression.getProperty("value")));
        }
        return clazz;
    }

    public Object visit(MinusExpression minusExpression) {
        Class clazz = this.visitUnaryOperation(minusExpression, "minus.expression.type");
        Expression expression = minusExpression.getExpression();
        if (expression.hasProperty("value")) {
            minusExpression.setProperty("value", InterpreterUtilities.minus(clazz, expression.getProperty("value")));
        }
        return clazz;
    }

    public Object visit(AddExpression addExpression) {
        Expression expression = addExpression.getLeftExpression();
        Expression expression2 = addExpression.getRightExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        Class clazz2 = (Class)expression2.acceptVisitor(this);
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = TypeChecker.class$("java.lang.String"));
        if (clazz != (class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = TypeChecker.class$("java.lang.String"))) && clazz2 != (class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = TypeChecker.class$("java.lang.String")))) {
            clazz3 = TypeChecker.visitNumericExpression(addExpression, "addition.type");
        } else {
            clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = TypeChecker.class$("java.lang.String"));
            addExpression.setProperty("type", clazz3);
        }
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            addExpression.setProperty("value", InterpreterUtilities.add(clazz3, expression.getProperty("value"), expression2.getProperty("value")));
        }
        return clazz3;
    }

    public Object visit(AddAssignExpression addAssignExpression) {
        Expression expression = addAssignExpression.getLeftExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        Class clazz2 = (Class)addAssignExpression.getRightExpression().acceptVisitor(this);
        if (!(clazz == (class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = TypeChecker.class$("java.lang.String"))) || clazz != null && clazz2 != null && clazz != Void.TYPE && clazz2 != Void.TYPE && clazz2 != Boolean.TYPE && clazz2.isPrimitive())) {
            throw new ExecutionError("addition.type", addAssignExpression);
        }
        if (!expression.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", addAssignExpression);
        }
        addAssignExpression.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(SubtractExpression subtractExpression) {
        Expression expression = subtractExpression.getLeftExpression();
        Expression expression2 = subtractExpression.getRightExpression();
        expression.acceptVisitor(this);
        expression2.acceptVisitor(this);
        Class clazz = TypeChecker.visitNumericExpression(subtractExpression, "subtraction.type");
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            subtractExpression.setProperty("value", InterpreterUtilities.subtract(clazz, expression.getProperty("value"), expression2.getProperty("value")));
        }
        return clazz;
    }

    public Object visit(SubtractAssignExpression subtractAssignExpression) {
        Expression expression = subtractAssignExpression.getLeftExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        Class clazz2 = (Class)subtractAssignExpression.getRightExpression().acceptVisitor(this);
        if (clazz == null || clazz2 == null || clazz == Void.TYPE || clazz2 == Void.TYPE || clazz == Boolean.TYPE || clazz2 == Boolean.TYPE || !clazz.isPrimitive() || !clazz2.isPrimitive()) {
            throw new ExecutionError("subtraction.type", subtractAssignExpression);
        }
        if (!expression.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", subtractAssignExpression);
        }
        subtractAssignExpression.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(MultiplyExpression multiplyExpression) {
        Expression expression = multiplyExpression.getLeftExpression();
        Expression expression2 = multiplyExpression.getRightExpression();
        expression.acceptVisitor(this);
        expression2.acceptVisitor(this);
        Class clazz = TypeChecker.visitNumericExpression(multiplyExpression, "multiplication.type");
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            multiplyExpression.setProperty("value", InterpreterUtilities.multiply(clazz, expression.getProperty("value"), expression2.getProperty("value")));
        }
        return clazz;
    }

    public Object visit(MultiplyAssignExpression multiplyAssignExpression) {
        Expression expression = multiplyAssignExpression.getLeftExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        Class clazz2 = (Class)multiplyAssignExpression.getRightExpression().acceptVisitor(this);
        if (clazz == null || clazz2 == null || clazz == Void.TYPE || clazz2 == Void.TYPE || clazz == Boolean.TYPE || clazz2 == Boolean.TYPE || !clazz.isPrimitive() || !clazz2.isPrimitive()) {
            throw new ExecutionError("multiplication.type", multiplyAssignExpression);
        }
        if (!expression.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", multiplyAssignExpression);
        }
        multiplyAssignExpression.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(DivideExpression divideExpression) {
        Expression expression = divideExpression.getLeftExpression();
        Expression expression2 = divideExpression.getRightExpression();
        expression.acceptVisitor(this);
        expression2.acceptVisitor(this);
        Class clazz = TypeChecker.visitNumericExpression(divideExpression, "division.type");
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            divideExpression.setProperty("value", InterpreterUtilities.divide(clazz, expression.getProperty("value"), expression2.getProperty("value")));
        }
        return clazz;
    }

    public Object visit(DivideAssignExpression divideAssignExpression) {
        Expression expression = divideAssignExpression.getLeftExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        Class clazz2 = (Class)divideAssignExpression.getRightExpression().acceptVisitor(this);
        if (clazz == null || clazz2 == null || clazz == Void.TYPE || clazz2 == Void.TYPE || clazz == Boolean.TYPE || clazz2 == Boolean.TYPE || !clazz.isPrimitive() || !clazz2.isPrimitive()) {
            throw new ExecutionError("division.type", divideAssignExpression);
        }
        if (!expression.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", divideAssignExpression);
        }
        divideAssignExpression.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(RemainderExpression remainderExpression) {
        Expression expression = remainderExpression.getLeftExpression();
        Expression expression2 = remainderExpression.getRightExpression();
        expression.acceptVisitor(this);
        expression2.acceptVisitor(this);
        Class clazz = TypeChecker.visitNumericExpression(remainderExpression, "remainder.type");
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            remainderExpression.setProperty("value", InterpreterUtilities.remainder(clazz, expression.getProperty("value"), expression2.getProperty("value")));
        }
        return clazz;
    }

    public Object visit(RemainderAssignExpression remainderAssignExpression) {
        Expression expression = remainderAssignExpression.getLeftExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        Class clazz2 = (Class)remainderAssignExpression.getRightExpression().acceptVisitor(this);
        if (clazz == null || clazz2 == null || clazz == Void.TYPE || clazz2 == Void.TYPE || clazz == Boolean.TYPE || clazz2 == Boolean.TYPE || !clazz.isPrimitive() || !clazz2.isPrimitive()) {
            throw new ExecutionError("remainder.type", remainderAssignExpression);
        }
        if (!expression.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", remainderAssignExpression);
        }
        remainderAssignExpression.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(EqualExpression equalExpression) {
        Expression expression = equalExpression.getLeftExpression();
        Expression expression2 = equalExpression.getRightExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        Class clazz2 = (Class)expression2.acceptVisitor(this);
        TypeChecker.checkEqualityStaticRules(clazz, clazz2, equalExpression);
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            equalExpression.setProperty("value", InterpreterUtilities.equalTo(clazz, clazz2, expression.getProperty("value"), expression2.getProperty("value")));
        }
        equalExpression.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    public Object visit(NotEqualExpression notEqualExpression) {
        Expression expression = notEqualExpression.getLeftExpression();
        Expression expression2 = notEqualExpression.getRightExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        Class clazz2 = (Class)expression2.acceptVisitor(this);
        TypeChecker.checkEqualityStaticRules(clazz, clazz2, notEqualExpression);
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            notEqualExpression.setProperty("value", InterpreterUtilities.notEqualTo(clazz, clazz2, expression.getProperty("value"), expression2.getProperty("value")));
        }
        notEqualExpression.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    public Object visit(LessExpression lessExpression) {
        Class clazz = this.visitRelationalExpression(lessExpression);
        Expression expression = lessExpression.getLeftExpression();
        Expression expression2 = lessExpression.getRightExpression();
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            lessExpression.setProperty("value", InterpreterUtilities.lessThan(expression.getProperty("value"), expression2.getProperty("value")));
        }
        return clazz;
    }

    public Object visit(LessOrEqualExpression lessOrEqualExpression) {
        Class clazz = this.visitRelationalExpression(lessOrEqualExpression);
        Expression expression = lessOrEqualExpression.getLeftExpression();
        Expression expression2 = lessOrEqualExpression.getRightExpression();
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            lessOrEqualExpression.setProperty("value", InterpreterUtilities.lessOrEqual(expression.getProperty("value"), expression2.getProperty("value")));
        }
        return clazz;
    }

    public Object visit(GreaterExpression greaterExpression) {
        Class clazz = this.visitRelationalExpression(greaterExpression);
        Expression expression = greaterExpression.getLeftExpression();
        Expression expression2 = greaterExpression.getRightExpression();
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            greaterExpression.setProperty("value", InterpreterUtilities.greaterThan(expression.getProperty("value"), expression2.getProperty("value")));
        }
        return clazz;
    }

    public Object visit(GreaterOrEqualExpression greaterOrEqualExpression) {
        Class clazz = this.visitRelationalExpression(greaterOrEqualExpression);
        Expression expression = greaterOrEqualExpression.getLeftExpression();
        Expression expression2 = greaterOrEqualExpression.getRightExpression();
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            greaterOrEqualExpression.setProperty("value", InterpreterUtilities.greaterOrEqual(expression.getProperty("value"), expression2.getProperty("value")));
        }
        return clazz;
    }

    public Object visit(BitAndExpression bitAndExpression) {
        Class clazz = this.visitBitwiseExpression(bitAndExpression);
        Expression expression = bitAndExpression.getLeftExpression();
        Expression expression2 = bitAndExpression.getRightExpression();
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            bitAndExpression.setProperty("value", InterpreterUtilities.bitAnd(clazz, expression.getProperty("value"), expression2.getProperty("value")));
        }
        return clazz;
    }

    public Object visit(BitAndAssignExpression bitAndAssignExpression) {
        return this.visitBitwiseAssign(bitAndAssignExpression);
    }

    public Object visit(BitOrExpression bitOrExpression) {
        Class clazz = this.visitBitwiseExpression(bitOrExpression);
        Expression expression = bitOrExpression.getLeftExpression();
        Expression expression2 = bitOrExpression.getRightExpression();
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            bitOrExpression.setProperty("value", InterpreterUtilities.bitOr(clazz, expression.getProperty("value"), expression2.getProperty("value")));
        }
        return clazz;
    }

    public Object visit(BitOrAssignExpression bitOrAssignExpression) {
        return this.visitBitwiseAssign(bitOrAssignExpression);
    }

    public Object visit(ExclusiveOrExpression exclusiveOrExpression) {
        Class clazz = this.visitBitwiseExpression(exclusiveOrExpression);
        Expression expression = exclusiveOrExpression.getLeftExpression();
        Expression expression2 = exclusiveOrExpression.getRightExpression();
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            exclusiveOrExpression.setProperty("value", InterpreterUtilities.xOr(clazz, expression.getProperty("value"), expression2.getProperty("value")));
        }
        return clazz;
    }

    public Object visit(ExclusiveOrAssignExpression exclusiveOrAssignExpression) {
        return this.visitBitwiseAssign(exclusiveOrAssignExpression);
    }

    public Object visit(ShiftLeftExpression shiftLeftExpression) {
        Class clazz = this.visitShiftExpression(shiftLeftExpression);
        Expression expression = shiftLeftExpression.getLeftExpression();
        Expression expression2 = shiftLeftExpression.getRightExpression();
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            shiftLeftExpression.setProperty("value", InterpreterUtilities.shiftLeft(NodeProperties.getType(shiftLeftExpression), expression.getProperty("value"), expression2.getProperty("value")));
        }
        return clazz;
    }

    public Object visit(ShiftLeftAssignExpression shiftLeftAssignExpression) {
        Class clazz = this.visitShiftExpression(shiftLeftAssignExpression);
        if (!shiftLeftAssignExpression.getLeftExpression().hasProperty("modifier")) {
            throw new ExecutionError("shift.left.type", shiftLeftAssignExpression);
        }
        return clazz;
    }

    public Object visit(ShiftRightExpression shiftRightExpression) {
        Class clazz = this.visitShiftExpression(shiftRightExpression);
        Expression expression = shiftRightExpression.getLeftExpression();
        Expression expression2 = shiftRightExpression.getRightExpression();
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            shiftRightExpression.setProperty("value", InterpreterUtilities.shiftRight(NodeProperties.getType(shiftRightExpression), expression.getProperty("value"), expression2.getProperty("value")));
        }
        return clazz;
    }

    public Object visit(ShiftRightAssignExpression shiftRightAssignExpression) {
        Class clazz = this.visitShiftExpression(shiftRightAssignExpression);
        if (!shiftRightAssignExpression.getLeftExpression().hasProperty("modifier")) {
            throw new ExecutionError("shift.right.type", shiftRightAssignExpression);
        }
        return clazz;
    }

    public Object visit(UnsignedShiftRightExpression unsignedShiftRightExpression) {
        Class clazz = this.visitShiftExpression(unsignedShiftRightExpression);
        Expression expression = unsignedShiftRightExpression.getLeftExpression();
        Expression expression2 = unsignedShiftRightExpression.getRightExpression();
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            unsignedShiftRightExpression.setProperty("value", InterpreterUtilities.unsignedShiftRight(NodeProperties.getType(unsignedShiftRightExpression), expression.getProperty("value"), expression2.getProperty("value")));
        }
        return clazz;
    }

    public Object visit(UnsignedShiftRightAssignExpression unsignedShiftRightAssignExpression) {
        Class clazz = this.visitShiftExpression(unsignedShiftRightAssignExpression);
        if (!unsignedShiftRightAssignExpression.getLeftExpression().hasProperty("modifier")) {
            throw new ExecutionError("unsigned.shift.right.type", unsignedShiftRightAssignExpression);
        }
        return clazz;
    }

    public Object visit(AndExpression andExpression) {
        Expression expression = andExpression.getLeftExpression();
        Expression expression2 = andExpression.getRightExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        Class clazz2 = (Class)expression2.acceptVisitor(this);
        if (clazz != Boolean.TYPE || clazz2 != Boolean.TYPE) {
            throw new ExecutionError("and.type", andExpression);
        }
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            andExpression.setProperty("value", (Boolean)expression.getProperty("value") != false && (Boolean)expression2.getProperty("value") != false ? Boolean.TRUE : Boolean.FALSE);
        }
        andExpression.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    public Object visit(OrExpression orExpression) {
        Expression expression = orExpression.getLeftExpression();
        Expression expression2 = orExpression.getRightExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        Class clazz2 = (Class)expression2.acceptVisitor(this);
        if (clazz != Boolean.TYPE || clazz2 != Boolean.TYPE) {
            throw new ExecutionError("or.type", orExpression);
        }
        if (expression.hasProperty("value") && expression2.hasProperty("value")) {
            orExpression.setProperty("value", (Boolean)expression.getProperty("value") != false || (Boolean)expression2.getProperty("value") != false ? Boolean.TRUE : Boolean.FALSE);
        }
        orExpression.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    public Object visit(InstanceOfExpression instanceOfExpression) {
        instanceOfExpression.getReferenceType().acceptVisitor(this);
        if (((Class)instanceOfExpression.getExpression().acceptVisitor(this)).isPrimitive()) {
            throw new ExecutionError("left.expression", instanceOfExpression);
        }
        instanceOfExpression.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object visit(ConditionalExpression conditionalExpression) {
        void var6_30;
        if (conditionalExpression.getConditionExpression().acceptVisitor(this) != Boolean.TYPE) {
            throw new ExecutionError("condition.type", conditionalExpression);
        }
        Expression expression = conditionalExpression.getIfTrueExpression();
        Expression expression2 = conditionalExpression.getIfFalseExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        Class clazz2 = (Class)expression2.acceptVisitor(this);
        Object var6_6 = null;
        if (clazz == clazz2) {
            Class clazz3 = clazz;
        } else if (clazz == null) {
            Class clazz4 = clazz2;
        } else if (clazz2 == null) {
            Class clazz5 = clazz;
        } else if (!clazz.isPrimitive() && !clazz2.isPrimitive()) {
            if (clazz.isAssignableFrom(clazz2)) {
                Class clazz6 = clazz;
            } else {
                if (!clazz2.isAssignableFrom(clazz)) throw new ExecutionError("incompatible.types", conditionalExpression);
                Class clazz7 = clazz2;
            }
        } else {
            if (clazz == Boolean.TYPE || clazz2 == Boolean.TYPE || clazz == Void.TYPE || clazz2 == Void.TYPE) {
                throw new ExecutionError("incompatible.types", conditionalExpression);
            }
            if (clazz == Short.TYPE && clazz2 == Byte.TYPE || clazz == Byte.TYPE && clazz2 == Short.TYPE) {
                Class<Short> clazz8 = Short.TYPE;
            } else if ((clazz2 == Byte.TYPE || clazz2 == Short.TYPE || clazz2 == Character.TYPE) && expression.hasProperty("value") && clazz == Integer.TYPE) {
                Number number = (Number)expression.getProperty("value");
                if (clazz2 == Byte.TYPE) {
                    if (number.intValue() == number.byteValue()) {
                        Class<Byte> clazz9 = Byte.TYPE;
                    } else {
                        Class<Integer> clazz10 = Integer.TYPE;
                    }
                } else if (number.intValue() == number.shortValue()) {
                    Class<Comparable<Character>> clazz11 = clazz2 == Character.TYPE ? Character.TYPE : Short.TYPE;
                } else {
                    Class<Integer> clazz12 = Integer.TYPE;
                }
            } else if ((clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Character.TYPE) && expression2.hasProperty("value") && clazz2 == Integer.TYPE) {
                Number number = (Number)expression2.getProperty("value");
                if (clazz == Byte.TYPE) {
                    if (number.intValue() == number.byteValue()) {
                        Class<Byte> clazz13 = Byte.TYPE;
                    } else {
                        Class<Integer> clazz14 = Integer.TYPE;
                    }
                } else if (number.intValue() == number.shortValue()) {
                    Class<Comparable<Character>> clazz15 = clazz == Character.TYPE ? Character.TYPE : Short.TYPE;
                } else {
                    Class<Integer> clazz16 = Integer.TYPE;
                }
            } else if (clazz == Double.TYPE || clazz2 == Double.TYPE) {
                Class<Double> clazz17 = Double.TYPE;
            } else if (clazz == Float.TYPE || clazz2 == Float.TYPE) {
                Class<Float> clazz18 = Float.TYPE;
            } else if (clazz == Long.TYPE || clazz2 == Long.TYPE) {
                Class<Long> clazz19 = Long.TYPE;
            } else {
                Class<Integer> clazz20 = Integer.TYPE;
            }
        }
        conditionalExpression.setProperty("type", var6_30);
        return var6_30;
    }

    public Object visit(FormalParameter formalParameter) {
        Class clazz = (Class)formalParameter.getType().acceptVisitor(this);
        if (formalParameter.isFinal()) {
            this.context.defineConstant(formalParameter.getName(), clazz);
        } else {
            this.context.define(formalParameter.getName(), clazz);
        }
        formalParameter.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(PostIncrement postIncrement) {
        Expression expression = postIncrement.getExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        if (!clazz.isPrimitive() || clazz == Void.TYPE || clazz == Boolean.TYPE) {
            throw new ExecutionError("post.increment.type", postIncrement);
        }
        if (!expression.hasProperty("modifier")) {
            throw new ExecutionError("post.increment.type", postIncrement);
        }
        postIncrement.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(PreIncrement preIncrement) {
        Expression expression = preIncrement.getExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        if (!clazz.isPrimitive() || clazz == Void.TYPE || clazz == Boolean.TYPE) {
            throw new ExecutionError("pre.increment.type", preIncrement);
        }
        if (!expression.hasProperty("modifier")) {
            throw new ExecutionError("pre.increment.type", preIncrement);
        }
        preIncrement.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(PostDecrement postDecrement) {
        Expression expression = postDecrement.getExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        if (!clazz.isPrimitive() || clazz == Void.TYPE || clazz == Boolean.TYPE) {
            throw new ExecutionError("post.decrement.type", postDecrement);
        }
        if (!expression.hasProperty("modifier")) {
            throw new ExecutionError("post.decrement.type", postDecrement);
        }
        postDecrement.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(PreDecrement preDecrement) {
        Expression expression = preDecrement.getExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        if (!clazz.isPrimitive() || clazz == Void.TYPE || clazz == Boolean.TYPE) {
            throw new ExecutionError("pre.decrement.type", preDecrement);
        }
        if (!expression.hasProperty("modifier")) {
            throw new ExecutionError("pre.decrement.type", preDecrement);
        }
        preDecrement.setProperty("type", clazz);
        return clazz;
    }

    public Object visit(CastExpression castExpression) {
        Class clazz = (Class)castExpression.getTargetType().acceptVisitor(this);
        TypeChecker.checkCastStaticRules(clazz, (Class)castExpression.getExpression().acceptVisitor(this), castExpression);
        castExpression.setProperty("type", clazz);
        return clazz;
    }

    private Class visitUnaryOperation(UnaryExpression unaryExpression, String string) {
        Class clazz = (Class)unaryExpression.getExpression().acceptVisitor(this);
        if (clazz == Character.TYPE || clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE) {
            unaryExpression.setProperty("type", Integer.TYPE);
        } else if (clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE) {
            unaryExpression.setProperty("type", clazz);
        } else {
            throw new ExecutionError(string, unaryExpression);
        }
        return clazz;
    }

    private static Class visitNumericExpression(BinaryExpression binaryExpression, String string) {
        Class clazz = NodeProperties.getType(binaryExpression.getLeftExpression());
        Class clazz2 = NodeProperties.getType(binaryExpression.getRightExpression());
        Class<Number> clazz3 = null;
        if (clazz == null || clazz2 == null || clazz == Boolean.TYPE || clazz2 == Boolean.TYPE || !clazz.isPrimitive() || !clazz2.isPrimitive() || clazz == Void.TYPE || clazz2 == Void.TYPE) {
            throw new ExecutionError(string, binaryExpression);
        }
        if (clazz == Double.TYPE || clazz2 == Double.TYPE) {
            clazz3 = Double.TYPE;
            binaryExpression.setProperty("type", clazz3);
        } else if (clazz == Float.TYPE || clazz2 == Float.TYPE) {
            clazz3 = Float.TYPE;
            binaryExpression.setProperty("type", clazz3);
        } else if (clazz == Long.TYPE || clazz2 == Long.TYPE) {
            clazz3 = Long.TYPE;
            binaryExpression.setProperty("type", clazz3);
        } else {
            clazz3 = Integer.TYPE;
            binaryExpression.setProperty("type", clazz3);
        }
        return clazz3;
    }

    private static void checkAssignmentStaticRules(Class clazz, Class clazz2, Node node, Node node2) {
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                if (clazz == Boolean.TYPE && clazz2 != Boolean.TYPE) {
                    throw new ExecutionError("assignment.types", node);
                }
                if (clazz == Byte.TYPE && clazz2 != Byte.TYPE) {
                    Number number;
                    if (clazz2 == Integer.TYPE && node2.hasProperty("value") && (number = (Number)node2.getProperty("value")).intValue() == number.byteValue()) {
                        return;
                    }
                    throw new ExecutionError("assignment.types", node);
                }
                if ((clazz == Short.TYPE || clazz2 == Character.TYPE) && clazz2 != Byte.TYPE && clazz2 != Short.TYPE && clazz2 != Character.TYPE) {
                    Number number;
                    if (clazz2 == Integer.TYPE && node2.hasProperty("value") && (number = (Number)node2.getProperty("value")).intValue() == number.shortValue()) {
                        return;
                    }
                    throw new ExecutionError("assignment.types", node);
                }
                if (clazz == Integer.TYPE && clazz2 != Byte.TYPE && clazz2 != Short.TYPE && clazz2 != Character.TYPE && clazz2 != Integer.TYPE) {
                    throw new ExecutionError("assignment.types", node);
                }
                if (!(clazz != Long.TYPE || clazz2 != null && clazz2.isPrimitive() && clazz2 != Void.TYPE && clazz2 != Boolean.TYPE && clazz2 != Float.TYPE && clazz2 != Double.TYPE)) {
                    throw new ExecutionError("assignment.types", node);
                }
                if (!(clazz != Float.TYPE || clazz2 != null && clazz2.isPrimitive() && clazz2 != Void.TYPE && clazz2 != Boolean.TYPE && clazz2 != Double.TYPE)) {
                    throw new ExecutionError("assignment.types", node);
                }
                if (!(clazz != Double.TYPE || clazz2 != null && clazz2.isPrimitive() && clazz2 != Void.TYPE && clazz2 != Boolean.TYPE)) {
                    throw new ExecutionError("assignment.types", node);
                }
            } else if (clazz2 != null && !clazz.isAssignableFrom(clazz2) && !clazz2.isAssignableFrom(clazz)) {
                throw new ExecutionError("assignment.types", node);
            }
        }
    }

    private static void checkEqualityStaticRules(Class clazz, Class clazz2, Node node) {
        if (clazz != clazz2 || clazz == Void.TYPE) {
            if (clazz == Void.TYPE || clazz2 == Void.TYPE || clazz == Boolean.TYPE || clazz2 == Boolean.TYPE) {
                throw new ExecutionError("compare.type", node);
            }
            if (clazz == null && clazz2.isPrimitive() || clazz2 == null && clazz.isPrimitive()) {
                throw new ExecutionError("compare.type", node);
            }
            if (clazz != null && clazz2 != null) {
                if (clazz.isPrimitive() ^ clazz2.isPrimitive()) {
                    throw new ExecutionError("compare.type", node);
                }
                if (!(clazz.isPrimitive() || clazz2.isPrimitive() || clazz.isAssignableFrom(clazz2) || clazz2.isAssignableFrom(clazz))) {
                    throw new ExecutionError("compare.type", node);
                }
            }
        }
    }

    private Class visitRelationalExpression(BinaryExpression binaryExpression) {
        Class clazz = (Class)binaryExpression.getLeftExpression().acceptVisitor(this);
        Class clazz2 = (Class)binaryExpression.getRightExpression().acceptVisitor(this);
        if (clazz == null || clazz2 == null || clazz == Void.TYPE || clazz2 == Void.TYPE || clazz == Boolean.TYPE || clazz2 == Boolean.TYPE || !clazz.isPrimitive() || !clazz2.isPrimitive()) {
            throw new ExecutionError("relational.expression.type", binaryExpression);
        }
        binaryExpression.setProperty("type", Boolean.TYPE);
        return Boolean.TYPE;
    }

    private Class visitBitwiseExpression(BinaryExpression binaryExpression) {
        Class clazz = (Class)binaryExpression.getLeftExpression().acceptVisitor(this);
        Class clazz2 = (Class)binaryExpression.getRightExpression().acceptVisitor(this);
        Class<Constable> clazz3 = null;
        if (clazz == null || clazz2 == null || clazz == Void.TYPE || clazz2 == Void.TYPE || clazz == Float.TYPE || clazz2 == Float.TYPE || clazz == Double.TYPE || clazz2 == Double.TYPE || clazz == Boolean.TYPE ^ clazz2 == Boolean.TYPE || !clazz.isPrimitive() || !clazz2.isPrimitive()) {
            throw new ExecutionError("bitwise.expression.type", binaryExpression);
        }
        if (clazz == Long.TYPE || clazz2 == Long.TYPE) {
            clazz3 = Long.TYPE;
            binaryExpression.setProperty("type", clazz3);
        } else if (clazz == Boolean.TYPE) {
            clazz3 = Boolean.TYPE;
            binaryExpression.setProperty("type", clazz3);
        } else {
            clazz3 = Integer.TYPE;
            binaryExpression.setProperty("type", clazz3);
        }
        return clazz3;
    }

    private Class visitBitwiseAssign(BinaryExpression binaryExpression) {
        Expression expression = binaryExpression.getLeftExpression();
        Class clazz = (Class)expression.acceptVisitor(this);
        Class clazz2 = (Class)binaryExpression.getRightExpression().acceptVisitor(this);
        if (clazz == null || clazz2 == null || clazz == Void.TYPE || clazz2 == Void.TYPE || clazz == Float.TYPE || clazz2 == Float.TYPE || clazz == Double.TYPE || clazz2 == Double.TYPE || clazz == Boolean.TYPE ^ clazz2 == Boolean.TYPE || !clazz.isPrimitive() || !clazz2.isPrimitive()) {
            throw new ExecutionError("bitwise.expression.type", binaryExpression);
        }
        if (!expression.hasProperty("modifier")) {
            throw new ExecutionError("left.expression", binaryExpression);
        }
        binaryExpression.setProperty("type", clazz);
        return clazz;
    }

    private Class visitShiftExpression(BinaryExpression binaryExpression) {
        Class clazz = (Class)binaryExpression.getLeftExpression().acceptVisitor(this);
        Class clazz2 = (Class)binaryExpression.getRightExpression().acceptVisitor(this);
        Class<Number> clazz3 = null;
        if (clazz == null || clazz2 == null || clazz == Boolean.TYPE || clazz2 == Boolean.TYPE || clazz == Void.TYPE || clazz2 == Void.TYPE || clazz == Float.TYPE || clazz2 == Float.TYPE || clazz == Double.TYPE || clazz2 == Double.TYPE || !clazz.isPrimitive() || !clazz2.isPrimitive()) {
            throw new ExecutionError("shift.expression.type", binaryExpression);
        }
        if (clazz == Long.TYPE) {
            clazz3 = Long.TYPE;
            binaryExpression.setProperty("type", clazz3);
        } else {
            clazz3 = Integer.TYPE;
            binaryExpression.setProperty("type", clazz3);
        }
        return clazz3;
    }

    private static void checkCastStaticRules(Class clazz, Class clazz2, Node node) {
        if (clazz != clazz2) {
            if (clazz.isPrimitive()) {
                if (clazz == null || !clazz2.isPrimitive() || clazz2 == Boolean.TYPE || clazz2 == Void.TYPE) {
                    throw new ExecutionError("cast", node);
                }
            } else if (clazz2 != null) {
                if (clazz2.isArray()) {
                    if (clazz.isArray()) {
                        Class<?> clazz3 = clazz.getComponentType();
                        Class<?> clazz4 = clazz2.getComponentType();
                        if (clazz3.isPrimitive() && clazz4.isPrimitive()) {
                            if (clazz3 != clazz4) {
                                throw new ExecutionError("cast", node);
                            }
                        } else {
                            TypeChecker.checkCastStaticRules(clazz3, clazz4, node);
                        }
                    } else {
                        if (clazz.isInterface() && clazz != (class$Ljava$lang$Cloneable != null ? class$Ljava$lang$Cloneable : (class$Ljava$lang$Cloneable = TypeChecker.class$("java.lang.Cloneable")))) {
                            throw new ExecutionError("cast", node);
                        }
                        if (clazz != (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = TypeChecker.class$("java.lang.Object")))) {
                            throw new ExecutionError("cast", node);
                        }
                    }
                } else if (clazz2.isInterface() ? !clazz.isInterface() && (clazz.isArray() ? !(class$Ljava$lang$Cloneable != null ? class$Ljava$lang$Cloneable : (class$Ljava$lang$Cloneable = TypeChecker.class$("java.lang.Cloneable"))).isAssignableFrom(clazz2) : Modifier.isFinal(clazz.getModifiers()) && !clazz.isAssignableFrom(clazz2)) : (clazz.isInterface() ? Modifier.isFinal(clazz.getModifiers()) && !clazz.isAssignableFrom(clazz2) : !clazz2.isAssignableFrom(clazz) && !clazz.isAssignableFrom(clazz2))) {
                    throw new ExecutionError("cast", node);
                }
            }
        }
    }

    private void checkList(List list) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            ((Node)listIterator.next()).acceptVisitor(this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TypeChecker(Context context) {
        this.context = context;
    }
}

