/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.throwable.ThrownException;
import koala.dynamicjava.parser.wrapper.ParseError;
import koala.dynamicjava.tree.Node;

public class InterpreterException
extends Exception {
    protected SourceInformation sourceInformation;
    protected String message;

    public SourceInformation getSourceInformation() {
        return this.sourceInformation;
    }

    public String getMessage() {
        return this.message;
    }

    public InterpreterException(ParseError parseError) {
        if (parseError.getLine() != -1) {
            this.sourceInformation = new SourceInformation(parseError.getFilename(), parseError.getLine(), parseError.getColumn());
            this.message = "L" + parseError.getLine() + ", C" + parseError.getColumn() + " (" + parseError.getFilename() + "):\n" + parseError.getMessage();
        } else {
            this.message = parseError.getMessage();
        }
    }

    public InterpreterException(ExecutionError executionError) {
        Node node = executionError.getNode();
        if (node != null && node.getFilename() != null) {
            this.sourceInformation = new SourceInformation(node.getFilename(), node.getBeginLine(), node.getBeginColumn());
            this.message = "L" + node.getBeginLine() + ", C" + node.getBeginColumn() + " (" + node.getFilename() + "):\n";
        } else {
            this.message = "";
        }
        this.message = executionError instanceof CatchedExceptionError ? this.message + ((CatchedExceptionError)executionError).getException() : (executionError instanceof ThrownException ? this.message + ((ThrownException)executionError).getException() : this.message + executionError.getMessage());
    }

    public static class SourceInformation {
        private String filename;
        private int line;
        private int column;

        public String getFilename() {
            return this.filename;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public SourceInformation(String string, int n, int n2) {
            this.filename = string;
            this.line = n;
            this.column = n2;
        }
    }
}

