/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classinfo;

import java.util.Iterator;
import java.util.List;
import koala.dynamicjava.classinfo.ClassFinder;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.ConstructorInfo;
import koala.dynamicjava.classinfo.TypeVisitor;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.FormalParameter;

public class TreeConstructorInfo
implements ConstructorInfo {
    private ConstructorDeclaration constructorTree;
    private ClassFinder classFinder;
    private ClassInfo[] parameters;
    private ClassInfo[] exceptions;
    private ClassInfo declaringClass;
    private TypeVisitor typeVisitor;

    public ConstructorDeclaration getConstructorDeclaration() {
        return this.constructorTree;
    }

    public int getModifiers() {
        return this.constructorTree.getAccessFlags();
    }

    public ClassInfo[] getParameterTypes() {
        if (this.parameters == null) {
            List list = this.constructorTree.getParameters();
            Iterator iterator = list.iterator();
            this.parameters = new ClassInfo[list.size()];
            int n = 0;
            while (iterator.hasNext()) {
                FormalParameter formalParameter = (FormalParameter)iterator.next();
                this.parameters[n++] = (ClassInfo)formalParameter.getType().acceptVisitor(this.typeVisitor);
            }
        }
        return (ClassInfo[])this.parameters.clone();
    }

    public ClassInfo[] getExceptionTypes() {
        if (this.exceptions == null) {
            List list = this.constructorTree.getExceptions();
            Iterator iterator = list.iterator();
            this.exceptions = new ClassInfo[list.size()];
            int n = 0;
            while (iterator.hasNext()) {
                this.exceptions[n++] = this.lookupClass((String)iterator.next(), this.declaringClass);
            }
        }
        return (ClassInfo[])this.exceptions.clone();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TreeConstructorInfo)) {
            return false;
        }
        return this.constructorTree.equals(((TreeConstructorInfo)object).constructorTree);
    }

    private ClassInfo lookupClass(String string, ClassInfo classInfo) {
        try {
            if (classInfo == null) {
                return this.classFinder.lookupClass(string, classInfo);
            }
            return this.classFinder.lookupClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TreeConstructorInfo(ConstructorDeclaration constructorDeclaration, ClassFinder classFinder, ClassInfo classInfo) {
        this.constructorTree = constructorDeclaration;
        this.classFinder = classFinder;
        this.declaringClass = classInfo;
        this.typeVisitor = new TypeVisitor(this.classFinder, this.declaringClass);
    }
}

