/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.event.CVSEvent;
import org.netbeans.lib.cvsclient.event.FileAddedEvent;
import org.netbeans.lib.cvsclient.event.FileUpdatedEvent;
import org.netbeans.lib.cvsclient.file.FileHandler;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

public class UpdatedResponse
implements Response {
    private static final boolean DEBUG = false;
    private String localPath;
    private String repositoryPath;
    private String entryLine;
    private String mode;
    protected String localFile;

    public void process(LoggedDataInputStream loggedDataInputStream, ResponseServices responseServices) throws ResponseException {
        try {
            Serializable serializable;
            this.localPath = loggedDataInputStream.readLine();
            this.repositoryPath = loggedDataInputStream.readLine();
            this.entryLine = loggedDataInputStream.readLine();
            this.mode = loggedDataInputStream.readLine();
            String string = loggedDataInputStream.readLine();
            boolean bl = string.charAt(0) == 'z';
            int n = Integer.parseInt(bl ? string.substring(1) : string);
            String string2 = responseServices.convertPathname(this.localPath, this.repositoryPath);
            File file = new File(string2);
            this.localFile = file.getAbsolutePath();
            Entry entry = new Entry(this.entryLine);
            FileHandler fileHandler = bl ? responseServices.getGzipFileHandler() : responseServices.getUncompressedFileHandler();
            fileHandler.setNextFileDate(responseServices.getNextFileDate());
            if (entry.isBinary()) {
                fileHandler.writeBinaryFile(string2, this.mode, loggedDataInputStream, n);
            } else {
                fileHandler.writeTextFile(string2, this.mode, loggedDataInputStream, n);
            }
            String string3 = null;
            if (entry.getConflict() != null && entry.getConflict().charAt(0) == '+') {
                if (entry.getConflict().charAt(1) == '=') {
                    serializable = new Date(file.lastModified());
                    string3 = this.getEntryConflict((Date)serializable, true);
                } else {
                    string3 = entry.getConflict().substring(1);
                }
            } else {
                serializable = new Date(file.lastModified());
                string3 = this.getEntryConflict((Date)serializable, false);
            }
            entry.setConflict(string3);
            if (entry.isNewUserFile()) {
                entry.setConflict("dummy timestamp");
            }
            responseServices.updateAdminData(this.localPath, this.repositoryPath, entry);
            if (file.exists()) {
                serializable = new FileAddedEvent(this, string2);
                responseServices.getEventManager().fireCVSEvent((CVSEvent)serializable);
            } else {
                serializable = new FileUpdatedEvent(this, string2);
                responseServices.getEventManager().fireCVSEvent((CVSEvent)serializable);
            }
        }
        catch (IOException iOException) {
            throw new ResponseException(iOException);
        }
    }

    protected String getEntryConflict(Date date, boolean bl) {
        return Entry.getLastModifiedDateFormatter().format(date);
    }

    public boolean isTerminalResponse() {
        return false;
    }
}

