/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

public class ModTimeResponse
implements Response {
    protected static final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.US);
    protected static final String SERVER_DATE_FORMAT = "dd MMM yyyy HH:mm:ss";

    public void process(LoggedDataInputStream loggedDataInputStream, ResponseServices responseServices) throws ResponseException {
        try {
            String string = loggedDataInputStream.readLine();
            Date date = dateFormatter.parse(string.substring(0, string.length() - 6));
            if (date.getTime() < 0L) {
                if (date.getYear() < 100 && date.getYear() >= 70) {
                    date.setYear(date.getYear() + 1900);
                } else if (date.getYear() >= 0 && date.getYear() < 70) {
                    date.setYear(date.getYear() + 2000);
                } else {
                    throw new ResponseException("Cannot adjust negative time value (" + string + ")", CommandException.getLocalMessage("ModTimeResponse.badDate", new Object[]{string}));
                }
            }
            responseServices.setNextFileDate(date);
        }
        catch (Exception exception) {
            throw new ResponseException(exception);
        }
    }

    public boolean isTerminalResponse() {
        return false;
    }

    static {
        dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT+0000"));
    }
}

