/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.importcmd;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BuildableCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.importcmd.ImportBuilder;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.ArgumentxRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.ModifiedRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.RootRequest;
import org.netbeans.lib.cvsclient.util.SimpleStringPattern;

public class ImportCommand
extends BuildableCommand {
    private Map wrapperMap = new HashMap();
    private String logMessage;
    private String module;
    private String releaseTag;
    private String vendorBranch;
    private String vendorTag;
    private KeywordSubstitutionOptions keywordSubstitutionOptions;

    public ImportCommand() {
        this.resetCVSCommand();
    }

    public void addWrapper(String string, KeywordSubstitutionOptions keywordSubstitutionOptions) {
        if (keywordSubstitutionOptions == null) {
            throw new IllegalArgumentException("keywordSubstitutionOptions must not be null");
        }
        this.wrapperMap.put(new SimpleStringPattern(string), keywordSubstitutionOptions);
    }

    public void setWrappers(Map map) {
        this.wrapperMap = map;
    }

    public Map getWrappers() {
        return this.wrapperMap;
    }

    public KeywordSubstitutionOptions getKeywordSubstitutionOptions() {
        return this.keywordSubstitutionOptions;
    }

    public void setKeywordSubstitutionOptions(KeywordSubstitutionOptions keywordSubstitutionOptions) {
        this.keywordSubstitutionOptions = keywordSubstitutionOptions;
    }

    public String getReleaseTag() {
        return this.releaseTag;
    }

    public void setReleaseTag(String string) {
        this.releaseTag = Command.getTrimmedString(string);
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public void setLogMessage(String string) {
        this.logMessage = Command.getTrimmedString(string);
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = Command.getTrimmedString(string);
    }

    public String getVendorBranch() {
        return this.vendorBranch;
    }

    private String getVendorBranchNotNull() {
        if (this.vendorBranch == null) {
            return "1.1.1";
        }
        return this.vendorBranch;
    }

    public void setVendorBranch(String string) {
        this.vendorBranch = Command.getTrimmedString(string);
    }

    public String getVendorTag() {
        return this.vendorTag;
    }

    public void setVendorTag(String string) {
        this.vendorTag = Command.getTrimmedString(string);
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException {
        if (this.getLogMessage() == null) {
            String string = CommandException.getLocalMessage("ImportCommand.messageEmpty");
            throw new CommandException("message may not be null nor empty", string);
        }
        if (this.getModule() == null) {
            String string = CommandException.getLocalMessage("ImportCommand.moduleEmpty");
            throw new CommandException("module may not be null nor empty", string);
        }
        if (this.getReleaseTag() == null) {
            String string = CommandException.getLocalMessage("ImportCommand.releaseTagEmpty");
            throw new CommandException("release tag may not be null nor empty", string);
        }
        if (this.getVendorTag() == null) {
            String string = CommandException.getLocalMessage("ImportCommand.vendorTagEmpty");
            throw new CommandException("vendor tag may not be null nor empty", string);
        }
        super.execute(clientServices, eventManager);
        ArrayList<Request> arrayList = new ArrayList<Request>();
        try {
            if (clientServices.isFirstCommand()) {
                arrayList.add(new RootRequest(clientServices.getRepository()));
            }
            arrayList.add(new ArgumentRequest("-b"));
            arrayList.add(new ArgumentRequest(this.getVendorBranchNotNull()));
            if (this.getKeywordSubstitutionOptions() != null) {
                arrayList.add(new ArgumentRequest("-k"));
                arrayList.add(new ArgumentRequest(this.getKeywordSubstitutionOptions().toString()));
            }
            this.addMessageRequests(arrayList, this.getLogMessage());
            this.addWrapperRequests(arrayList, this.wrapperMap);
            arrayList.add(new ArgumentRequest(this.getModule()));
            arrayList.add(new ArgumentRequest(this.getVendorTag()));
            arrayList.add(new ArgumentRequest(this.getReleaseTag()));
            this.addFileRequests(new File(this.getLocalPath()), arrayList, clientServices);
            arrayList.add(new DirectoryRequest(".", this.getRepositoryRoot(clientServices)));
            arrayList.add(CommandRequest.IMPORT);
            clientServices.processRequests(arrayList);
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (EOFException eOFException) {
            String string = CommandException.getLocalMessage("CommandException.EndOfFile", null);
            throw new CommandException(eOFException, string);
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
    }

    public String getCVSCommand() {
        String string;
        StringBuffer stringBuffer = new StringBuffer("import ");
        stringBuffer.append(this.getCVSArguments());
        if (this.getModule() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(this.getModule());
        } else {
            string = CommandException.getLocalMessage("ImportCommand.moduleEmpty.text");
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        if (this.getVendorTag() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(this.getVendorTag());
        } else {
            string = CommandException.getLocalMessage("ImportCommand.vendorTagEmpty.text");
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        if (this.getReleaseTag() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(this.getReleaseTag());
        } else {
            string = CommandException.getLocalMessage("ImportCommand.releaseTagEmpty.text");
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.getLogMessage() != null) {
            stringBuffer.append("-m \"");
            stringBuffer.append(this.getLogMessage());
            stringBuffer.append("\" ");
        }
        if (this.getKeywordSubstitutionOptions() != null) {
            stringBuffer.append("-k");
            stringBuffer.append(this.getKeywordSubstitutionOptions().toString());
            stringBuffer.append(" ");
        }
        if (this.getVendorBranch() != null) {
            stringBuffer.append("-b ");
            stringBuffer.append(this.getVendorBranch());
            stringBuffer.append(" ");
        }
        if (this.wrapperMap.size() > 0) {
            Iterator iterator = this.wrapperMap.keySet().iterator();
            while (iterator.hasNext()) {
                SimpleStringPattern simpleStringPattern = (SimpleStringPattern)iterator.next();
                KeywordSubstitutionOptions keywordSubstitutionOptions = (KeywordSubstitutionOptions)this.wrapperMap.get(simpleStringPattern);
                stringBuffer.append("-W ");
                stringBuffer.append(simpleStringPattern.toString());
                stringBuffer.append(" -k '");
                stringBuffer.append(keywordSubstitutionOptions.toString());
                stringBuffer.append("' ");
            }
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'b') {
            this.setVendorBranch(string);
        } else if (c == 'm') {
            this.setLogMessage(string);
        } else if (c == 'k') {
            this.setKeywordSubstitutionOptions(KeywordSubstitutionOptions.findKeywordSubstOption(string));
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setLogMessage(null);
        this.setModule(null);
        this.setReleaseTag(null);
        this.setVendorTag(null);
        this.setVendorBranch(null);
        this.wrapperMap.clear();
    }

    public String getOptString() {
        return "m:W:b:k:";
    }

    private void addMessageRequests(List list, String string) {
        list.add(new ArgumentRequest("-m"));
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            if (bl) {
                list.add(new ArgumentRequest(stringTokenizer.nextToken()));
                bl = false;
                continue;
            }
            list.add(new ArgumentxRequest(stringTokenizer.nextToken()));
        }
    }

    private void addWrapperRequests(List list, Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            SimpleStringPattern simpleStringPattern = (SimpleStringPattern)iterator.next();
            KeywordSubstitutionOptions keywordSubstitutionOptions = (KeywordSubstitutionOptions)map.get(simpleStringPattern);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(simpleStringPattern.toString());
            stringBuffer.append(" -k '");
            stringBuffer.append(keywordSubstitutionOptions.toString());
            stringBuffer.append("'");
            list.add(new ArgumentRequest("-W"));
            list.add(new ArgumentRequest(stringBuffer.toString()));
        }
    }

    private void addFileRequests(File file, List list, ClientServices clientServices) throws IOException {
        Object object;
        Object object2;
        String string = this.getRelativeToLocalPathInUnixStyle(file);
        String string2 = this.getRepositoryRoot(clientServices);
        if (!string.equals(".")) {
            string2 = string2 + '/' + string;
        }
        list.add(new DirectoryRequest(string, string2));
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        LinkedList<Object> linkedList = null;
        int n = 0;
        while (n < fileArray.length) {
            object2 = fileArray[n];
            object = ((File)object2).getName();
            if (!clientServices.shouldBeIgnored(file, (String)object)) {
                if (((File)object2).isDirectory()) {
                    if (linkedList == null) {
                        linkedList = new LinkedList<Object>();
                    }
                    linkedList.add(object2);
                } else {
                    boolean bl = this.isBinary((String)object);
                    list.add(new ModifiedRequest((File)object2, bl));
                }
            }
            ++n;
        }
        if (linkedList != null) {
            object2 = linkedList.iterator();
            while (object2.hasNext()) {
                object = (File)object2.next();
                this.addFileRequests((File)object, list, clientServices);
            }
        }
    }

    private String getRepositoryRoot(ClientServices clientServices) {
        String string = clientServices.getRepository() + '/' + this.getModule();
        return string;
    }

    private boolean isBinary(String string) {
        KeywordSubstitutionOptions keywordSubstitutionOptions = this.getKeywordSubstitutionOptions();
        Iterator iterator = this.wrapperMap.keySet().iterator();
        while (iterator.hasNext()) {
            SimpleStringPattern simpleStringPattern = (SimpleStringPattern)iterator.next();
            if (!simpleStringPattern.doesMatch(string)) continue;
            keywordSubstitutionOptions = (KeywordSubstitutionOptions)this.wrapperMap.get(simpleStringPattern);
            break;
        }
        return keywordSubstitutionOptions == KeywordSubstitutionOptions.BINARY;
    }

    public Builder createBuilder(EventManager eventManager) {
        return new ImportBuilder(eventManager, this);
    }
}

