/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.diff;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;

public class DiffInformation
extends FileInfoContainer {
    private File file;
    private String repositoryFileName;
    private String rightRevision = null;
    private String leftRevision = null;
    private String parameters;
    protected LinkedList changesList = new LinkedList();
    private Iterator iterator = null;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getRepositoryFileName() {
        return this.repositoryFileName;
    }

    public void setRepositoryFileName(String string) {
        this.repositoryFileName = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("\nFile: " + (this.file != null ? this.file.getAbsolutePath() : "null"));
        stringBuffer.append("\nRCS file: " + this.repositoryFileName);
        stringBuffer.append("\nRevision: " + this.leftRevision);
        if (this.rightRevision != null) {
            stringBuffer.append("\nRevision: " + this.rightRevision);
        }
        stringBuffer.append("\nParameters: " + this.parameters);
        return stringBuffer.toString();
    }

    public String getRightRevision() {
        return this.rightRevision;
    }

    public void setRightRevision(String string) {
        this.rightRevision = string;
    }

    public String getLeftRevision() {
        return this.leftRevision;
    }

    public void setLeftRevision(String string) {
        this.leftRevision = string;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String string) {
        this.parameters = string;
    }

    public DiffChange createDiffChange() {
        return new DiffChange();
    }

    public void addChange(DiffChange diffChange) {
        this.changesList.addLast(diffChange);
    }

    public DiffChange getFirstChange() {
        this.iterator = this.changesList.iterator();
        return this.getNextChange();
    }

    public DiffChange getNextChange() {
        if (this.iterator == null) {
            return null;
        }
        if (!this.iterator.hasNext()) {
            return null;
        }
        return (DiffChange)this.iterator.next();
    }

    public class DiffChange {
        public static final int ADD = 0;
        public static final int DELETE = 1;
        public static final int CHANGE = 2;
        protected int type;
        private int leftBeginning = -1;
        private int leftEnd = -1;
        private ArrayList leftDiff = new ArrayList();
        private int rightBeginning = -1;
        private int rightEnd = -1;
        private ArrayList rightDiff = new ArrayList();

        public void setType(int n) {
            this.type = n;
        }

        public int getType() {
            return this.type;
        }

        public void setLeftRange(int n, int n2) {
            this.leftBeginning = n;
            this.leftEnd = n2;
        }

        public void setRightRange(int n, int n2) {
            this.rightBeginning = n;
            this.rightEnd = n2;
        }

        public int getMainBeginning() {
            return this.rightBeginning;
        }

        public int getRightMin() {
            return this.rightBeginning;
        }

        public int getRightMax() {
            return this.rightEnd;
        }

        public int getLeftMin() {
            return this.leftBeginning;
        }

        public int getLeftMax() {
            return this.leftEnd;
        }

        public boolean isInRange(int n, boolean bl) {
            if (bl) {
                return n >= this.leftBeginning && n <= this.leftEnd;
            }
            return n >= this.rightBeginning && n <= this.rightEnd;
        }

        public String getLine(int n, boolean bl) {
            if (bl) {
                int n2 = n - this.leftBeginning;
                if (n2 < 0 || n2 >= this.leftDiff.size()) {
                    return null;
                }
                String string = (String)this.leftDiff.get(n2);
                return string;
            }
            int n3 = n - this.rightBeginning;
            if (n3 < 0 || n3 >= this.rightDiff.size()) {
                return null;
            }
            String string = (String)this.rightDiff.get(n3);
            return string;
        }

        public void appendLeftLine(String string) {
            this.leftDiff.add(string);
        }

        public void appendRightLine(String string) {
            this.rightDiff.add(string);
        }
    }
}

