/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.annotate;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateBuilder;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.EntryRequest;

public class AnnotateCommand
extends BasicCommand {
    protected EventManager eventManager;
    private boolean useHeadIfNotFound;
    private String annotateByDate;
    private String annotateByRevision;

    public Builder createBuilder(EventManager eventManager) {
        return new AnnotateBuilder(eventManager, this);
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException {
        this.eventManager = eventManager;
        super.execute(clientServices, eventManager);
        this.excludeBinaryFiles(this.requests);
        try {
            try {
                if (this.useHeadIfNotFound) {
                    this.requests.add(1, new ArgumentRequest("-f"));
                }
                if (this.annotateByDate != null && !this.annotateByDate.equals("")) {
                    this.requests.add(1, new ArgumentRequest("-D"));
                    this.requests.add(2, new ArgumentRequest(this.getAnnotateByDate()));
                }
                if (this.annotateByRevision != null && !this.annotateByRevision.equals("")) {
                    this.requests.add(1, new ArgumentRequest("-r"));
                    this.requests.add(2, new ArgumentRequest(this.getAnnotateByRevision()));
                }
                this.requests.add(new DirectoryRequest(".", clientServices.getRepositoryForDirectory(this.getLocalPath())));
                this.addArgumentRequests();
                this.requests.add(CommandRequest.ANNOTATE);
                clientServices.processRequests(this.requests);
            }
            catch (CommandException commandException) {
                throw commandException;
            }
            catch (Exception exception) {
                throw new CommandException(exception, exception.getLocalizedMessage());
            }
            Object var6_3 = null;
            this.requests.clear();
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.requests.clear();
            throw throwable;
        }
    }

    private void excludeBinaryFiles(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EntryRequest entryRequest;
            Object e = iterator.next();
            if (!(e instanceof EntryRequest) || !(entryRequest = (EntryRequest)e).getEntry().isBinary()) continue;
            iterator.remove();
            if (!iterator.hasNext()) continue;
            Object e2 = iterator.next();
            iterator.remove();
        }
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    public void setUseHeadIfNotFound(boolean bl) {
        this.useHeadIfNotFound = bl;
    }

    public String getAnnotateByDate() {
        return this.annotateByDate;
    }

    public void setAnnotateByDate(String string) {
        this.annotateByDate = string;
    }

    public String getAnnotateByRevision() {
        return this.annotateByRevision;
    }

    public void setAnnotateByRevision(String string) {
        this.annotateByRevision = string;
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("annotate ");
        stringBuffer.append(this.getCVSArguments());
        File[] fileArray = this.getFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                stringBuffer.append(fileArray[n].getName() + " ");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'r') {
            this.setAnnotateByRevision(string);
        } else if (c == 'D') {
            this.setAnnotateByDate(string);
        } else if (c == 'f') {
            this.setUseHeadIfNotFound(true);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rlr:D:f";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setAnnotateByDate(null);
        this.setAnnotateByRevision(null);
        this.setUseHeadIfNotFound(false);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        if (this.getAnnotateByRevision() != null) {
            stringBuffer.append("-r ");
            stringBuffer.append(this.getAnnotateByRevision());
            stringBuffer.append(" ");
        }
        if (this.getAnnotateByDate() != null) {
            stringBuffer.append("-D ");
            stringBuffer.append(this.getAnnotateByDate());
            stringBuffer.append(" ");
        }
        if (this.isUseHeadIfNotFound()) {
            stringBuffer.append("-f ");
        }
        return stringBuffer.toString();
    }
}

