/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient;

import java.io.EOFException;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.event.CVSEvent;
import org.netbeans.lib.cvsclient.event.EnhancedMessageEvent;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.file.DefaultFileHandler;
import org.netbeans.lib.cvsclient.file.FileDetails;
import org.netbeans.lib.cvsclient.file.FileHandler;
import org.netbeans.lib.cvsclient.file.GzippedFileHandler;
import org.netbeans.lib.cvsclient.request.CaseRequest;
import org.netbeans.lib.cvsclient.request.GzipFileContentsRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.UnconfiguredRequestException;
import org.netbeans.lib.cvsclient.request.UseUnchangedRequest;
import org.netbeans.lib.cvsclient.request.ValidRequestsRequest;
import org.netbeans.lib.cvsclient.request.ValidResponsesRequest;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseFactory;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.DefaultIgnoreFileFilter;
import org.netbeans.lib.cvsclient.util.IgnoreFileFilter;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;
import org.netbeans.lib.cvsclient.util.Logger;

public class Client
implements ClientServices,
ResponseServices {
    private Connection connection;
    private FileHandler transmitFileHandler;
    private FileHandler gzipFileHandler = new GzippedFileHandler();
    private FileHandler uncompFileHandler = new DefaultFileHandler();
    private boolean dontUseGzipFileHandler;
    private Date modifiedDate = null;
    private AdminHandler adminHandler;
    private String localPath;
    private boolean isFirstCommand = true;
    private EventManager eventManager;
    private GlobalOptions globalOptions;
    private boolean abort;
    private IgnoreFileFilter ignoreFileFilter;

    public Client(Connection connection, AdminHandler adminHandler) {
        this.setConnection(connection);
        this.setAdminHandler(adminHandler);
        this.eventManager = new EventManager();
        this.ignoreFileFilter = new DefaultIgnoreFileFilter();
        this.dontUseGzipFileHandler = false;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.setIsFirstCommand(true);
    }

    public AdminHandler getAdminHandler() {
        return this.adminHandler;
    }

    public void setAdminHandler(AdminHandler adminHandler) {
        this.adminHandler = adminHandler;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String string) {
        this.localPath = string;
    }

    public boolean isFirstCommand() {
        return this.isFirstCommand;
    }

    public void setIsFirstCommand(boolean bl) {
        this.isFirstCommand = bl;
    }

    public FileHandler getUncompressedFileHandler() {
        return this.uncompFileHandler;
    }

    public void setUncompressedFileHandler(FileHandler fileHandler) {
        this.uncompFileHandler = fileHandler;
    }

    public FileHandler getGzipFileHandler() {
        return this.gzipFileHandler;
    }

    public void setGzipFileHandler(FileHandler fileHandler) {
        this.gzipFileHandler = fileHandler;
    }

    public void dontUseGzipFileHandler() {
        this.setGzipFileHandler(new DefaultFileHandler());
        this.dontUseGzipFileHandler = true;
    }

    public void processRequests(List list) throws IOException, UnconfiguredRequestException, ResponseException, CommandAbortedException {
        Object object;
        Object object2;
        Object object3;
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("[processRequests] requests was either null or empty.");
        }
        if (this.abort) {
            throw new CommandAbortedException("Aborted during request processing", CommandException.getLocalMessage("Client.commandAborted", null));
        }
        if (this.isFirstCommand()) {
            this.setIsFirstCommand(false);
            Collection collection = this.globalOptions.createRequestList();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                list.add(1, iterator.next());
            }
            if (this.globalOptions.isUseGzip()) {
                list.add(1, new GzipFileContentsRequest());
            }
            if (System.getProperty("os.name").startsWith("Windows")) {
                list.add(1, new CaseRequest());
            }
            list.add(1, new UseUnchangedRequest());
            list.add(1, new ValidRequestsRequest());
            list.add(1, new ValidResponsesRequest());
        }
        boolean bl = this.getEventManager().isFireEnhancedEventSet();
        int n = 0;
        if (bl) {
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = (Request)object3.next();
                object = ((Request)object2).getFileForTransmission();
                if (object == null || !((FileDetails)object).getFile().exists()) continue;
                ++n;
            }
            object2 = new EnhancedMessageEvent((Object)this, "Requests_Count", new Integer(n));
            this.getEventManager().fireCVSEvent((CVSEvent)object2);
        }
        object3 = this.connection.getOutputStream();
        object2 = new LinkedList();
        this.transmitFileHandler = this.getUncompressedFileHandler();
        object = list.iterator();
        while (object.hasNext()) {
            Object object4;
            Object object5;
            if (this.abort) {
                throw new CommandAbortedException("Aborted during request processing", CommandException.getLocalMessage("Client.commandAborted", null));
            }
            Request request = (Request)object.next();
            if (request instanceof GzipFileContentsRequest && this.dontUseGzipFileHandler) continue;
            ((LoggedDataOutputStream)object3).writeBytes(request.getRequestString());
            request.modifyOutputStream(this.connection);
            if (request.modifiesInputStream()) {
                object2.add(request);
            }
            object3 = this.connection.getOutputStream();
            FileDetails fileDetails = request.getFileForTransmission();
            if (fileDetails != null && ((File)(object5 = fileDetails.getFile())).exists()) {
                Logger.logOutput("<Sending file: " + ((File)object5).getAbsolutePath() + ">\n");
                if (bl) {
                    object4 = new EnhancedMessageEvent((Object)this, "File_Sent_To_Server", object5);
                    this.getEventManager().fireCVSEvent((CVSEvent)object4);
                    --n;
                }
                if (fileDetails.isBinary()) {
                    this.transmitFileHandler.transmitBinaryFile((File)object5, (LoggedDataOutputStream)object3);
                } else {
                    this.transmitFileHandler.transmitTextFile((File)object5, (LoggedDataOutputStream)object3);
                }
                if (bl && n == 0) {
                    object4 = new EnhancedMessageEvent((Object)this, "All_Requests_Were_Sent", "Ok");
                    this.getEventManager().fireCVSEvent((CVSEvent)object4);
                }
            }
            if (!request.isResponseExpected()) continue;
            ((FilterOutputStream)object3).flush();
            object5 = object2.iterator();
            while (object5.hasNext()) {
                System.err.println("Modifying the inputstream...");
                object4 = (Request)object5.next();
                System.err.println("Request is a: " + object4.getClass().getName());
                ((Request)object4).modifyInputStream(this.connection);
            }
            object2.clear();
            this.handleResponse();
        }
        ((FilterOutputStream)object3).flush();
        this.transmitFileHandler = null;
    }

    private void handleResponse() throws ResponseException, CommandAbortedException {
        try {
            CharSequence charSequence;
            LoggedDataInputStream loggedDataInputStream = this.connection.getInputStream();
            byte by = loggedDataInputStream.readByte();
            while (by != -1) {
                charSequence = new StringBuffer();
                while (by != -1 && (char)by != '\n' && (char)by != ' ') {
                    ((StringBuffer)charSequence).append((char)by);
                    by = loggedDataInputStream.readByte();
                }
                String string = ((StringBuffer)charSequence).toString();
                Response response = ResponseFactory.createResponse(string);
                response.process(loggedDataInputStream, this);
                if (response.isTerminalResponse() || this.abort) break;
                by = loggedDataInputStream.readByte();
            }
            if (this.abort) {
                charSequence = CommandException.getLocalMessage("Client.commandAborted", null);
                throw new CommandAbortedException("Aborted during request processing", (String)charSequence);
            }
        }
        catch (EOFException eOFException) {
            throw new ResponseException(eOFException, CommandException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (IOException iOException) {
            throw new ResponseException(iOException);
        }
    }

    public void executeCommand(Command command, GlobalOptions globalOptions) throws CommandException, CommandAbortedException {
        this.globalOptions = globalOptions;
        try {
            this.eventManager.addCVSListener(command);
            command.execute(this, this.eventManager);
            Object var4_3 = null;
            this.eventManager.removeCVSListener(command);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.eventManager.removeCVSListener(command);
            throw throwable;
        }
    }

    public String convertPathname(String string, String string2) {
        int n = string2.lastIndexOf(47);
        String string3 = string2.substring(n + 1);
        return this.getLocalPath() + '/' + string + string3;
    }

    public String getRepository() {
        return this.connection.getRepository();
    }

    public void updateAdminData(String string, String string2, Entry entry) throws IOException {
        String string3 = this.localPath + '/' + string;
        string2 = string2.substring(this.getRepository().length() + 1);
        this.adminHandler.updateAdminData(string3, string2, entry, this.globalOptions);
    }

    public void setNextFileDate(Date date) {
        this.modifiedDate = date;
    }

    public Date getNextFileDate() {
        Date date = this.modifiedDate;
        this.modifiedDate = null;
        return date;
    }

    public Entry getEntry(File file) throws IOException {
        return this.adminHandler.getEntry(file);
    }

    public Iterator getEntries(File file) throws IOException {
        return this.adminHandler.getEntries(file);
    }

    public String getRepositoryForDirectory(String string) throws IOException {
        try {
            String string2 = this.adminHandler.getRepositoryForDirectory(string, this.getRepository());
            return string2;
        }
        catch (IOException iOException) {
            int n = this.getLocalPath().length();
            String string3 = this.getRepository() + string.substring(n);
            return string3;
        }
    }

    public void setEntry(File file, Entry entry) throws IOException {
        this.adminHandler.setEntry(file, entry);
    }

    public void removeEntry(File file) throws IOException {
        this.adminHandler.removeEntry(file);
    }

    public void removeLocalFile(String string) throws IOException {
        this.transmitFileHandler.removeLocalFile(string);
    }

    public void removeLocalFile(String string, String string2) throws IOException {
        int n = string2.lastIndexOf(47);
        if (n > 0) {
            String string3 = string2.substring(n + 1);
            String string4 = string + string3;
            File file = new File(this.getLocalPath(), string4);
            this.removeLocalFile(file.getAbsolutePath());
            this.removeEntry(file);
        }
    }

    public void renameLocalFile(String string, String string2) throws IOException {
        this.transmitFileHandler.renameLocalFile(string, string2);
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public synchronized void abort() {
        this.abort = true;
    }

    public Set getAllFiles(File file) throws IOException {
        return this.adminHandler.getAllFiles(file);
    }

    public void setIgnoreFileFilter(IgnoreFileFilter ignoreFileFilter) {
        this.ignoreFileFilter = ignoreFileFilter;
    }

    public IgnoreFileFilter getIgnoreFileFilter() {
        return this.ignoreFileFilter;
    }

    public boolean shouldBeIgnored(File file, String string) {
        if (this.ignoreFileFilter != null) {
            return this.ignoreFileFilter.shouldBeIgnored(file, string);
        }
        return false;
    }

    public String getStickyTagForDirectory(File file) {
        return this.adminHandler.getStickyTagForDirectory(file);
    }
}

