/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.ui.IndexedRoot;
import org.netbeans.modules.java.ui.wizard.JavaPanel;
import org.netbeans.modules.java.ui.wizard.JavaWizardData;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;
import org.netbeans.modules.java.ui.wizard.MemberListPanel;
import org.netbeans.modules.java.ui.wizard.MethodCustomizer;
import org.netbeans.modules.java.ui.wizard.MethodsChildren;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.src.Identifier;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MethodsPanel
extends JPanel
implements JavaPanel,
MemberListPanel.ElementCreator,
ExplorerManager.Provider {
    private static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$java$ui$wizard$MethodsPanel == null ? (class$org$netbeans$modules$java$ui$wizard$MethodsPanel = MethodsPanel.class$("org.netbeans.modules.java.ui.wizard.MethodsPanel")) : class$org$netbeans$modules$java$ui$wizard$MethodsPanel));
    private static final MessageFormat METHOD_NAME_FORMAT = new MessageFormat(bundle.getString("FMT_NewMethodName"));
    private JavaWizardData wizardData;
    private MethodElement method;
    private MethodCustomizer methodCustomizer;
    private MemberListPanel listPanel;
    private ExplorerManager manager;
    private PropertyChangeListener managerListener;
    private int newElementCount = 0;
    private MethodElement created;
    private JLabel methodsLabel;
    private JLabel headLabel;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$MethodsPanel;
    static /* synthetic */ Class class$org$openide$src$MethodElement;

    public void initialize(JavaWizardData javaWizardData) {
        this.wizardData = javaWizardData;
        this.initComponents();
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(4));
        this.listPanel = new MemberListPanel(this);
        this.listPanel.newButton.setToolTipText(JavaWizardIterator.getString("ACS_NewMethodA11yDesc"));
        this.listPanel.duplicateButton.setToolTipText(JavaWizardIterator.getString("ACS_DuplicateMethodA11yDesc"));
        this.listPanel.deleteButton.setToolTipText(JavaWizardIterator.getString("ACS_DeleteMethodA11yDesc"));
        this.listPanel.upButton.setToolTipText(JavaWizardIterator.getString("ACS_UpMethodA11yDesc"));
        this.listPanel.downButton.setToolTipText(JavaWizardIterator.getString("ACS_DownMethodA11yDesc"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.listPanel, gridBagConstraints);
        this.methodCustomizer = new MethodCustomizer(this.method);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.add((Component)this.methodCustomizer, gridBagConstraints);
        MethodsChildren methodsChildren = new MethodsChildren(javaWizardData.getCustomizedClass());
        IndexedRoot indexedRoot = new IndexedRoot(methodsChildren);
        this.getExplorerManager().setRootContext((Node)indexedRoot);
        this.methodsLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Methods_Mnemonic").charAt(0));
        this.methodsLabel.setLabelFor(this.listPanel);
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_MethodsPanelA11yName"));
        this.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_MethodsPanelA11yDesc"));
        this.headLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_Add_methodA11yDesc"));
    }

    private void initComponents() {
        this.headLabel = new JLabel();
        this.methodsLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setName(JavaWizardIterator.getString("TIT_AddMethodsWizardPanel"));
        this.headLabel.setText(JavaWizardIterator.getString("LBL_Add_method"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.headLabel, gridBagConstraints);
        this.methodsLabel.setText(JavaWizardIterator.getString("LBL_Methods"));
        this.methodsLabel.setLabelFor(this.listPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.methodsLabel, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        if (this.managerListener == null) {
            this.managerListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                        MethodsPanel.this.handleSelection((Node[])propertyChangeEvent.getNewValue());
                    }
                }
            };
        }
        this.manager.addPropertyChangeListener(this.managerListener);
        this.handleSelection(this.manager.getSelectedNodes());
    }

    private void handleSelection(Node[] nodeArray) {
        MethodElement methodElement = null;
        boolean bl = false;
        if (nodeArray.length == 1) {
            methodElement = (MethodElement)nodeArray[0].getCookie(class$org$openide$src$MethodElement == null ? (class$org$openide$src$MethodElement = MethodsPanel.class$("org.openide.src.MethodElement")) : class$org$openide$src$MethodElement);
            bl = !this.containsOriginal(methodElement);
        }
        this.customizeMethod(methodElement, bl);
    }

    private void customizeMethod(MethodElement methodElement, boolean bl) {
        if (bl) {
            this.methodCustomizer.setEnabled(true);
            this.methodCustomizer.setObject(methodElement);
            if (this.created == methodElement) {
                this.methodCustomizer.requestNameFocus();
            }
        } else {
            this.methodCustomizer.setObject(methodElement);
            this.methodCustomizer.setEnabled(false);
        }
        this.created = null;
    }

    public void removeNotify() {
        super.removeNotify();
        this.manager.removePropertyChangeListener(this.managerListener);
    }

    public MemberElement createElement() throws SourceException {
        MethodElement methodElement = new MethodElement();
        this.createName(methodElement);
        this.wizardData.getCustomizedClass().addMethod(methodElement);
        this.created = this.findMethod(methodElement);
        return methodElement;
    }

    MethodElement findMethod(MethodElement methodElement) {
        MethodParameter[] methodParameterArray = methodElement.getParameters();
        Type[] typeArray = new Type[methodParameterArray.length];
        int n = 0;
        while (n < methodParameterArray.length) {
            typeArray[n] = methodParameterArray[n].getType();
            ++n;
        }
        return this.wizardData.getCustomizedClass().getMethod(methodElement.getName(), typeArray);
    }

    public MemberElement duplicateElement(MemberElement memberElement) throws SourceException {
        MethodElement methodElement;
        try {
            methodElement = (MethodElement)memberElement.clone();
            this.createName(methodElement);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(cloneNotSupportedException);
            methodElement = (MethodElement)this.createElement();
        }
        this.wizardData.getCustomizedClass().addMethod(methodElement);
        this.created = this.findMethod(methodElement);
        return methodElement;
    }

    private void createName(MethodElement methodElement) throws SourceException {
        String string = METHOD_NAME_FORMAT.format(new Object[]{new Integer(this.newElementCount)});
        methodElement.setName(Identifier.create((String)string));
        ++this.newElementCount;
    }

    public void deleteElement(MemberElement memberElement) throws SourceException {
        this.wizardData.getCustomizedClass().removeMethod((MethodElement)memberElement);
    }

    public boolean canDelete(MemberElement memberElement) {
        return !this.containsOriginal((MethodElement)memberElement);
    }

    private boolean elementEquals(MemberElement memberElement, MemberElement memberElement2) {
        MethodElement.Key key = new MethodElement.Key((MethodElement)memberElement);
        MethodElement.Key key2 = new MethodElement.Key((MethodElement)memberElement2);
        return key.equals((Object)key2);
    }

    private boolean containsOriginal(MethodElement methodElement) {
        MethodElement[] methodElementArray = this.wizardData.getOriginalClass().getMethods();
        int n = 0;
        while (n < methodElementArray.length) {
            if (this.elementEquals((MemberElement)methodElement, (MemberElement)methodElementArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
        }
        return this.manager;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.java.wizard.MethodDefs");
    }

    public void readSettings(Object object) {
    }

    public void storeSettings(Object object) {
    }

    public boolean isValid() {
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public Component getComponent() {
        return this;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

