/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.ui.wizard.Util;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;

class JavaPackageIterator
implements TemplateWizard.Iterator {
    WizardDescriptor.Panel targetChooser;
    TemplateWizard wizardInstance;

    JavaPackageIterator() {
    }

    static TemplateWizard.Iterator create() {
        return new JavaPackageIterator();
    }

    public boolean hasNext() {
        return false;
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public String name() {
        return Util.getString("TIT_PackageName");
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public boolean hasPrevious() {
        return false;
    }

    public WizardDescriptor.Panel current() {
        return this.wizardInstance.targetChooser();
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wizardInstance = templateWizard;
    }

    public void uninitialize(TemplateWizard templateWizard) {
    }

    private void throwIllegalName(String string, String string2) throws IllegalStateException {
        String string3 = MessageFormat.format(Util.getString(string), string2);
        IllegalStateException illegalStateException = (IllegalStateException)TopManager.getDefault().getErrorManager().annotate((Throwable)new IllegalStateException(string3), 256, null, string3, null, null);
        throw illegalStateException;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        FileObject fileObject;
        DataFolder dataFolder = templateWizard.getTargetFolder();
        String string = dataFolder.getPrimaryFile().getPackageNameExt('.', '.');
        if (!Util.isValidPackageName(string)) {
            this.throwIllegalName("FMTERR_InvalidPackage", string);
        }
        if ((string = templateWizard.getTargetName()) == null) {
            fileObject = templateWizard.getTemplate().getPrimaryFile();
            string = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)fileObject.getName(), (String)fileObject.getExt());
        } else if (!Util.isValidPackageName(string)) {
            this.throwIllegalName("FMTERR_InvalidPackage", string);
        }
        fileObject = DataObject.find((FileObject)FileUtil.createFolder((FileObject)dataFolder.getPrimaryFile(), (String)string.replace('.', '/')));
        string = fileObject.getName();
        dataFolder = fileObject.getFolder();
        fileObject = fileObject.createFromTemplate(dataFolder, string);
        return Collections.singleton(fileObject);
    }
}

