/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;

public class TreePathWalker
implements DocumentListener,
PropertyChangeListener {
    ExplorerManager manager;
    String delimiter;
    JTextComponent textComponent;
    boolean disableExplorer;
    public static final String DEFAULT_DELIMITER = ".";

    public TreePathWalker(ExplorerManager explorerManager) {
        this(explorerManager, DEFAULT_DELIMITER);
    }

    public TreePathWalker(ExplorerManager explorerManager, String string) {
        this.delimiter = string;
        this.manager = explorerManager;
        explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void setTextComponent(JTextComponent jTextComponent) {
        if (this.textComponent != null) {
            this.textComponent.getDocument().removeDocumentListener(this);
        }
        this.textComponent = jTextComponent;
        if (jTextComponent != null) {
            jTextComponent.getDocument().addDocumentListener(this);
        }
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    private void selectString(Document document) {
        try {
            String string = document.getText(0, document.getLength());
            this.selectString(string);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public final void removeUpdate(DocumentEvent documentEvent) {
    }

    public final void insertUpdate(DocumentEvent documentEvent) {
        this.selectString(documentEvent.getDocument());
    }

    public final void changedUpdate(DocumentEvent documentEvent) {
        this.selectString(documentEvent.getDocument());
    }

    private boolean nameMatches(Node node, String string) {
        return node.getName().startsWith(string);
    }

    private boolean namesEqual(Node node, String string) {
        return node.getName().equals(string);
    }

    private Enumeration enumerateComponents(String string) {
        return new StringTokenizer(string, this.getDelimiter());
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void selectString(String string) {
        Object object;
        Enumeration enumeration = this.enumerateComponents(string);
        Node node = this.getExplorerManager().getRootContext();
        Node node2 = null;
        boolean bl = false;
        String string2 = "";
        boolean bl2 = false;
        System.err.println("begin search");
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            Enumeration enumeration2 = node.getChildren().nodes();
            int n = ((String)object).length();
            node2 = null;
            bl = false;
            bl2 = false;
            System.err.println("got component: " + (String)object);
            string2 = null;
            while (enumeration2.hasMoreElements()) {
                Node node3 = (Node)enumeration2.nextElement();
                String string3 = node3.getName();
                if (!this.nameMatches(node3, (String)object)) continue;
                if (node2 != null) {
                    bl2 = true;
                }
                if (!bl) {
                    node2 = node3;
                }
                if (this.namesEqual(node3, (String)object)) {
                    bl = true;
                    string2 = "";
                    continue;
                }
                String string4 = string3.substring(n);
                string2 = string2 == null ? string4 : this.commonPrefix(string2, string4);
            }
            if (node2 == null || bl2 && !bl) break;
            node = node2;
        }
        if (node2 == null) {
            return;
        }
        if (bl || !bl2) {
            this.selectNode(node2);
            if (string.endsWith(this.getDelimiter())) {
                this.expandNode(node2);
            }
        }
        object = this.getTextComponent();
        if ("".equals(string2) || object == null) {
            return;
        }
        this.appendSelectedString((JTextComponent)object, string2);
    }

    private void expandNode(Node node) {
        this.getExplorerManager().setExploredContext(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectNode(Node node) {
        try {
            try {
                this.disableExplorer = true;
                this.getExplorerManager().setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException propertyVetoException) {
                Object var4_3 = null;
                this.disableExplorer = false;
            }
            Object var4_2 = null;
            this.disableExplorer = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.disableExplorer = false;
            throw throwable;
        }
    }

    private void appendSelectedString(final JTextComponent jTextComponent, final String string) {
        if ("".equals(string)) {
            return;
        }
        final Document document = jTextComponent.getDocument();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Caret caret = jTextComponent.getCaret();
                    int n = document.getLength();
                    document.insertString(n, string, null);
                    int n2 = document.getLength();
                    caret.setDot(n2);
                    caret.moveDot(n);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
    }

    private String commonPrefix(String string, String string2) {
        int n;
        int n2 = string.length();
        int n3 = n2 > (n = string2.length()) ? n : n2;
        int n4 = 0;
        while (n4 < n3) {
            if (string.charAt(n4) != string2.charAt(n4)) {
                return string.substring(0, n4);
            }
            ++n4;
        }
        return n3 == n2 ? string : string2;
    }

    private void displayNodePath(Node node) {
        String[] stringArray = NodeOp.createPath((Node)node, (Node)this.getExplorerManager().getRootContext());
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(this.getDelimiter());
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        JTextComponent jTextComponent = this.getTextComponent();
        if (jTextComponent != null) {
            Document document = jTextComponent.getDocument();
            try {
                document.remove(0, document.getLength());
                document.insertString(0, stringBuffer.toString(), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.disableExplorer) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if ("selectedNodes".equals(string)) {
            Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
            if (nodeArray.length == 0) {
                return;
            }
            this.displayNodePath(nodeArray[0]);
        }
    }
}

