/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.tools;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.java.tools.InheritanceSupport;
import org.netbeans.modules.java.tools.OverrideAction;
import org.netbeans.modules.java.tools.OverridePanelBase;
import org.openide.src.ClassElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class OverrideActionPanel
extends OverridePanelBase {
    private Map removeMethods;
    private Map addMethods;

    public OverrideActionPanel(InheritanceSupport inheritanceSupport) {
        super(inheritanceSupport);
        this.initializeGUI();
    }

    private boolean isInSource(MethodElement methodElement) {
        ClassElement classElement = this.getSupport().getSourceClass();
        MethodParameter[] methodParameterArray = methodElement.getParameters();
        Type[] typeArray = new Type[methodParameterArray.length];
        int n = 0;
        while (n < methodParameterArray.length) {
            typeArray[n] = methodParameterArray[n].getType();
            ++n;
        }
        return classElement.getMethod(methodElement.getName(), typeArray) != null;
    }

    protected void overrideMethod(MethodElement methodElement) throws SourceException {
        MethodElement.Key key = new MethodElement.Key(methodElement);
        if (this.removeMethods != null && this.removeMethods.containsKey(key)) {
            this.removeMethods.remove(key);
        } else {
            if (this.isInSource(methodElement)) {
                this.throwAddException(methodElement);
            }
            if (this.addMethods == null) {
                this.addMethods = new HashMap(17);
            } else if (this.addMethods.containsKey(key)) {
                this.throwAddException(methodElement);
            }
            this.addMethods.put(key, methodElement);
        }
        super.overrideMethod(methodElement);
    }

    private void throwAddException(MethodElement methodElement) throws SourceException {
        String string = MessageFormat.format(OverrideAction.getString("FMT_METHOD_PRESENT"), methodElement.getName().getName());
        throw new SourceException(string);
    }

    public Collection getMethodsToAdd() {
        if (this.addMethods == null) {
            return null;
        }
        return this.addMethods.values();
    }

    public Collection getMethodsToRemove() {
        if (this.removeMethods == null) {
            return null;
        }
        return this.removeMethods.values();
    }

    protected void removeMethod(MethodElement methodElement) throws SourceException {
        MethodElement.Key key = new MethodElement.Key(methodElement);
        if (this.addMethods == null || !this.addMethods.containsKey(key)) {
            if (this.removeMethods == null) {
                this.removeMethods = new HashMap(17);
            }
            this.removeMethods.put(key, methodElement);
        } else {
            this.addMethods.remove(key);
        }
        super.removeMethod(methodElement);
    }
}

