/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.tools;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataObject;

public class MultiDataContainer
implements DataObject.Container,
PropertyChangeListener {
    public static final String PROP_CONTAINERS = "containers";
    public static final String PROP_CONTENTS = "contents";
    private static final DataObject[] EMPTY_CHILDREN = new DataObject[0];
    private static final Object REJECTED_OBJECT = new Object();
    DataObject[] children;
    Collection contents;
    DataFilter filter;
    boolean refreshChildren;
    Map nestedContainers;
    Map containerContents;
    PropertyChangeSupport propSupport;
    static /* synthetic */ Class class$org$openide$loaders$DataObject$Container;

    public MultiDataContainer() {
        this(DataFilter.ALL);
    }

    public MultiDataContainer(DataFilter dataFilter) {
        this(Collections.EMPTY_LIST, dataFilter);
    }

    public MultiDataContainer(Collection collection, DataFilter dataFilter) {
        this.contents = collection;
        this.filter = dataFilter;
        this.children = EMPTY_CHILDREN;
        this.refreshChildren = true;
        this.nestedContainers = new TreeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContents(Collection collection) {
        MultiDataContainer multiDataContainer = this;
        synchronized (multiDataContainer) {
            Object object;
            if (this.contents.equals(collection)) {
                return;
            }
            Iterator iterator = this.contents.iterator();
            while (iterator.hasNext()) {
                object = (DataObject.Container)iterator.next();
                object.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.contents = Collections.unmodifiableCollection(collection);
            object = this.contents.iterator();
            while (object.hasNext()) {
                DataObject.Container container = (DataObject.Container)object.next();
                container.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.invalidateChildren();
        }
        this.fireContentsChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateChildren() {
        MultiDataContainer multiDataContainer = this;
        synchronized (multiDataContainer) {
            this.refreshChildren = true;
        }
    }

    private void fireContentsChange() {
        if (this.propSupport == null) {
            return;
        }
        this.propSupport.firePropertyChange(PROP_CONTENTS, null, null);
        this.fireChildrenChange();
    }

    private void fireChildrenChange() {
        if (this.propSupport == null) {
            return;
        }
        this.propSupport.firePropertyChange("children", null, null);
    }

    public Collection getContents() {
        return this.contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject[] getChildren() {
        if (this.refreshChildren) {
            MultiDataContainer multiDataContainer = this;
            synchronized (multiDataContainer) {
                this.refreshChildren = false;
                this.refreshData();
            }
        }
        return this.children;
    }

    public Map getContainers() {
        return this.nestedContainers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshData() {
        Object object;
        HashSet hashSet = new HashSet(31);
        LinkedList linkedList = new LinkedList();
        HashMap hashMap = new HashMap(31);
        int n = 0;
        Iterator iterator = this.getContents().iterator();
        while (iterator.hasNext()) {
            n += this.addContainer(hashMap, hashSet, linkedList, (DataObject.Container)iterator.next());
        }
        boolean bl = false;
        Iterator iterator2 = hashMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            Object k = object.getKey();
            Collection collection = (Collection)object.getValue();
            MultiDataContainer multiDataContainer = (MultiDataContainer)this.nestedContainers.get(k);
            if (multiDataContainer == null) {
                System.err.println("creating nested container for " + k);
                multiDataContainer = this.createContainer(collection);
                bl = true;
            } else {
                multiDataContainer.setContents(collection);
            }
            object.setValue(multiDataContainer);
        }
        if (this.nestedContainers != null) {
            object = this.nestedContainers.keySet().iterator();
            while (!bl && object.hasNext()) {
                bl &= hashMap.containsKey(object.next());
            }
        } else {
            bl |= !hashMap.isEmpty();
        }
        object = this;
        synchronized (object) {
            this.nestedContainers = hashMap;
            this.children = linkedList.toArray(new DataObject[linkedList.size()]);
        }
        if (bl) {
            this.propSupport.firePropertyChange(PROP_CONTAINERS, null, null);
        }
    }

    private int addContainer(Map map, Set set, Collection collection, DataObject.Container container) {
        System.err.println("addContainer: " + container);
        DataObject[] dataObjectArray = container.getChildren();
        int n = 0;
        int n2 = 0;
        while (n2 < dataObjectArray.length) {
            DataObject dataObject;
            DataObject dataObject2 = dataObject = dataObjectArray[n2];
            Object object = this.createKey(dataObject);
            if (!this.filter.acceptDataObject(dataObject)) {
                System.err.println("addContainer: " + dataObject + " was rejected. ");
                ++n;
            } else if (this.isContainer(dataObject)) {
                System.err.println("got container: " + dataObject + " with key " + object);
                LinkedList<DataObject> linkedList = (LinkedList<DataObject>)map.get(object);
                if (linkedList == null) {
                    linkedList = new LinkedList<DataObject>();
                    map.put(object, linkedList);
                    System.err.println("new container");
                }
                linkedList.add(dataObject);
            } else if (set.add(object)) {
                collection.add(dataObject2);
            }
            ++n2;
        }
        return n;
    }

    public DataFilter getFilter() {
        return this.filter;
    }

    public MultiDataContainer createContainer(Collection collection) {
        return new MultiDataContainer(collection, this.getFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) throws IllegalArgumentException {
        if (propertyChangeListener == null) {
            throw new IllegalArgumentException("eee");
        }
        MultiDataContainer multiDataContainer = this;
        synchronized (multiDataContainer) {
            if (this.propSupport == null) {
                this.propSupport = new PropertyChangeSupport(this);
            }
        }
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    protected Object createKey(DataObject dataObject) {
        return dataObject.getName();
    }

    protected boolean isContainer(DataObject dataObject) {
        return dataObject.getCookie(class$org$openide$loaders$DataObject$Container == null ? (class$org$openide$loaders$DataObject$Container = MultiDataContainer.class$("org.openide.loaders.DataObject$Container")) : class$org$openide$loaders$DataObject$Container) != null;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propSupport == null) {
            return;
        }
        this.propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("children".equals(propertyChangeEvent.getPropertyName())) {
            this.invalidateChildren();
            this.fireChildrenChange();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

