/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.imptool;

import java.io.IOException;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.java.imptool.BodyIdentifier;
import org.netbeans.modules.java.imptool.MethodParameterOwner;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class SourceIdentifier {
    private Identifier identifier;
    private int type;
    private Object owner;
    private String resolvedPackage;
    private int useFQN = 0;
    static final int USE_FQN_NO_CHANGE = 0;
    static final int USE_FQN_TRUE = 1;
    static final int USE_FQN_FALSE = 2;
    static final int TYPE_TYPE = 0;
    static final int TYPE_SUPERCLASS = 1;
    static final int TYPE_INTERFACE = 2;
    static final int TYPE_EXCEPTION = 3;
    static final int TYPE_BODY = 4;

    public SourceIdentifier(Identifier identifier, int n, Object object) {
        this.identifier = identifier;
        this.type = n;
        this.owner = object;
    }

    void commit() throws SourceException, IOException, BadLocationException {
        Identifier identifier = null;
        if (this.resolvedPackage == null && this.useFQN == 0) {
            return;
        }
        identifier = Identifier.create((String)this.getFQN(), (String)this.getSourceText());
        if (this.owner instanceof ClassElement) {
            ClassElement classElement = (ClassElement)this.owner;
            switch (this.type) {
                case 1: {
                    classElement.setSuperclass(identifier);
                    break;
                }
                case 2: {
                    classElement.removeInterface(this.identifier);
                    classElement.addInterface(identifier);
                }
            }
        } else if (this.owner instanceof MethodElement) {
            MethodElement methodElement = (MethodElement)this.owner;
            switch (this.type) {
                case 3: {
                    Identifier[] identifierArray = methodElement.getExceptions();
                    this.replaceIdentifierIn(identifierArray, identifier);
                    methodElement.setExceptions(identifierArray);
                    break;
                }
                case 0: {
                    Type type = this.createTypeFrom(methodElement.getReturn(), identifier);
                    methodElement.setReturn(type);
                }
            }
        } else if (this.owner instanceof ConstructorElement) {
            ConstructorElement constructorElement = (ConstructorElement)this.owner;
            switch (this.type) {
                case 3: {
                    Identifier[] identifierArray = constructorElement.getExceptions();
                    this.replaceIdentifierIn(identifierArray, identifier);
                    constructorElement.setExceptions(identifierArray);
                }
            }
        } else if (this.owner instanceof FieldElement) {
            FieldElement fieldElement = (FieldElement)this.owner;
            Type type = this.createTypeFrom(fieldElement.getType(), identifier);
            fieldElement.setType(type);
        } else if (this.owner instanceof MethodParameterOwner) {
            MethodParameterOwner methodParameterOwner = (MethodParameterOwner)this.owner;
            Type type = this.createTypeFrom(methodParameterOwner.getMethodParameterType(), identifier);
            methodParameterOwner.setMethodParameterType(type);
        } else if (this.owner instanceof BodyIdentifier) {
            BodyIdentifier bodyIdentifier = (BodyIdentifier)this.owner;
            bodyIdentifier.getBounds().setText(this.getSourceText());
        } else {
            throw new IllegalArgumentException();
        }
    }

    void rollback() {
        this.resolvedPackage = null;
        this.useFQN = 0;
    }

    int resolve(int n) {
        return 0;
    }

    String getSourceText() {
        if (this.resolvedPackage != null) {
            if (this.useFQN == 1) {
                return this.getFQN();
            }
            return this.getName();
        }
        if (this.useFQN == 1) {
            return this.identifier.getFullName();
        }
        if (this.useFQN == 2) {
            return this.identifier.getName();
        }
        return this.identifier.getSourceName();
    }

    String getFQN() {
        if (this.resolvedPackage != null) {
            return this.resolvedPackage.concat(".").concat(this.getName());
        }
        return this.identifier.getFullName();
    }

    String getPackage() {
        if (this.resolvedPackage != null) {
            return this.resolvedPackage;
        }
        if (this.identifier.getResolutionStatus() == 2) {
            return null;
        }
        String string = this.identifier.getQualifier();
        if (string != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    void setPackage(String string) {
        this.resolvedPackage = string;
    }

    String getName() {
        return this.identifier.getName();
    }

    int getResolveStatus() {
        return 0;
    }

    int getUseFQN() {
        return this.useFQN;
    }

    void setUseFQN(int n) {
        this.useFQN = n;
    }

    boolean reallyUseFQN() {
        return !this.getSourceText().equals(this.getName());
    }

    private Type createTypeFrom(Type type, Identifier identifier) {
        if (type.isClass()) {
            if (type.getTypeIdentifier().equals((Object)this.identifier)) {
                return Type.createClass((Identifier)identifier);
            }
            throw new IllegalArgumentException();
        }
        if (type.isArray()) {
            return Type.createArray((Type)this.createTypeFrom(type.getElementType(), identifier));
        }
        throw new IllegalArgumentException();
    }

    private void replaceIdentifierIn(Identifier[] identifierArray, Identifier identifier) {
        int n = 0;
        while (n < identifierArray.length) {
            if (identifierArray[n].equals((Object)this.identifier)) {
                identifierArray[n] = identifier;
                break;
            }
            ++n;
        }
    }
}

