/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.environment;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.modules.java.environment.LibraryArchive;
import org.netbeans.modules.java.environment.Utilities;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Lookup;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class LibraryProcessor
implements XMLDataObject.Processor,
InstanceCookie {
    static final String JAVALIB_DTD_PUBLIC_ID = "-//NetBeans IDE//DTD JavaLibrary//EN";
    static final String TAG_LIBRARY = "Library";
    static final String TAG_ARCHIVE = "Archive";
    static final String ATTR_NAME = "name";
    private static final char FILE_SEPARATOR = File.separatorChar;
    protected XMLDataObject xmlDataObject;
    FileSystem libraryFileSystem;
    static /* synthetic */ Class class$org$netbeans$modules$java$environment$LibraryArchive;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    public void attachTo(XMLDataObject xMLDataObject) {
        this.xmlDataObject = xMLDataObject;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        if (this.libraryFileSystem != null) {
            return this.libraryFileSystem;
        }
        this.loadLibrary(this.xmlDataObject);
        return this.libraryFileSystem;
    }

    public Class instanceClass() {
        return class$org$netbeans$modules$java$environment$LibraryArchive == null ? (class$org$netbeans$modules$java$environment$LibraryArchive = LibraryProcessor.class$("org.netbeans.modules.java.environment.LibraryArchive")) : class$org$netbeans$modules$java$environment$LibraryArchive;
    }

    public String instanceName() {
        return this.instanceClass().getName();
    }

    static void throwNotFoundException(DataObject dataObject, String string) throws SAXException {
        ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = LibraryProcessor.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
        String string2 = MessageFormat.format(Utilities.getString("FMT_ResourceNotFound"), string, dataObject.getPrimaryFile().toString());
        throw (SAXException)errorManager.annotate((Throwable)new SAXException("Mount resource not found"), 256, null, string2, null, null);
    }

    private void loadLibrary(XMLDataObject xMLDataObject) throws IOException {
        HandlerBase handlerBase = new HandlerBase(){
            private boolean inLibrary = false;

            public void startElement(String string, AttributeList attributeList) throws SAXException {
                if (LibraryProcessor.TAG_LIBRARY.equals(string)) {
                    this.inLibrary = true;
                } else if (this.inLibrary && LibraryProcessor.TAG_ARCHIVE.equals(string)) {
                    File file;
                    String string2 = attributeList.getValue(LibraryProcessor.ATTR_NAME);
                    if (string2 == null) {
                        return;
                    }
                    if (FILE_SEPARATOR != '/') {
                        string2.replace('/', FILE_SEPARATOR);
                    }
                    if ((file = Utilities.findInstalledFile(string2)) == null) {
                        LibraryProcessor.throwNotFoundException((DataObject)LibraryProcessor.this.xmlDataObject, string2);
                    }
                    String string3 = LibraryProcessor.this.xmlDataObject.getPrimaryFile().getPackageNameExt('/', '.');
                    LibraryArchive libraryArchive = new LibraryArchive(string3);
                    try {
                        libraryArchive.setJarFile(file);
                        libraryArchive.setHidden(true);
                        LibraryProcessor.this.libraryFileSystem = libraryArchive;
                    }
                    catch (PropertyVetoException propertyVetoException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            public void endElement(String string) throws SAXException {
                if (LibraryProcessor.TAG_LIBRARY.equals(string)) {
                    this.inLibrary = false;
                }
            }
        };
        Parser parser = XMLDataObject.createParser();
        parser.setDocumentHandler(handlerBase);
        parser.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        });
        try {
            parser.parse(new InputSource(xMLDataObject.getPrimaryFile().getInputStream()));
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException();
            TopManager.getDefault().getErrorManager().copyAnnotation((Throwable)iOException, (Throwable)sAXException);
            throw iOException;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

