/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.netbeans.modules.java.CoronaClassFile;
import org.netbeans.modules.java.CoronaClassPath;
import org.netbeans.modules.java.ErrConsumer;
import org.netbeans.modules.java.JavaParser;
import org.openide.filesystems.FileObject;
import org.openide.util.io.NullOutputStream;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassNotFound;
import sun.tools.java.ClassPath;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.javac.BatchEnvironment;
import sun.tools.javac.Main;

public class CoronaEnvironment
extends BatchEnvironment {
    private ErrConsumer errConsumer;
    ErrorMessage errors;
    boolean thereWereErrors;
    String errorFileName;
    Vector deprecationFiles;
    ClassPath srcPath;
    ClassPath binPath;
    private Hashtable list = new Hashtable();
    private static int OFFSET_BITS = 32;
    private static long OFFSET_BITS_MASK = 0xFFFFFFFFL;

    public CoronaEnvironment(CoronaClassPath coronaClassPath, CoronaClassPath coronaClassPath2, ErrConsumer errConsumer) {
        super((OutputStream)new NullOutputStream(), (ClassPath)coronaClassPath, (ClassPath)coronaClassPath2);
        coronaClassPath.attachToEnvironment(this);
        coronaClassPath2.attachToEnvironment(this);
        this.errConsumer = errConsumer;
        this.deprecationFiles = new Vector();
        this.srcPath = coronaClassPath;
        this.binPath = coronaClassPath2;
    }

    private static String getPath() {
        char c = File.separatorChar;
        return System.getProperty("java.class.path");
    }

    public CoronaClassFile getClassFile(FileObject fileObject) {
        CoronaClassFile coronaClassFile = (CoronaClassFile)((Object)this.list.get(fileObject));
        if (coronaClassFile == null) {
            coronaClassFile = new CoronaClassFile(fileObject);
            this.list.put(fileObject, coronaClassFile);
        }
        return coronaClassFile;
    }

    public boolean proceeded(FileObject fileObject) {
        return this.list.get(fileObject) != null;
    }

    public void setConsumer(ErrConsumer errConsumer) {
        this.errConsumer = errConsumer;
    }

    public boolean insertError(long l, String string) {
        if (this.errConsumer == null) {
            return false;
        }
        if (this.errors == null || this.errors.where > l) {
            ErrorMessage errorMessage = new ErrorMessage(l, string);
            errorMessage.next = this.errors;
            this.errors = errorMessage;
        } else {
            ErrorMessage errorMessage;
            ErrorMessage errorMessage2;
            if (this.errors.where == l && this.errors.message.equals(string)) {
                return false;
            }
            ErrorMessage errorMessage3 = this.errors;
            while ((errorMessage2 = errorMessage3.next) != null && errorMessage2.where < l) {
                errorMessage3 = errorMessage2;
            }
            while ((errorMessage = errorMessage3.next) != null && errorMessage.where == l) {
                if (errorMessage.message.equals(string)) {
                    return false;
                }
                errorMessage3 = errorMessage;
            }
            ErrorMessage errorMessage4 = new ErrorMessage(l, string);
            errorMessage4.next = errorMessage3.next;
            errorMessage3.next = errorMessage4;
        }
        return true;
    }

    public void reportError(Object object, long l, String string, String string2) {
        if (object == null) {
            if (this.errorFileName != null) {
                this.flushErrors();
                this.errorFileName = null;
            }
            if (string.startsWith("warn.")) {
                if (this.warnings()) {
                    ++this.nwarnings;
                    this.output(string2);
                }
                return;
            }
            this.output("error: " + string2);
            ++this.nerrors;
            this.flags |= 0x10000;
            return;
        }
        if (object instanceof String) {
            String string3 = (String)object;
            if (!string3.equals(this.errorFileName)) {
                this.flushErrors();
                this.errorFileName = string3;
            }
            if (string.startsWith("warn.")) {
                if (string.indexOf("is.deprecated") >= 0) {
                    ++this.ndeprecations;
                    if (!this.deprecationFiles.contains(object)) {
                        this.deprecationFiles.addElement(object);
                    }
                    if (!this.deprecation()) {
                        return;
                    }
                }
                ++this.nwarnings;
                if (!this.warnings()) {
                    return;
                }
            } else {
                ++this.nerrors;
                this.flags |= 0x10000;
            }
            this.insertError(l, string2);
            return;
        }
        if (object instanceof ClassFile) {
            this.reportError(((ClassFile)object).getPath(), l, string, string2);
            return;
        }
        if (object instanceof Identifier) {
            this.reportError(object.toString(), l, string, string2);
            return;
        }
        if (object instanceof ClassDeclaration) {
            try {
                this.reportError(((ClassDeclaration)object).getClassDefinition((Environment)this), l, string, string2);
            }
            catch (ClassNotFound classNotFound) {
                this.reportError(((ClassDeclaration)object).getName(), l, string, string2);
                return;
            }
            return;
        }
        if (object instanceof ClassDefinition) {
            ClassDefinition classDefinition = (ClassDefinition)object;
            if (!string.startsWith("warn.")) {
                classDefinition.setError();
            }
            this.reportError(classDefinition.getSource(), l, string, string2);
            return;
        }
        if (object instanceof MemberDefinition) {
            ClassDeclaration classDeclaration = ((MemberDefinition)object).getClassDeclaration();
            this.reportError(classDeclaration, l, string, string2);
            return;
        }
        this.output(":error=" + string + ":" + string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void flushErrors() {
        if (this.errors == null) {
            return;
        }
        if (this.errConsumer == null) {
            this.errors = null;
            return;
        }
        var1_1 = null;
        var1_1 = (CoronaClassFile)this.srcPath.getFile(this.errorFileName + ".java");
        if (var1_1.pis != null) {
            var2_2 = var1_1.pis.getString(0).toCharArray();
        } else {
            try {
                var3_3 = var1_1.getInputStream();
                try {
                    var2_2 = this.readDataFromIs(var3_3);
                    var5_6 = null;
                }
                catch (Throwable var4_8) {
                    var5_7 = null;
                    var3_3.close();
                    throw var4_8;
                }
                var3_3.close();
                {
                }
            }
            catch (IOException var3_4) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    var3_4.printStackTrace();
                }
                this.errors = null;
                return;
            }
        }
        var3_5 = var2_2.length;
        var4_9 = this.errors;
        ** GOTO lbl57
        {
            var4_9 = var4_9.next;
            if (this.nwarnings > 1) {
                --this.nwarnings;
            } else {
                --this.nerrors;
            }
            do {
                if ((var5_6 = var4_9.next) != null && var4_9.where == var5_6.where && var4_9.message.equals(var5_6.message)) continue block4;
                var6_10 = var4_9.where >>> CoronaEnvironment.OFFSET_BITS;
                var8_11 = (int)(var4_9.where & CoronaEnvironment.OFFSET_BITS_MASK);
                if (var8_11 > var3_5) {
                    var8_11 = var3_5;
                }
                var9_12 = var8_11 - 1;
                while (var9_12 > 0 && var2_2[var9_12 - 1] != '\n' && var2_2[var9_12 - 1] != '\r') {
                    --var9_12;
                }
                var10_13 = var8_11;
                while (var10_13 < var3_5 && var2_2[var10_13] != '\n' && var2_2[var10_13] != '\r') {
                    ++var10_13;
                }
                if (var9_12 < 0) {
                    var9_12 = 0;
                }
                var11_14 = new String(var2_2, var9_12, var10_13 - var9_12);
                this.errConsumer.pushError(var1_1.getFile(), (int)var6_10, var8_11 - 1 - var9_12, var4_9.message, var11_14);
                var4_9 = var4_9.next;
lbl57:
                // 2 sources

            } while (var4_9 != null);
        }
        this.errors = null;
    }

    private char[] readDataFromIs(InputStream inputStream) throws IOException {
        char[] cArray;
        char[] cArray2 = new char[1024];
        int n = 0;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        while (true) {
            int n2;
            if ((n2 = inputStreamReader.read(cArray2, n, cArray2.length - n)) < 0) break;
            if ((n += n2) < cArray2.length) continue;
            cArray = new char[2 * cArray2.length];
            System.arraycopy(cArray2, 0, cArray, 0, cArray2.length);
            cArray2 = cArray;
        }
        cArray = new char[n];
        System.arraycopy(cArray2, 0, cArray, 0, n);
        cArray2 = cArray;
        return cArray2;
    }

    public void output(String string) {
        if (this.errConsumer != null) {
            this.errConsumer.pushError(null, -1, -1, string, null);
        }
    }

    public Object getDeprElement() {
        return this.deprecationFiles.elementAt(0);
    }

    public void x_parseFile(ClassFile classFile) throws FileNotFoundException {
        FileObject fileObject;
        Object object;
        JavaParser javaParser;
        Environment environment;
        long l;
        block12: {
            l = System.currentTimeMillis();
            this.dtEnter("parseFile: PARSING SOURCE " + classFile);
            environment = new Environment((Environment)this, (Object)classFile);
            javaParser = null;
            try {
                environment.setCharacterEncoding(this.getCharacterEncoding());
                if (classFile instanceof CoronaClassFile) {
                    object = (CoronaClassFile)classFile;
                    fileObject = ((CoronaClassFile)((Object)object)).getFile();
                    javaParser = this.createParser(environment, fileObject);
                    ((CoronaClassFile)((Object)object)).pis = javaParser.input;
                    break block12;
                }
                throw new IllegalArgumentException();
            }
            catch (IOException iOException) {
                this.dtEvent("parseFile: IO EXCEPTION " + classFile);
                throw new FileNotFoundException();
            }
        }
        try {
            javaParser.parseFile();
        }
        catch (Exception exception) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                exception.printStackTrace();
            }
            throw new CompilerError(exception);
        }
        if (this.verbose()) {
            l = System.currentTimeMillis() - l;
            this.output(Main.getText((String)"benv.parsed_in", (String)classFile.getPath(), (String)Long.toString(l)));
        }
        if (javaParser.getClassesProtected().size() == 0) {
            javaParser.getImportsProtected().resolve(environment);
        } else {
            object = javaParser.getClassesProtected().elements();
            fileObject = (ClassDefinition)object.nextElement();
            if (fileObject.isInnerClass()) {
                throw new CompilerError("BatchEnvironment, first is inner");
            }
            FileObject fileObject2 = fileObject;
            while (object.hasMoreElements()) {
                ClassDefinition classDefinition = (ClassDefinition)object.nextElement();
                if (classDefinition.isInnerClass()) continue;
                fileObject2.addDependency(classDefinition.getClassDeclaration());
                classDefinition.addDependency(fileObject2.getClassDeclaration());
                fileObject2 = classDefinition;
            }
            if (fileObject2 != fileObject) {
                fileObject2.addDependency(fileObject.getClassDeclaration());
                fileObject.addDependency(fileObject2.getClassDeclaration());
            }
        }
        this.dtExit("parseFile: SOURCE PARSED " + classFile);
    }

    public JavaParser createParser(Environment environment, FileObject fileObject) throws IOException {
        return new JavaParser(environment, fileObject, false);
    }

    int getClassesSize() {
        int n = 0;
        Enumeration enumeration = this.getClasses();
        while (enumeration.hasMoreElements()) {
            ++n;
            enumeration.nextElement();
        }
        return n;
    }

    static class ErrorMessage {
        long where;
        String message;
        ErrorMessage next;

        ErrorMessage(long l, String string) {
            this.where = l;
            this.message = string;
        }
    }
}

