/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.netbeans.modules.java.CoronaClassFile;
import org.netbeans.modules.java.CoronaEnvironment;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.util.enum.EmptyEnumeration;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;

public class CoronaClassPath
extends ClassPath {
    private CoronaEnvironment env;
    private FileSystemCapability pool = FileSystemCapability.COMPILE;
    private static WeakHashMap cache = new WeakHashMap(113);
    private static final Object nullFile = new Object();
    private static final String pathStr = new String(new char[]{File.pathSeparatorChar});
    private static final Enumeration emptyEnum = EmptyEnumeration.EMPTY;
    private CoronaClassPath srcPath;

    public CoronaClassPath(boolean bl, CoronaClassPath coronaClassPath) {
        super(bl ? CoronaClassPath.getSystemEntriesFromClassPath() : "");
        cache.clear();
        this.srcPath = coronaClassPath;
    }

    public CoronaClassPath(boolean bl) {
        this(bl, null);
    }

    public void attachToEnvironment(CoronaEnvironment coronaEnvironment) {
        this.env = coronaEnvironment;
    }

    public ClassFile getDirectory(String string) {
        ClassFile classFile = this.getFile(string, true);
        return classFile;
    }

    public ClassFile getFile(String string) {
        ClassFile classFile;
        if (this.srcPath != null && string.endsWith(".class")) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.setLength(string.length() - 5);
            int n = stringBuffer.toString().indexOf(36);
            if (n >= 0) {
                stringBuffer.setLength(n);
                stringBuffer.append('.');
            }
            stringBuffer.append("java");
            classFile = this.srcPath.getFile(stringBuffer.toString());
            if (classFile != null) {
                return this.srcPath.getFile(string);
            }
        }
        classFile = this.getFile(string, false);
        return classFile;
    }

    private ClassFile getFile(String string, boolean bl) {
        FileObject fileObject = null;
        Object v = cache.get(string);
        if (v != null) {
            if (v != nullFile) {
                return (ClassFile)v;
            }
            return null;
        }
        Object var6_5 = null;
        String string2 = null;
        Object var8_7 = null;
        if (string == null) {
            return null;
        }
        string2 = File.separatorChar != '/' ? string.replace(File.separatorChar, '/') : string;
        if (bl) {
            fileObject = this.pool.findResource(string2);
            if (fileObject == null) {
                ClassFile classFile = super.getDirectory(string);
                if (classFile != null) {
                    cache.put(string, classFile);
                    return classFile;
                }
                cache.put(string, nullFile);
                return null;
            }
        } else {
            fileObject = this.pool.findResource(string2);
            if (fileObject == null) {
                ClassFile classFile = super.getFile(string);
                if (classFile != null) {
                    cache.put(string, classFile);
                    return classFile;
                }
                cache.put(string, nullFile);
                return null;
            }
            if (!string2.equals(fileObject.getPackageNameExt('/', '.'))) {
                cache.put(string, nullFile);
                return null;
            }
        }
        CoronaClassFile coronaClassFile = this.env.getClassFile(fileObject);
        cache.put(string, coronaClassFile);
        return coronaClassFile;
    }

    public Enumeration getFiles(String string, String string2) {
        ClassFile classFile;
        String string3 = null;
        HashMap<String, ClassFile> hashMap = new HashMap<String, ClassFile>();
        Enumeration enumeration = super.getFiles(string, string2);
        while (enumeration.hasMoreElements()) {
            classFile = (ClassFile)enumeration.nextElement();
            string3 = classFile.getName();
            hashMap.put(string3, classFile);
        }
        String string4 = string.replace(File.separatorChar, '.');
        while (string4.endsWith(".")) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        while (string2.startsWith(".")) {
            string2 = string2.substring(1, string2.length());
        }
        Enumeration enumeration2 = this.pool.fileSystems();
        while (enumeration2.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration2.nextElement();
            FileObject fileObject = fileSystem.findResource(string4);
            if (fileObject == null || !fileObject.isFolder()) continue;
            FileObject[] fileObjectArray = fileObject.getChildren();
            int n = 0;
            while (n < fileObjectArray.length) {
                if (fileObjectArray[n].getExt().compareTo(string2) == 0) {
                    classFile = this.env.getClassFile(fileObjectArray[n]);
                    hashMap.put(classFile.getName(), classFile);
                }
                ++n;
            }
        }
        return Collections.enumeration(hashMap.values());
    }

    public void close() throws IOException {
    }

    private static final String getSystemEntriesFromClassPath() {
        NbClassPath nbClassPath = NbClassPath.createBootClassPath();
        NbClassPath nbClassPath2 = NbClassPath.createClassPath();
        NbClassPath nbClassPath3 = NbClassPath.createLibraryPath();
        return nbClassPath.getClassPath() + File.pathSeparatorChar + nbClassPath2.getClassPath() + File.pathSeparatorChar + nbClassPath3.getClassPath();
    }
}

