/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.debug;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.debug.ToolsDebugger;
import org.netbeans.modules.debugger.debug.ToolsFilter;
import org.netbeans.modules.debugger.debug.ToolsFixedWatch;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.ModifiersFilter;
import org.netbeans.modules.debugger.support.util.Protector;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.util.NbBundle;
import sun.tools.debug.RemoteArray;
import sun.tools.debug.RemoteClass;
import sun.tools.debug.RemoteField;
import sun.tools.debug.RemoteObject;
import sun.tools.debug.RemoteValue;

public class ToolsVariable
implements JavaVariable {
    static final long serialVersionUID = -4908841115435797749L;
    private static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$debug$ToolsVariable == null ? (class$org$netbeans$modules$debugger$debug$ToolsVariable = ToolsVariable.class$("org.netbeans.modules.debugger.debug.ToolsVariable")) : class$org$netbeans$modules$debugger$debug$ToolsVariable));
    private transient RemoteObject parentObject;
    private int slotNumber = -1;
    protected transient RemoteValue remoteValue;
    protected transient String name;
    protected transient String value;
    protected transient VariablesFilter filter;
    protected transient String innerType;
    protected transient String type;
    protected transient String modifiers;
    private transient RemoteObject oldObject;
    private transient AbstractVariable[] oldFields;
    private transient boolean isCloned;
    private transient boolean isArray;
    private transient boolean isObject;
    private transient Validator validator;
    private transient int index = -1;
    private transient PropertyChangeSupport pcs;
    private int startIndex = 1;
    private int length = 100;
    protected transient ToolsDebugger debugger;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$debug$ToolsVariable;

    ToolsVariable(ToolsDebugger toolsDebugger, boolean bl) {
        Validator validator = this.validator = bl ? toolsDebugger.getValidator() : null;
        if (bl) {
            this.validator = toolsDebugger.getValidator();
            this.validator.add((Validator.Object)this);
        }
        this.debugger = toolsDebugger;
        this.pcs = new PropertyChangeSupport(this);
    }

    ToolsVariable(ToolsDebugger toolsDebugger, RemoteObject remoteObject, RemoteField remoteField, int n) {
        this(toolsDebugger, true);
        this.update(remoteField, n, remoteObject);
    }

    ToolsVariable(ToolsDebugger toolsDebugger, String string, RemoteValue remoteValue, String string2) {
        this(toolsDebugger, false);
        this.update(string, remoteValue, string2);
    }

    ToolsVariable(ToolsDebugger toolsDebugger, RemoteArray remoteArray, String string, int n, String string2) {
        this(toolsDebugger, true);
        this.update(string, remoteArray, n, string2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.debugger = (ToolsDebugger)TopManager.getDefault().getDebugger();
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            throw new IOException();
        }
    }

    public String getVariableName() {
        return this.name;
    }

    public String getAsText() {
        return this.value == null ? "null" : this.value;
    }

    public void setAsText(final String string) {
        final String string2 = this.type;
        final String string3 = this.name;
        PropertyChangeSupport propertyChangeSupport = this.pcs;
        new Protector("ToolsVariable.setAsText"){

            public Object protect() throws Exception {
                if (ToolsVariable.this.parentObject == null) {
                    throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Static"));
                }
                if (string2.equals("int")) {
                    try {
                        ToolsVariable.this.parentObject.setField(string3, Integer.parseInt(string));
                        ToolsVariable.this.setValue(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Wrong_format"));
                    }
                    catch (Exception exception) {
                        throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Value_cannt_be_set"));
                    }
                } else if (string2.equals("byte")) {
                    try {
                        ToolsVariable.this.parentObject.setField(string3, (int)Byte.parseByte(string));
                        ToolsVariable.this.setValue(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Wrong_format"));
                    }
                    catch (Exception exception) {
                        throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Value_cannt_be_set"));
                    }
                } else if (string2.equals("short")) {
                    try {
                        ToolsVariable.this.parentObject.setField(string3, (int)Short.parseShort(string));
                        ToolsVariable.this.setValue(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Wrong_format"));
                    }
                    catch (Exception exception) {
                        throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Value_cannt_be_set"));
                    }
                } else if (string2.equals("boolean")) {
                    Boolean bl = Boolean.valueOf(string);
                    if (bl == null) {
                        throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Wrong_format"));
                    }
                    try {
                        ToolsVariable.this.parentObject.setField(string3, bl.booleanValue());
                        ToolsVariable.this.setValue(string);
                    }
                    catch (Exception exception) {
                        throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Value_cannt_be_set"));
                    }
                } else if (string2.equals("char")) {
                    if (string.length() < 1) {
                        throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Wrong_format"));
                    }
                    try {
                        ToolsVariable.this.parentObject.setField(string3, string.charAt(0));
                        ToolsVariable.this.setValue(string);
                    }
                    catch (Exception exception) {
                        throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Value_cannt_be_set"));
                    }
                } else if (string2.equals("double")) {
                    try {
                        ToolsVariable.this.parentObject.setField(string3, new Double(string).doubleValue());
                        ToolsVariable.this.setValue(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Wrong_format"));
                    }
                    catch (Exception exception) {
                        throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Value_cannt_be_set"));
                    }
                } else if (string2.equals("float")) {
                    try {
                        ToolsVariable.this.parentObject.setField(string3, new Float(string).floatValue());
                        ToolsVariable.this.setValue(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Wrong_format"));
                    }
                    catch (Exception exception) {
                        throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Value_cannt_be_set"));
                    }
                } else if (string2.equals("long")) {
                    try {
                        ToolsVariable.this.parentObject.setField(string3, Long.parseLong(string));
                        ToolsVariable.this.setValue(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Wrong_format"));
                    }
                    catch (Exception exception) {
                        throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Value_cannt_be_set"));
                    }
                } else {
                    throw Utils.localizeException((Exception)new IllegalArgumentException(), (String)bundle.getString("EXC_Unsupported_type"));
                }
                return null;
            }
        }.wait(this.debugger.synchronizer, this.debugger.killer);
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange("asText", null, null);
        }
    }

    public String getType() {
        return this.type;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isLeaf() {
        return this.remoteValue == null || !(this.remoteValue instanceof RemoteObject);
    }

    public VariablesFilter getVariablesFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        return this.debugger.getVariablesFilter();
    }

    public void setVariablesFilter(VariablesFilter variablesFilter) {
        if (variablesFilter == this.filter) {
            return;
        }
        if (variablesFilter != null && variablesFilter.equals(this.filter)) {
            return;
        }
        VariablesFilter variablesFilter2 = this.filter;
        this.filter = variablesFilter;
        this.pcs.firePropertyChange("variablesFilter", variablesFilter2, variablesFilter);
    }

    public String getInfo() {
        return null;
    }

    public AbstractVariable[] getVariables() {
        if (this.debugger.synchronizer == null) {
            return new ToolsVariable[0];
        }
        final String string = this.remoteValue instanceof RemoteArray ? this.innerType.substring(0, this.innerType.length() - 2) : this.innerType;
        final String string2 = this.name;
        return (AbstractVariable[])new Protector("ToolsVariable.getFields"){

            public Object protect() throws Exception {
                if (ToolsVariable.this.remoteValue == null || !(ToolsVariable.this.remoteValue instanceof RemoteObject)) {
                    return new ToolsVariable[0];
                }
                if (ToolsVariable.this.oldObject != null && ToolsVariable.this.oldObject.equals(ToolsVariable.this.remoteValue)) {
                    return ToolsVariable.this.oldFields;
                }
                try {
                    AbstractVariable[] abstractVariableArray;
                    RemoteObject remoteObject = (RemoteObject)ToolsVariable.this.remoteValue;
                    if (ToolsVariable.this.remoteValue instanceof RemoteArray) {
                        RemoteArray remoteArray = (RemoteArray)ToolsVariable.this.remoteValue;
                        RemoteValue[] remoteValueArray = remoteArray.getElements();
                        int n = remoteValueArray.length;
                        abstractVariableArray = new AbstractVariable[n];
                        int n2 = 0;
                        while (n2 < n) {
                            abstractVariableArray[n2] = new ToolsVariable(ToolsVariable.this.debugger, remoteArray, string2, n2, string);
                            ++n2;
                        }
                    } else {
                        RemoteField[] remoteFieldArray = ((RemoteObject)ToolsVariable.this.remoteValue).getFields();
                        RemoteClass remoteClass = remoteObject.getClazz();
                        RemoteField[] remoteFieldArray2 = remoteClass.getFields();
                        abstractVariableArray = new AbstractVariable[remoteFieldArray.length + remoteFieldArray2.length];
                        int n = remoteFieldArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            abstractVariableArray[n3] = new ToolsVariable(ToolsVariable.this.debugger, remoteObject, remoteFieldArray[n3], n3);
                            ++n3;
                        }
                        int n4 = remoteFieldArray2.length;
                        n3 = 0;
                        while (n3 < n4) {
                            abstractVariableArray[n3 + n] = new ToolsVariable(ToolsVariable.this.debugger, (RemoteObject)remoteClass, remoteFieldArray2[n3], n3);
                            ++n3;
                        }
                    }
                    ToolsVariable.this.oldObject = remoteObject;
                    ToolsVariable.access$302(ToolsVariable.this, abstractVariableArray);
                    return abstractVariableArray;
                }
                catch (Exception exception) {
                    return new ToolsVariable[0];
                }
            }
        }.wait(this.debugger.synchronizer, this.debugger.killer);
    }

    public AbstractVariable getVariable(final String string) {
        return (AbstractVariable)new Protector("ToolsVariable.getVariable"){

            public Object protect() throws Exception {
                try {
                    RemoteObject remoteObject = (RemoteObject)ToolsVariable.this.remoteValue;
                    RemoteField remoteField = ((RemoteObject)ToolsVariable.this.remoteValue).getField(string);
                    return new ToolsVariable(ToolsVariable.this.debugger, remoteObject, remoteField, 0);
                }
                catch (Exception exception) {
                    return new ToolsVariable[0];
                }
            }
        }.wait(this.debugger.synchronizer, this.debugger.killer);
    }

    public int getVariablesNumber() {
        if (this.remoteValue == null || !(this.remoteValue instanceof RemoteArray)) {
            return 0;
        }
        return ((RemoteArray)this.remoteValue).getSize();
    }

    public String getInnerType() {
        return this.innerType;
    }

    public boolean isObject() {
        return this.isObject;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public String getModifiers() {
        return this.modifiers;
    }

    boolean update(String string, RemoteArray remoteArray, int n, String string2) {
        this.name = string + " [" + n + "]";
        this.parentObject = remoteArray;
        this.index = n;
        this.type = string2;
        this.modifiers = "";
        try {
            this.remoteValue = remoteArray.getElement(n);
        }
        catch (Exception exception) {
            return false;
        }
        this.update();
        return true;
    }

    boolean update(RemoteField remoteField, int n, RemoteObject remoteObject) {
        if (remoteField == null) {
            return false;
        }
        this.name = remoteField.getName();
        this.slotNumber = n;
        this.parentObject = remoteObject;
        try {
            this.remoteValue = n >= 0 ? remoteObject.getFieldValue(n) : remoteObject.getFieldValue(this.name);
            this.modifiers = remoteField.getModifiers();
            this.type = remoteField.getType().toString();
        }
        catch (Exception exception) {
            return false;
        }
        this.update();
        return true;
    }

    void update(String string, RemoteValue remoteValue, String string2) {
        this.name = string;
        this.remoteValue = remoteValue;
        this.parentObject = null;
        this.type = string2;
        this.modifiers = "";
        this.update();
    }

    void setNull() {
        this.remoteValue = null;
        this.parentObject = null;
        this.modifiers = "";
        this.type = "";
        this.update();
    }

    public void validate() {
        if (this.debugger.synchronizer == null) {
            return;
        }
        new Protector("ToolsVariable.validate"){

            public Object protect() {
                ToolsVariable.this.validateUnsafe();
                return null;
            }
        }.wait(this.debugger.synchronizer, this.debugger.killer);
        PropertyChangeSupport propertyChangeSupport = this.pcs;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToolsVariable.this.firePropertyChange();
            }
        });
    }

    public boolean canRemove() {
        return true;
    }

    private void validateUnsafe() {
        if (this.isCloned) {
            if (this.isObject) {
                this.value = this.remoteValue.toString();
                this.checkString();
            }
            return;
        }
        if (this.index != -1) {
            if (this.parentObject instanceof RemoteArray) {
                try {
                    this.remoteValue = ((RemoteArray)this.parentObject).getElement(this.index);
                }
                catch (Exception exception) {}
            } else {
                this.remoteValue = null;
            }
        } else if (this.parentObject != null) {
            try {
                this.remoteValue = this.parentObject.getFieldValue(this.slotNumber);
            }
            catch (Exception exception) {}
        } else {
            this.remoteValue = null;
        }
        this.update();
    }

    private void update() {
        if (this.remoteValue == null) {
            this.isObject = false;
            this.isArray = false;
            this.value = null;
            this.innerType = "";
        } else {
            try {
                this.isObject = this.remoteValue.isObject();
                this.isArray = this.remoteValue instanceof RemoteArray;
                if (this.isArray) {
                    this.value = this.remoteValue.toString();
                    this.checkString();
                    this.innerType = this.obtainType(((RemoteArray)this.remoteValue).getClazz().getName());
                } else if (this.isObject) {
                    this.value = this.remoteValue.toString();
                    this.checkString();
                    this.innerType = ((RemoteObject)this.remoteValue).getClazz().getName();
                } else {
                    this.innerType = this.remoteValue.typeName();
                    this.value = this.remoteValue.description();
                    if (this.innerType.equals("byte") || this.innerType.equals("short")) {
                        try {
                            this.value = Integer.toString(Integer.decode(this.value));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
            catch (Exception exception) {
                this.type = null;
                this.value = exception.toString();
            }
        }
    }

    private String obtainType(String string) {
        try {
            if (!string.startsWith("[")) {
                return string;
            }
            int n = string.lastIndexOf(91);
            String string2 = "";
            switch (string.charAt(n + 1)) {
                case 'I': {
                    string2 = "int";
                    break;
                }
                case 'Z': {
                    string2 = "boolean";
                    break;
                }
                case 'J': {
                    string2 = "long";
                    break;
                }
                case 'F': {
                    string2 = "float";
                    break;
                }
                case 'D': {
                    string2 = "double";
                    break;
                }
                case 'B': {
                    string2 = "byte";
                    break;
                }
                case 'S': {
                    string2 = "short";
                    break;
                }
                case 'C': {
                    string2 = "char";
                    break;
                }
                case 'L': {
                    string2 = string.substring(n + 2, string.length() - 1);
                }
            }
            int n2 = 0;
            while (n2 <= n) {
                string2 = string2.concat("[]");
                ++n2;
            }
            return string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return string;
        }
    }

    private void checkString() {
        try {
            if (this.type.equals("java.lang.String")) {
                AbstractVariable[] abstractVariableArray = this.getVariables();
                int n = 0;
                while (n < abstractVariableArray.length) {
                    if (abstractVariableArray[n].getVariableName().equals("count")) break;
                    ++n;
                }
                if (n < abstractVariableArray.length && abstractVariableArray[n].getAsText().equals("0")) {
                    this.value = new String("");
                }
                if (this.value != null) {
                    this.value = "\"".concat(this.value.concat("\""));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setValue(String string) {
        this.value = string;
    }

    public JavaVariable createFixedVariable() {
        return new ToolsFixedWatch(this.debugger, this.name, this.remoteValue, this.type);
    }

    public boolean isFixedVariable() {
        return this.isCloned;
    }

    ToolsDebugger getDebugger() {
        return this.debugger;
    }

    void setErrorMessage(String string) {
    }

    RemoteValue getRemoteValue() {
        return this.remoteValue;
    }

    void setRemoteValue(RemoteValue remoteValue) {
        this.remoteValue = remoteValue;
    }

    void setError_protected(String string) {
    }

    void firePropertyChange() {
        this.pcs.firePropertyChange(null, null, null);
    }

    public JavaVariable[] filterVariables(final ModifiersFilter modifiersFilter, int n, final int n2) {
        if (this.debugger.synchronizer == null) {
            return new ToolsVariable[0];
        }
        final String string = this.remoteValue instanceof RemoteArray ? this.innerType.substring(0, this.innerType.length() - 2) : this.innerType;
        final String string2 = this.name;
        return (ToolsVariable[])new Protector("ToolsVariable.getFields"){

            public Object protect() throws Exception {
                if (ToolsVariable.this.remoteValue == null || !(ToolsVariable.this.remoteValue instanceof RemoteObject)) {
                    return new ToolsVariable[0];
                }
                if (ToolsVariable.this.oldObject != null && ToolsVariable.this.oldObject.equals(ToolsVariable.this.remoteValue)) {
                    return ToolsVariable.this.oldFields;
                }
                try {
                    ToolsVariable[] toolsVariableArray;
                    RemoteObject remoteObject = (RemoteObject)ToolsVariable.this.remoteValue;
                    if (ToolsVariable.this.remoteValue instanceof RemoteArray) {
                        RemoteArray remoteArray = (RemoteArray)ToolsVariable.this.remoteValue;
                        int n = Math.min(remoteArray.getSize(), n2);
                        toolsVariableArray = new ToolsVariable[n];
                        int n22 = 0;
                        while (n22 < n) {
                            toolsVariableArray[n22] = new ToolsVariable(ToolsVariable.this.debugger, remoteArray, string2, n22, string);
                            ++n22;
                        }
                    } else {
                        RemoteField[] remoteFieldArray = ((RemoteObject)ToolsVariable.this.remoteValue).getFields();
                        RemoteClass remoteClass = remoteObject.getClazz();
                        RemoteField[] remoteFieldArray2 = remoteClass.getFields();
                        ArrayList<ToolsVariable> arrayList = new ArrayList<ToolsVariable>(remoteFieldArray.length + remoteFieldArray2.length);
                        int n = remoteFieldArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            if (modifiersFilter == null || ToolsFilter.filter(remoteFieldArray[n3], modifiersFilter)) {
                                arrayList.add(new ToolsVariable(ToolsVariable.this.debugger, remoteObject, remoteFieldArray[n3], n3));
                            }
                            ++n3;
                        }
                        int n4 = remoteFieldArray2.length;
                        n3 = 0;
                        while (n3 < n4) {
                            if (modifiersFilter == null || ToolsFilter.filter(remoteFieldArray2[n3], modifiersFilter)) {
                                arrayList.add(new ToolsVariable(ToolsVariable.this.debugger, (RemoteObject)remoteClass, remoteFieldArray2[n3], n3));
                            }
                            ++n3;
                        }
                        toolsVariableArray = new ToolsVariable[arrayList.size()];
                        arrayList.toArray(toolsVariableArray);
                    }
                    ToolsVariable.this.oldObject = remoteObject;
                    ToolsVariable.access$302(ToolsVariable.this, (AbstractVariable[])toolsVariableArray);
                    return toolsVariableArray;
                }
                catch (Exception exception) {
                    return new ToolsVariable[0];
                }
            }
        }.wait(this.debugger.synchronizer, this.debugger.killer);
    }

    public String toStringValue() {
        return this.value;
    }

    public int getSize() {
        if (this.remoteValue instanceof RemoteArray) {
            return ((RemoteArray)this.remoteValue).getSize();
        }
        return 0;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid start index: " + n + " (must be non-negative)");
        }
        int n2 = this.startIndex;
        this.startIndex = n;
        this.firePropertyChange();
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid length: " + n + " (must be non-negative)");
        }
        int n2 = this.length;
        this.length = n;
        this.firePropertyChange();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ AbstractVariable[] access$302(ToolsVariable toolsVariable, AbstractVariable[] abstractVariableArray) {
        toolsVariable.oldFields = abstractVariableArray;
        return abstractVariableArray;
    }
}

