/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import koala.dynamicjava.util.AmbiguousFieldException;
import koala.dynamicjava.util.ReflectionUtilities;

public class InterpreterUtilities {
    public static final Byte ONE = new Byte(1);
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$Boolean;
    private static /* synthetic */ Class class$Ljava$lang$Byte;
    private static /* synthetic */ Class class$Ljava$lang$Integer;
    private static /* synthetic */ Class class$Ljava$lang$Character;
    private static /* synthetic */ Class class$Ljava$lang$Short;
    private static /* synthetic */ Class class$Ljava$lang$Long;
    private static /* synthetic */ Class class$Ljava$lang$Float;
    private static /* synthetic */ Class class$Ljava$lang$Double;

    public static Object equalTo(Class clazz, Class clazz2, Object object, Object object2) {
        return InterpreterUtilities.equalityOperation(clazz, clazz2, object, object2, EqualToPredicate.INSTANCE);
    }

    public static Object notEqualTo(Class clazz, Class clazz2, Object object, Object object2) {
        return InterpreterUtilities.equalityOperation(clazz, clazz2, object, object2, NotEqualToPredicate.INSTANCE);
    }

    protected static Object equalityOperation(Class clazz, Class clazz2, Object object, Object object2, BinaryPredicate binaryPredicate) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return binaryPredicate.invoke((Boolean)object, (Boolean)object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (clazz == Character.TYPE) {
                object = new Integer(((Character)object).charValue());
            }
            if (clazz2 == Character.TYPE) {
                object2 = new Integer(((Character)object2).charValue());
            }
            return binaryPredicate.invoke(((Number)object).doubleValue(), ((Number)object2).doubleValue()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return binaryPredicate.invoke(object, object2) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object add(Class clazz, Object object, Object object2) {
        if (clazz == (class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = InterpreterUtilities.class$("java.lang.String")))) {
            return "" + object + object2;
        }
        return InterpreterUtilities.binaryArithmeticOperation(clazz, object, object2, AddOperation.INSTANCE);
    }

    public static Object subtract(Class clazz, Object object, Object object2) {
        return InterpreterUtilities.binaryArithmeticOperation(clazz, object, object2, SubtractOperation.INSTANCE);
    }

    public static Object multiply(Class clazz, Object object, Object object2) {
        return InterpreterUtilities.binaryArithmeticOperation(clazz, object, object2, MultiplyOperation.INSTANCE);
    }

    public static Object divide(Class clazz, Object object, Object object2) {
        return InterpreterUtilities.binaryArithmeticOperation(clazz, object, object2, DivideOperation.INSTANCE);
    }

    public static Object remainder(Class clazz, Object object, Object object2) {
        return InterpreterUtilities.binaryArithmeticOperation(clazz, object, object2, RemainderOperation.INSTANCE);
    }

    protected static Object binaryArithmeticOperation(Class clazz, Object object, Object object2, BinaryArithmeticOperation binaryArithmeticOperation) {
        if (object instanceof Character) {
            object = new Integer(((Character)object).charValue());
        }
        if (object2 instanceof Character) {
            object2 = new Integer(((Character)object2).charValue());
        }
        if (clazz == Integer.TYPE) {
            return new Integer(binaryArithmeticOperation.invoke(((Number)object).intValue(), ((Number)object2).intValue()));
        }
        if (clazz == Long.TYPE) {
            return new Long(binaryArithmeticOperation.invoke(((Number)object).longValue(), ((Number)object2).longValue()));
        }
        if (clazz == Float.TYPE) {
            return new Float(binaryArithmeticOperation.invoke(((Number)object).floatValue(), ((Number)object2).floatValue()));
        }
        return new Double(binaryArithmeticOperation.invoke(((Number)object).doubleValue(), ((Number)object2).doubleValue()));
    }

    public static Object lessThan(Object object, Object object2) {
        return InterpreterUtilities.relationalOperation(object, object2, LessThanOperation.INSTANCE);
    }

    public static Object lessOrEqual(Object object, Object object2) {
        return InterpreterUtilities.relationalOperation(object, object2, LessOrEqualOperation.INSTANCE);
    }

    public static Object greaterThan(Object object, Object object2) {
        return InterpreterUtilities.relationalOperation(object, object2, GreaterThanOperation.INSTANCE);
    }

    public static Object greaterOrEqual(Object object, Object object2) {
        return InterpreterUtilities.relationalOperation(object, object2, GreaterOrEqualOperation.INSTANCE);
    }

    protected static Object relationalOperation(Object object, Object object2, RelationalOperation relationalOperation) {
        if (object instanceof Character) {
            object = new Integer(((Character)object).charValue());
        }
        if (object2 instanceof Character) {
            object2 = new Integer(((Character)object2).charValue());
        }
        return relationalOperation.invoke(((Number)object).doubleValue(), ((Number)object2).doubleValue()) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object bitAnd(Class clazz, Object object, Object object2) {
        return InterpreterUtilities.bitwiseOperation(clazz, object, object2, BitAndOperation.INSTANCE);
    }

    public static Object xOr(Class clazz, Object object, Object object2) {
        return InterpreterUtilities.bitwiseOperation(clazz, object, object2, XOrOperation.INSTANCE);
    }

    public static Object bitOr(Class clazz, Object object, Object object2) {
        return InterpreterUtilities.bitwiseOperation(clazz, object, object2, BitOrOperation.INSTANCE);
    }

    protected static Object bitwiseOperation(Class clazz, Object object, Object object2, BitwiseOperation bitwiseOperation) {
        if (clazz == Boolean.TYPE) {
            return new Boolean(bitwiseOperation.invoke((Boolean)object, (Boolean)object2));
        }
        if (object instanceof Character) {
            object = new Integer(((Character)object).charValue());
        }
        if (object2 instanceof Character) {
            object2 = new Integer(((Character)object2).charValue());
        }
        if (clazz == Integer.TYPE) {
            return new Integer(bitwiseOperation.invoke(((Number)object).intValue(), ((Number)object2).intValue()));
        }
        return new Long(bitwiseOperation.invoke(((Number)object).longValue(), ((Number)object2).longValue()));
    }

    public static Object shiftLeft(Class clazz, Object object, Object object2) {
        return InterpreterUtilities.shiftOperation(clazz, object, object2, ShiftLeftOperation.INSTANCE);
    }

    public static Object shiftRight(Class clazz, Object object, Object object2) {
        return InterpreterUtilities.shiftOperation(clazz, object, object2, ShiftRightOperation.INSTANCE);
    }

    public static Object unsignedShiftRight(Class clazz, Object object, Object object2) {
        return InterpreterUtilities.shiftOperation(clazz, object, object2, UnsignedShiftRightOperation.INSTANCE);
    }

    protected static Object shiftOperation(Class clazz, Object object, Object object2, ShiftOperation shiftOperation) {
        if (object instanceof Character) {
            object = new Integer(((Character)object).charValue());
        }
        if (object2 instanceof Character) {
            object2 = new Integer(((Character)object2).charValue());
        }
        if (clazz == Integer.TYPE) {
            return new Integer(shiftOperation.invoke(((Number)object).intValue(), ((Number)object2).intValue()));
        }
        return new Long(shiftOperation.invoke(((Number)object).longValue(), ((Number)object2).intValue()));
    }

    public static Object plus(Class clazz, Object object) {
        return InterpreterUtilities.unaryOperation(clazz, object, PlusOperation.INSTANCE);
    }

    public static Object minus(Class clazz, Object object) {
        return InterpreterUtilities.unaryOperation(clazz, object, MinusOperation.INSTANCE);
    }

    public static Object unaryOperation(Class clazz, Object object, UnaryOperation unaryOperation) {
        if (object instanceof Character) {
            object = new Integer(((Character)object).charValue());
        }
        if (clazz == Integer.TYPE) {
            return new Integer(unaryOperation.invoke(((Number)object).intValue()));
        }
        if (clazz == Long.TYPE) {
            return new Long(unaryOperation.invoke(((Number)object).longValue()));
        }
        if (clazz == Float.TYPE) {
            return new Float(unaryOperation.invoke(((Number)object).floatValue()));
        }
        return new Double(unaryOperation.invoke(((Number)object).doubleValue()));
    }

    public static Class getDeclaringClass(Class clazz) {
        Class clazz2 = clazz.getDeclaringClass();
        if (clazz2 == null) {
            try {
                Field field = clazz.getField("declaring$Class$Reference$0");
                clazz2 = (Class)field.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return clazz2;
    }

    public static Field getOuterField(Class clazz, String string) throws NoSuchFieldException, AmbiguousFieldException {
        boolean bl = Modifier.isStatic(clazz.getModifiers());
        Class clazz2 = clazz != null ? InterpreterUtilities.getDeclaringClass(clazz) : null;
        while (clazz2 != null) {
            try {
                Field field = ReflectionUtilities.getField(clazz2, string);
                if (!bl || Modifier.isStatic(field.getModifiers())) {
                    return field;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            bl |= Modifier.isStatic(clazz2.getModifiers());
            clazz2 = InterpreterUtilities.getDeclaringClass(clazz2);
        }
        throw new NoSuchFieldException(string);
    }

    public static Method lookupOuterMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        boolean bl = Modifier.isStatic(clazz.getModifiers());
        Class clazz2 = clazz != null ? InterpreterUtilities.getDeclaringClass(clazz) : null;
        while (clazz2 != null) {
            try {
                Method method = ReflectionUtilities.lookupMethod(clazz2, string, classArray);
                if (!bl || Modifier.isStatic(method.getModifiers())) {
                    return method;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            bl |= Modifier.isStatic(clazz2.getModifiers());
            clazz2 = InterpreterUtilities.getDeclaringClass(clazz2);
        }
        throw new NoSuchMethodException(string);
    }

    public static boolean isValidAssignment(Class clazz, Object object) {
        Class<?> clazz2;
        Class<?> clazz3 = clazz2 = object == null ? null : object.getClass();
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                if (clazz == Boolean.TYPE && clazz2 != (class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = InterpreterUtilities.class$("java.lang.Boolean")))) {
                    return false;
                }
                if (clazz == Byte.TYPE && clazz2 != (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = InterpreterUtilities.class$("java.lang.Byte")))) {
                    if (clazz2 == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = InterpreterUtilities.class$("java.lang.Integer")))) {
                        Number number = (Number)object;
                        return number.intValue() == number.byteValue();
                    }
                    return false;
                }
                if ((clazz == Short.TYPE || clazz2 == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = InterpreterUtilities.class$("java.lang.Character")))) && clazz2 != (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = InterpreterUtilities.class$("java.lang.Byte"))) && clazz2 != (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = InterpreterUtilities.class$("java.lang.Short"))) && clazz2 != (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = InterpreterUtilities.class$("java.lang.Character")))) {
                    if (clazz2 == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = InterpreterUtilities.class$("java.lang.Integer")))) {
                        Number number = (Number)object;
                        return number.intValue() == number.shortValue();
                    }
                    return false;
                }
                if (clazz == Integer.TYPE && clazz2 != (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = InterpreterUtilities.class$("java.lang.Byte"))) && clazz2 != (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = InterpreterUtilities.class$("java.lang.Short"))) && clazz2 != (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = InterpreterUtilities.class$("java.lang.Character"))) && clazz2 != (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = InterpreterUtilities.class$("java.lang.Integer")))) {
                    return false;
                }
                if (clazz == Long.TYPE && clazz2 != (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = InterpreterUtilities.class$("java.lang.Byte"))) && clazz2 != (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = InterpreterUtilities.class$("java.lang.Short"))) && clazz2 != (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = InterpreterUtilities.class$("java.lang.Character"))) && clazz2 != (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = InterpreterUtilities.class$("java.lang.Integer"))) && clazz2 != (class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = InterpreterUtilities.class$("java.lang.Long")))) {
                    return false;
                }
                if (clazz == Float.TYPE && clazz2 != (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = InterpreterUtilities.class$("java.lang.Byte"))) && clazz2 != (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = InterpreterUtilities.class$("java.lang.Short"))) && clazz2 != (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = InterpreterUtilities.class$("java.lang.Character"))) && clazz2 != (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = InterpreterUtilities.class$("java.lang.Integer"))) && clazz2 != (class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = InterpreterUtilities.class$("java.lang.Long"))) && clazz2 != (class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = InterpreterUtilities.class$("java.lang.Float")))) {
                    return false;
                }
                if (clazz == Double.TYPE && clazz2 != (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = InterpreterUtilities.class$("java.lang.Byte"))) && clazz2 != (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = InterpreterUtilities.class$("java.lang.Short"))) && clazz2 != (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = InterpreterUtilities.class$("java.lang.Character"))) && clazz2 != (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = InterpreterUtilities.class$("java.lang.Integer"))) && clazz2 != (class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = InterpreterUtilities.class$("java.lang.Long"))) && clazz2 != (class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = InterpreterUtilities.class$("java.lang.Float"))) && clazz2 != (class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = InterpreterUtilities.class$("java.lang.Double")))) {
                    return false;
                }
            } else if (clazz2 != null && !clazz.isAssignableFrom(clazz2) && !clazz2.isAssignableFrom(clazz)) {
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected InterpreterUtilities() {
    }

    protected static abstract class BinaryPredicate {
        abstract boolean invoke(boolean var1, boolean var2);

        abstract boolean invoke(double var1, double var3);

        abstract boolean invoke(Object var1, Object var2);

        BinaryPredicate() {
        }
    }

    protected static class EqualToPredicate
    extends BinaryPredicate {
        static final EqualToPredicate INSTANCE = new EqualToPredicate();

        boolean invoke(boolean bl, boolean bl2) {
            return bl == bl2;
        }

        boolean invoke(double d, double d2) {
            return d == d2;
        }

        boolean invoke(Object object, Object object2) {
            return object == object2;
        }

        EqualToPredicate() {
        }
    }

    protected static class NotEqualToPredicate
    extends BinaryPredicate {
        static final NotEqualToPredicate INSTANCE = new NotEqualToPredicate();

        boolean invoke(boolean bl, boolean bl2) {
            return bl != bl2;
        }

        boolean invoke(double d, double d2) {
            return d != d2;
        }

        boolean invoke(Object object, Object object2) {
            return object != object2;
        }

        NotEqualToPredicate() {
        }
    }

    protected static abstract class BinaryArithmeticOperation {
        abstract int invoke(int var1, int var2);

        abstract long invoke(long var1, long var3);

        abstract float invoke(float var1, float var2);

        abstract double invoke(double var1, double var3);

        BinaryArithmeticOperation() {
        }
    }

    protected static class AddOperation
    extends BinaryArithmeticOperation {
        static final AddOperation INSTANCE = new AddOperation();

        int invoke(int n, int n2) {
            return n + n2;
        }

        long invoke(long l, long l2) {
            return l + l2;
        }

        float invoke(float f, float f2) {
            return f + f2;
        }

        double invoke(double d, double d2) {
            return d + d2;
        }

        AddOperation() {
        }
    }

    protected static class SubtractOperation
    extends BinaryArithmeticOperation {
        static final SubtractOperation INSTANCE = new SubtractOperation();

        int invoke(int n, int n2) {
            return n - n2;
        }

        long invoke(long l, long l2) {
            return l - l2;
        }

        float invoke(float f, float f2) {
            return f - f2;
        }

        double invoke(double d, double d2) {
            return d - d2;
        }

        SubtractOperation() {
        }
    }

    protected static class MultiplyOperation
    extends BinaryArithmeticOperation {
        static final MultiplyOperation INSTANCE = new MultiplyOperation();

        int invoke(int n, int n2) {
            return n * n2;
        }

        long invoke(long l, long l2) {
            return l * l2;
        }

        float invoke(float f, float f2) {
            return f * f2;
        }

        double invoke(double d, double d2) {
            return d * d2;
        }

        MultiplyOperation() {
        }
    }

    protected static class DivideOperation
    extends BinaryArithmeticOperation {
        static final DivideOperation INSTANCE = new DivideOperation();

        int invoke(int n, int n2) {
            return n / n2;
        }

        long invoke(long l, long l2) {
            return l / l2;
        }

        float invoke(float f, float f2) {
            return f / f2;
        }

        double invoke(double d, double d2) {
            return d / d2;
        }

        DivideOperation() {
        }
    }

    protected static class RemainderOperation
    extends BinaryArithmeticOperation {
        static final RemainderOperation INSTANCE = new RemainderOperation();

        int invoke(int n, int n2) {
            return n % n2;
        }

        long invoke(long l, long l2) {
            return l % l2;
        }

        float invoke(float f, float f2) {
            return f % f2;
        }

        double invoke(double d, double d2) {
            return d % d2;
        }

        RemainderOperation() {
        }
    }

    protected static abstract class RelationalOperation {
        abstract boolean invoke(double var1, double var3);

        RelationalOperation() {
        }
    }

    protected static class LessThanOperation
    extends RelationalOperation {
        static final LessThanOperation INSTANCE = new LessThanOperation();

        boolean invoke(double d, double d2) {
            return d < d2;
        }

        LessThanOperation() {
        }
    }

    protected static class LessOrEqualOperation
    extends RelationalOperation {
        static final LessOrEqualOperation INSTANCE = new LessOrEqualOperation();

        boolean invoke(double d, double d2) {
            return d <= d2;
        }

        LessOrEqualOperation() {
        }
    }

    protected static class GreaterThanOperation
    extends RelationalOperation {
        static final GreaterThanOperation INSTANCE = new GreaterThanOperation();

        boolean invoke(double d, double d2) {
            return d > d2;
        }

        GreaterThanOperation() {
        }
    }

    protected static class GreaterOrEqualOperation
    extends RelationalOperation {
        static final GreaterOrEqualOperation INSTANCE = new GreaterOrEqualOperation();

        boolean invoke(double d, double d2) {
            return d >= d2;
        }

        GreaterOrEqualOperation() {
        }
    }

    protected static abstract class BitwiseOperation {
        abstract boolean invoke(boolean var1, boolean var2);

        abstract int invoke(int var1, int var2);

        abstract long invoke(long var1, long var3);

        BitwiseOperation() {
        }
    }

    protected static class BitAndOperation
    extends BitwiseOperation {
        static final BitAndOperation INSTANCE = new BitAndOperation();

        boolean invoke(boolean bl, boolean bl2) {
            return bl & bl2;
        }

        int invoke(int n, int n2) {
            return n & n2;
        }

        long invoke(long l, long l2) {
            return l & l2;
        }

        BitAndOperation() {
        }
    }

    protected static class BitOrOperation
    extends BitwiseOperation {
        static final BitOrOperation INSTANCE = new BitOrOperation();

        boolean invoke(boolean bl, boolean bl2) {
            return bl | bl2;
        }

        int invoke(int n, int n2) {
            return n | n2;
        }

        long invoke(long l, long l2) {
            return l | l2;
        }

        BitOrOperation() {
        }
    }

    protected static class XOrOperation
    extends BitwiseOperation {
        static final XOrOperation INSTANCE = new XOrOperation();

        boolean invoke(boolean bl, boolean bl2) {
            return bl ^ bl2;
        }

        int invoke(int n, int n2) {
            return n ^ n2;
        }

        long invoke(long l, long l2) {
            return l ^ l2;
        }

        XOrOperation() {
        }
    }

    protected static abstract class ShiftOperation {
        abstract int invoke(int var1, int var2);

        abstract long invoke(long var1, int var3);

        ShiftOperation() {
        }
    }

    protected static class ShiftLeftOperation
    extends ShiftOperation {
        static final ShiftLeftOperation INSTANCE = new ShiftLeftOperation();

        int invoke(int n, int n2) {
            return n << n2;
        }

        long invoke(long l, int n) {
            return l << n;
        }

        ShiftLeftOperation() {
        }
    }

    protected static class ShiftRightOperation
    extends ShiftOperation {
        static final ShiftRightOperation INSTANCE = new ShiftRightOperation();

        int invoke(int n, int n2) {
            return n >> n2;
        }

        long invoke(long l, int n) {
            return l >> n;
        }

        ShiftRightOperation() {
        }
    }

    protected static class UnsignedShiftRightOperation
    extends ShiftOperation {
        static final UnsignedShiftRightOperation INSTANCE = new UnsignedShiftRightOperation();

        int invoke(int n, int n2) {
            return n >>> n2;
        }

        long invoke(long l, int n) {
            return l >>> n;
        }

        UnsignedShiftRightOperation() {
        }
    }

    protected static abstract class UnaryOperation {
        abstract int invoke(int var1);

        abstract long invoke(long var1);

        abstract float invoke(float var1);

        abstract double invoke(double var1);

        UnaryOperation() {
        }
    }

    protected static class PlusOperation
    extends UnaryOperation {
        static final PlusOperation INSTANCE = new PlusOperation();

        int invoke(int n) {
            return n;
        }

        long invoke(long l) {
            return l;
        }

        float invoke(float f) {
            return f;
        }

        double invoke(double d) {
            return d;
        }

        PlusOperation() {
        }
    }

    protected static class MinusOperation
    extends UnaryOperation {
        static final MinusOperation INSTANCE = new MinusOperation();

        int invoke(int n) {
            return -n;
        }

        long invoke(long l) {
            return -l;
        }

        float invoke(float f) {
            return -f;
        }

        double invoke(double d) {
            return -d;
        }

        MinusOperation() {
        }
    }
}

