/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.util.HashMap;
import java.util.Map;

public abstract class JVMUtilities {
    private static final Map types = new HashMap(11, 1.0f);
    private static final Map stypes = new HashMap(11, 1.0f);

    public static String getName(Class clazz) {
        String string = (String)types.get(clazz);
        if (string != null) {
            return string;
        }
        return clazz.getName().replace('.', '/');
    }

    public static String getName(String string) {
        String string2 = (String)stypes.get(string);
        if (string2 != null) {
            return string2;
        }
        if (string.endsWith("[]")) {
            if (string.endsWith("[][]")) {
                return "[" + JVMUtilities.getName(string.substring(0, string.length() - 2));
            }
            return "[" + JVMUtilities.getReturnTypeName(string.substring(0, string.length() - 2));
        }
        return string.replace('.', '/');
    }

    public static String getReturnTypeName(Class clazz) {
        String string = (String)types.get(clazz);
        if (string != null) {
            return string;
        }
        return (clazz.isArray() ? clazz.getName() : "L" + clazz.getName() + ";").replace('.', '/');
    }

    public static String getReturnTypeName(String string) {
        String string2 = (String)stypes.get(string);
        if (string2 != null) {
            return string2;
        }
        if (string.endsWith("[]")) {
            return "[" + JVMUtilities.getReturnTypeName(string.substring(0, string.length() - 2));
        }
        return (string.startsWith("[") ? string : "L" + string + ";").replace('.', '/');
    }

    public static String getParameterTypeName(Class clazz) {
        return JVMUtilities.getReturnTypeName(clazz);
    }

    public static String getParameterTypeName(String string) {
        return JVMUtilities.getReturnTypeName(string);
    }

    public static String createMethodDescriptor(String string, String[] stringArray) {
        if (stringArray != null) {
            String string2 = "(";
            int n = 0;
            while (n < stringArray.length) {
                string2 = string2 + stringArray[n];
                ++n;
            }
            return string2 + ")" + string;
        }
        return string;
    }

    private JVMUtilities() {
    }

    static {
        types.put(Byte.TYPE, "B");
        types.put(Character.TYPE, "C");
        types.put(Double.TYPE, "D");
        types.put(Float.TYPE, "F");
        types.put(Integer.TYPE, "I");
        types.put(Long.TYPE, "J");
        types.put(Short.TYPE, "S");
        types.put(Boolean.TYPE, "Z");
        types.put(Void.TYPE, "V");
        stypes.put("byte", "B");
        stypes.put("char", "C");
        stypes.put("double", "D");
        stypes.put("float", "F");
        stypes.put("int", "I");
        stypes.put("long", "J");
        stypes.put("short", "S");
        stypes.put("boolean", "Z");
        stypes.put("void", "V");
    }
}

