/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import koala.dynamicjava.classfile.AttributeInfo;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.ConstantString;

public class ConstantValueAttribute
extends AttributeInfo {
    private short index;

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeInt(this.length);
        dataOutputStream.writeShort(this.index);
    }

    public ConstantValueAttribute(ConstantPool constantPool, Integer n) {
        this(constantPool);
        this.index = this.constantPool.put(n);
    }

    public ConstantValueAttribute(ConstantPool constantPool, Long l) {
        this(constantPool);
        this.index = this.constantPool.put(l);
    }

    public ConstantValueAttribute(ConstantPool constantPool, Float f) {
        this(constantPool);
        this.index = this.constantPool.put(f);
    }

    public ConstantValueAttribute(ConstantPool constantPool, Double d) {
        this(constantPool);
        this.index = this.constantPool.put(d);
    }

    public ConstantValueAttribute(ConstantPool constantPool, String string) {
        this(constantPool);
        this.index = this.constantPool.put(new ConstantString(string));
    }

    private ConstantValueAttribute(ConstantPool constantPool) {
        super(constantPool, "ConstantValue");
        this.length = 2;
    }
}

