/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import koala.dynamicjava.classfile.ClassIdentifier;
import koala.dynamicjava.classfile.ConstantString;
import koala.dynamicjava.classfile.FieldIdentifier;
import koala.dynamicjava.classfile.InterfaceMethodIdentifier;
import koala.dynamicjava.classfile.JVMUtilities;
import koala.dynamicjava.classfile.MethodIdentifier;

public class ConstantPool {
    private static final byte CONSTANT_UTF8 = 1;
    private static final byte CONSTANT_INTEGER = 3;
    private static final byte CONSTANT_FLOAT = 4;
    private static final byte CONSTANT_LONG = 5;
    private static final byte CONSTANT_DOUBLE = 6;
    private static final byte CONSTANT_CLASS = 7;
    private static final byte CONSTANT_STRING = 8;
    private static final byte CONSTANT_FIELDREF = 9;
    private static final byte CONSTANT_METHODREF = 10;
    private static final byte CONSTANT_INTERFACEMETHODREF = 11;
    private static final byte CONSTANT_NAMEANDTYPE = 12;
    private Map constants = new HashMap();
    private short count = 1;
    List constantList = new LinkedList();

    public short getCount() {
        return this.count;
    }

    public short put(Integer n) {
        Info info = (Info)this.constants.get(n);
        if (info == null) {
            ConstantPool constantPool = this;
            if (constantPool == null) {
                throw null;
            }
            info = constantPool.new IntegerInfo(n);
        }
        return info.index;
    }

    public short put(Long l) {
        Info info = (Info)this.constants.get(l);
        if (info == null) {
            ConstantPool constantPool = this;
            if (constantPool == null) {
                throw null;
            }
            info = constantPool.new LongInfo(l);
        }
        return info.index;
    }

    public short put(Float f) {
        Info info = (Info)this.constants.get(f);
        if (info == null) {
            ConstantPool constantPool = this;
            if (constantPool == null) {
                throw null;
            }
            info = constantPool.new FloatInfo(f);
        }
        return info.index;
    }

    public short put(Double d) {
        Info info = (Info)this.constants.get(d);
        if (info == null) {
            ConstantPool constantPool = this;
            if (constantPool == null) {
                throw null;
            }
            info = constantPool.new DoubleInfo(d);
        }
        return info.index;
    }

    public short put(ConstantString constantString) {
        Info info = (Info)this.constants.get(constantString);
        if (info == null) {
            ConstantPool constantPool = this;
            if (constantPool == null) {
                throw null;
            }
            info = constantPool.new StringInfo(constantString);
        }
        return info.index;
    }

    public short put(ClassIdentifier classIdentifier) {
        Info info = (Info)this.constants.get(classIdentifier);
        if (info == null) {
            ConstantPool constantPool = this;
            if (constantPool == null) {
                throw null;
            }
            info = constantPool.new ClassInfo(classIdentifier);
        }
        return info.index;
    }

    public short put(FieldIdentifier fieldIdentifier) {
        Info info = (Info)this.constants.get(fieldIdentifier);
        if (info == null) {
            ConstantPool constantPool = this;
            if (constantPool == null) {
                throw null;
            }
            info = constantPool.new FieldInfo(fieldIdentifier);
        }
        return info.index;
    }

    public short put(MethodIdentifier methodIdentifier) {
        Info info = (Info)this.constants.get(methodIdentifier);
        if (info == null) {
            ConstantPool constantPool = this;
            if (constantPool == null) {
                throw null;
            }
            info = constantPool.new MethodInfo(methodIdentifier);
        }
        return info.index;
    }

    public short put(InterfaceMethodIdentifier interfaceMethodIdentifier) {
        Info info = (Info)this.constants.get(interfaceMethodIdentifier);
        if (info == null) {
            ConstantPool constantPool = this;
            if (constantPool == null) {
                throw null;
            }
            info = constantPool.new InterfaceMethodInfo(interfaceMethodIdentifier);
        }
        return info.index;
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(new DataOutputStream(outputStream));
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.count);
        Iterator iterator = this.constantList.iterator();
        while (iterator.hasNext()) {
            ((Info)iterator.next()).write(dataOutputStream);
        }
    }

    short putNameAndType(String string, String string2, String[] stringArray) {
        NameAndTypeKey nameAndTypeKey = new NameAndTypeKey(string, string2, stringArray);
        Info info = (Info)this.constants.get(nameAndTypeKey);
        if (info == null) {
            ConstantPool constantPool = this;
            if (constantPool == null) {
                throw null;
            }
            info = constantPool.new NameAndTypeInfo(nameAndTypeKey);
        }
        return info.index;
    }

    short putUTF8(String string) {
        Info info = (Info)this.constants.get(string);
        if (info == null) {
            ConstantPool constantPool = this;
            if (constantPool == null) {
                throw null;
            }
            info = constantPool.new UTF8Info(string);
        }
        return info.index;
    }

    Info get(short s) {
        return (Info)this.constantList.get(s);
    }

    static /* synthetic */ byte access$3() {
        return CONSTANT_INTEGER;
    }

    static /* synthetic */ byte access$4() {
        return CONSTANT_LONG;
    }

    static /* synthetic */ byte access$5() {
        return CONSTANT_FLOAT;
    }

    static /* synthetic */ byte access$6() {
        return CONSTANT_DOUBLE;
    }

    static /* synthetic */ byte access$7() {
        return CONSTANT_STRING;
    }

    static /* synthetic */ byte access$8() {
        return CONSTANT_CLASS;
    }

    static /* synthetic */ byte access$9() {
        return CONSTANT_FIELDREF;
    }

    static /* synthetic */ byte access$10() {
        return CONSTANT_METHODREF;
    }

    static /* synthetic */ byte access$11() {
        return CONSTANT_INTERFACEMETHODREF;
    }

    static /* synthetic */ byte access$12() {
        return CONSTANT_NAMEANDTYPE;
    }

    static /* synthetic */ byte access$13() {
        return CONSTANT_UTF8;
    }

    abstract class Info {
        short index;

        short getIndexIncrement() {
            return 1;
        }

        abstract void write(DataOutputStream var1) throws IOException;

        Info(Object object) {
            this.index = ConstantPool.this.count;
            ConstantPool constantPool2 = ConstantPool.this;
            constantPool2.count = (short)(constantPool2.count + this.getIndexIncrement());
            ConstantPool.this.constants.put(object, this);
            ConstantPool.this.constantList.add(this);
        }
    }

    class IntegerInfo
    extends Info {
        Integer value;

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(3);
            dataOutputStream.writeInt(this.value);
        }

        IntegerInfo(Integer n) {
            super(n);
            this.value = n;
        }
    }

    class LongInfo
    extends Info {
        Long value;

        short getIndexIncrement() {
            return 2;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(5);
            dataOutputStream.writeLong(this.value);
        }

        LongInfo(Long l) {
            super(l);
            this.value = l;
        }
    }

    class FloatInfo
    extends Info {
        Float value;

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(4);
            dataOutputStream.writeFloat(this.value.floatValue());
        }

        FloatInfo(Float f) {
            super(f);
            this.value = f;
        }
    }

    class DoubleInfo
    extends Info {
        Double value;

        short getIndexIncrement() {
            return 2;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(6);
            dataOutputStream.writeDouble(this.value);
        }

        DoubleInfo(Double d) {
            super(d);
            this.value = d;
        }
    }

    class StringInfo
    extends Info {
        int UTF8Index;

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(8);
            dataOutputStream.writeShort(this.UTF8Index);
        }

        StringInfo(ConstantString constantString) {
            super(constantString);
            this.UTF8Index = ConstantPool.this.putUTF8(constantString.getValue());
        }
    }

    class ClassInfo
    extends Info {
        int UTF8Index;

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(7);
            dataOutputStream.writeShort(this.UTF8Index);
        }

        ClassInfo(ClassIdentifier classIdentifier) {
            super(classIdentifier);
            this.UTF8Index = ConstantPool.this.putUTF8(classIdentifier.getValue());
        }
    }

    class FieldInfo
    extends Info {
        int classIndex;
        int nameAndTypeIndex;

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(9);
            dataOutputStream.writeShort(this.classIndex);
            dataOutputStream.writeShort(this.nameAndTypeIndex);
        }

        FieldInfo(FieldIdentifier fieldIdentifier) {
            super(fieldIdentifier);
            this.classIndex = ConstantPool.this.put(new ClassIdentifier(fieldIdentifier.getDeclaringClass()));
            this.nameAndTypeIndex = ConstantPool.this.putNameAndType(fieldIdentifier.getName(), fieldIdentifier.getType(), null);
        }
    }

    class MethodInfo
    extends Info {
        int classIndex;
        int nameAndTypeIndex;

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(10);
            dataOutputStream.writeShort(this.classIndex);
            dataOutputStream.writeShort(this.nameAndTypeIndex);
        }

        MethodInfo(MethodIdentifier methodIdentifier) {
            super(methodIdentifier);
            this.classIndex = ConstantPool.this.put(new ClassIdentifier(methodIdentifier.getDeclaringClass()));
            this.nameAndTypeIndex = ConstantPool.this.putNameAndType(methodIdentifier.getName(), methodIdentifier.getType(), methodIdentifier.getParameters());
        }
    }

    class InterfaceMethodInfo
    extends Info {
        int classIndex;
        int nameAndTypeIndex;

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(11);
            dataOutputStream.writeShort(this.classIndex);
            dataOutputStream.writeShort(this.nameAndTypeIndex);
        }

        InterfaceMethodInfo(InterfaceMethodIdentifier interfaceMethodIdentifier) {
            super(interfaceMethodIdentifier);
            this.classIndex = ConstantPool.this.put(new ClassIdentifier(interfaceMethodIdentifier.getDeclaringClass()));
            this.nameAndTypeIndex = ConstantPool.this.putNameAndType(interfaceMethodIdentifier.getName(), interfaceMethodIdentifier.getType(), interfaceMethodIdentifier.getParameters());
        }
    }

    class NameAndTypeInfo
    extends Info {
        int nameIndex;
        int typeIndex;

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(12);
            dataOutputStream.writeShort(this.nameIndex);
            dataOutputStream.writeShort(this.typeIndex);
        }

        NameAndTypeInfo(NameAndTypeKey nameAndTypeKey) {
            super(nameAndTypeKey);
            this.nameIndex = ConstantPool.this.putUTF8(nameAndTypeKey.name);
            this.typeIndex = ConstantPool.this.putUTF8(nameAndTypeKey.type);
        }
    }

    class UTF8Info
    extends Info {
        String value;

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(this.value);
        }

        UTF8Info(String string) {
            super(string);
            this.value = string;
        }
    }

    static class NameAndTypeKey {
        String name;
        String type;

        public boolean equals(Object object) {
            if (object == null || !(object instanceof NameAndTypeKey)) {
                return false;
            }
            NameAndTypeKey nameAndTypeKey = (NameAndTypeKey)object;
            return this.name.equals(nameAndTypeKey.name) && this.type.equals(nameAndTypeKey.type);
        }

        public int hashCode() {
            return this.name.hashCode() + this.type.hashCode();
        }

        NameAndTypeKey(String string, String string2, String[] stringArray) {
            this.name = string;
            this.type = JVMUtilities.createMethodDescriptor(string2, stringArray);
        }
    }
}

