/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi.registry;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.rmi.registry.RMIRegistrySF;
import org.openide.TopManager;
import org.openide.util.NbBundle;

public final class LocalRegistry {
    public static final String PROP_INTERNAL_REGISTRY_PORT = "internalRegistryPort";
    public static final String PROP_RUNNING = "running";
    private int internalRegistryPort = 1099;
    private int runningOnPort = -1;
    private Registry registry = null;
    private static LocalRegistry instance;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$org$netbeans$modules$rmi$registry$LocalRegistry;
    static /* synthetic */ Class class$java$rmi$Remote;

    private LocalRegistry() {
    }

    public int getInternalRegistryPort() {
        return this.internalRegistryPort;
    }

    public void setInternalRegistryPort(int n) {
        int n2 = this.internalRegistryPort;
        this.internalRegistryPort = n;
        this.firePropertyChange(PROP_INTERNAL_REGISTRY_PORT, new Integer(n2), new Integer(this.internalRegistryPort));
    }

    public int getRunningPort() {
        return this.runningOnPort;
    }

    public boolean isRunning() {
        Remote remote = LocalRegistry.getImpl(0);
        return remote != null || this.registry != null;
    }

    public synchronized void startRegistry() throws IOException {
        if (this.isRunning()) {
            return;
        }
        this.runningOnPort = -1;
        this.registry = LocateRegistry.createRegistry(this.internalRegistryPort, RMISocketFactory.getDefaultSocketFactory(), new RMIRegistrySF());
        System.out.println(MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$registry$LocalRegistry == null ? (class$org$netbeans$modules$rmi$registry$LocalRegistry = LocalRegistry.class$("org.netbeans.modules.rmi.registry.LocalRegistry")) : class$org$netbeans$modules$rmi$registry$LocalRegistry)).getString("FMT_RegistryStarted"), new Integer(this.internalRegistryPort)));
        this.runningOnPort = this.internalRegistryPort;
        this.firePropertyChange(PROP_RUNNING, null, null);
    }

    public synchronized void stopRegistry() throws IOException {
        if (this.registry != null) {
            LocalRegistry.unexportObject(this.registry, true);
            this.registry = null;
            if (this.runningOnPort != -1) {
                RMIRegistrySF.cancelSocket(this.runningOnPort, 1000);
            }
        }
        this.runningOnPort = -1;
    }

    public static final LocalRegistry getInstance() {
        if (instance == null) {
            instance = new LocalRegistry();
        }
        return instance;
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public static Remote getImpl(int n) {
        return LocalRegistry.getImpl(new ObjID(n));
    }

    public static Remote getImpl(ObjID objID) {
        try {
            Class<?> clazz = Class.forName("sun.rmi.transport.ObjectTable");
            Field field = clazz.getDeclaredField("objTable");
            ((AccessibleObject)field).setAccessible(true);
            Object object = field.get(null);
            Map map = (Map)object;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object v = entry.getValue();
                field = v.getClass().getDeclaredField("id");
                ((AccessibleObject)field).setAccessible(true);
                ObjID objID2 = (ObjID)field.get(v);
                if (objID2 == null || !objID2.equals(objID)) continue;
                field = v.getClass().getDeclaredField("weakImpl");
                ((AccessibleObject)field).setAccessible(true);
                object = field.get(v);
                WeakReference weakReference = (WeakReference)object;
                Object t = weakReference.get();
                return (Remote)t;
            }
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
        }
        return null;
    }

    public static void unexportObject(Remote remote, boolean bl) {
        try {
            Class<?> clazz = Class.forName("sun.rmi.transport.ObjectTable");
            Method method = clazz.getMethod("unexportObject", class$java$rmi$Remote == null ? (class$java$rmi$Remote = LocalRegistry.class$("java.rmi.Remote")) : class$java$rmi$Remote, Boolean.TYPE);
            if (method != null) {
                method.invoke(null, remote, new Boolean(bl));
            }
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
        }
    }

    public static int getPort(Remote remote) {
        block6: {
            try {
                Object object;
                if (!(remote instanceof RemoteObject)) break block6;
                RemoteRef remoteRef = ((RemoteObject)remote).getRef();
                System.err.println("remote ref: " + remoteRef);
                Class<?> clazz = Class.forName("sun.rmi.server.UnicastRef");
                System.err.println(clazz);
                Field[] fieldArray = clazz.getDeclaredFields();
                int n = 0;
                while (n < fieldArray.length) {
                    System.err.println("\t" + fieldArray[n]);
                    ++n;
                }
                if (!clazz.isAssignableFrom(remoteRef.getClass())) break block6;
                Field field = clazz.getDeclaredField("ref");
                ((AccessibleObject)field).setAccessible(true);
                Object object2 = field.get(remoteRef);
                System.err.println("live ref: " + object2);
                try {
                    field = object2.getClass().getDeclaredField("isLocal");
                    ((AccessibleObject)field).setAccessible(true);
                    object = (Boolean)field.get(object2);
                    if (object != null && !((Boolean)object).booleanValue()) {
                        return -1;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = object2.getClass().getMethod("getPort", new Class[0]);
                Integer n2 = (Integer)((Method)object).invoke(object2, new Object[0]);
                return n2;
            }
            catch (Exception exception) {
                LocalRegistry.debug("LocalRegistry:getPort", exception);
            }
        }
        return -1;
    }

    private static final void debug(String string, Throwable throwable) {
        if (Boolean.getBoolean("org.netbeans.modules.rmi.debug") && string != null) {
            System.err.println(string);
        }
        throwable.printStackTrace();
    }

    public static void main(String[] stringArray) throws Exception {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

