/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi.activation;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.rmi.activation.ActivationGroupItem;
import org.netbeans.modules.rmi.activation.ActivationObjectItem;
import org.netbeans.rmi.RMIDWrapper;
import org.netbeans.rmi.UnknownRMIDException;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class ActivationSystemItem
implements Serializable,
Node.Cookie {
    static final long serialVersionUID = -1871355455413536595L;
    private static boolean debug = Boolean.getBoolean("org.netbeans.modules.rmi.test");
    public static final String PROP_ACTIVATION_ITEMS = "activationItems";
    public static final int RMID_RUNNING = 0;
    public static final int RMID_NOT_RUNNING = 1;
    public static final int RMID_UNKNOWN = 2;
    private InetAddress address;
    private int port;
    private transient HashMap aGroupItems;
    private transient HashMap aObjectItems;
    private transient PropertyChangeSupport support;
    private transient ActivationSystem asystem = null;
    private transient RequestProcessor processor;
    private transient RequestProcessor.Task taskUpdate = null;
    private transient UpdateTask task;
    private transient int rmid = 1;

    public ActivationSystemItem(String string, int n) throws UnknownHostException {
        this.address = InetAddress.getByName(string);
        this.port = n;
        this.initProcessor();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initProcessor();
    }

    private void initProcessor() {
        this.processor = new RequestProcessor();
        this.task = new UpdateTask();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.support != null) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        if (this.support != null) {
            this.support.firePropertyChange(string, object, object2);
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String getHostName() {
        return this.getAddress().getHostName();
    }

    public int getPort() {
        return this.port;
    }

    public Set getActivationItems() {
        HashSet hashSet = new HashSet();
        if (this.aObjectItems != null) {
            hashSet.addAll(this.aObjectItems.values());
        }
        if (this.aGroupItems != null) {
            hashSet.addAll(this.aGroupItems.values());
        }
        return hashSet;
    }

    private void setActivationItems(HashMap hashMap, HashMap hashMap2) {
        this.aObjectItems = hashMap;
        this.aGroupItems = hashMap2;
        this.firePropertyChange(PROP_ACTIVATION_ITEMS, null, null);
    }

    public Set getActivationObjectItems() {
        if (this.aObjectItems != null) {
            return new HashSet(this.aObjectItems.values());
        }
        return Collections.EMPTY_SET;
    }

    public Set getActivationGroupItems() {
        if (this.aGroupItems != null) {
            return new HashSet(this.aGroupItems.values());
        }
        return Collections.EMPTY_SET;
    }

    public void addActivationObjectItem(ActivationDesc activationDesc) throws UnknownGroupException, ActivationException, RemoteException {
        ActivationGroupItem activationGroupItem;
        ActivationID activationID = this.asystem.registerObject(activationDesc);
        ActivationObjectItem activationObjectItem = new ActivationObjectItem(activationID, activationDesc, this);
        if (this.aObjectItems == null) {
            this.aObjectItems = new HashMap();
        }
        this.aObjectItems.put(activationID, activationObjectItem);
        if (this.aGroupItems != null && (activationGroupItem = (ActivationGroupItem)this.aGroupItems.get(activationDesc.getGroupID())) != null) {
            activationGroupItem.addActivatable(activationObjectItem);
        }
        this.firePropertyChange(PROP_ACTIVATION_ITEMS, null, null);
    }

    public void removeActivationObjectItem(ActivationObjectItem activationObjectItem) {
        ActivationGroupItem activationGroupItem;
        ActivationID activationID = activationObjectItem.getActivationID();
        ActivationGroupID activationGroupID = activationObjectItem.getDesc().getGroupID();
        if (this.aObjectItems != null) {
            this.aObjectItems.remove(activationID);
        }
        if (this.aGroupItems != null && (activationGroupItem = (ActivationGroupItem)this.aGroupItems.get(activationGroupID)) != null) {
            activationGroupItem.removeActivatable(activationObjectItem);
        }
        this.firePropertyChange(PROP_ACTIVATION_ITEMS, null, null);
    }

    public void addActivationGroupItem(ActivationGroupDesc activationGroupDesc) throws ActivationException, RemoteException {
        ActivationGroupID activationGroupID = this.asystem.registerGroup(activationGroupDesc);
        ActivationGroupItem activationGroupItem = new ActivationGroupItem(activationGroupID, activationGroupDesc, this);
        if (this.aGroupItems == null) {
            this.aGroupItems = new HashMap();
        }
        this.aGroupItems.put(activationGroupID, activationGroupItem);
        this.firePropertyChange(PROP_ACTIVATION_ITEMS, null, null);
    }

    public ActivationGroupItem getActivationGroupItem(ActivationObjectItem activationObjectItem) {
        if (this.aGroupItems != null) {
            return (ActivationGroupItem)this.aGroupItems.get(activationObjectItem.getDesc().getGroupID());
        }
        return null;
    }

    public void removeActivationGroupItem(ActivationGroupItem activationGroupItem) {
        Iterator iterator = activationGroupItem.getActivatables().iterator();
        while (iterator.hasNext()) {
            ActivationObjectItem activationObjectItem = (ActivationObjectItem)iterator.next();
            if (this.aObjectItems != null) {
                this.aObjectItems.remove(activationObjectItem.getActivationID());
            }
            activationObjectItem.setDeleted(true);
        }
        if (this.aGroupItems != null) {
            this.aGroupItems.remove(activationGroupItem.getActivationGroupID());
        }
        this.firePropertyChange(PROP_ACTIVATION_ITEMS, null, null);
    }

    public void setActivationSystem(ActivationSystem activationSystem) {
        this.asystem = activationSystem;
    }

    public ActivationSystem getActivationSystem() {
        return this.asystem;
    }

    public void shutdown() throws RemoteException {
        this.asystem.shutdown();
        this.updateActivationItems();
    }

    public synchronized void updateActivationItems() {
        if (this.taskUpdate != null && !this.taskUpdate.isFinished()) {
            if (debug) {
                System.err.println("ASItem: not yet finished: " + this.getHostName() + ':' + this.getPort());
            }
            return;
        }
        this.taskUpdate = this.getRP().post((Runnable)this.task);
    }

    private void updateActivationItemsImpl() {
        HashMap<ActivationID, Object> hashMap = new HashMap<ActivationID, Object>();
        HashMap<ActivationGroupID, ActivationGroupItem> hashMap2 = new HashMap<ActivationGroupID, ActivationGroupItem>();
        HashMap<ActivationGroupItem, ArrayList<Object>> hashMap3 = new HashMap<ActivationGroupItem, ArrayList<Object>>();
        this.rmid = 1;
        try {
            ActivationGroupItem activationGroupItem;
            ActivationDesc activationDesc;
            Object object;
            Registry registry = LocateRegistry.getRegistry(this.getHostName(), this.getPort());
            registry.lookup("java.rmi.activation.ActivationSystem");
            this.rmid = 2;
            RMIDWrapper rMIDWrapper = (RMIDWrapper)registry.lookup("org.netbeans.rmi.RMIDWrapper");
            this.rmid = 0;
            this.setActivationSystem((ActivationSystem)rMIDWrapper);
            ActivationID[] activationIDArray = rMIDWrapper.getActivationIDs();
            ActivationGroupID[] activationGroupIDArray = rMIDWrapper.getActivationGroupIDs();
            int n = 0;
            while (n < activationGroupIDArray.length) {
                ActivationGroupItem activationGroupItem2 = null;
                if (this.aGroupItems != null) {
                    activationGroupItem2 = (ActivationGroupItem)this.aGroupItems.get(activationGroupIDArray[n]);
                }
                object = rMIDWrapper.getActivationGroupDesc(activationGroupIDArray[n]);
                if (activationGroupItem2 == null) {
                    activationGroupItem2 = new ActivationGroupItem(activationGroupIDArray[n], (ActivationGroupDesc)object, this);
                } else {
                    activationGroupItem2.setDesc((ActivationGroupDesc)object);
                }
                hashMap2.put(activationGroupIDArray[n], activationGroupItem2);
                ++n;
            }
            int n2 = 0;
            while (n2 < activationIDArray.length) {
                object = null;
                if (this.aObjectItems != null) {
                    object = (ActivationObjectItem)this.aObjectItems.get(activationIDArray[n2]);
                }
                activationDesc = rMIDWrapper.getActivationDesc(activationIDArray[n2]);
                if (object == null) {
                    object = new ActivationObjectItem(activationIDArray[n2], activationDesc, this);
                } else {
                    ((ActivationObjectItem)object).setDesc(activationDesc);
                }
                hashMap.put(activationIDArray[n2], object);
                activationGroupItem = activationDesc.getGroupID();
                ArrayList<Object> arrayList = (ArrayList<Object>)hashMap3.get(activationGroupItem);
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                    hashMap3.put(activationGroupItem, arrayList);
                }
                arrayList.add(object);
                ++n2;
            }
            this.setActivationItems(hashMap, hashMap2);
            object = hashMap2.keySet().iterator();
            while (object.hasNext()) {
                activationDesc = (ActivationGroupID)object.next();
                activationGroupItem = (ActivationGroupItem)hashMap2.get(activationDesc);
                activationGroupItem.setActivatables((List)hashMap3.get(activationDesc));
            }
        }
        catch (AccessException accessException) {
            this.fault(accessException);
        }
        catch (UnknownRMIDException unknownRMIDException) {
            this.rmid = 2;
            this.fault((Exception)((Object)unknownRMIDException));
        }
        catch (NotBoundException notBoundException) {
            this.fault(notBoundException);
        }
        catch (ActivationException activationException) {
            this.fault((Exception)((Object)activationException));
        }
        catch (ConnectException connectException) {
            this.fault(connectException);
        }
        catch (RemoteException remoteException) {
            this.fault(remoteException);
        }
    }

    private void fault(Exception exception) {
        if (debug) {
            exception.printStackTrace();
        }
        this.setActivationSystem(null);
        this.setActivationItems(null, null);
    }

    public Remote getStub(ActivationID activationID) throws RemoteException, ActivationException, UnknownObjectException, StubNotFoundException {
        RMIDWrapper rMIDWrapper = (RMIDWrapper)this.asystem;
        return rMIDWrapper.getStub(activationID);
    }

    public void rebind(ActivationID activationID, String string, int n) throws RemoteException, AccessException, MalformedURLException, ActivationException, UnknownObjectException, StubNotFoundException {
        RMIDWrapper rMIDWrapper = (RMIDWrapper)this.asystem;
        rMIDWrapper.rebind(activationID, string, n);
    }

    public void inactivateObject(ActivationID activationID) throws RemoteException, UnknownObjectException {
        try {
            RMIDWrapper rMIDWrapper = (RMIDWrapper)this.asystem;
            rMIDWrapper.inactivateObject(activationID);
        }
        catch (UnknownRMIDException unknownRMIDException) {
            if (debug) {
                unknownRMIDException.printStackTrace();
            }
            this.rmid = 2;
            this.setActivationSystem(null);
            this.setActivationItems(null, null);
        }
    }

    public void inactivateGroup(ActivationGroupID activationGroupID) throws RemoteException, UnknownGroupException {
        try {
            RMIDWrapper rMIDWrapper = (RMIDWrapper)this.asystem;
            rMIDWrapper.inactivateGroup(activationGroupID);
        }
        catch (UnknownRMIDException unknownRMIDException) {
            if (debug) {
                unknownRMIDException.printStackTrace();
            }
            this.rmid = 2;
            this.setActivationSystem(null);
            this.setActivationItems(null, null);
        }
    }

    public RequestProcessor getRP() {
        return this.processor;
    }

    public boolean equals(Object object) {
        ActivationSystemItem activationSystemItem;
        return object instanceof ActivationSystemItem && (activationSystemItem = (ActivationSystemItem)object).getPort() == this.getPort() && activationSystemItem.getAddress().equals(this.getAddress());
    }

    public int hashCode() {
        return this.getAddress().hashCode() ^ this.getPort();
    }

    public int getRMID() {
        return this.rmid;
    }

    public void destroy() {
        this.processor.stop();
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    class UpdateTask
    implements Runnable {
        UpdateTask() {
        }

        public void run() {
            ActivationSystemItem.this.updateActivationItemsImpl();
            if (debug) {
                System.err.println("ASItem: " + ActivationSystemItem.this.getHostName() + ':' + ActivationSystemItem.this.getPort() + " finished");
            }
        }
    }
}

