/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.Parsing;
import org.netbeans.modules.rmi.RMIDataObject;
import org.netbeans.modules.rmi.RMIHelper;
import org.netbeans.modules.rmi.settings.RMISettings;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.SourceElement;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

public class RemoteDetectionSupport {
    static final String EA_DETECT_REMOTE = "NetBeansAttrDetectRemote";
    private Parsing.Listener parsingListener = null;
    private PropertyChangeListener settingsListener = null;
    private WeakSet filter = new WeakSet(16);
    private static RemoteDetectionSupport instance;

    private RemoteDetectionSupport() {
    }

    public static RemoteDetectionSupport getInstance() {
        if (instance == null) {
            instance = new RemoteDetectionSupport();
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void markRMI(JavaDataObject javaDataObject, boolean bl) throws IOException, PropertyVetoException {
        if (javaDataObject == null) {
            return;
        }
        FileObject fileObject = javaDataObject.getPrimaryFile();
        if (javaDataObject instanceof RMIDataObject) {
            if (bl) return;
            FileLock fileLock = null;
            try {
                try {
                    FileObject fileObject2 = FileUtil.findBrother((FileObject)fileObject, (String)"rmi");
                    if (fileObject2 != null) {
                        fileLock = fileObject2.lock();
                        fileObject2.delete(fileLock);
                    }
                    RemoteDetectionSupport.setDetectRemoteEnabled((DataObject)javaDataObject, true);
                    javaDataObject.setValid(false);
                }
                catch (Exception exception) {
                    TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
                    Object var6_9 = null;
                    if (fileLock == null) return;
                    fileLock.releaseLock();
                    return;
                }
                Object var6_8 = null;
                if (fileLock == null) return;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (fileLock == null) throw throwable;
                fileLock.releaseLock();
                throw throwable;
            }
            fileLock.releaseLock();
            return;
        }
        if (!bl) return;
        FileObject fileObject3 = fileObject.getParent();
        try {
            if (fileObject.getParent().getFileObject(fileObject.getName(), "rmi") == null) {
                fileObject.getParent().createData(fileObject.getName(), "rmi");
            }
            javaDataObject.setValid(false);
            return;
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
        }
    }

    static boolean isDetectRemoteEnabled(DataObject dataObject) {
        Boolean bl = (Boolean)dataObject.getPrimaryFile().getAttribute(EA_DETECT_REMOTE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    static void setDetectRemoteEnabled(DataObject dataObject, boolean bl) {
        try {
            if (!bl) {
                dataObject.getPrimaryFile().setAttribute(EA_DETECT_REMOTE, (Object)new Boolean(bl));
            } else {
                dataObject.getPrimaryFile().setAttribute(EA_DETECT_REMOTE, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void updateParsingListener() {
        this.updateParsingListener(RMISettings.getInstance());
    }

    public synchronized void updateParsingListener(RMISettings rMISettings) {
        if (rMISettings.isDetectRemote()) {
            this.registerParsingListener();
        } else {
            this.unregisterParsingListener();
        }
    }

    synchronized void registerParsingListener() {
        if (this.parsingListener == null) {
            this.parsingListener = new ParsingListener();
            Parsing.addParsingListener((Parsing.Listener)this.parsingListener);
        }
    }

    synchronized void unregisterParsingListener() {
        if (this.parsingListener != null) {
            Parsing.removeParsingListener((Parsing.Listener)this.parsingListener);
            this.parsingListener = null;
        }
    }

    public void registerSetttingsListener() {
        this.registerSettingsListener(RMISettings.getInstance());
    }

    public synchronized void registerSettingsListener(RMISettings rMISettings) {
        if (this.settingsListener == null) {
            this.settingsListener = new SettingsListener();
            rMISettings.addPropertyChangeListener(this.settingsListener);
        }
    }

    synchronized void unregisterSetttingsListener() {
        if (this.settingsListener != null) {
            RMISettings.getInstance().removePropertyChangeListener(this.settingsListener);
            this.settingsListener = null;
        }
    }

    private class ParsingPerformer
    implements Runnable {
        private String OPTION_YES = null;
        private String OPTION_YES_ALL = null;
        private String OPTION_NO = null;
        private String OPTION_NO_ALL = null;
        private Parsing.Event ev;
        static /* synthetic */ Class class$org$netbeans$modules$rmi$RMIDataLoader;

        public ParsingPerformer(Parsing.Event event) {
            this.ev = event;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void run() {
            JavaDataObject javaDataObject;
            block21: {
                block20: {
                    block19: {
                        javaDataObject = this.ev.getJavaDataObject();
                        try {
                            try {
                                if (!RMISettings.getInstance().isDetectRemote()) {
                                    Object var8_2 = null;
                                    break block19;
                                }
                                SourceElement sourceElement = this.ev.getSourceElement();
                                int n = sourceElement.getStatus();
                                if (n != 3 && n != 2) {
                                    break block20;
                                }
                                ClassElement[] classElementArray = sourceElement.getAllClasses();
                                int n2 = 0;
                                while (n2 < classElementArray.length) {
                                    if (classElementArray[n2].isClass() && RMIHelper.implementsClass(classElementArray[n2], "java.rmi.Remote")) {
                                        if (this.getConfirm()) {
                                            try {
                                                Object object = TopManager.getDefault().notify(this.createDescriptor(classElementArray[n2]));
                                                if (object == this.OPTION_YES) {
                                                    RemoteDetectionSupport.markRMI(javaDataObject, true);
                                                    break block21;
                                                }
                                                if (object == this.OPTION_YES_ALL) {
                                                    RemoteDetectionSupport.markRMI(javaDataObject, true);
                                                    this.setConfirm(false);
                                                    break block21;
                                                }
                                                if (object == this.OPTION_NO_ALL) {
                                                    RemoteDetectionSupport.setDetectRemoteEnabled((DataObject)javaDataObject, false);
                                                    this.setDetect(false);
                                                    break block21;
                                                } else if (object == this.OPTION_NO) {
                                                    RemoteDetectionSupport.setDetectRemoteEnabled((DataObject)javaDataObject, false);
                                                }
                                                break block21;
                                            }
                                            catch (Exception exception) {
                                                TopManager.getDefault().getErrorManager().notify((Throwable)exception);
                                            }
                                            break block21;
                                        }
                                        try {
                                            RemoteDetectionSupport.markRMI(javaDataObject, true);
                                        }
                                        catch (Exception exception) {
                                            TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
                                        }
                                        break block21;
                                    }
                                    ++n2;
                                }
                                break block21;
                            }
                            catch (Exception exception) {
                                TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
                                Object var8_5 = null;
                                RemoteDetectionSupport.this.filter.remove((Object)javaDataObject);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_6 = null;
                            RemoteDetectionSupport.this.filter.remove((Object)javaDataObject);
                            throw throwable;
                        }
                    }
                    RemoteDetectionSupport.this.filter.remove((Object)javaDataObject);
                    return;
                }
                Object var8_3 = null;
                RemoteDetectionSupport.this.filter.remove((Object)javaDataObject);
                return;
            }
            Object var8_4 = null;
            RemoteDetectionSupport.this.filter.remove((Object)javaDataObject);
        }

        protected boolean getConfirm() {
            return RMISettings.getInstance().isConfirmConvert();
        }

        protected void setConfirm(boolean bl) {
            RMISettings.getInstance().setConfirmConvert(bl);
        }

        protected void setDetect(boolean bl) {
            RMISettings.getInstance().setDetectRemote(bl);
        }

        protected NotifyDescriptor createDescriptor(ClassElement classElement) {
            if (this.OPTION_YES == null) {
                this.OPTION_YES = NbBundle.getMessage((Class)(class$org$netbeans$modules$rmi$RMIDataLoader == null ? (class$org$netbeans$modules$rmi$RMIDataLoader = ParsingPerformer.class$("org.netbeans.modules.rmi.RMIDataLoader")) : class$org$netbeans$modules$rmi$RMIDataLoader), (String)"CTL_OPTION_YES");
                this.OPTION_YES_ALL = NbBundle.getMessage((Class)(class$org$netbeans$modules$rmi$RMIDataLoader == null ? (class$org$netbeans$modules$rmi$RMIDataLoader = ParsingPerformer.class$("org.netbeans.modules.rmi.RMIDataLoader")) : class$org$netbeans$modules$rmi$RMIDataLoader), (String)"CTL_OPTION_YES_ALL");
                this.OPTION_NO = NbBundle.getMessage((Class)(class$org$netbeans$modules$rmi$RMIDataLoader == null ? (class$org$netbeans$modules$rmi$RMIDataLoader = ParsingPerformer.class$("org.netbeans.modules.rmi.RMIDataLoader")) : class$org$netbeans$modules$rmi$RMIDataLoader), (String)"CTL_OPTION_NO");
                this.OPTION_NO_ALL = NbBundle.getMessage((Class)(class$org$netbeans$modules$rmi$RMIDataLoader == null ? (class$org$netbeans$modules$rmi$RMIDataLoader = ParsingPerformer.class$("org.netbeans.modules.rmi.RMIDataLoader")) : class$org$netbeans$modules$rmi$RMIDataLoader), (String)"CTL_OPTION_NO_ALL");
            }
            return new NotifyDescriptor((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$rmi$RMIDataLoader == null ? (class$org$netbeans$modules$rmi$RMIDataLoader = ParsingPerformer.class$("org.netbeans.modules.rmi.RMIDataLoader")) : class$org$netbeans$modules$rmi$RMIDataLoader), (String)"FMT_CONVERT_MESSAGE", (Object)classElement.getName().getFullName()), NbBundle.getMessage((Class)(class$org$netbeans$modules$rmi$RMIDataLoader == null ? (class$org$netbeans$modules$rmi$RMIDataLoader = ParsingPerformer.class$("org.netbeans.modules.rmi.RMIDataLoader")) : class$org$netbeans$modules$rmi$RMIDataLoader), (String)"CTL_CONFIRMATION_TITLE"), -1, 3, new Object[]{this.OPTION_YES, this.OPTION_YES_ALL, this.OPTION_NO, this.OPTION_NO_ALL}, null);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class SettingsListener
    implements PropertyChangeListener {
        private SettingsListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("detectRemote".equals(propertyChangeEvent.getPropertyName())) {
                RemoteDetectionSupport.this.updateParsingListener();
            }
        }
    }

    private class ParsingListener
    implements Parsing.Listener {
        static /* synthetic */ Class class$org$netbeans$modules$java$JavaDataObject;

        private ParsingListener() {
        }

        public void objectParsed(Parsing.Event event) {
            JavaDataObject javaDataObject = event.getJavaDataObject();
            if (javaDataObject.getClass().equals(class$org$netbeans$modules$java$JavaDataObject == null ? (class$org$netbeans$modules$java$JavaDataObject = ParsingListener.class$("org.netbeans.modules.java.JavaDataObject")) : class$org$netbeans$modules$java$JavaDataObject) && RemoteDetectionSupport.isDetectRemoteEnabled((DataObject)javaDataObject) && !RemoteDetectionSupport.this.filter.contains((Object)javaDataObject)) {
                WeakSet weakSet = RemoteDetectionSupport.this.filter;
                synchronized (weakSet) {
                    RemoteDetectionSupport.this.filter.add((Object)javaDataObject);
                }
                RequestProcessor.postRequest((Runnable)new ParsingPerformer(event));
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

