/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi;

import java.io.File;
import java.io.IOException;
import java.text.Format;
import java.util.Map;
import org.netbeans.modules.java.JavaCompilerType;
import org.netbeans.modules.rmi.RMICompilerSupport;
import org.netbeans.modules.rmi.RMIStubCompiler;
import org.netbeans.modules.rmi.RMIStubCompilerType;
import org.netbeans.modules.rmi.Version;
import org.openide.compiler.Compiler;
import org.openide.compiler.ExternalCompiler;
import org.openide.compiler.ExternalCompilerGroup;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;

public class RMIStubCompilerGroup
extends ExternalCompilerGroup {
    private static boolean DEBUG = false;
    static final String EMPTY = "";
    static final String TAG_PACKAGEROOT = "packageroot";
    static final String TAG_KEEP_GENERATED = "keepgenerated";
    static final String TAG_KEEP_GENERATED_REPLACE = "-keepgenerated";
    static final String TAG_IIOP = "iiop";
    static final String TAG_IIOP_REPLACE = "-iiop";
    static final String TAG_OUTPUTDIR = "outputdir";
    static final String TAG_OUTPUTDIR_REPLACE = "-d";
    static final String TAG_VERSION = "version";
    FileObject fso;
    RMIStubCompilerType myType;
    JavaCompilerType javaType;

    public void add(Compiler compiler) throws IllegalArgumentException {
        try {
            if (this.myType == null) {
                RMIStubCompiler.Key key = (RMIStubCompiler.Key)compiler.compilerGroupKey();
                this.fso = key.getRoot();
                this.myType = key.getType();
                this.javaType = key.getJavaType();
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
        if (!this.fso.isFolder()) {
            throw new IllegalArgumentException();
        }
        super.add(compiler);
    }

    protected Process createProcess(NbProcessDescriptor nbProcessDescriptor, String[] stringArray) throws IOException {
        ExternalCompilerGroup.Format format = new ExternalCompilerGroup.Format(stringArray);
        Map map = format.getMap();
        map.put(TAG_PACKAGEROOT, RMIStubCompilerGroup.getPackageRoot(this.fso));
        map.put(TAG_OUTPUTDIR, "-d " + this.getOutputDir());
        map.put(TAG_KEEP_GENERATED, this.myType.isKeepGenerated() ? TAG_KEEP_GENERATED_REPLACE : EMPTY);
        map.put(TAG_IIOP, this.myType.isIiop() ? TAG_IIOP_REPLACE : EMPTY);
        map.put(TAG_VERSION, Version.getReplaceTag(this.myType.getVersion()));
        return nbProcessDescriptor.exec((Format)format);
    }

    String getOutputDir() {
        FileSystem fileSystem = null;
        String string = EMPTY;
        fileSystem = RMICompilerSupport.getTargetFileSystem(this.myType, this.javaType);
        if (fileSystem != null) {
            if (fileSystem == JavaCompilerType.TARGET_INVALID) {
                return EMPTY;
            }
            string = NbClassPath.toFile((FileObject)fileSystem.getRoot()).toString();
        } else {
            string = RMIStubCompilerGroup.getPackageRoot(this.fso);
        }
        if (string.indexOf(32) > -1) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    public static String getPackageRoot(FileObject fileObject) throws IllegalArgumentException {
        final StringBuffer stringBuffer = new StringBuffer(64);
        try {
            fileObject.getFileSystem().prepareEnvironment(new FileSystem.Environment(){

                public void addClassPath(String string) {
                    stringBuffer.append(string);
                }
            });
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            throw new IllegalArgumentException();
        }
        catch (EnvironmentNotSupportedException environmentNotSupportedException) {
            return ".";
        }
        String string = stringBuffer.toString();
        File file = new File(string);
        try {
            if (file.isDirectory()) {
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ".";
    }

    public boolean start() {
        boolean bl = super.start();
        ExternalCompiler[] externalCompilerArray = this.getAllCompilers();
        int n = 0;
        while (n < externalCompilerArray.length) {
            RMIStubCompiler rMIStubCompiler = (RMIStubCompiler)externalCompilerArray[n];
            try {
                rMIStubCompiler.registerStubs(RMICompilerSupport.getTargetFileSystem(this.myType, this.javaType));
            }
            catch (IOException iOException) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    iOException.printStackTrace();
                }
                bl = false;
            }
            ++n;
        }
        return bl;
    }
}

