/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi;

import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.HttpServer;
import org.openide.util.MapFormat;

public class RMIExecutorSettings {
    static final RMIExecutorSettings DEFAULT = new RMIExecutorSettings();
    public static final String TAG_HOSTNAME = "hostname";
    public static final String TAG_HOSTIP = "hostip";
    public static final String TAG_HTTPPORT = "internalHttpPort";
    public static final String TAG_REPOSITORYURL = "filesystemsURL";
    public static final String TAG_REPOSITORYIPURL = "filesystemsIPURL";
    public static final String TAG_EXPORT_PORT = "port";
    public static final String TAG_EXPORT_SERVICE = "service";

    public String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return "localhost";
        }
    }

    public String getHostIP() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            return "127.0.0.1";
        }
    }

    public int getInternalHttpPort() {
        try {
            URL uRL = HttpServer.getRepositoryRoot();
            return uRL.getPort();
        }
        catch (Exception exception) {
            return 8082;
        }
    }

    public URL getRepositoryURL() {
        try {
            return HttpServer.getRepositoryRoot();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public URL getRepositoryIPURL() {
        try {
            URL uRL = HttpServer.getRepositoryRoot();
            return new URL(uRL.getProtocol(), this.getHostIP(), uRL.getPort(), uRL.getFile());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static RMIExecutorSettings getDefault() {
        return DEFAULT;
    }

    public Map addSettings(Map map) {
        map.put(TAG_HOSTNAME, this.getHostname());
        map.put(TAG_HOSTIP, this.getHostIP());
        map.put(TAG_HTTPPORT, String.valueOf(this.getInternalHttpPort()));
        map.put(TAG_REPOSITORYURL, this.getRepositoryURL());
        map.put(TAG_REPOSITORYIPURL, this.getRepositoryIPURL());
        return map;
    }

    public Map getSettings() {
        return this.addSettings(new HashMap());
    }

    public static NbProcessDescriptor format(Map map, NbProcessDescriptor nbProcessDescriptor) {
        MapFormat mapFormat = new MapFormat(map);
        String string = nbProcessDescriptor.getProcessName();
        String string2 = nbProcessDescriptor.getArguments();
        String string3 = nbProcessDescriptor.getInfo();
        return new NbProcessDescriptor(mapFormat.format(string), mapFormat.format(string2), string3);
    }
}

