/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.netbeans.modules.java.JavaDataLoader;
import org.netbeans.modules.rmi.RMIDataObject;
import org.netbeans.modules.rmi.RMIStubSupport;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class RMIDataLoader
extends JavaDataLoader {
    private static final transient boolean DEBUG = false;
    static final long serialVersionUID = -3325329576021256358L;
    public static final String PROP_STUB_FORMATS = "stubFormats";
    public static final String PROP_HIDE_STUBS = "hideStubs";
    public static final String RMI_EXTENSION = "rmi";
    public static final String IMPL_SUFFIX = "Impl";
    static final char INNER_CLASS_DIVIDER = '$';
    public static final String[] DEFAULT_STUB_FORMATS = new String[]{"{0}_Stub", "{0}_Skel", "_{0}_Tie", "_{0}_Stub"};
    private static final int STREAM_VERSION = 1;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$RMIDataLoader;
    static /* synthetic */ Class class$org$openide$actions$OpenAction;
    static /* synthetic */ Class class$org$openide$actions$CustomizeBeanAction;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$CompileAction;
    static /* synthetic */ Class class$org$openide$actions$BuildAction;
    static /* synthetic */ Class class$org$openide$actions$ExecuteAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$NewAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$SaveAsTemplateAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    public RMIDataLoader() {
        this("org.netbeans.modules.rmi.RMIDataObject");
    }

    public RMIDataLoader(String string) {
        super(string);
    }

    public RMIDataLoader(Class clazz) {
        super(clazz);
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$rmi$RMIDataLoader == null ? (class$org$netbeans$modules$rmi$RMIDataLoader = RMIDataLoader.class$("org.netbeans.modules.rmi.RMIDataLoader")) : class$org$netbeans$modules$rmi$RMIDataLoader), (String)"CTL_RMIDataLoader");
    }

    protected SystemAction[] defaultActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$OpenAction == null ? (class$org$openide$actions$OpenAction = RMIDataLoader.class$("org.openide.actions.OpenAction")) : class$org$openide$actions$OpenAction)), SystemAction.get((Class)(class$org$openide$actions$CustomizeBeanAction == null ? (class$org$openide$actions$CustomizeBeanAction = RMIDataLoader.class$("org.openide.actions.CustomizeBeanAction")) : class$org$openide$actions$CustomizeBeanAction)), SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = RMIDataLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$openide$actions$CompileAction == null ? (class$org$openide$actions$CompileAction = RMIDataLoader.class$("org.openide.actions.CompileAction")) : class$org$openide$actions$CompileAction)), null, SystemAction.get((Class)(class$org$openide$actions$BuildAction == null ? (class$org$openide$actions$BuildAction = RMIDataLoader.class$("org.openide.actions.BuildAction")) : class$org$openide$actions$BuildAction)), null, SystemAction.get((Class)(class$org$openide$actions$ExecuteAction == null ? (class$org$openide$actions$ExecuteAction = RMIDataLoader.class$("org.openide.actions.ExecuteAction")) : class$org$openide$actions$ExecuteAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = RMIDataLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = RMIDataLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = RMIDataLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = RMIDataLoader.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction)), SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = RMIDataLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = RMIDataLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)), null, SystemAction.get((Class)(class$org$openide$actions$SaveAsTemplateAction == null ? (class$org$openide$actions$SaveAsTemplateAction = RMIDataLoader.class$("org.openide.actions.SaveAsTemplateAction")) : class$org$openide$actions$SaveAsTemplateAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = RMIDataLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = RMIDataLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        return new RMIDataObject(fileObject, (MultiFileLoader)this);
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        FileObject fileObject2;
        FileObject fileObject3;
        if (fileObject.isFolder()) {
            return null;
        }
        String string = fileObject.getExt();
        String string2 = fileObject.getName();
        String string3 = null;
        boolean bl = false;
        if (string.equals("class") || string.equals("java") || string.equals(RMI_EXTENSION)) {
            int n;
            if (this.isHideStubs()) {
                string3 = this.checkStub(string2);
            }
            if (string3 == null) {
                string3 = string2;
            }
            if ((n = string3.indexOf(36)) != -1) {
                string3 = string3.substring(0, n);
            }
        }
        if ((fileObject3 = fileObject.getParent()) != null && string3 != null && (bl = fileObject3.getFileObject(string3, RMI_EXTENSION) != null) && (fileObject2 = fileObject3.getFileObject(string3, "java")) != null) {
            return fileObject2;
        }
        return null;
    }

    protected String checkStub(String string) {
        String[] stringArray = this.getStubFormats();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = RMIStubSupport.getSourceName(string, stringArray[n]);
            if (string2 != null) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    public boolean isHideStubs() {
        Boolean bl = (Boolean)this.getProperty(PROP_HIDE_STUBS);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public void setHideStubs(boolean bl) {
        this.putProperty(PROP_HIDE_STUBS, new Boolean(bl), true);
    }

    public String[] getStubFormats() {
        String[] stringArray = (String[])this.getProperty(PROP_STUB_FORMATS);
        if (stringArray == null) {
            return DEFAULT_STUB_FORMATS;
        }
        return stringArray;
    }

    public void setStubFormats(String[] stringArray) {
        this.putProperty(PROP_STUB_FORMATS, stringArray, true);
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new RMIFileEntry(multiDataObject, fileObject);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        if (fileObject.getExt().equals(RMI_EXTENSION)) {
            return new FileEntry(multiDataObject, fileObject);
        }
        return super.createSecondaryEntry(multiDataObject, fileObject);
    }

    public static String getFSPath(FileObject fileObject) {
        final StringBuffer stringBuffer = new StringBuffer();
        try {
            FileSystem fileSystem = fileObject.getFileSystem();
            fileObject.getFileSystem().prepareEnvironment(new FileSystem.Environment(){

                public void addClassPath(String string) {
                    stringBuffer.append(string);
                }
            });
            return stringBuffer.toString();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
        }
        catch (EnvironmentNotSupportedException environmentNotSupportedException) {
            // empty catch block
        }
        return null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(1);
        this.writeProperty(PROP_STUB_FORMATS, objectOutput);
        this.writeProperty(PROP_HIDE_STUBS, objectOutput);
        objectOutput.writeObject(null);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        if (objectInput.available() > 0) {
            objectInput.readInt();
            if (this.readProperty(objectInput) == null) {
                return;
            }
            if (this.readProperty(objectInput) == null) {
                return;
            }
            this.firePropertyChange(null, null, null);
        }
    }

    private void writeProperty(String string, ObjectOutput objectOutput) throws IOException {
        Object object = this.getProperty(string);
        if (object != null) {
            objectOutput.writeObject(string);
            objectOutput.writeObject(object);
        }
    }

    private String readProperty(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = null;
        string = (String)objectInput.readObject();
        if (string != null) {
            Object object = objectInput.readObject();
            this.putProperty(string, object, false);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class RMIFileEntry
    extends JavaDataLoader.JavaFileEntry {
        static final long serialVersionUID = 2704205254221237611L;

        protected RMIFileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            super((JavaDataLoader)RMIDataLoader.this, multiDataObject, fileObject);
        }

        protected void modifyMap(Map map, FileObject fileObject, String string, String string2) {
            super.modifyMap(map, fileObject, string, string2);
            RMIDataObject rMIDataObject = (RMIDataObject)this.getDataObject();
            String string3 = string;
            int n = string3.indexOf(RMIDataLoader.IMPL_SUFFIX);
            string3 = n != -1 ? string3.substring(0, n) : "java.rmi.Remote";
            map.put("INTERFACENAME", string3);
            map.put("STRING", "\"");
            String string4 = (String)map.get("NAME");
            if (string4 != null) {
                map.put("NAMESTRING", "\"" + string4 + "\"");
            }
            if ((string4 = (String)map.get("PACKAGE")) != null) {
                map.put("PACKAGESTRING", "\"" + string4 + "\"");
            }
            if ((string4 = RMIDataLoader.getFSPath(this.getFile())) != null) {
                map.put("FSPATH", string4);
            }
        }
    }
}

