/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.TreeSet;
import org.netbeans.modules.web.context.WebContextLoader;
import org.netbeans.modules.web.context.WebContextObject;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;

public class WebAppNameEditor
extends PropertyEditorSupport {
    public String[] getTags() {
        Collection collection = WebAppNameEditor.getWebAppDisplayNames();
        return collection.toArray(new String[collection.size()]);
    }

    public String getAsText() {
        return WebAppNameEditor.getDisplayNameFromSystemName((String)this.getValue());
    }

    public void setAsText(String string) {
        this.setValue(WebAppNameEditor.getSystemNameFromDisplayName(string));
    }

    public static Collection getWebAppSystemNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        Repository repository = TopManager.getDefault().getRepository();
        Enumeration enumeration = repository.fileSystems();
        while (enumeration.hasMoreElements()) {
            treeSet.add(((FileSystem)enumeration.nextElement()).getSystemName());
        }
        return treeSet;
    }

    public static Collection getWebAppDisplayNames() {
        Repository repository = TopManager.getDefault().getRepository();
        Enumeration enumeration = repository.fileSystems();
        TreeSet<String> treeSet = new TreeSet<String>();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            if (!WebContextLoader.isWebApplication(fileSystem)) continue;
            treeSet.add(fileSystem.getDisplayName());
        }
        return treeSet;
    }

    public static FileObject findWebContextFO(String string) {
        Repository repository = TopManager.getDefault().getRepository();
        Enumeration enumeration = repository.fileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            if (!WebContextLoader.isWebApplication(fileSystem) || !fileSystem.getSystemName().equals(string)) continue;
            return fileSystem.getRoot();
        }
        return null;
    }

    public static String getDisplayNameFromSystemName(String string) {
        TopManager topManager = TopManager.getDefault();
        Repository repository = topManager.getRepository();
        FileSystem fileSystem = repository.findFileSystem(string);
        if (fileSystem == null) {
            return "";
        }
        return fileSystem.getDisplayName();
    }

    public static String getSystemNameFromDisplayName(String string) {
        Enumeration enumeration = TopManager.getDefault().getRepository().getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            if (!fileSystem.getDisplayName().equals(string)) continue;
            return fileSystem.getSystemName();
        }
        return "";
    }

    public static DataObject getDDForModuleFromSystemName(String string) {
        Repository repository = TopManager.getDefault().getRepository();
        Enumeration enumeration = repository.fileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            if (!fileSystem.getSystemName().equals(string) || !WebContextLoader.isWebApplication(fileSystem)) continue;
            try {
                WebContextObject webContextObject = WebContextLoader.findContext(fileSystem);
                return webContextObject.getDeploymentDescriptor();
            }
            catch (IOException iOException) {
                TopManager.getDefault().getErrorManager().notify(4096, (Throwable)iOException);
            }
        }
        return null;
    }
}

