/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.io.IOException;
import java.util.List;
import org.netbeans.modules.j2ee.impl.ServerExecSupport;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.core.QueryStringCookie;
import org.netbeans.modules.web.core.jsploader.ServletDataLoader;
import org.netbeans.modules.web.core.jsploader.ServletDataNode;
import org.netbeans.modules.web.execution.ServletExecPerformer;
import org.netbeans.modules.web.webdata.WebDataFactory;
import org.netbeans.modules.web.webdata.WebModuleImpl;
import org.netbeans.modules.web.webdata.WebServletImpl;
import org.openide.TopManager;
import org.openide.debugger.DebuggerType;
import org.openide.execution.Executor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.ExecSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListener;

public class ServletDataObject
extends JavaDataObject
implements QueryStringCookie {
    protected static final String EA_URI = "NbAttrURI";
    protected static final String EA_SERVLETPARAMS_NAME = "NbAttrExecParamsName";
    protected transient ServletExecSupport servletExecSupport = null;
    private FileChangeListener fcl = new ServletChangeListener();

    protected static WebModuleImpl getDefaultWebModuleImpl(FileObject fileObject) throws DataObjectNotFoundException {
        DataObject dataObject;
        WebModuleImpl webModuleImpl = WebDataFactory.getFactory().findWebModule(fileObject);
        if (webModuleImpl != null && (dataObject = DataObject.find((FileObject)webModuleImpl.getFileObject())) instanceof WebContextObject) {
            return webModuleImpl;
        }
        return null;
    }

    public ServletDataObject(FileObject fileObject, ServletDataLoader servletDataLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)servletDataLoader);
        fileObject.addFileChangeListener(WeakListener.fileChange((FileChangeListener)this.fcl, (Object)fileObject));
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected Node createNodeDelegate() {
        return new ServletDataNode(this);
    }

    public ExecSupport getExecSupport() {
        if (this.servletExecSupport == null) {
            this.servletExecSupport = new ServletExecSupport(this.getPrimaryEntry(), new ServerExecSupport(this.getPrimaryEntry()));
        }
        return this.servletExecSupport;
    }

    public String getURIParameter() {
        FileObject fileObject = this.getPrimaryFile();
        try {
            String string = (String)fileObject.getAttribute(EA_URI);
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setURIParameter(String string) {
        FileObject fileObject = this.getPrimaryFile();
        try {
            fileObject.setAttribute(EA_URI, (Object)string);
        }
        catch (Exception exception) {
            TopManager.getDefault().notifyException((Throwable)exception);
        }
    }

    public String getWebModuleParameter() {
        FileObject fileObject = this.getPrimaryFile();
        Object object = fileObject.getAttribute(EA_SERVLETPARAMS_NAME);
        if (object == null || !(object instanceof String)) {
            return this.defaultWebModule();
        }
        return (String)object;
    }

    public void setWebModuleParameter(String string) {
        FileObject fileObject = this.getPrimaryFile();
        try {
            if (string != null && string.equals(this.defaultWebModule())) {
                fileObject.setAttribute(EA_SERVLETPARAMS_NAME, null);
            } else {
                fileObject.setAttribute(EA_SERVLETPARAMS_NAME, (Object)string);
            }
        }
        catch (Exception exception) {
            TopManager.getDefault().notifyException((Throwable)exception);
        }
    }

    private String defaultWebModule() {
        String string = null;
        try {
            WebModuleImpl webModuleImpl = ServletDataObject.getDefaultWebModuleImpl(this.getPrimaryFile());
            if (webModuleImpl != null) {
                string = webModuleImpl.getFileObject().getFileSystem().getSystemName();
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)dataObjectNotFoundException);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)fileStateInvalidException);
        }
        return string;
    }

    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        DataObject dataObject = super.handleCreateFromTemplate(dataFolder, string);
        if (dataObject != null && dataObject.getPrimaryFile().getAttribute(EA_URI) == null) {
            String string2 = "/servlet/" + dataObject.getPrimaryFile().getPackageName('.');
            dataObject.getPrimaryFile().setAttribute(EA_URI, (Object)string2);
        }
        return dataObject;
    }

    protected FileObject handleMove(DataFolder dataFolder) throws IOException {
        String string = this.getWebModuleParameter();
        FileObject fileObject = super.handleMove(dataFolder);
        try {
            FileObject fileObject2;
            WebModuleImpl webModuleImpl = ServletDataObject.getDefaultWebModuleImpl(fileObject);
            FileObject fileObject3 = fileObject2 = webModuleImpl != null ? webModuleImpl.getFileObject() : null;
            if (fileObject2 != null) {
                fileObject.setAttribute(EA_SERVLETPARAMS_NAME, null);
            } else {
                fileObject.setAttribute(EA_SERVLETPARAMS_NAME, (Object)string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileObject;
    }

    private class ServletChangeListener
    extends FileChangeAdapter {
        private ServletChangeListener() {
        }

        public void fileChanged(FileEvent fileEvent) {
            WebModuleImpl webModuleImpl = ServletExecPerformer.getWebModuleForDO((DataObject)ServletDataObject.this);
            WebServletImpl webServletImpl = WebDataFactory.getFactory().getWebServlet(ServletDataObject.this.getPrimaryFile().getPackageNameExt('/', '.'), webModuleImpl);
            if (webModuleImpl != null && webServletImpl != null) {
                webModuleImpl.fireWebModuleChanged(2, 2, (WebStandardData)webServletImpl);
            }
        }
    }

    private class ServletExecSupport
    extends ExecSupport {
        private ServerExecSupport orig;

        public ServletExecSupport(MultiDataObject.Entry entry, ServerExecSupport serverExecSupport) {
            super(entry);
            this.orig = serverExecSupport;
        }

        protected DebuggerType defaultDebuggerType() {
            return this.orig.defaultDebuggerType();
        }

        protected Executor defaultExecutor() {
            return this.orig.defaultExecutor();
        }

        public void addProperties(Sheet.Set set) {
            this.orig.addProperties(set);
        }
    }

    public static interface ServletConfigCookie
    extends Node.Cookie {
        public List getServletMappings(String var1);
    }
}

