/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.openide.TopManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;

public class ContextDescriptor {
    private FileSystem baseFs;

    public ContextDescriptor(FileSystem fileSystem) {
        this.baseFs = fileSystem;
    }

    public URL getResource(String string) throws MalformedURLException {
        FileObject fileObject = this.getResourceAsObject(string);
        if (fileObject == null) {
            return null;
        }
        try {
            return this.getFileExternalURL(fileObject);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            throw new MalformedURLException(((Object)((Object)fileStateInvalidException)).getClass().getName() + " : " + fileStateInvalidException.toString());
        }
    }

    public InputStream getResourceAsStream(String string) {
        FileObject fileObject = this.getResourceAsObject(string);
        if (fileObject == null) {
            return null;
        }
        try {
            return fileObject.getInputStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public FileObject getResourceAsObject(String string) {
        string = string.replace('\\', '/');
        if (this.baseFs == null) {
            return TopManager.getDefault().getRepository().findResource(string);
        }
        return this.baseFs.findResource(string);
    }

    private URL getFileExternalURL(FileObject fileObject) throws FileStateInvalidException {
        File file = NbClassPath.toFile((FileObject)fileObject);
        if (file != null) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return fileObject.getURL();
            }
        }
        return fileObject.getURL();
    }

    public String getRealPath(String string) {
        String string2 = null;
        try {
            File file;
            FileObject fileObject;
            URL uRL = this.getResource(string);
            if (uRL != null && uRL.getProtocol().equals("file") && (fileObject = this.getResourceAsObject(string)) != null && (file = NbClassPath.toFile((FileObject)fileObject)) != null) {
                string2 = file.getAbsolutePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }
}

