/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.context;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.netbeans.modules.web.context.WebAppNode;
import org.netbeans.modules.web.context.WebAppWizardIterator;
import org.netbeans.modules.web.context.WebContextObject;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataShadow;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Node;

public class WebAppObject
extends DataShadow {
    public static final String PROP_DOCBASE = "documentBase";
    public static final String PROP_APPNAME = "appName";
    private transient WebContextObject wc;

    public WebAppObject(FileObject fileObject, DataObject dataObject, DataLoader dataLoader) throws DataObjectExistsException {
        super(fileObject, dataObject, dataLoader);
        this.init();
    }

    private void init() {
        this.setWizardIterator();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (WebAppObject.PROP_DOCBASE.equals(propertyChangeEvent.getPropertyName()) || WebAppObject.PROP_APPNAME.equals(propertyChangeEvent.getPropertyName())) {
                    WebAppObject.this.firePropertyChange0("name", null, WebAppObject.this.getName());
                }
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
    }

    void firePropertyChange0(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    private void setWizardIterator() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    TemplateWizard.setIterator((DataObject)WebAppObject.this, (TemplateWizard.Iterator)WebAppWizardIterator.singleton());
                }
                catch (IOException iOException) {
                    TopManager.getDefault().getErrorManager().notify(16, (Throwable)iOException);
                }
            }
        });
    }

    protected Node createNodeDelegate() {
        WebAppNode webAppNode = new WebAppNode(this);
        return webAppNode;
    }

    public Node.Cookie getCookie(Class clazz) {
        try {
            return super.getCookie(clazz);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    protected static DataObject deserialize0(FileObject fileObject) throws IOException {
        return DataShadow.deserialize((FileObject)fileObject);
    }

    public WebContextObject getContext() {
        return (WebContextObject)this.getOriginal();
    }

    static class WizardData {
        private FileSystem documentBase;
        private String documentBasePath;
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        public FileSystem getDocumentBase() {
            return this.documentBase;
        }

        public void setDocumentBase(FileSystem fileSystem) {
            FileSystem fileSystem2 = this.documentBase;
            this.documentBase = fileSystem;
            this.propertyChangeSupport.firePropertyChange(WebAppObject.PROP_DOCBASE, fileSystem2, fileSystem);
        }

        public String getDocumentBasePath() {
            return this.documentBasePath;
        }

        public void setDocumentBasePath(String string) {
            this.documentBasePath = string;
        }
    }
}

