/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jndi;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.jndi.JndiRootNode;
import org.netbeans.modules.jndi.NewPropertyPanel;
import org.netbeans.modules.jndi.utils.SimpleListModel;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;

public abstract class AbstractNewPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    JList list;
    JTextField context;
    JTextField authentification;
    JTextField root;
    JTextField principal;
    JTextField credentials;
    SimpleListModel properties;
    NewPropertyPanel panel;
    Dialog dlg = null;
    JButton removeButton;
    JButton changeButton;
    JButton addButton;

    public AbstractNewPanel() {
        this.createGUI();
    }

    public String getContext() {
        return this.context.getText();
    }

    public String getRoot() {
        return this.root.getText();
    }

    public String getAuthentification() {
        return this.authentification.getText();
    }

    public String getPrincipal() {
        return this.principal.getText();
    }

    public String getCredentials() {
        return this.credentials.getText();
    }

    public Vector getAditionalProperties() {
        return this.properties.asVector();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("ADD")) {
            this.panel = new NewPropertyPanel();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, JndiRootNode.getLocalizedString("TITLE_Add_property"), true, 2, NotifyDescriptor.OK_OPTION, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == NotifyDescriptor.OK_OPTION) {
                        if (AbstractNewPanel.this.panel.getName().length() == 0 || AbstractNewPanel.this.panel.getValue().length() == 0) {
                            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)JndiRootNode.getLocalizedString("EXC_Params"), 0));
                            return;
                        }
                        String string = AbstractNewPanel.this.panel.getName() + "=" + AbstractNewPanel.this.panel.getValue();
                        AbstractNewPanel.this.properties.addElement(string);
                        ((Component)AbstractNewPanel.this.dlg).setVisible(false);
                        AbstractNewPanel.this.dlg.dispose();
                    } else if (actionEvent.getSource() == NotifyDescriptor.CANCEL_OPTION) {
                        ((Component)AbstractNewPanel.this.dlg).setVisible(false);
                        AbstractNewPanel.this.dlg.dispose();
                    }
                }
            });
            this.dlg = TopManager.getDefault().createDialog(dialogDescriptor);
            ((Component)this.dlg).setVisible(true);
        } else if (actionEvent.getActionCommand().equals("DEL")) {
            int n = this.list.getSelectedIndex();
            if (n < 0) {
                return;
            }
            this.properties.removeElementAt(n);
            this.removeButton.setEnabled(false);
            this.changeButton.setEnabled(false);
        } else if (actionEvent.getActionCommand().equals("CHANGE")) {
            this.panel = new NewPropertyPanel();
            int n = this.list.getSelectedIndex();
            if (n < 0) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer((String)this.properties.getElementAt(n), "=");
            if (stringTokenizer.countTokens() != 2) {
                return;
            }
            this.panel.setName(stringTokenizer.nextToken());
            this.panel.setValue(stringTokenizer.nextToken());
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, JndiRootNode.getLocalizedString("TITLE_Change_property"), true, 2, NotifyDescriptor.OK_OPTION, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == NotifyDescriptor.OK_OPTION) {
                        if (AbstractNewPanel.this.panel.getName().length() == 0 || AbstractNewPanel.this.panel.getValue().length() == 0) {
                            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)JndiRootNode.getLocalizedString("EXC_Params"), 0));
                            return;
                        }
                        AbstractNewPanel.this.properties.removeElementAt(AbstractNewPanel.this.list.getSelectedIndex());
                        String string = AbstractNewPanel.this.panel.getName() + "=" + AbstractNewPanel.this.panel.getValue();
                        AbstractNewPanel.this.properties.addElement(string);
                        AbstractNewPanel.this.removeButton.setEnabled(false);
                        AbstractNewPanel.this.changeButton.setEnabled(false);
                        ((Component)AbstractNewPanel.this.dlg).setVisible(false);
                        AbstractNewPanel.this.dlg.dispose();
                    } else if (actionEvent.getSource() == NotifyDescriptor.CANCEL_OPTION) {
                        ((Component)AbstractNewPanel.this.dlg).setVisible(false);
                        AbstractNewPanel.this.dlg.dispose();
                    }
                }
            });
            this.dlg = TopManager.getDefault().createDialog(dialogDescriptor);
            ((Component)this.dlg).setVisible(true);
        }
    }

    public abstract String getFactory();

    abstract JPanel createSubGUI();

    abstract JPanel createNotesPanel();

    final void createGUI() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = this.createSubGUI();
        this.properties = new SimpleListModel();
        this.list = new JList();
        this.list.addListSelectionListener(this);
        this.list.setModel(this.properties);
        this.list.setVisibleRowCount(8);
        this.list.setPrototypeCellValue("123456789012345678901234567890123456");
        JLabel jLabel = new JLabel(JndiRootNode.getLocalizedString("TXT_OtherProps"));
        jLabel.setLabelFor(this.list);
        jLabel.setDisplayedMnemonic(JndiRootNode.getLocalizedString("TXT_OtherProps_MNEM").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)new JScrollPane(this.list), gridBagConstraints);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.addButton = new JButton(JndiRootNode.getLocalizedString("TXT_Add"));
        this.addButton.setActionCommand("ADD");
        this.addButton.addActionListener(this);
        this.addButton.setMnemonic(JndiRootNode.getLocalizedString("TXT_Add_MNEM").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        this.changeButton = new JButton(JndiRootNode.getLocalizedString("TXT_Change"));
        this.changeButton.setEnabled(false);
        this.changeButton.setActionCommand("CHANGE");
        this.changeButton.addActionListener(this);
        this.changeButton.setMnemonic(JndiRootNode.getLocalizedString("TXT_Change_MNEM").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.changeButton, gridBagConstraints);
        this.removeButton = new JButton(JndiRootNode.getLocalizedString("TXT_Rem"));
        this.removeButton.setEnabled(false);
        this.removeButton.setActionCommand("DEL");
        this.removeButton.addActionListener(this);
        this.removeButton.setMnemonic(JndiRootNode.getLocalizedString("TXT_Rem_MNEM").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagConstraints.anchor = 12;
        this.add((Component)jPanel, gridBagConstraints);
        jPanel = this.createNotesPanel();
        if (jPanel != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets = new Insets(0, 8, 8, 8);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            this.add((Component)jPanel, gridBagConstraints);
        }
        this.list.getAccessibleContext().setAccessibleDescription(JndiRootNode.getLocalizedString("AD_OtherProps"));
        this.context.getAccessibleContext().setAccessibleDescription(JndiRootNode.getLocalizedString("AD_Context"));
        this.authentification.getAccessibleContext().setAccessibleDescription(JndiRootNode.getLocalizedString("AD_Authentification"));
        this.root.getAccessibleContext().setAccessibleDescription(JndiRootNode.getLocalizedString("AD_Root"));
        this.principal.getAccessibleContext().setAccessibleDescription(JndiRootNode.getLocalizedString("AD_Principal"));
        this.credentials.getAccessibleContext().setAccessibleDescription(JndiRootNode.getLocalizedString("AD_Credentials"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(JndiRootNode.getLocalizedString("AD_RemoveButton"));
        this.changeButton.getAccessibleContext().setAccessibleDescription(JndiRootNode.getLocalizedString("AD_ChangeButton"));
        this.addButton.getAccessibleContext().setAccessibleDescription(JndiRootNode.getLocalizedString("AD_AddButton"));
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.list) {
            if (this.list.getSelectedIndex() == -1) {
                this.removeButton.setEnabled(false);
                this.changeButton.setEnabled(false);
            } else {
                this.removeButton.setEnabled(true);
                this.changeButton.setEnabled(true);
            }
        }
    }
}

