/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.editor.options.ScrollInsetsEditor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ScrollInsetsCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$options$ScrollInsetsCustomEditor == null ? (class$org$netbeans$modules$editor$options$ScrollInsetsCustomEditor = ScrollInsetsCustomEditor.class$("org.netbeans.modules.editor.options.ScrollInsetsCustomEditor")) : class$org$netbeans$modules$editor$options$ScrollInsetsCustomEditor));
    static final long serialVersionUID = -1472891501739636852L;
    private static final String HELP_ID = "editing.scrollinsets";
    private ScrollInsetsEditor editor;
    private JLabel topLabel;
    private JTextField topField;
    private JLabel leftLabel;
    private JTextField leftField;
    private JPanel jPanel2;
    private JLabel rightLabel;
    private JLabel bottomLabel;
    private JTextField rightField;
    private JTextField bottomField;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$ScrollInsetsCustomEditor;

    public ScrollInsetsCustomEditor(ScrollInsetsEditor scrollInsetsEditor) {
        this.initComponents();
        this.editor = scrollInsetsEditor;
        Insets insets = (Insets)scrollInsetsEditor.getValue();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_SICE"));
        this.topLabel.setDisplayedMnemonic(bundle.getString("SICE_Top_Mnemonic").charAt(0));
        this.bottomLabel.setDisplayedMnemonic(bundle.getString("SICE_Bottom_Mnemonic").charAt(0));
        this.leftLabel.setDisplayedMnemonic(bundle.getString("SICE_Left_Mnemonic").charAt(0));
        this.rightLabel.setDisplayedMnemonic(bundle.getString("SICE_Right_Mnemonic").charAt(0));
        this.topField.setText(ScrollInsetsCustomEditor.int2percent(insets.top));
        this.leftField.setText(ScrollInsetsCustomEditor.int2percent(insets.left));
        this.bottomField.setText(ScrollInsetsCustomEditor.int2percent(insets.bottom));
        this.rightField.setText(ScrollInsetsCustomEditor.int2percent(insets.right));
        this.topField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_SICE_Top"));
        this.leftField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_SICE_Left"));
        this.bottomField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_SICE_Bottom"));
        this.rightField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_SICE_Right"));
        HelpCtx.setHelpIDString((JComponent)this, (String)HELP_ID);
        this.setPreferredSize(new Dimension(320, this.getPreferredSize().height));
    }

    public Object getPropertyValue() throws IllegalStateException {
        try {
            return this.getValue();
        }
        catch (NumberFormatException numberFormatException) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)bundle.getString("SIC_InvalidValue"), 0));
            throw new IllegalStateException();
        }
    }

    public static String int2percent(int n) {
        if (n < 0) {
            return "" + -n + "%";
        }
        return "" + n;
    }

    private int percent2int(String string) throws NumberFormatException {
        if ((string = string.trim()).endsWith("%")) {
            return -Math.abs(Integer.parseInt(string.substring(0, string.length() - 1)));
        }
        return Integer.parseInt(string);
    }

    Insets getValue() throws NumberFormatException {
        int n = this.percent2int(this.topField.getText());
        int n2 = this.percent2int(this.leftField.getText());
        int n3 = this.percent2int(this.bottomField.getText());
        int n4 = this.percent2int(this.rightField.getText());
        return new Insets(n, n2, n3, n4);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.topLabel = new JLabel();
        this.topField = new JTextField();
        this.leftLabel = new JLabel();
        this.leftField = new JTextField();
        this.bottomLabel = new JLabel();
        this.bottomField = new JTextField();
        this.rightLabel = new JLabel();
        this.rightField = new JTextField();
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        this.jPanel2.setLayout(new GridBagLayout());
        this.topLabel.setText(bundle.getString("SICE_Top"));
        this.topLabel.setLabelFor(this.topField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.topLabel, gridBagConstraints);
        this.topField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScrollInsetsCustomEditor.this.updateInsets(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.topField, gridBagConstraints);
        this.leftLabel.setText(bundle.getString("SICE_Left"));
        this.leftLabel.setLabelFor(this.leftField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.leftLabel, gridBagConstraints);
        this.leftField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScrollInsetsCustomEditor.this.updateInsets(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel2.add((Component)this.leftField, gridBagConstraints);
        this.bottomLabel.setText(bundle.getString("SICE_Bottom"));
        this.bottomLabel.setLabelFor(this.bottomField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.bottomLabel, gridBagConstraints);
        this.bottomField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScrollInsetsCustomEditor.this.updateInsets(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel2.add((Component)this.bottomField, gridBagConstraints);
        this.rightLabel.setText(bundle.getString("SICE_Right"));
        this.rightLabel.setLabelFor(this.rightField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(7, 0, 0, 12);
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.rightLabel, gridBagConstraints);
        this.rightField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScrollInsetsCustomEditor.this.updateInsets(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel2.add((Component)this.rightField, gridBagConstraints);
        this.add(this.jPanel2);
    }

    private void updateInsets(ActionEvent actionEvent) {
        try {
            this.editor.setValue(this.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

