/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Color;
import java.awt.Insets;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import org.netbeans.editor.MultiKeyBinding;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OptionUtilities {
    public static final String DEFAULT_FOLDER = "Defaults";
    static /* synthetic */ Class class$org$netbeans$editor$MultiKeyBinding;

    private OptionUtilities() {
    }

    private static String wrap(String string) {
        return string.length() == 1 ? "0" + string : string;
    }

    public static String color2String(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#");
        stringBuffer.append(OptionUtilities.wrap(Integer.toHexString(color.getRed()).toUpperCase()));
        stringBuffer.append(OptionUtilities.wrap(Integer.toHexString(color.getGreen()).toUpperCase()));
        stringBuffer.append(OptionUtilities.wrap(Integer.toHexString(color.getBlue()).toUpperCase()));
        return stringBuffer.toString();
    }

    public static Color string2Color(String string) {
        try {
            return Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static int string2Int(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static int getFontStyle(String string) {
        string = string.toLowerCase();
        int n = 0;
        if (string.indexOf("bold") != -1) {
            n |= 1;
        }
        if (string.indexOf("italic") != -1) {
            n |= 2;
        }
        return n;
    }

    public static String style2String(int n) {
        if (1 == n) {
            return "bold";
        }
        if (2 == n) {
            return "italic";
        }
        if (3 == n) {
            return "bold-italic";
        }
        return "plain";
    }

    public static Map getMapDiff(Map map, Map map2, boolean bl) {
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = map2.get(object2);
            if (!object.equals(map.get(object2))) {
                hashMap.put(object2, map2.get(object2));
                continue;
            }
            if (!bl || map.containsKey(object2)) continue;
            hashMap.put(object2, map2.get(object2));
        }
        object2 = map.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            Object v = map.get(object);
            if (map2.containsKey(object)) continue;
            hashMap.put(object, "");
        }
        return hashMap;
    }

    public static String keysToString(KeyStroke[] keyStrokeArray) {
        if (keyStrokeArray == null) {
            return "NULL";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < keyStrokeArray.length) {
            stringBuffer.append(Utilities.keyToString((KeyStroke)keyStrokeArray[n]));
            if (n < keyStrokeArray.length - 1) {
                stringBuffer.append("$");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String keyToString(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return "NULL";
        }
        return Utilities.keyToString((KeyStroke)keyStroke);
    }

    public static KeyStroke stringToKey(String string) {
        if (string.equals("NULL")) {
            return null;
        }
        return Utilities.stringToKey((String)string);
    }

    public static KeyStroke[] stringToKeys(String string) {
        if (string.equals("NULL")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase(), "$");
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        while (stringTokenizer.hasMoreElements()) {
            string = stringTokenizer.nextToken();
            KeyStroke keyStroke = OptionUtilities.stringToKey(string);
            if (keyStroke == null) {
                return null;
            }
            arrayList.add(keyStroke);
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    public static void printDefaultAbbrevs(Map map) {
        System.out.println("-----------------------------------------------------------");
        System.out.println("<?xml version=\"1.0\"?>");
        System.out.println("<!DOCTYPE catalog PUBLIC \"-//NetBeans//DTD Editor Abbreviations settings 1.0//EN\"");
        System.out.println(" \"http://www.netbeans.org/dtds/EditorAbbreviations-1_0.dtd\">");
        System.out.println("");
        System.out.println("<abbrevs>");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            System.out.println("<abbrev key=\"" + string + "\">" + string2 + "</" + "abbrev" + ">");
        }
        System.out.println("</abbrevs>");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void printDefaultAbbrevs(Map map, FileObject fileObject) {
        String string;
        Document document = XMLUtil.createDocument((String)"abbrevs", null, (String)"-//NetBeans//DTD Editor Abbreviations settings 1.0//EN", (String)"http://www.netbeans.org/dtds/EditorAbbreviations-1_0.dtd");
        Element element = document.getDocumentElement();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (!(map.get(string) instanceof String)) continue;
            String string2 = (String)map.get(string);
            Element element2 = document.createElement("abbrev");
            element2.setAttribute("key", string);
            element2.appendChild(document.createTextNode(string2));
            element.appendChild(element2);
        }
        document.getDocumentElement().normalize();
        try {
            string = fileObject.lock();
            try {
                try {
                    XMLUtil.write((Document)document, (OutputStream)fileObject.getOutputStream((FileLock)string), null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var9_11 = null;
                    string.releaseLock();
                    return;
                }
                Object var9_10 = null;
                string.releaseLock();
                return;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                string.releaseLock();
                throw throwable;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void printDefaultMacros(Map map, FileObject fileObject) {
        String string;
        Document document = XMLUtil.createDocument((String)"macros", null, (String)"-//NetBeans//DTD Editor Macros settings 1.0//EN", (String)"http://www.netbeans.org/dtds/EditorMacros-1_0.dtd");
        Element element = document.getDocumentElement();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (!(map.get(string) instanceof String)) continue;
            String string2 = (String)map.get(string);
            Element element2 = document.createElement("macro");
            element2.setAttribute("name", string);
            element2.appendChild(document.createTextNode(string2));
            element.appendChild(element2);
        }
        document.getDocumentElement().normalize();
        try {
            string = fileObject.lock();
            try {
                try {
                    XMLUtil.write((Document)document, (OutputStream)fileObject.getOutputStream((FileLock)string), null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var9_11 = null;
                    string.releaseLock();
                    return;
                }
                Object var9_10 = null;
                string.releaseLock();
                return;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                string.releaseLock();
                throw throwable;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void printDefaultKeyBindings(List list, FileObject fileObject) {
        String string;
        Map map = OptionUtilities.makeKeyBindingsMap(list);
        Document document = XMLUtil.createDocument((String)"bindings", null, (String)"-//NetBeans//DTD Editor KeyBindings settings 1.0//EN", (String)"http://www.netbeans.org/dtds/EditorKeyBindings-1_0.dtd");
        Element element = document.getDocumentElement();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            MultiKeyBinding multiKeyBinding;
            string = (String)iterator.next();
            if (!(map.get(string) instanceof MultiKeyBinding) || (multiKeyBinding = (MultiKeyBinding)map.get(string)) == null) continue;
            Element element2 = document.createElement("bind");
            element2.setAttribute("key", string);
            element2.setAttribute("actionName", multiKeyBinding.actionName);
            element.appendChild(element2);
        }
        document.getDocumentElement().normalize();
        try {
            string = fileObject.lock();
            try {
                try {
                    XMLUtil.write((Document)document, (OutputStream)fileObject.getOutputStream((FileLock)string), null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var10_12 = null;
                    string.releaseLock();
                    return;
                }
                Object var10_11 = null;
                string.releaseLock();
                return;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                string.releaseLock();
                throw throwable;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String insetsToString(Insets insets) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(insets.top);
        stringBuffer.append(',');
        stringBuffer.append(insets.left);
        stringBuffer.append(',');
        stringBuffer.append(insets.bottom);
        stringBuffer.append(',');
        stringBuffer.append(insets.right);
        return stringBuffer.toString();
    }

    public static Insets parseInsets(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[4];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            if (n > 3) {
                return null;
            }
            try {
                nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            ++n;
        }
        if (n != 4) {
            return null;
        }
        return new Insets(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public static Map makeKeyBindingsMap(List list) {
        HashMap<String, MultiKeyBinding> hashMap = new HashMap<String, MultiKeyBinding>();
        boolean bl = true;
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (!(e instanceof MultiKeyBinding)) {
                if (!(class$org$netbeans$editor$MultiKeyBinding == null ? OptionUtilities.class$("org.netbeans.editor.MultiKeyBinding") : class$org$netbeans$editor$MultiKeyBinding).getClassLoader().equals(e.getClass().getClassLoader()) && bl) {
                    System.err.println("Different classloaders:");
                    System.err.println((class$org$netbeans$editor$MultiKeyBinding == null ? OptionUtilities.class$("org.netbeans.editor.MultiKeyBinding") : class$org$netbeans$editor$MultiKeyBinding).getClassLoader());
                    System.err.println(e.getClass().getClassLoader());
                    bl = false;
                }
            } else {
                String string;
                MultiKeyBinding multiKeyBinding = (MultiKeyBinding)e;
                String string2 = string = multiKeyBinding.keys == null ? OptionUtilities.keyToString(multiKeyBinding.key) : OptionUtilities.keysToString(multiKeyBinding.keys);
                if (string != null) {
                    hashMap.put(string, multiKeyBinding);
                }
            }
            ++n;
        }
        return hashMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

