/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderInstance;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AnnotationTypesFolder
extends FolderInstance {
    private static final String FOLDER = "Editors/AnnotationTypes";
    private static AnnotationTypesFolder folder;
    private Map annotationTypes;
    private FileObject fo;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    private AnnotationTypesFolder(FileObject fileObject, DataFolder dataFolder) {
        super(dataFolder);
        this.recreate();
        this.instanceFinished();
        this.fo = fileObject;
        fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileDeleted(FileEvent fileEvent) {
                Iterator iterator = AnnotationTypes.getTypes().getAnnotationTypeNames();
                while (iterator.hasNext()) {
                    AnnotationType annotationType = AnnotationTypes.getTypes().getType((String)iterator.next());
                    if (annotationType == null || !((FileObject)annotationType.getProp("file")).equals(fileEvent.getFile())) continue;
                    AnnotationTypes.getTypes().removeType(annotationType.getName());
                    break;
                }
            }
        });
    }

    public static synchronized AnnotationTypesFolder getAnnotationTypesFolder() {
        if (folder != null) {
            return folder;
        }
        FileObject fileObject = TopManager.getDefault().getRepository().getDefaultFileSystem().findResource(FOLDER);
        if (fileObject == null) {
            return null;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            DataFolder dataFolder = (DataFolder)dataObject.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = AnnotationTypesFolder.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
            if (dataFolder != null) {
                folder = new AnnotationTypesFolder(fileObject, dataFolder);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                dataObjectNotFoundException.printStackTrace();
            }
            return null;
        }
        return folder;
    }

    protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
        this.annotationTypes = new HashMap(instanceCookieArray.length * 4 / 3);
        int n = 0;
        while (n < instanceCookieArray.length) {
            Object object = instanceCookieArray[n].instanceCreate();
            if (object instanceof AnnotationType) {
                AnnotationType annotationType = (AnnotationType)object;
                this.annotationTypes.put(annotationType.getName(), annotationType);
            }
            ++n;
        }
        AnnotationTypes.getTypes().setTypes(this.annotationTypes);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveAnnotationType(AnnotationType annotationType) {
        Element element;
        FileObject fileObject = (FileObject)annotationType.getProp("file");
        Document document = XMLUtil.createDocument((String)"type", null, (String)"-//NetBeans//DTD annotation type 1.0//EN", (String)"http://www.netbeans.org/dtds/annotation-type-1_0.dtd");
        Element element2 = document.getDocumentElement();
        element2.setAttribute("name", annotationType.getName());
        if (annotationType.getProp("bundle") != null) {
            element2.setAttribute("localizing_bundle", (String)annotationType.getProp("bundle"));
        }
        if (annotationType.getProp("desciptionKey") != null) {
            element2.setAttribute("description_key", (String)annotationType.getProp("desciptionKey"));
        }
        element2.setAttribute("visible", annotationType.isVisible() ? "true" : "false");
        element2.setAttribute("type", annotationType.isWholeLine() ? "line" : "linepart");
        if (annotationType.getProp("glyph") != null) {
            element2.setAttribute("glyph", annotationType.getGlyph().toExternalForm());
        }
        if (annotationType.getProp("highlight") != null && annotationType.isUseHighlightColor()) {
            element2.setAttribute("highlight", "0x" + Integer.toHexString(annotationType.getHighlight().getRGB() & 0xFFFFFF));
        }
        if (annotationType.getProp("foreground") != null && !annotationType.isInheritForegroundColor()) {
            element2.setAttribute("foreground", "0x" + Integer.toHexString(annotationType.getForegroundColor().getRGB() & 0xFFFFFF));
        }
        if (annotationType.getProp("actionsFolder") != null) {
            element2.setAttribute("actions", (String)annotationType.getProp("actionsFolder"));
        }
        if (annotationType.getCombinations() != null) {
            element = document.createElement("combination");
            element.setAttribute("tiptext_key", (String)annotationType.getProp("tooltipTextKey"));
            if (annotationType.getProp("combinationOrder") != null) {
                element.setAttribute("order", "" + annotationType.getCombinationOrder());
            }
            if (annotationType.getProp("combinationMinimumOptionals") != null) {
                element.setAttribute("min_optionals", "" + annotationType.getMinimumOptionals());
            }
            element2.appendChild(element);
            AnnotationType.CombinationMember[] combinationMemberArray = annotationType.getCombinations();
            int n = 0;
            while (n < combinationMemberArray.length) {
                Element element3 = document.createElement("combine");
                element3.setAttribute("annotationtype", combinationMemberArray[n].getName());
                element3.setAttribute("absorb_all", combinationMemberArray[n].isAbsorbAll() ? "true" : "false");
                element3.setAttribute("optional", combinationMemberArray[n].isOptional() ? "true" : "false");
                if (combinationMemberArray[n].getMinimumCount() > 0) {
                    element3.setAttribute("min", "" + combinationMemberArray[n].getMinimumCount());
                }
                element.appendChild(element3);
                ++n;
            }
        }
        document.getDocumentElement().normalize();
        try {
            element = fileObject.lock();
            try {
                try {
                    XMLUtil.write((Document)document, (OutputStream)fileObject.getOutputStream((FileLock)element), null);
                }
                catch (Exception exception) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        exception.printStackTrace();
                    }
                    Object var10_12 = null;
                    element.releaseLock();
                    return;
                }
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                element.releaseLock();
                throw throwable;
            }
            element.releaseLock();
            return;
        }
        catch (IOException iOException) {
            if (!Boolean.getBoolean("netbeans.debug.exceptions")) return;
            iOException.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

