/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JavaDrawLayerFactory;
import org.netbeans.editor.ext.java.JavaFormatter;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.NbJavaCompletion;
import org.netbeans.modules.editor.java.NbJavaFastImport;
import org.netbeans.modules.editor.java.NbJavaSyntaxSupport;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.Watch;
import org.openide.util.NbBundle;

public class JavaKit
extends NbEditorKit {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    private static final String[] getSetIsPrefixes = new String[]{"get", "set", "is"};
    public static final String makeGetterAction = "make-getter";
    public static final String makeSetterAction = "make-setter";
    public static final String makeIsAction = "make-is";
    public static final String addWatchAction = "add-watch";
    public static final String toggleBreakpointAction = "toggle-breakpoint";
    public static final String abbrevDebugLineAction = "abbrev-debug-line";
    public static final String fastImportAction = "fast-import";
    static final long serialVersionUID = -5445829962533684922L;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;

    public String getContentType() {
        return JAVA_MIME_TYPE;
    }

    public Document createDefaultDocument() {
        NbEditorDocument nbEditorDocument = new NbEditorDocument(this.getClass());
        nbEditorDocument.putProperty("write-line-separator", "\n");
        return nbEditorDocument;
    }

    public Syntax createSyntax(Document document) {
        return new JavaSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        return new NbJavaSyntaxSupport(baseDocument);
    }

    public Completion createCompletion(ExtEditorUI extEditorUI) {
        return new NbJavaCompletion(extEditorUI);
    }

    public Formatter createFormatter() {
        return new JavaFormatter(this.getClass());
    }

    protected void initDocument(BaseDocument baseDocument) {
        baseDocument.addLayer(new JavaDrawLayerFactory.JavaLayer(), 1010);
        baseDocument.addDocumentListener(new JavaDrawLayerFactory.LParenWatcher());
    }

    public Class getFocusableComponentClass(JTextComponent jTextComponent) {
        return class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = JavaKit.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent;
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new JavaDefaultKeyTypedAction(), new AddWatchAction(), new JavaGotoHelpAction(), new JavaGotoSourceAction(), new JavaGotoDeclarationAction(), new ExtKit.PrefixMakerAction(makeGetterAction, "get", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeSetterAction, "set", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeIsAction, "is", getSetIsPrefixes), new AbbrevDebugLineAction(), new ExtKit.CommentAction("//"), new ExtKit.UncommentAction("//"), new FastImportAction()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class FastImportAction
    extends BaseAction {
        public FastImportAction() {
            super(JavaKit.fastImportAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                new NbJavaFastImport(jTextComponent).setDialogVisible(true);
            }
        }
    }

    public static class AbbrevDebugLineAction
    extends BaseAction {
        public AbbrevDebugLineAction() {
            super(JavaKit.abbrevDebugLineAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                StringBuffer stringBuffer = new StringBuffer("System.out.println(\"");
                String string = (String)baseDocument.getProperty("title");
                if (string != null) {
                    stringBuffer.append(string);
                    stringBuffer.append(':');
                }
                try {
                    stringBuffer.append(Utilities.getLineOffset(baseDocument, jTextComponent.getCaret().getDot()) + 1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                stringBuffer.append(' ');
                BaseKit baseKit = Utilities.getKit(jTextComponent);
                Action action = baseKit.getActionByName("insert-content");
                if (action != null) {
                    Utilities.performAction(action, new ActionEvent(jTextComponent, 1001, stringBuffer.toString()), jTextComponent);
                }
            }
        }
    }

    public static class JavaGotoHelpAction
    extends BaseAction {
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit;

        public JavaGotoHelpAction() {
            super("goto-help", 128);
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction = JavaGotoHelpAction.class$("org.netbeans.modules.editor.java.JavaKit$JavaGotoHelpAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction).getName());
        }

        public URL[] getJavaDocURLs(JTextComponent jTextComponent) {
            Completion completion = ExtUtilities.getCompletion(jTextComponent);
            SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport(jTextComponent);
            NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)syntaxSupport.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaGotoHelpAction.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
            if (completion != null) {
                if (completion.isPaneVisible()) {
                    Object object = completion.getSelectedValue();
                    if (object != null) {
                        return nbJavaSyntaxSupport.getJavaDocURLs(object);
                    }
                } else {
                    int n = jTextComponent.getCaret().getDot();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    try {
                        int[] nArray = NbEditorUtilities.getIdentifierAndMethodBlock(baseDocument, n);
                        if (nArray == null) {
                            nArray = new int[]{n, n};
                        }
                        int n2 = nArray.length - 1;
                        while (n2 >= 1) {
                            CompletionQuery.Result result = completion.getQuery().query(jTextComponent, nArray[n2], nbJavaSyntaxSupport);
                            if (result != null && result.getData().size() > 0) {
                                return nbJavaSyntaxSupport.getJavaDocURLs(result.getData().get(0));
                            }
                            --n2;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                URL[] uRLArray = this.getJavaDocURLs(jTextComponent);
                if (uRLArray != null && uRLArray.length > 0) {
                    TopManager topManager = NbEditorUtilities.getTopManager();
                    if (topManager != null) {
                        topManager.showUrl(uRLArray[0]);
                    }
                } else {
                    Utilities.setStatusText(jTextComponent, NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaGotoHelpAction.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("cannot_find_javadoc"));
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        public String getPopupMenuText(JTextComponent jTextComponent) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaGotoHelpAction.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("show_javadoc");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class JavaGotoSourceAction
    extends BaseAction {
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit;

        public JavaGotoSourceAction() {
            super("goto-source", 128);
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction = JavaGotoSourceAction.class$("org.netbeans.modules.editor.java.JavaKit$JavaGotoSourceAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction).getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            TopManager topManager;
            String string;
            if (jTextComponent != null && (string = this.openSource(jTextComponent, false)) != null && (topManager = NbEditorUtilities.getTopManager()) != null) {
                topManager.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
            }
        }

        private int findEndOfMethod(JTextComponent jTextComponent, int n) {
            try {
                int n2 = 0;
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int n3 = n;
                while (n3 < jTextComponent.getDocument().getLength()) {
                    char c = baseDocument.getChars(n3, 1)[0];
                    if (c == ';') {
                        return -1;
                    }
                    if (c == '(') {
                        ++n2;
                    }
                    if (c == ')') {
                        if (n2 == 0) {
                            return n3 + 1;
                        }
                        --n2;
                    }
                    ++n3;
                }
                return -1;
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }

        public String openSource(JTextComponent jTextComponent, boolean bl) {
            Object object = null;
            String string = null;
            Completion completion = ExtUtilities.getCompletion(jTextComponent);
            SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport(jTextComponent);
            NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)syntaxSupport.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaGotoSourceAction.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
            if (completion != null) {
                if (completion.isPaneVisible()) {
                    object = completion.getSelectedValue();
                    if (object != null) {
                        string = nbJavaSyntaxSupport.openSource(object, false, bl);
                    }
                } else {
                    try {
                        int n = jTextComponent.getCaret().getDot();
                        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                        int[] nArray = NbEditorUtilities.getIdentifierAndMethodBlock(baseDocument, n);
                        if (nArray == null || n > 0 && baseDocument.getChars(n - 1, 1)[0] == '(' && n == nArray[0]) {
                            nArray = new int[]{n, n};
                        }
                        int n2 = nArray.length - 1;
                        while (n2 >= 1) {
                            CompletionQuery.Result result = completion.getQuery().query(jTextComponent, nArray[n2], nbJavaSyntaxSupport);
                            if (result != null && result.getData().size() > 0) {
                                CompletionQuery.Result result2;
                                int n3;
                                Object e = result.getData().get(0);
                                if ((e instanceof JCConstructor || e instanceof JCMethod) && result.getData().size() > 1 && (n3 = this.findEndOfMethod(jTextComponent, nArray[n2])) > -1 && (result2 = completion.getQuery().query(jTextComponent, n3, nbJavaSyntaxSupport)) != null && result2.getData().size() > 0) {
                                    string = nbJavaSyntaxSupport.openSource(result2.getData().get(0), false, bl);
                                } else {
                                    nbJavaSyntaxSupport.refreshJavaImport();
                                    n3 = 0;
                                    int n4 = 0;
                                    while (n4 < result.getData().size()) {
                                        Object e2 = result.getData().get(n4);
                                        if (!(e2 instanceof JCClass)) break;
                                        if (nbJavaSyntaxSupport.isImported((JCClass)e2)) {
                                            string = nbJavaSyntaxSupport.openSource(result.getData().get(n4), false, bl);
                                            n3 = 1;
                                            break;
                                        }
                                        ++n4;
                                    }
                                    if (n3 == 0) {
                                        string = nbJavaSyntaxSupport.openSource(result.getData().get(0), false, bl);
                                    }
                                }
                                break;
                            }
                            --n2;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            String string2 = null;
            if (string != null) {
                boolean bl2 = object instanceof JCPackage;
                string2 = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaGotoSourceAction.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(bl ? (bl2 ? "goto_source_explore_package" : "goto_source_open_source") : (bl2 ? "goto_source_package_not_found" : "goto_source_source_not_found"));
                string2 = MessageFormat.format(string2, string);
            }
            return string2;
        }

        public String getPopupMenuText(JTextComponent jTextComponent) {
            return this.openSource(jTextComponent, true);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class JavaGotoDeclarationAction
    extends ExtKit.GotoDeclarationAction {
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport;

        public JavaGotoDeclarationAction() {
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction = JavaGotoDeclarationAction.class$("org.netbeans.modules.editor.java.JavaKit$JavaGotoDeclarationAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction).getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block11: {
                if (jTextComponent != null) {
                    Completion completion = ExtUtilities.getCompletion(jTextComponent);
                    SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport(jTextComponent);
                    NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)syntaxSupport.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaGotoDeclarationAction.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
                    if (completion != null) {
                        if (completion.isPaneVisible()) {
                            Object object = completion.getSelectedValue();
                            if (object != null) {
                                nbJavaSyntaxSupport.openSource(object, true, false);
                            }
                        } else {
                            boolean bl = false;
                            int n = jTextComponent.getCaret().getDot();
                            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                            try {
                                int n2;
                                int[] nArray = NbEditorUtilities.getIdentifierAndMethodBlock(baseDocument, n);
                                if (nArray != null && nArray.length == 2 && ((n2 = Utilities.getFirstNonWhiteBwd(baseDocument, nArray[0])) < 0 || baseDocument.getChars(n2, 1)[0] != '.')) {
                                    bl = this.gotoDeclaration(jTextComponent);
                                }
                                if (bl) break block11;
                                if (nArray == null) {
                                    nArray = new int[]{n, n};
                                }
                                n2 = nArray.length - 1;
                                while (n2 >= 1) {
                                    CompletionQuery.Result result = completion.getQuery().query(jTextComponent, nArray[n2], nbJavaSyntaxSupport);
                                    if (result != null && result.getData().size() > 0) {
                                        nbJavaSyntaxSupport.openSource(result.getData().get(0), true, false);
                                        break;
                                    }
                                    --n2;
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class AddWatchAction
    extends BaseAction {
        static final long serialVersionUID = 4253425227297112737L;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$AddWatchAction;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit;

        public AddWatchAction() {
            super(JavaKit.addWatchAction);
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$AddWatchAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$AddWatchAction = AddWatchAction.class$("org.netbeans.modules.editor.java.JavaKit$AddWatchAction")) : class$org$netbeans$modules$editor$java$JavaKit$AddWatchAction).getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                int n = jTextComponent.getCaret().getDot();
                try {
                    Debugger debugger;
                    String string = Utilities.getSelectionOrIdentifier(jTextComponent, n);
                    ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = AddWatchAction.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit));
                    JPanel jPanel = new JPanel();
                    jPanel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_WatchPanel"));
                    JLabel jLabel = new JLabel(resourceBundle.getString("CTL_Watch_Name"));
                    jLabel.setBorder(new EmptyBorder(0, 0, 0, 10));
                    jPanel.setLayout(new BorderLayout());
                    jPanel.setBorder(new EmptyBorder(11, 12, 1, 11));
                    jPanel.add("West", jLabel);
                    JTextField jTextField = new JTextField(25);
                    jPanel.add("Center", jTextField);
                    jTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Watch_Name"));
                    jTextField.setBorder(new CompoundBorder(jTextField.getBorder(), new EmptyBorder(2, 0, 2, 0)));
                    jLabel.setDisplayedMnemonic(resourceBundle.getString("CTL_Watch_Name_Mnemonic").charAt(0));
                    if (string != null) {
                        jTextField.setText(string);
                    }
                    jLabel.setLabelFor(jTextField);
                    jTextField.requestFocus();
                    DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, resourceBundle.getString("CTL_Watch_Title"));
                    Dialog dialog = TopManager.getDefault().createDialog(dialogDescriptor);
                    dialog.show();
                    dialog.dispose();
                    NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)Utilities.getSyntaxSupport(jTextComponent);
                    if (dialogDescriptor.getValue() == NotifyDescriptor.OK_OPTION && (string = jTextField.getText()) != null && (debugger = nbJavaSyntaxSupport.getDebugger()) != null) {
                        debugger.createWatch(string, false);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class ToggleBreakpointAction
    extends BaseAction {
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$ToggleBreakpointAction;

        public ToggleBreakpointAction() {
            super(JavaKit.toggleBreakpointAction);
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$ToggleBreakpointAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$ToggleBreakpointAction = ToggleBreakpointAction.class$("org.netbeans.modules.editor.java.JavaKit$ToggleBreakpointAction")) : class$org$netbeans$modules$editor$java$JavaKit$ToggleBreakpointAction).getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                int n;
                NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)Utilities.getSyntaxSupport(jTextComponent);
                Breakpoint breakpoint = nbJavaSyntaxSupport.getBreakpoint(n = jTextComponent.getCaret().getDot());
                if (breakpoint == null) {
                    nbJavaSyntaxSupport.createBreakpoint(n);
                } else {
                    breakpoint.remove();
                }
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class JavaBuildToolTipAction
    extends ExtKit.BuildToolTipAction {
        static final long serialVersionUID = -2009277037915948909L;

        protected String buildText(JTextComponent jTextComponent) {
            Watch watch;
            String string;
            int n;
            String string2 = null;
            NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)Utilities.getSyntaxSupport(jTextComponent);
            Debugger debugger = nbJavaSyntaxSupport.getDebugger();
            if (debugger != null && ((n = debugger.getState()) == 3 || n == 4) && (string = ExtUtilities.getExtEditorUI(jTextComponent).getToolTipSupport().getIdentifierUnderCursor()) != null && (watch = debugger.createWatch(string, true)) != null) {
                String string3 = watch.getAsText();
                if (string3 != null && !string3.trim().equals(string.trim())) {
                    string2 = string + '=' + string3;
                }
                watch.remove();
            }
            return string2;
        }
    }

    public static class JavaDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
    }
}

