/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.editor.ext.java.JCBaseFinder;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCFileProvider;
import org.netbeans.editor.ext.java.JCUtilities;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.modules.editor.java.JCStorageElement;
import org.openide.TopManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;

public class JCStorage {
    private static final String DB_DIR = "ParserDB";
    private static final String STORAGE = "storage";
    private static final String STORAGE_EXT = "ser";
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.jcstorage");
    private static final String PROVIDER_FILE_EXT = "jcs";
    private static boolean inited;
    private static JCStorage storage;
    private FileObject dbFolder;
    private ArrayList elementList = new ArrayList();
    private HashSet updatingElements = new HashSet();
    static /* synthetic */ Class class$org$netbeans$editor$ext$java$JavaCompletion;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JCStorage;

    public static JCStorage getStorage() {
        Class clazz = class$org$netbeans$editor$ext$java$JavaCompletion == null ? (class$org$netbeans$editor$ext$java$JavaCompletion = JCStorage.class$("org.netbeans.editor.ext.java.JavaCompletion")) : class$org$netbeans$editor$ext$java$JavaCompletion;
        synchronized (clazz) {
            Class clazz2 = class$org$netbeans$modules$editor$java$JCStorage == null ? (class$org$netbeans$modules$editor$java$JCStorage = JCStorage.class$("org.netbeans.modules.editor.java.JCStorage")) : class$org$netbeans$modules$editor$java$JCStorage;
            synchronized (clazz2) {
                if (storage == null) {
                    JCStorage.init(TopManager.getDefault().getRepository().getDefaultFileSystem().getRoot());
                }
                JCStorage jCStorage = storage;
                return jCStorage;
            }
        }
    }

    private static void init(FileObject fileObject) {
        long l = 0L;
        if (debug) {
            System.err.println("JCStorage initing\t" + Thread.currentThread());
            l = System.currentTimeMillis();
        }
        storage = new JCStorage(fileObject);
        if (debug) {
            System.err.println("JCStorage inited in=" + (System.currentTimeMillis() - l) + "ms");
        }
    }

    JCStorage(FileObject fileObject) {
        this.checkDBFolder(fileObject);
        if (this.dbFolder != null) {
            if (debug) {
                String string;
                try {
                    string = this.dbFolder.getFileSystem().toString();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    string = "<Invalid filesystem>";
                }
                System.err.println("JCStorage.init(): scanning dbFolder='" + this.dbFolder + "' of filesystem='" + string + "'");
            }
            this.initElements();
            this.initProviders();
            this.refresh();
        }
    }

    private void checkDBFolder(FileObject fileObject) {
        if (fileObject != null) {
            this.dbFolder = fileObject.getFileObject(DB_DIR);
            if (this.dbFolder == null) {
                try {
                    this.dbFolder = fileObject.createFolder(DB_DIR);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private File getStorageFile(boolean bl) {
        File file = null;
        if (this.dbFolder == null) {
            return null;
        }
        FileObject fileObject = this.dbFolder.getFileObject(STORAGE, STORAGE_EXT);
        try {
            if (bl && fileObject == null) {
                fileObject = this.dbFolder.createData(STORAGE, STORAGE_EXT);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileObject != null) {
            file = NbClassPath.toFile((FileObject)fileObject);
        }
        return file;
    }

    private void initElements() {
        try {
            File file = this.getStorageFile(false);
            if (file != null && file.exists()) {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                this.elementList = (ArrayList)objectInputStream.readObject();
                objectInputStream.close();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveElements() {
        try {
            File file = this.getStorageFile(true);
            if (file != null) {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                objectOutputStream.writeObject(this.elementList);
                objectOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public JCStorageElement[] getElements() {
        JCStorageElement[] jCStorageElementArray = new JCStorageElement[this.elementList.size()];
        this.elementList.toArray(jCStorageElementArray);
        return jCStorageElementArray;
    }

    public JCStorageElement getElement(String string) {
        int n = this.elementList.indexOf(new JCStorageElement(string));
        if (n >= 0) {
            return (JCStorageElement)this.elementList.get(n);
        }
        return null;
    }

    private void initProviders() {
        if (this.dbFolder != null) {
            Enumeration enumeration = this.dbFolder.getData(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject = (FileObject)enumeration.nextElement();
                if (debug) {
                    System.err.println("JCStorage.initProviders(): fileObject='" + fileObject + "'");
                }
                if (!PROVIDER_FILE_EXT.equals(fileObject.getExt()) || !fileObject.existsExt("jcb")) continue;
                String string = fileObject.getName();
                File file = NbClassPath.toFile((FileObject)fileObject);
                String string2 = file.getAbsolutePath();
                string2 = string2.substring(0, string2.length() - PROVIDER_FILE_EXT.length() - 1);
                if (debug) {
                    System.err.println("JCStorage.initProviders():   body file exists, full path prefix='" + string2 + "'");
                }
                JCFileProvider jCFileProvider = new JCFileProvider(string2);
                JCStorageElement jCStorageElement = this.getElement(string);
                if (jCStorageElement != null) {
                    jCStorageElement.setProvider(jCFileProvider);
                    continue;
                }
                jCStorageElement = new JCStorageElement(string);
                jCStorageElement.setProvider(jCFileProvider);
                this.addElement(jCStorageElement);
            }
        }
    }

    public JCStorageElement findFileSystemElement(String string) {
        Iterator iterator = ((AbstractList)this.elementList).iterator();
        while (iterator.hasNext()) {
            JCStorageElement jCStorageElement = (JCStorageElement)iterator.next();
            if (!string.equals(jCStorageElement.getFileSystemName())) continue;
            return jCStorageElement;
        }
        return null;
    }

    void removeFileSystemElement(String string) {
        int n = this.elementList.size();
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(((JCStorageElement)this.elementList.get(n2)).getFileSystemName())) {
                this.elementList.remove(n2);
                --n;
            }
            ++n2;
        }
    }

    private void addElement(JCStorageElement jCStorageElement) {
        int n = this.elementList.indexOf(jCStorageElement);
        if (n >= 0) {
            this.elementList.set(n, jCStorageElement);
        } else {
            this.elementList.add(jCStorageElement);
        }
    }

    public JCStorageElement addElement(String string, String string2, int n, int n2, int n3) {
        JCStorageElement jCStorageElement = new JCStorageElement(string, string2, n, n2, n3);
        this.removeFileSystemElement(string2);
        this.addElement(jCStorageElement);
        this.saveElements();
        return jCStorageElement;
    }

    public void checkProvider(JCStorageElement jCStorageElement) {
        if (jCStorageElement.getProvider() == null && this.dbFolder != null) {
            String string = jCStorageElement.getName();
            String string2 = PROVIDER_FILE_EXT;
            FileObject fileObject = this.dbFolder.getFileObject(string, string2);
            try {
                if (fileObject == null) {
                    fileObject = this.dbFolder.createData(string, string2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (fileObject != null) {
                string2 = "jcb";
                FileObject fileObject2 = this.dbFolder.getFileObject(string, string2);
                try {
                    if (fileObject2 == null) {
                        fileObject2 = this.dbFolder.createData(string, string2);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (fileObject2 != null) {
                    JCFileProvider jCFileProvider = new JCFileProvider(NbClassPath.toFile((FileObject)fileObject).getAbsolutePath(), NbClassPath.toFile((FileObject)fileObject2).getAbsolutePath());
                    jCFileProvider.reset();
                    jCStorageElement.setProvider(jCFileProvider);
                }
            }
        }
    }

    public void refresh() {
        JCBaseFinder jCBaseFinder = new JCBaseFinder();
        JavaCompletion.setFinder(jCBaseFinder);
        JCStorage jCStorage = this;
        synchronized (jCStorage) {
            Iterator iterator = ((AbstractList)this.elementList).iterator();
            while (iterator.hasNext()) {
                JCStorageElement jCStorageElement = (JCStorageElement)iterator.next();
                if (jCStorageElement.getProvider() == null || this.updatingElements.contains(jCStorageElement)) continue;
                jCBaseFinder.append(jCStorageElement.getProvider());
            }
        }
    }

    public synchronized void addProcessedElement(JCStorageElement jCStorageElement) {
        this.updatingElements.add(jCStorageElement);
    }

    public synchronized void removeProcessedElement(JCStorageElement jCStorageElement) {
        this.updatingElements.remove(jCStorageElement);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 5) {
            System.err.println("arg1=base-source-dir arg2=target-file-prefix arg3=class-level arg4=field-level arg5=method-level\nStorage level: 0=all, 1=not private 2=public and protected, 3=public only\nExample of args: e:\\java\\jdk12\\src e:\\NB\\system\\ParserDB\\jdk12 2 2 2");
            return;
        }
        int n = Integer.parseInt(stringArray[2]);
        int n2 = Integer.parseInt(stringArray[3]);
        int n3 = Integer.parseInt(stringArray[4]);
        System.out.println("Inspecting classes ...");
        List list = JCUtilities.getClassNameList(stringArray[0]);
        List list2 = JCUtilities.getClassList(list, true, n, n2, n3);
        final int[] nArray = new int[1];
        JCFileProvider jCFileProvider = new JCFileProvider(stringArray[1]);
        jCFileProvider.reset();
        JavaCompletion.ListProvider listProvider = new JavaCompletion.ListProvider(list2){

            public boolean notifyAppend(JCClass jCClass, boolean bl) {
                if (bl) {
                    System.out.print("Building " + jCClass.getFullName() + " ...             \r");
                    nArray[0] = nArray[0] + 1;
                }
                return true;
            }
        };
        long l = System.currentTimeMillis();
        jCFileProvider.append(listProvider);
        System.out.println(nArray[0] + " classes rebuilt in " + (System.currentTimeMillis() - l) + "ms.");
        File file = new File(stringArray[1] + PROVIDER_FILE_EXT);
        File file2 = new File(stringArray[1] + "jcb");
        System.out.println("Files created:\nSkeleton file: " + file.getAbsolutePath() + ", length=" + file.length() + "\nBody file: " + file2.getAbsolutePath() + ", length=" + file2.length());
        System.exit(0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)this.elementList).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((JCStorageElement)iterator.next()).toString());
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

