/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.HashSet;
import java.util.Iterator;
import org.openide.util.TaskListener;

public class Task
implements Runnable {
    public static final Task EMPTY = new Task();
    private Runnable run;
    private boolean finished;
    private HashSet list;

    public Task(Runnable runnable) {
        this.run = runnable;
        if (runnable == null) {
            this.finished = true;
        }
    }

    protected Task() {
    }

    public final boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitFinished() {
        if (this.finished) return;
        Task task = this;
        synchronized (task) {
            while (!this.finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyRunning() {
        Task task = this;
        synchronized (task) {
            this.finished = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void notifyFinished() {
        Iterator iterator;
        Task task = this;
        synchronized (task) {
            this.finished = true;
            this.notifyAll();
            if (this.list == null) {
                return;
            }
            iterator = ((HashSet)this.list.clone()).iterator();
        }
        while (iterator.hasNext()) {
            TaskListener taskListener = (TaskListener)iterator.next();
            taskListener.taskFinished(this);
        }
    }

    final void setFinished(boolean bl) {
        if (bl) {
            this.notifyFinished();
        } else {
            this.notifyRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.notifyRunning();
            if (this.run != null) {
                this.run.run();
            }
            Object var2_1 = null;
            this.notifyFinished();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.notifyFinished();
            throw throwable;
        }
    }

    public synchronized void addTaskListener(TaskListener taskListener) {
        if (this.list == null) {
            this.list = new HashSet();
        }
        this.list.add(taskListener);
        if (this.finished) {
            taskListener.taskFinished(this);
        }
    }

    public synchronized void removeTaskListener(TaskListener taskListener) {
        if (this.list == null) {
            return;
        }
        this.list.remove(taskListener);
    }

    public String toString() {
        return "task " + this.run;
    }

    static {
        Task.EMPTY.finished = true;
    }
}

