/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;

public abstract class SharedClassObject
implements Externalizable {
    private static final long serialVersionUID = 4527891234589143259L;
    private static final String ATTR_GLOBAL = "global";
    static final String GLOBAL_METHOD_NAME = "isGlobal";
    private byte[] defaultInstance = null;
    private static final Object PROP_SUPPORT = new Object();
    private static final Map values = new WeakHashMap(4);
    private final DataEntry dataEntry;
    private Object lock;
    private final SharedClassObject first;
    private Throwable firstTrace = null;
    private static final Map instancesBeingCreated = new HashMap(3);
    private static final Set alreadyWarnedAboutDupes = new HashSet();
    private boolean systemOption = false;
    private boolean waitingOnSystemOption = false;
    private IllegalStateException prematureSystemOptionMutation = null;
    private boolean inReadExternal = false;
    private boolean addNotifySuper;
    private boolean removeNotifySuper;
    private boolean initializeSuper;
    static /* synthetic */ Class class$java$io$ObjectStreamException;
    static /* synthetic */ Class class$java$lang$Object;

    protected final void finalize() throws Throwable {
        this.referenceLost();
    }

    protected boolean clearSharedData() {
        return true;
    }

    public final boolean equals(Object object) {
        return object instanceof SharedClassObject && this.getClass().equals(object.getClass());
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }

    protected final Object getLock() {
        if (this.lock == null) {
            this.lock = this.getClass().getName().intern();
        }
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SharedClassObject() {
        Object object;
        Object object2 = this.getLock();
        synchronized (object2) {
            object = (DataEntry)values.get(this.getClass());
            if (object == null) {
                object = new DataEntry();
                values.put(this.getClass(), object);
            }
            this.dataEntry = object;
            ((DataEntry)object).increase();
            this.first = ((DataEntry)object).first(this);
        }
        if (this.first != null) {
            if (this.first == this) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    object = new Throwable("First instance created here");
                    ((Throwable)object).fillInStackTrace();
                    this.first.firstTrace = object;
                }
            } else {
                boolean bl;
                object = this.getClass().getName();
                Map map = instancesBeingCreated;
                synchronized (map) {
                    bl = instancesBeingCreated.containsKey(object);
                }
                if (!bl && !alreadyWarnedAboutDupes.contains(object)) {
                    alreadyWarnedAboutDupes.add(object);
                    IllegalStateException illegalStateException = new IllegalStateException("Warning: multiple instances of shared class " + (String)object + " created.");
                    ErrorManager errorManager = Utilities.errMan();
                    if (errorManager != null) {
                        if (this.first.firstTrace != null) {
                            errorManager.annotate((Throwable)illegalStateException, this.first.firstTrace);
                        } else {
                            errorManager.annotate((Throwable)illegalStateException, "(Run with -J-Dnetbeans.debug.exceptions=true for more details.)");
                        }
                        errorManager.notify(1, illegalStateException);
                    } else {
                        illegalStateException.printStackTrace();
                        if (this.first.firstTrace != null) {
                            this.first.firstTrace.printStackTrace();
                        } else {
                            System.err.println("(Run with -J-Dnetbeans.debug.exceptions=true for more details.)");
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void referenceLost() {
        Object object = this.getLock();
        synchronized (object) {
            if ((this.dataEntry == null || this.dataEntry.decrease() == 0) && this.clearSharedData()) {
                values.remove(this.getClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object putProperty(Object object, Object object2) {
        Object object3 = this.getLock();
        synchronized (object3) {
            block5: {
                if (!object.equals("netbeans.systemoption.hack")) break block5;
                this.systemOption = true;
                Object var4_4 = null;
                return var4_4;
            }
            if (this.waitingOnSystemOption && object != PROP_SUPPORT && this.prematureSystemOptionMutation == null && !this.dataEntry.isInInitialize() && !this.inReadExternal) {
                this.prematureSystemOptionMutation = new IllegalStateException("...setting property here...");
            }
            Object object4 = this.dataEntry.getMap(this).put(object, object2);
            return object4;
        }
    }

    protected final Object putProperty(String string, Object object, boolean bl) {
        Object object2 = this.putProperty(string, object);
        if (bl) {
            this.firePropertyChange(string, object2, object);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object getProperty(Object object) {
        Object object2 = this.getLock();
        synchronized (object2) {
            Object object3 = this.dataEntry.get(this, object);
            return object3;
        }
    }

    protected void initialize() {
        this.initializeSuper = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        boolean bl;
        Object object;
        Object object2 = this.getLock();
        synchronized (object2) {
            object = (PropertyChangeSupport)this.getProperty(PROP_SUPPORT);
            if (object == null) {
                object = new PropertyChangeSupport(this);
                this.putProperty(PROP_SUPPORT, object);
            }
            bl = !((PropertyChangeSupport)object).hasListeners(null);
            ((PropertyChangeSupport)object).addPropertyChangeListener(propertyChangeListener);
        }
        if (bl) {
            this.addNotifySuper = false;
            this.addNotify();
            if (!this.addNotifySuper) {
                object = "You must call super.addNotify() from " + this.getClass().getName() + ".addNotify()";
                ErrorManager errorManager = Utilities.errMan();
                if (errorManager != null) {
                    errorManager.log(16, (String)object);
                } else {
                    System.err.println((String)object);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        boolean bl;
        Object object;
        Object object2 = this.getLock();
        synchronized (object2) {
            object = (PropertyChangeSupport)this.getProperty(PROP_SUPPORT);
            if (object == null) {
                return;
            }
            boolean bl2 = ((PropertyChangeSupport)object).hasListeners(null);
            ((PropertyChangeSupport)object).removePropertyChangeListener(propertyChangeListener);
            bl = bl2 && !((PropertyChangeSupport)object).hasListeners(null);
        }
        if (bl) {
            this.removeNotifySuper = false;
            this.removeNotify();
            if (!this.removeNotifySuper) {
                object = "You must call super.removeNotify() from " + this.getClass().getName() + ".removeNotify()";
                ErrorManager errorManager = Utilities.errMan();
                if (errorManager != null) {
                    errorManager.log(16, (String)object);
                } else {
                    System.err.println((String)object);
                }
            }
        }
    }

    protected void addNotify() {
        this.addNotifySuper = true;
    }

    protected void removeNotify() {
        this.removeNotifySuper = true;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)this.getProperty(PROP_SUPPORT);
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    protected Object writeReplace() {
        return new WriteReplace(this);
    }

    public static SharedClassObject findObject(Class clazz) {
        return SharedClassObject.findObject(clazz, false);
    }

    public static SharedClassObject findObject(Class clazz, boolean bl) {
        Object object;
        DataEntry dataEntry = (DataEntry)values.get(clazz);
        SharedClassObject sharedClassObject = dataEntry == null ? null : dataEntry.get();
        boolean bl2 = false;
        if (sharedClassObject == null && bl) {
            object = new SetAccessibleAction(clazz);
            try {
                sharedClassObject = (SharedClassObject)AccessController.doPrivileged(object);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(exception.toString());
                ErrorManager errorManager = Utilities.errMan();
                if (errorManager != null) {
                    errorManager.copyAnnotation(illegalArgumentException, exception);
                }
                throw illegalArgumentException;
            }
            bl2 = true;
        }
        if ((dataEntry = (DataEntry)values.get(clazz)) != null) {
            object = dataEntry.get();
            if (sharedClassObject != null && sharedClassObject != object) {
                if (object == null && bl) {
                    throw new IllegalStateException("Inconsistent state: " + clazz);
                }
                return object;
            }
        }
        if (bl2) {
            sharedClassObject.reset();
            if (sharedClassObject != null && sharedClassObject.systemOption && ((Lookup.Result)(object = Lookup.getDefault().lookup(new Lookup.Template(clazz)))).allInstances().isEmpty()) {
                sharedClassObject.waitingOnSystemOption = true;
                SharedClassObject sharedClassObject2 = sharedClassObject;
                IllegalStateException illegalStateException = new IllegalStateException("Making a SystemOption here that is not in lookup...");
                class SOLoader
                implements LookupListener {
                    private final /* synthetic */ Lookup.Result val$r;
                    private final /* synthetic */ SharedClassObject val$_obj;
                    private final /* synthetic */ IllegalStateException val$start;

                    SOLoader(Lookup.Result result, SharedClassObject sharedClassObject, IllegalStateException illegalStateException) {
                        this.val$r = result;
                        this.val$_obj = sharedClassObject;
                        this.val$start = illegalStateException;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void resultChanged(LookupEvent lookupEvent) {
                        if (!this.val$r.allInstances().isEmpty()) {
                            this.val$r.removeLookupListener(this);
                            Object object = this.val$_obj.getLock();
                            synchronized (object) {
                                SharedClassObject.access$002(this.val$_obj, false);
                                if (SharedClassObject.access$100(this.val$_obj) != null) {
                                    SharedClassObject.access$200(this.val$start);
                                    SharedClassObject.access$200(SharedClassObject.access$100(this.val$_obj));
                                    SharedClassObject.access$200(new IllegalStateException("...and maybe getting clobbered here, see #17711."));
                                    SharedClassObject.access$102(this.val$_obj, null);
                                }
                            }
                        }
                    }
                }
                ((Lookup.Result)object).addLookupListener(new SOLoader((Lookup.Result)object, sharedClassObject2, illegalStateException));
            }
        }
        if (sharedClassObject == null && bl) {
            throw new IllegalStateException("Inconsistent state: " + clazz);
        }
        return sharedClassObject;
    }

    private static void warn(Throwable throwable) {
        ErrorManager errorManager = Utilities.errMan();
        if (errorManager != null) {
            errorManager.notify(1, throwable);
        } else {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object createInstancePrivileged(Class clazz) throws Exception {
        Map map;
        Integer n;
        Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        String string = clazz.getName();
        Map map2 = instancesBeingCreated;
        synchronized (map2) {
            n = (Integer)instancesBeingCreated.get(string);
            instancesBeingCreated.put(string, n == null ? new Integer(1) : new Integer(n + 1));
        }
        try {
            n = constructor.newInstance(new Object[0]);
            Object var7_6 = null;
            map = instancesBeingCreated;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Map map3 = instancesBeingCreated;
            synchronized (map3) {
                Integer n2 = (Integer)instancesBeingCreated.get(string);
                if (n2 == 1) {
                    instancesBeingCreated.remove(string);
                } else {
                    instancesBeingCreated.put(string, new Integer(n2 - 1));
                }
            }
            constructor.setAccessible(false);
            throw throwable;
        }
        synchronized (map) {
            Integer n3 = (Integer)instancesBeingCreated.get(string);
            if (n3 == 1) {
                instancesBeingCreated.remove(string);
            } else {
                instancesBeingCreated.put(string, new Integer(n3 - 1));
            }
        }
        constructor.setAccessible(false);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        if (!this.systemOption || !this.isProjectOption()) {
            return;
        }
        Object object = this.getLock();
        synchronized (object) {
            if (this.defaultInstance == null) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    NbObjectOutputStream nbObjectOutputStream = new NbObjectOutputStream(byteArrayOutputStream);
                    nbObjectOutputStream.writeObject(this);
                    this.defaultInstance = byteArrayOutputStream.toByteArray();
                }
                catch (IOException iOException) {
                    this.defaultInstance = null;
                }
                return;
            }
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.defaultInstance);
                NbObjectInputStream nbObjectInputStream = new NbObjectInputStream(byteArrayInputStream);
                nbObjectInputStream.readObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isProjectOption() {
        try {
            Class<?> clazz = this.getClass();
            if (this.hasGlobalAtrributeInBeanInfo(clazz)) {
                return !this.isGlobalFromBeanInfo(clazz);
            }
            Method method = clazz.getMethod(GLOBAL_METHOD_NAME, new Class[0]);
            method.setAccessible(true);
            Boolean bl = (Boolean)method.invoke((Object)this, new Object[0]);
            return bl == false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean hasGlobalAtrributeInBeanInfo(Class clazz) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            if (beanInfo != null) {
                Object object;
                BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
                if (beanDescriptor != null && (object = beanDescriptor.getValue(ATTR_GLOBAL)) != null) {
                    return true;
                }
                object = beanInfo.getAdditionalBeanInfo();
                if (object != null) {
                    int n = 0;
                    while (n < ((BeanInfo[])object).length) {
                        Object object2;
                        BeanDescriptor beanDescriptor2 = object[n].getBeanDescriptor();
                        if (beanDescriptor2 != null && (object2 = beanDescriptor2.getValue(ATTR_GLOBAL)) != null) {
                            return true;
                        }
                        ++n;
                    }
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return false;
    }

    private boolean isGlobalFromBeanInfo(Class clazz) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            if (beanInfo != null) {
                Object object;
                BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
                if (beanDescriptor != null && (object = beanDescriptor.getValue(ATTR_GLOBAL)) instanceof Boolean) {
                    return (Boolean)object;
                }
                object = beanInfo.getAdditionalBeanInfo();
                if (object != null) {
                    int n = 0;
                    while (n < ((BeanInfo[])object).length) {
                        Object object2;
                        BeanDescriptor beanDescriptor2 = object[n].getBeanDescriptor();
                        if (beanDescriptor2 != null && (object2 = beanDescriptor2.getValue(ATTR_GLOBAL)) instanceof Boolean) {
                            return (Boolean)object2;
                        }
                        ++n;
                    }
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            ErrorManager errorManager = Utilities.errMan();
            errorManager.notify(4096, introspectionException);
        }
        throw new IllegalArgumentException("Trying to get a value from beaninfo but the value is not there");
    }

    static /* synthetic */ boolean access$002(SharedClassObject sharedClassObject, boolean bl) {
        sharedClassObject.waitingOnSystemOption = bl;
        return sharedClassObject.waitingOnSystemOption;
    }

    static /* synthetic */ IllegalStateException access$100(SharedClassObject sharedClassObject) {
        return sharedClassObject.prematureSystemOptionMutation;
    }

    static /* synthetic */ void access$200(Throwable throwable) {
        SharedClassObject.warn(throwable);
    }

    static /* synthetic */ IllegalStateException access$102(SharedClassObject sharedClassObject, IllegalStateException illegalStateException) {
        sharedClassObject.prematureSystemOptionMutation = illegalStateException;
        return sharedClassObject.prematureSystemOptionMutation;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class SetAccessibleAction
    implements PrivilegedExceptionAction {
        Class klass;

        SetAccessibleAction(Class clazz) {
            this.klass = clazz;
        }

        public Object run() throws Exception {
            return SharedClassObject.createInstancePrivileged(this.klass);
        }
    }

    static final class DataEntry {
        private HashMap map;
        private int count = 0;
        private WeakReference ref = new WeakReference<Object>(null);
        private boolean initialized = false;
        private boolean initializeInProgress = false;
        private Throwable invalid = null;

        DataEntry() {
        }

        public String toString() {
            return "SCO.DataEntry[ref=" + this.ref.get() + ",count=" + this.count + ",initialized=" + this.initialized + ",invalid=" + this.invalid + ",map=" + this.map + "]";
        }

        boolean isInInitialize() {
            return this.initializeInProgress;
        }

        Map getMap(SharedClassObject sharedClassObject) {
            this.ensureValid(sharedClassObject);
            if (this.map == null) {
                this.map = new HashMap();
            }
            if (!this.initialized) {
                this.initialized = true;
                this.tryToInitialize(sharedClassObject);
            }
            return this.map;
        }

        Object get(SharedClassObject sharedClassObject, Object object) {
            Object v;
            this.ensureValid(sharedClassObject);
            if (this.map == null) {
                this.map = new HashMap();
                v = null;
            } else {
                v = this.map.get(object);
            }
            if (v == null && !this.initialized) {
                if (object == PROP_SUPPORT) {
                    return null;
                }
                this.initialized = true;
                this.tryToInitialize(sharedClassObject);
                v = this.map.get(object);
            }
            return v;
        }

        Map getMap() {
            this.ensureValid(this.get());
            if (this.map == null) {
                this.map = new HashMap();
            }
            return this.map;
        }

        private void ensureValid(SharedClassObject sharedClassObject) throws IllegalStateException {
            if (this.invalid != null) {
                String string = sharedClassObject != null ? sharedClassObject.toString() : "<unknown object>";
                IllegalStateException illegalStateException = new IllegalStateException(string);
                ErrorManager errorManager = Utilities.errMan();
                if (errorManager != null) {
                    errorManager.annotate((Throwable)illegalStateException, this.invalid);
                }
                throw illegalStateException;
            }
        }

        private void tryToInitialize(SharedClassObject sharedClassObject) throws IllegalStateException {
            this.initializeInProgress = true;
            sharedClassObject.initializeSuper = false;
            try {
                try {
                    sharedClassObject.initialize();
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    this.invalid = throwable;
                    IllegalStateException illegalStateException = new IllegalStateException(this.invalid.toString() + " from " + sharedClassObject);
                    ErrorManager errorManager = Utilities.errMan();
                    if (errorManager != null) {
                        errorManager.annotate((Throwable)illegalStateException, this.invalid);
                    } else {
                        this.invalid.printStackTrace();
                    }
                    throw illegalStateException;
                }
                Object var7_2 = null;
                this.initializeInProgress = false;
            }
            catch (Throwable throwable) {
                Object var7_3 = null;
                this.initializeInProgress = false;
                throw throwable;
            }
            if (!sharedClassObject.initializeSuper) {
                String string = "You must call super.initialize() from " + sharedClassObject.getClass().getName() + ".initialize()";
                ErrorManager errorManager = Utilities.errMan();
                if (errorManager != null) {
                    errorManager.log(16, string);
                } else {
                    System.err.println(string);
                }
            }
        }

        int increase() {
            return ++this.count;
        }

        int decrease() {
            return --this.count;
        }

        SharedClassObject first(SharedClassObject sharedClassObject) {
            SharedClassObject sharedClassObject2 = (SharedClassObject)this.ref.get();
            if (sharedClassObject2 == null) {
                this.ref = new WeakReference<SharedClassObject>(sharedClassObject);
                return sharedClassObject;
            }
            return sharedClassObject2;
        }

        public SharedClassObject get() {
            return (SharedClassObject)this.ref.get();
        }

        public void reset(SharedClassObject sharedClassObject) {
            SharedClassObject sharedClassObject2 = this.get();
            if (sharedClassObject2 != null && sharedClassObject2 != sharedClassObject) {
                return;
            }
            this.invalid = null;
            this.getMap().clear();
            this.initialized = true;
            this.tryToInitialize(sharedClassObject);
        }
    }

    static final class WriteReplace
    implements Serializable {
        static final long serialVersionUID = 1327893248974327640L;
        private Class clazz;
        private String name;
        private transient SharedClassObject object;

        public WriteReplace(SharedClassObject sharedClassObject) {
            this.object = sharedClassObject;
            this.clazz = sharedClassObject.getClass();
            this.name = this.clazz.getName();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            this.object.writeExternal(objectOutputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.clazz == null) {
                if (this.name != null) {
                    throw new ClassNotFoundException(this.name);
                }
                throw new ClassNotFoundException();
            }
            this.object = SharedClassObject.findObject(this.clazz, true);
            this.object.inReadExternal = true;
            try {
                this.object.readExternal(objectInputStream);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.object.inReadExternal = false;
                throw throwable;
            }
            this.object.inReadExternal = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object readResolve() throws ObjectStreamException {
            SharedClassObject sharedClassObject = this.object;
            Method method = WriteReplace.findReadResolveMethod(this.object.getClass());
            if (method != null) {
                try {
                    try {
                        method.setAccessible(true);
                        sharedClassObject = (SharedClassObject)method.invoke((Object)this.object, null);
                    }
                    catch (Exception exception) {
                        String string = "Skipping " + this.object.getClass() + " resolution:";
                        ErrorManager errorManager = Utilities.errMan();
                        if (errorManager != null) {
                            errorManager.log(1, string);
                            errorManager.notify(1, exception);
                        } else {
                            System.err.println(string);
                            exception.printStackTrace();
                        }
                        Object var7_4 = null;
                        method.setAccessible(false);
                    }
                    Object var7_3 = null;
                    method.setAccessible(false);
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    method.setAccessible(false);
                    throw throwable;
                }
            }
            return sharedClassObject;
        }

        private static Method findReadResolveMethod(Class clazz) {
            Method method = null;
            Class clazz2 = clazz;
            while (clazz2 != null) {
                try {
                    method = WriteReplace.accept(clazz2.getDeclaredMethod("readResolve", new Class[0]));
                    if (method != null) {
                        break;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                clazz2 = clazz2.getSuperclass();
            }
            return method;
        }

        private static Method accept(Method method) {
            Class<?>[] classArray;
            if (method != null && (classArray = method.getExceptionTypes()).length == 1 && (class$java$io$ObjectStreamException == null ? (class$java$io$ObjectStreamException = SharedClassObject.class$("java.io.ObjectStreamException")) : class$java$io$ObjectStreamException).equals(classArray[0]) && (class$java$lang$Object == null ? (class$java$lang$Object = SharedClassObject.class$("java.lang.Object")) : class$java$lang$Object).equals(method.getReturnType())) {
                return method;
            }
            return null;
        }
    }
}

