/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.Type;
import org.openide.util.NbBundle;

public final class ElementFormat
extends Format {
    static final long serialVersionUID = 3775521938640169753L;
    static final ResourceBundle bundle = NbBundle.getBundle(class$org$openide$src$ElementFormat == null ? (class$org$openide$src$ElementFormat = ElementFormat.class$("org.openide.src.ElementFormat")) : class$org$openide$src$ElementFormat);
    private static final String MSG_BAD_PATTERN = bundle.getString("MSG_badPattern");
    private static final String MSG_BAD_ARGUMENT = bundle.getString("MSG_badArgument");
    private static final String MSG_NO_PARSING = bundle.getString("MSG_noParsing");
    private static final String PROPERTIES_NAMES_INDEX = "mnfCtrscpaie";
    private static final String[] PROPERTIES_NAMES = new String[]{"modifiers", "name", "name", "name", "type", "return", "superclass", "static", "parameters", "parameters", "interfaces", "exceptions"};
    private static final byte STATUS_OUTSIDE = 0;
    private static final byte STATUS_INSIDE = 1;
    private static final byte STATUS_RBRACE = 2;
    private String pattern;
    private boolean source;
    private transient LinkedList list;
    static /* synthetic */ Class class$org$openide$src$ElementFormat;

    public ElementFormat(String string) {
        this.applyPattern(string);
        this.source = true;
    }

    public void setSourceFormat(boolean bl) {
        this.source = bl;
    }

    public boolean isSourceFormat() {
        return this.source;
    }

    public String getPattern() {
        return this.pattern;
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        try {
            Element element = (Element)object;
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof String) {
                    stringBuffer.append((String)e);
                    continue;
                }
                ((Tag)e).format(element, stringBuffer);
            }
            return stringBuffer;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(MSG_BAD_ARGUMENT);
        }
    }

    public String format(Element element) {
        return this.format(element, new StringBuffer(), null).toString();
    }

    public boolean dependsOnProperty(String string) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            int n;
            Object e = iterator.next();
            if (!(e instanceof Tag) || !PROPERTIES_NAMES[n = PROPERTIES_NAMES_INDEX.indexOf(((Tag)e).kind)].equals(string)) continue;
            return true;
        }
        return false;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.applyPattern(this.pattern);
    }

    private void applyPattern(String string) {
        this.pattern = string;
        this.list = new LinkedList();
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (n) {
                case 0: {
                    if (string2.equals("}")) {
                        throw new IllegalArgumentException(MSG_BAD_PATTERN);
                    }
                    if (string2.equals("{")) {
                        n = 1;
                        break;
                    }
                    this.list.add(string2);
                    break;
                }
                case 1: {
                    if (string2.equals("{") || string2.equals("}")) {
                        throw new IllegalArgumentException(MSG_BAD_PATTERN);
                    }
                    this.list.add(this.createTag(string2));
                    n = 2;
                    break;
                }
                case 2: {
                    if (!string2.equals("}")) {
                        throw new IllegalArgumentException(MSG_BAD_PATTERN);
                    }
                    n = 0;
                }
            }
        }
    }

    private Tag createTag(String string) {
        if (string.length() > 0) {
            char c = string.charAt(0);
            String[] stringArray = new String[]{};
            if (string.length() > 1) {
                if (string.length() < 2 || string.charAt(1) != ',') {
                    throw new IllegalArgumentException(MSG_BAD_PATTERN);
                }
                stringArray = this.parseParams(string.substring(2));
            }
            if ("mnfCtrsc".indexOf(c) != -1) {
                switch (stringArray.length) {
                    case 0: {
                        return new Tag(c, "", "");
                    }
                    case 2: {
                        return new Tag(c, stringArray[0], stringArray[1]);
                    }
                }
            } else if ("paie".indexOf(c) != -1) {
                switch (stringArray.length) {
                    case 0: {
                        return new ArrayTag(c, "", "", ", ");
                    }
                    case 2: {
                        return new ArrayTag(c, stringArray[0], stringArray[1], ", ");
                    }
                    case 3: {
                        return new ArrayTag(c, stringArray[0], stringArray[1], stringArray[2]);
                    }
                }
            }
        }
        throw new IllegalArgumentException(MSG_BAD_PATTERN);
    }

    private String[] parseParams(String string) {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (bl2) {
                stringBuffer.append((String)stringArray);
                if (!stringArray.endsWith("\"")) continue;
                if (stringBuffer.length() > 1) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
                arrayList.add(stringBuffer.toString());
                stringBuffer.setLength(0);
                bl2 = false;
                bl = true;
                continue;
            }
            if (stringArray.equals(",")) {
                if (bl) {
                    bl = false;
                    continue;
                }
                arrayList.add("");
                continue;
            }
            if (bl) {
                throw new IllegalArgumentException(MSG_BAD_PATTERN);
            }
            Object object = stringArray;
            if (stringArray.startsWith("\"")) {
                if (stringArray.endsWith("\"") && stringArray.length() > 1) {
                    object = stringArray.length() <= 2 ? "" : stringArray.substring(1, stringArray.length() - 1);
                } else {
                    stringBuffer.append(stringArray.substring(1));
                    bl2 = true;
                    continue;
                }
            }
            arrayList.add(object);
            bl = true;
            stringBuffer.setLength(0);
        }
        if (!bl) {
            arrayList.add("");
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static void resolveClassName(StringBuffer stringBuffer, ClassElement classElement) {
        ClassElement classElement2 = classElement.getDeclaringClass();
        if (classElement2 == null) {
            stringBuffer.append(classElement.getName().getName());
            return;
        }
        ElementFormat.resolveClassName(stringBuffer, classElement2);
        stringBuffer.append('.').append(classElement.getName().getName());
    }

    String identifierToString(Identifier identifier) {
        return this.source ? identifier.getSourceName() : identifier.getFullName();
    }

    String typeToString(Type type) {
        return this.source ? type.getSourceString() : type.getFullString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ArrayTag
    extends Tag {
        String delim;
        static final long serialVersionUID = 2060398944304753010L;

        ArrayTag(char c, String string, String string2, String string3) {
            super(c, string, string2);
            this.delim = string3;
        }

        void format(Element element, StringBuffer stringBuffer) {
            try {
                int n = stringBuffer.length();
                stringBuffer.append(this.prefix);
                switch (this.kind) {
                    case 'e': {
                        Identifier[] identifierArray = ((ConstructorElement)element).getExceptions();
                        int n2 = 0;
                        while (n2 < identifierArray.length) {
                            if (n2 > 0) {
                                stringBuffer.append(this.delim);
                            }
                            stringBuffer.append(ElementFormat.this.identifierToString(identifierArray[n2]));
                            ++n2;
                        }
                        break;
                    }
                    case 'a': 
                    case 'p': {
                        MethodParameter[] methodParameterArray = ((ConstructorElement)element).getParameters();
                        int n3 = 0;
                        while (n3 < methodParameterArray.length) {
                            if (n3 > 0) {
                                stringBuffer.append(this.delim);
                            }
                            if (this.kind == 'a') {
                                methodParameterArray[n3].getAsString(stringBuffer, ElementFormat.this.source);
                            } else {
                                methodParameterArray[n3].getType().getAsString(stringBuffer, ElementFormat.this.source);
                            }
                            ++n3;
                        }
                        break;
                    }
                    case 'i': {
                        Identifier[] identifierArray = ((ClassElement)element).getInterfaces();
                        int n4 = 0;
                        while (n4 < identifierArray.length) {
                            if (n4 > 0) {
                                stringBuffer.append(this.delim);
                            }
                            stringBuffer.append(ElementFormat.this.identifierToString(identifierArray[n4]));
                            ++n4;
                        }
                        break;
                    }
                }
                if (stringBuffer.length() > n + this.prefix.length()) {
                    stringBuffer.append(this.suffix);
                } else {
                    stringBuffer.setLength(n);
                }
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(MSG_BAD_PATTERN);
            }
        }
    }

    private class Tag
    implements Serializable {
        char kind;
        String prefix;
        String suffix;
        static final long serialVersionUID = 4946774706959011193L;

        Tag(char c, String string, String string2) {
            this.kind = c;
            this.prefix = string;
            this.suffix = string2;
        }

        void format(Element element, StringBuffer stringBuffer) {
            try {
                int n = stringBuffer.length();
                stringBuffer.append(this.prefix);
                switch (this.kind) {
                    case 'm': {
                        stringBuffer.append(Modifier.toString(((MemberElement)element).getModifiers()));
                        break;
                    }
                    case 'n': {
                        stringBuffer.append(ElementFormat.this.identifierToString(((MemberElement)element).getName()));
                        break;
                    }
                    case 'f': {
                        stringBuffer.append(((MemberElement)element).getName().getFullName());
                        break;
                    }
                    case 'C': {
                        ElementFormat.resolveClassName(stringBuffer, (ClassElement)element);
                        break;
                    }
                    case 't': {
                        stringBuffer.append(ElementFormat.this.typeToString(((FieldElement)element).getType()));
                        break;
                    }
                    case 'r': {
                        stringBuffer.append(ElementFormat.this.typeToString(((MethodElement)element).getReturn()));
                        break;
                    }
                    case 's': {
                        Identifier identifier = ((ClassElement)element).getSuperclass();
                        if (identifier == null) break;
                        stringBuffer.append(ElementFormat.this.identifierToString(identifier));
                        break;
                    }
                    case 'c': {
                        if (!((InitializerElement)element).isStatic()) break;
                        stringBuffer.append(Modifier.toString(8));
                    }
                }
                if (stringBuffer.length() > n + this.prefix.length()) {
                    stringBuffer.append(this.suffix);
                } else {
                    stringBuffer.setLength(n);
                }
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(MSG_BAD_PATTERN);
            }
        }
    }
}

