/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.TMUtil;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.datatransfer.ExTransferable;

public final class IndexedCustomizer
extends JDialog
implements Customizer {
    private JList control;
    private JButton buttonUp;
    private JButton buttonDown;
    private JButton buttonClose;
    private Index index;
    private Node[] nodes;
    private boolean immediateReorder = true;
    private int[] permutation;
    private ChangeListener nodeChangesL;
    private IndexedDragSource dragSupport;
    private IndexedDropTarget dropSupport;
    static final long serialVersionUID = -8731362267771694641L;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$nodes$IndexedCustomizer;

    public IndexedCustomizer() {
        this((Container)null, true);
    }

    IndexedCustomizer(Container container, boolean bl) {
        super(TMUtil.mainWindow(), true);
        if (bl) {
            this.setDefaultCloseOperation(2);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    IndexedCustomizer.this.setVisible(false);
                    IndexedCustomizer.this.dispose();
                }
            }, KeyStroke.getKeyStroke(27, 0, true), 2);
            this.setTitle(Node.getString("LAB_order"));
        }
        if (container == null) {
            container = this.getContentPane();
        }
        container.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(Node.getString("LAB_listOrder"));
        jLabel.setDisplayedMnemonic(Node.getString("LAB_listOrder_Mnemonic").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 2, 12);
        container.add((Component)jLabel, gridBagConstraints);
        this.control = new AutoscrollJList();
        jLabel.setLabelFor(this.control);
        this.control.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (IndexedCustomizer.this.control.isSelectionEmpty()) {
                    IndexedCustomizer.this.buttonUp.setEnabled(false);
                    IndexedCustomizer.this.buttonDown.setEnabled(false);
                } else {
                    int n = IndexedCustomizer.this.control.getSelectedIndex();
                    if (n > 0) {
                        IndexedCustomizer.this.buttonUp.setEnabled(true);
                    } else {
                        IndexedCustomizer.this.buttonUp.setEnabled(false);
                    }
                    if (n < IndexedCustomizer.this.nodes.length - 1) {
                        IndexedCustomizer.this.buttonDown.setEnabled(true);
                    } else {
                        IndexedCustomizer.this.buttonDown.setEnabled(false);
                    }
                }
            }
        });
        this.control.setCellRenderer(new IndexedListCellRenderer());
        this.control.setVisibleRowCount(15);
        this.control.setSelectionMode(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 11);
        container.add((Component)new JScrollPane(this.control), gridBagConstraints);
        JPanel jPanel = new JPanel();
        if (bl) {
            this.buttonClose = new JButton(Node.getString("Button_close"));
            this.buttonClose.setMnemonic(Node.getString("Button_close_Mnemonic").charAt(0));
        }
        this.buttonUp = new JButton(Node.getString("Button_up"));
        this.buttonUp.setMnemonic(Node.getString("Button_up_Mnemonic").charAt(0));
        this.buttonDown = new JButton(Node.getString("Button_down"));
        this.buttonDown.setMnemonic(Node.getString("Button_down_Mnemonic").charAt(0));
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        jPanel.add((Component)this.buttonUp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        jPanel.add((Component)this.buttonDown, gridBagConstraints);
        if (bl) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.buttonClose, gridBagConstraints);
        }
        this.buttonUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = IndexedCustomizer.this.control.getSelectedIndex();
                IndexedCustomizer.this.moveUp(n);
                IndexedCustomizer.this.updateList();
                IndexedCustomizer.this.control.setSelectedIndex(n - 1);
                IndexedCustomizer.this.control.ensureIndexIsVisible(n - 1);
                IndexedCustomizer.this.control.repaint();
            }
        });
        this.buttonDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = IndexedCustomizer.this.control.getSelectedIndex();
                IndexedCustomizer.this.moveDown(n);
                IndexedCustomizer.this.updateList();
                IndexedCustomizer.this.control.setSelectedIndex(n + 1);
                IndexedCustomizer.this.control.ensureIndexIsVisible(n + 1);
                IndexedCustomizer.this.control.repaint();
            }
        });
        if (bl) {
            this.buttonClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    IndexedCustomizer.this.doClose();
                    IndexedCustomizer.this.dispose();
                }
            });
        }
        this.buttonUp.setEnabled(false);
        this.buttonDown.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        container.add((Component)jPanel, gridBagConstraints);
        if (bl) {
            this.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            this.buttonClose.requestFocus();
            this.buttonClose.getAccessibleContext().setAccessibleDescription(Node.getString("ACSD_Button_close"));
        }
        this.buttonUp.getAccessibleContext().setAccessibleDescription(Node.getString("ACSD_Button_up"));
        this.buttonDown.getAccessibleContext().setAccessibleDescription(Node.getString("ACSD_Button_down"));
        this.control.getAccessibleContext().setAccessibleDescription(Node.getString("ACSD_ListOrder"));
        container.getAccessibleContext().setAccessibleDescription(Node.getString("ACSD_IndexedCustomizer"));
        this.getAccessibleContext().setAccessibleDescription(Node.getString("ACSD_IndexedCustomizer"));
    }

    void doClose() {
        if (!this.immediateReorder && this.index != null && this.permutation != null) {
            int[] nArray = new int[this.permutation.length];
            int n = 0;
            while (n < nArray.length) {
                nArray[this.permutation[n]] = n;
                ++n;
            }
            this.index.reorder(nArray);
        }
    }

    private void updateList() {
        if (this.index == null) {
            return;
        }
        Node[] nodeArray = this.index.getNodes();
        if (!this.immediateReorder) {
            this.getPermutation();
            int n = this.permutation.length;
            int n2 = nodeArray.length;
            if (n < n2) {
                this.nodes = new Node[n2];
                int[] nArray = new int[n2];
                System.arraycopy(nArray, 0, this.permutation, 0, n);
                int n3 = 0;
                while (n3 < n2) {
                    if (n3 < n) {
                        this.nodes[n3] = nodeArray[this.permutation[n3]];
                    } else {
                        this.nodes[n3] = nodeArray[n3];
                        nArray[n3] = n3;
                    }
                    ++n3;
                }
                this.permutation = nArray;
            } else if (n > n2) {
                this.nodes = new Node[n2];
                this.permutation = new int[n2];
                int n4 = 0;
                while (n4 < n2) {
                    this.nodes[n4] = nodeArray[n4];
                    this.permutation[n4] = n4;
                    ++n4;
                }
            } else {
                this.nodes = new Node[n2];
                int n5 = 0;
                while (n5 < n2) {
                    this.nodes[n5] = nodeArray[this.permutation[n5]];
                    ++n5;
                }
            }
        } else {
            this.nodes = (Node[])nodeArray.clone();
        }
        this.control.setListData(this.nodes);
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, super.getPreferredSize().height);
    }

    public boolean isImmediateReorder() {
        return this.immediateReorder;
    }

    public void setImmediateReorder(boolean bl) {
        if (this.immediateReorder == bl) {
            return;
        }
        this.immediateReorder = bl;
        if (bl && this.permutation != null) {
            this.index.reorder(this.permutation);
            this.permutation = null;
            this.updateList();
        }
    }

    public void setObject(Object object) {
        if (!(object instanceof Index)) {
            throw new IllegalArgumentException();
        }
        this.index = (Index)object;
        this.nodeChangesL = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        IndexedCustomizer.access$600(6.access$800(this.this$1));
                    }
                });
            }

            static /* synthetic */ IndexedCustomizer access$800(6 var0) {
                return var0.IndexedCustomizer.this;
            }
        };
        this.updateList();
        this.control.invalidate();
        this.validate();
        this.index.addChangeListener(WeakListener.change(this.nodeChangesL, this.index));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    private void moveUp(int n) {
        if (this.index == null) {
            return;
        }
        if (this.immediateReorder) {
            this.index.moveUp(n);
        } else {
            this.getPermutation();
            int n2 = this.permutation[n];
            this.permutation[n] = this.permutation[n - 1];
            this.permutation[n - 1] = n2;
        }
    }

    private void moveDown(int n) {
        if (this.index == null) {
            return;
        }
        if (this.immediateReorder) {
            this.index.moveDown(n);
        } else {
            this.getPermutation();
            int n2 = this.permutation[n];
            this.permutation[n] = this.permutation[n + 1];
            this.permutation[n + 1] = n2;
        }
    }

    private int[] getPermutation() {
        if (this.permutation == null) {
            if (this.nodes == null) {
                this.nodes = (Node[])this.index.getNodes().clone();
            }
            this.permutation = new int[this.nodes.length];
            int n = 0;
            while (n < this.nodes.length) {
                this.permutation[n] = n++;
            }
        }
        return this.permutation;
    }

    void performReorder(int[] nArray, int n) {
        if (this.immediateReorder) {
            this.index.reorder(nArray);
        } else {
            int[] nArray2 = new int[nArray.length];
            int n2 = 0;
            while (n2 < nArray2.length) {
                nArray2[nArray[n2]] = n2;
                ++n2;
            }
            int[] nArray3 = this.getPermutation();
            this.permutation = new int[nArray3.length];
            int n3 = 0;
            while (n3 < nArray3.length) {
                this.permutation[n3] = nArray3[nArray2[n3]];
                ++n3;
            }
        }
        this.updateList();
        this.control.setSelectedIndex(n);
        this.control.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class AutoscrollJList
    extends JList
    implements Autoscroll {
        Insets scrollInsets;
        Insets realInsets;
        JViewport viewport;
        static final long serialVersionUID = 5495776972406885734L;

        private AutoscrollJList() {
        }

        public void autoscroll(Point point) {
            JViewport jViewport = this.getViewport();
            Point point2 = jViewport.getViewPosition();
            int n = jViewport.getExtentSize().height;
            if (point.y - point2.y <= this.realInsets.top) {
                jViewport.setViewPosition(new Point(point2.x, Math.max(point2.y - this.realInsets.top, 0)));
            } else if (point2.y + n - point.y <= this.realInsets.bottom) {
                jViewport.setViewPosition(new Point(point2.x, Math.min(point2.y + this.realInsets.bottom, this.getHeight() - n)));
            }
        }

        public Insets getAutoscrollInsets() {
            if (this.scrollInsets == null) {
                int n = this.getHeight();
                this.scrollInsets = new Insets(n, 0, n, 0);
                Rectangle rectangle = this.getViewport().getViewRect();
                this.realInsets = new Insets(15, 0, 15, 0);
            }
            return this.scrollInsets;
        }

        JViewport getViewport() {
            if (this.viewport == null) {
                Container container = this;
                while (!(container instanceof JViewport) && container != null) {
                    container = container.getParent();
                }
                this.viewport = (JViewport)container;
            }
            return this.viewport;
        }
    }

    private static final class IndexedListCellRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate = TMUtil.findListCellRenderer();
        int dragIndex = -1;
        boolean up;
        static final long serialVersionUID = -5526451942677242944L;
        protected static Border hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));

        IndexedListCellRenderer() {
        }

        public void draggingEnter(int n, Point point, Point point2) {
            this.dragIndex = n;
            this.up = point.y > point2.y;
        }

        public void draggingOver(int n, Point point, Point point2) {
        }

        public void draggingExit() {
            this.dragIndex = -1;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JComponent jComponent = (JComponent)this.delegate.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (n == this.dragIndex) {
                jComponent.setBorder(hasFocusBorder);
            }
            return jComponent;
        }
    }

    private static final class IndexTransferable
    extends ExTransferable.Single {
        int index;

        IndexTransferable(DataFlavor dataFlavor, int n) {
            super(dataFlavor);
            this.index = n;
        }

        protected Object getData() throws IOException, UnsupportedFlavorException {
            return String.valueOf(this.index);
        }
    }

    private static final class IndexedDropTarget
    implements DropTargetListener {
        JList comp;
        IndexedListCellRenderer cellRenderer;
        IndexedCustomizer dialog;
        IndexedDragSource ids;
        int lastIndex = -1;

        IndexedDropTarget(IndexedCustomizer indexedCustomizer, IndexedDragSource indexedDragSource) {
            this.dialog = indexedCustomizer;
            this.comp = indexedCustomizer.control;
            this.cellRenderer = (IndexedListCellRenderer)this.comp.getCellRenderer();
            this.ids = indexedDragSource;
            DropTarget dropTarget = new DropTarget(this.comp, 2, this, true);
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (!this.checkConditions(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
            } else {
                this.lastIndex = this.comp.locationToIndex(dropTargetDragEvent.getLocation());
                this.cellRenderer.draggingEnter(this.lastIndex, this.ids.getDragGestureEvent().getDragOrigin(), dropTargetDragEvent.getLocation());
                this.comp.repaint(this.comp.getCellBounds(this.lastIndex, this.lastIndex));
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (!this.checkConditions(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
                if (this.lastIndex >= 0) {
                    this.cellRenderer.draggingExit();
                    this.comp.repaint(this.comp.getCellBounds(this.lastIndex, this.lastIndex));
                    this.lastIndex = -1;
                }
            } else {
                dropTargetDragEvent.acceptDrag(2);
                int n = this.comp.locationToIndex(dropTargetDragEvent.getLocation());
                if (this.lastIndex == n) {
                    this.cellRenderer.draggingOver(n, this.ids.getDragGestureEvent().getDragOrigin(), dropTargetDragEvent.getLocation());
                } else {
                    if (this.lastIndex < 0) {
                        this.lastIndex = n;
                    }
                    this.cellRenderer.draggingExit();
                    this.cellRenderer.draggingEnter(n, this.ids.getDragGestureEvent().getDragOrigin(), dropTargetDragEvent.getLocation());
                    this.comp.repaint(this.comp.getCellBounds(this.lastIndex, n));
                    this.lastIndex = n;
                }
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (this.lastIndex >= 0) {
                this.cellRenderer.draggingExit();
                this.comp.repaint(this.comp.getCellBounds(this.lastIndex, this.lastIndex));
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            int n;
            if (2 != dropTargetDropEvent.getDropAction() || !dropTargetDropEvent.isLocalTransfer()) {
                dropTargetDropEvent.rejectDrop();
            }
            if ((n = this.comp.locationToIndex(dropTargetDropEvent.getLocation())) < 0) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            Transferable transferable = dropTargetDropEvent.getTransferable();
            dropTargetDropEvent.acceptDrop(2);
            try {
                int n2 = Integer.parseInt((String)transferable.getTransferData(this.ids.myFlavor));
                if (n2 != n) {
                    this.performReorder(n2, n);
                    dropTargetDropEvent.dropComplete(true);
                } else {
                    dropTargetDropEvent.dropComplete(false);
                }
            }
            catch (IOException iOException) {
                dropTargetDropEvent.dropComplete(false);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                dropTargetDropEvent.dropComplete(false);
            }
            catch (NumberFormatException numberFormatException) {
                dropTargetDropEvent.dropComplete(false);
            }
        }

        void performReorder(int n, int n2) {
            int[] nArray = new int[this.comp.getModel().getSize()];
            int n3 = 0;
            while (n3 < Math.min(n, n2)) {
                nArray[n3] = n3;
                ++n3;
            }
            int n4 = Math.max(n, n2) + 1;
            while (n4 < nArray.length) {
                nArray[n4] = n4;
                ++n4;
            }
            nArray[n] = n2;
            if (n > n2) {
                int n5 = n2;
                while (n5 < n) {
                    nArray[n5] = n5 + 1;
                    ++n5;
                }
            } else {
                int n6 = n + 1;
                while (n6 < n2 + 1) {
                    nArray[n6] = n6 - 1;
                    ++n6;
                }
            }
            this.dialog.performReorder(nArray, n2);
        }

        boolean checkConditions(DropTargetDragEvent dropTargetDragEvent) {
            int n = this.comp.locationToIndex(dropTargetDragEvent.getLocation());
            return 2 == dropTargetDragEvent.getDropAction() && n >= 0;
        }
    }

    private static final class IndexedDragSource
    implements DragGestureListener,
    DragSourceListener {
        JList comp;
        DragGestureEvent dge;
        DataFlavor myFlavor;

        IndexedDragSource(JList jList) {
            this.comp = jList;
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(jList, 2, this);
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            block4: {
                if ((dragGestureEvent.getDragAction() & 2) == 0) {
                    return;
                }
                int n = this.comp.locationToIndex(dragGestureEvent.getDragOrigin());
                if (n < 0) {
                    return;
                }
                this.myFlavor = new DataFlavor(class$java$lang$String == null ? (class$java$lang$String = IndexedCustomizer.class$("java.lang.String")) : class$java$lang$String, NbBundle.getBundle(class$org$openide$nodes$IndexedCustomizer == null ? (class$org$openide$nodes$IndexedCustomizer = IndexedCustomizer.class$("org.openide.nodes.IndexedCustomizer")) : class$org$openide$nodes$IndexedCustomizer).getString("IndexedFlavor"));
                try {
                    dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, new IndexTransferable(this.myFlavor, n), this);
                    this.dge = dragGestureEvent;
                }
                catch (InvalidDnDOperationException invalidDnDOperationException) {
                    if (System.getProperty("netbeans.debug.exceptions") == null) break block4;
                    invalidDnDOperationException.printStackTrace();
                }
            }
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        DragGestureEvent getDragGestureEvent() {
            return this.dge;
        }
    }
}

