/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.DefaultHandle;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class AbstractNode
extends Node {
    private static final MessageFormat[] icons = new MessageFormat[]{new MessageFormat("{0}.gif"), new MessageFormat("{0}32.gif"), new MessageFormat("{0}.gif"), new MessageFormat("{0}32.gif"), new MessageFormat("{0}Open.gif"), new MessageFormat("{0}Open32.gif"), new MessageFormat("{0}Open.gif"), new MessageFormat("{0}Open32.gif")};
    private static final int ICON_BASE = -1;
    private static final int OPENED_ICON_BASE = 3;
    private static final PasteType[] NO_PASTE_TYPES = new PasteType[0];
    private static final NewType[] NO_NEW_TYPES = new NewType[0];
    private static final Node.PropertySet[] NO_PROPERTY_SETS = new Node.PropertySet[0];
    protected MessageFormat displayFormat;
    private static final String DEFAULT_ICON_BASE = "/org/openide/resources/defaultNode";
    private static final String DEFAULT_ICON = "/org/openide/resources/defaultNode.gif";
    private Object[] iconBase = new Object[]{"/org/openide/resources/defaultNode"};
    private CookieSet cookieSet;
    private Sheet sheet;
    protected SystemAction[] systemActions;
    private SystemAction defaultAction;
    private SheetAndCookieListener sheetCookieL = null;

    public AbstractNode(Children children) {
        super(children);
        super.setName("");
    }

    public Node cloneNode() {
        try {
            if (this instanceof Cloneable) {
                return (Node)this.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return new FilterNode(this);
    }

    public void setName(String string) {
        super.setName(string);
        MessageFormat messageFormat = this.displayFormat;
        if (messageFormat != null) {
            this.setDisplayName(messageFormat.format(new Object[]{string}));
        } else {
            this.fireDisplayNameChange(null, null);
        }
    }

    public void setIconBase(String string) {
        this.iconBase = new Object[]{string};
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    public Image getIcon(int n) {
        return this.findIcon(n, -1);
    }

    public Image getOpenedIcon(int n) {
        return this.findIcon(n, 3);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private Image findIcon(int n, int n2) {
        String string = icons[n + n2].format(this.iconBase);
        Image image = Utilities.loadImage(string);
        if (image != null) {
            return image;
        }
        string = icons[1 + n2].format(this.iconBase);
        image = Utilities.loadImage(string);
        if (image != null) {
            return image;
        }
        if (n2 == 3) {
            return this.findIcon(n, -1);
        }
        return this.getDefaultIcon();
    }

    Image getDefaultIcon() {
        return Utilities.loadImage(DEFAULT_ICON);
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    protected final synchronized void setSheet(Sheet sheet) {
        if (this.sheetCookieL == null) {
            this.sheetCookieL = new SheetAndCookieListener();
        }
        if (this.sheet != null) {
            this.sheet.removePropertyChangeListener(this.sheetCookieL);
        }
        sheet.addPropertyChangeListener(this.sheetCookieL);
        this.sheet = sheet;
        this.firePropertySetsChange(null, null);
    }

    protected Sheet createSheet() {
        return new Sheet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Sheet getSheet() {
        Sheet sheet = this.sheet;
        if (sheet != null) {
            return sheet;
        }
        AbstractNode abstractNode = this;
        synchronized (abstractNode) {
            block5: {
                if (this.sheet == null) break block5;
                Sheet sheet2 = this.sheet;
                return sheet2;
            }
            this.setSheet(this.createSheet());
            Sheet sheet3 = this.sheet;
            return sheet3;
        }
    }

    public Node.PropertySet[] getPropertySets() {
        Sheet sheet = this.getSheet();
        if (sheet == null) {
            return NO_PROPERTY_SETS;
        }
        return sheet.toArray();
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable(this, 1);
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable(this, 4);
    }

    public Transferable drag() throws IOException {
        return this.clipboardCopy();
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    protected void createPasteTypes(Transferable transferable, List list) {
        NodeTransfer.Paste paste = NodeTransfer.findPaste(transferable);
        if (paste != null) {
            list.addAll(Arrays.asList(paste.types(this)));
        }
    }

    public final PasteType[] getPasteTypes(Transferable transferable) {
        LinkedList linkedList = new LinkedList();
        this.createPasteTypes(transferable, linkedList);
        return linkedList.toArray(NO_PASTE_TYPES);
    }

    public PasteType getDropType(Transferable transferable, int n, int n2) {
        LinkedList linkedList = new LinkedList();
        this.createPasteTypes(transferable, linkedList);
        return linkedList.isEmpty() ? null : (PasteType)linkedList.get(0);
    }

    public NewType[] getNewTypes() {
        return NO_NEW_TYPES;
    }

    public SystemAction getDefaultAction() {
        return this.defaultAction;
    }

    public void setDefaultAction(SystemAction systemAction) {
        this.defaultAction = systemAction;
    }

    public SystemAction[] getActions() {
        if (this.systemActions == null) {
            this.systemActions = this.createActions();
            if (this.systemActions == null) {
                this.systemActions = super.getActions();
            }
        }
        return this.systemActions;
    }

    protected SystemAction[] createActions() {
        return null;
    }

    public boolean hasCustomizer() {
        return false;
    }

    public Component getCustomizer() {
        return null;
    }

    protected final synchronized void setCookieSet(CookieSet cookieSet) {
        if (this.sheetCookieL == null) {
            this.sheetCookieL = new SheetAndCookieListener();
        }
        if (this.cookieSet != null) {
            this.cookieSet.removeChangeListener(this.sheetCookieL);
        }
        cookieSet.addChangeListener(this.sheetCookieL);
        this.cookieSet = cookieSet;
        this.fireCookieChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CookieSet getCookieSet() {
        CookieSet cookieSet = this.cookieSet;
        if (cookieSet != null) {
            return cookieSet;
        }
        AbstractNode abstractNode = this;
        synchronized (abstractNode) {
            block5: {
                if (this.cookieSet == null) break block5;
                CookieSet cookieSet2 = this.cookieSet;
                return cookieSet2;
            }
            this.setCookieSet(new CookieSet());
            CookieSet cookieSet3 = this.cookieSet;
            return cookieSet3;
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        CookieSet cookieSet = this.cookieSet;
        if (cookieSet == null) {
            return null;
        }
        return cookieSet.getCookie(clazz);
    }

    public Node.Handle getHandle() {
        return DefaultHandle.createHandle(this);
    }

    private final class SheetAndCookieListener
    implements PropertyChangeListener,
    ChangeListener {
        SheetAndCookieListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractNode.this.firePropertySetsChange(null, null);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            AbstractNode.this.fireCookieChange();
        }
    }
}

