/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.xml.EntityCatalog;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class XMLDataObjectImpl {
    private static EntityCatalog runtimeCatalogInstance = null;

    XMLDataObjectImpl() {
    }

    static DocumentBuilder makeBuilder(boolean bl) throws IOException, SAXException {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            documentBuilderFactory.setNamespaceAware(false);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            XMLDataObjectImpl.notifyFactoryErr(factoryConfigurationError, "javax.xml.parsers.DocumentBuilderFactory");
            throw factoryConfigurationError;
        }
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            SAXException sAXException = new SAXException("Configuration exception.");
            ErrorManager errorManager = TopManager.getDefault().getErrorManager();
            errorManager.annotate((Throwable)sAXException, parserConfigurationException);
            errorManager.annotate((Throwable)sAXException, "Can not create a DOM builder!\nCheck javax.xml.parsers.DocumentBuilderFactory property and the builder library presence on classpath.");
            throw sAXException;
        }
        return documentBuilder;
    }

    private static SAXParserFactory makeParserFactory(boolean bl, boolean bl2) {
        SAXParserFactory sAXParserFactory = null;
        try {
            sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(bl);
            sAXParserFactory.setNamespaceAware(bl2);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            XMLDataObjectImpl.notifyFactoryErr(factoryConfigurationError, "javax.xml.parsers.SAXParserFactory");
            throw factoryConfigurationError;
        }
        return sAXParserFactory;
    }

    static Parser makeParser(boolean bl) {
        SAXParserFactory sAXParserFactory = XMLDataObjectImpl.makeParserFactory(bl, false);
        try {
            return sAXParserFactory.newSAXParser().getParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            XMLDataObjectImpl.notifyNewSAXParserEx(parserConfigurationException);
            return null;
        }
        catch (SAXException sAXException) {
            XMLDataObjectImpl.notifyNewSAXParserEx(sAXException);
            return null;
        }
    }

    static XMLReader makeXMLReader(boolean bl, boolean bl2) {
        SAXParserFactory sAXParserFactory = XMLDataObjectImpl.makeParserFactory(bl, bl2);
        try {
            return sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            XMLDataObjectImpl.notifyNewSAXParserEx(parserConfigurationException);
            return null;
        }
        catch (SAXException sAXException) {
            XMLDataObjectImpl.notifyNewSAXParserEx(sAXException);
            return null;
        }
    }

    private static void notifyNewSAXParserEx(Exception exception) {
        ErrorManager errorManager = TopManager.getDefault().getErrorManager();
        errorManager.annotate((Throwable)exception, "Can not create a SAX parser!\nCheck javax.xml.parsers.SAXParserFactory property features and the parser library presence on classpath.");
        errorManager.notify(exception);
    }

    private static void notifyFactoryErr(Error error, String string) {
        ErrorManager errorManager = TopManager.getDefault().getErrorManager();
        errorManager.annotate((Throwable)error, "Can not create a factory!\nCheck " + string + "  property and the factory library presence on classpath.");
        errorManager.notify(error);
    }

    private static void notifyException(Throwable throwable) {
        ErrorManager errorManager = TopManager.getDefault().getErrorManager();
        errorManager.notify(1, throwable);
    }

    static synchronized EntityCatalog createEntityCatalog() {
        if (runtimeCatalogInstance == null) {
            runtimeCatalogInstance = new RuntimeCatalog();
        }
        return runtimeCatalogInstance;
    }

    static synchronized void registerCatalogEntry(String string, String string2) {
        ((RuntimeCatalog)XMLDataObjectImpl.createEntityCatalog()).registerCatalogEntry(string, string2);
    }

    static final class RuntimeCatalog
    extends EntityCatalog {
        private Hashtable id2uri;
        private Hashtable id2resource;
        private Hashtable id2loader;

        RuntimeCatalog() {
        }

        public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
            String string3 = this.name2uri(string);
            InputStream inputStream = this.mapResource(string);
            if (string3 != null) {
                InputSource inputSource = new InputSource(string3);
                inputSource.setPublicId(string);
                return inputSource;
            }
            if (inputStream != null) {
                string2 = "java:resource:" + (String)this.id2resource.get(string);
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setPublicId(string);
                return inputSource;
            }
            return null;
        }

        public void registerCatalogEntry(String string, String string2) {
            if (this.id2uri == null) {
                this.id2uri = new Hashtable(17);
            }
            this.id2uri.put(string, string2);
        }

        public void registerCatalogEntry(String string, String string2, ClassLoader classLoader) {
            if (this.id2resource == null) {
                this.id2resource = new Hashtable(17);
            }
            this.id2resource.put(string, string2);
            if (classLoader != null) {
                if (this.id2loader == null) {
                    this.id2loader = new Hashtable(17);
                }
                this.id2loader.put(string, classLoader);
            }
        }

        private String name2uri(String string) {
            if (string == null || this.id2uri == null) {
                return null;
            }
            return (String)this.id2uri.get(string);
        }

        private InputStream mapResource(String string) {
            if (string == null || this.id2resource == null) {
                return null;
            }
            String string2 = (String)this.id2resource.get(string);
            ClassLoader classLoader = null;
            if (string2 == null) {
                return null;
            }
            if (this.id2loader != null) {
                classLoader = (ClassLoader)this.id2loader.get(string);
            }
            if (classLoader == null) {
                return ClassLoader.getSystemResourceAsStream(string2);
            }
            return classLoader.getResourceAsStream(string2);
        }
    }
}

