/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.ClassNamePanel;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard1;
import org.openide.loaders.TemplateWizard2;
import org.openide.loaders.TemplateWizardIterImpl;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class TemplateWizard
extends WizardDescriptor {
    private static final String EA_DESCRIPTION = "templateWizardURL";
    private static final String EA_ITERATOR = "templateWizardIterator";
    private static final String EA_DESC_RESOURCE = "templateWizardDescResource";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    static Dimension PREF_DIM = new Dimension(560, 350);
    private WizardDescriptor.Panel templateChooser;
    private WizardDescriptor.Panel targetChooser;
    private boolean showTargetChooser = true;
    private Iterator targetIterator;
    private TemplateWizardIterImpl iterator;
    private DataObject template;
    private DataFolder templatesFolder;
    private String className = null;
    private String packageName = NbBundle.getBundle(class$org$openide$loaders$TemplateWizard == null ? (class$org$openide$loaders$TemplateWizard = TemplateWizard.class$("org.openide.loaders.TemplateWizard")) : class$org$openide$loaders$TemplateWizard).getString("LAB_TemplatePackageName");
    private Reference system = new WeakReference<Object>(null);
    private boolean titleFormatSet = false;
    private PropertyChangeListener pcl;
    private Component lastComp;
    static /* synthetic */ Class class$org$openide$loaders$TemplateWizard;

    public TemplateWizard() {
        this(new TemplateWizardIterImpl());
    }

    private TemplateWizard(TemplateWizardIterImpl templateWizardIterImpl) {
        super(templateWizardIterImpl);
        this.iterator = templateWizardIterImpl;
        this.iterator.initialize(this);
        this.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        this.setTitle(NbBundle.getBundle(class$org$openide$loaders$TemplateWizard == null ? (class$org$openide$loaders$TemplateWizard = TemplateWizard.class$("org.openide.loaders.TemplateWizard")) : class$org$openide$loaders$TemplateWizard).getString("CTL_TemplateTitle"));
        this.setTitleFormat(new MessageFormat("{0}"));
    }

    protected TemplateWizard(Iterator iterator) {
        super(iterator);
    }

    protected void initialize() {
        if (this.iterator != null) {
            this.iterator.initialize(this);
        }
        super.initialize();
    }

    final String getClassName() {
        return this.className;
    }

    final void setClassName(String string) {
        this.className = string;
    }

    final String getPackageName() {
        return this.packageName;
    }

    final FileSystem getSystem() {
        FileSystem fileSystem = (FileSystem)this.system.get();
        if (fileSystem == null) {
            Enumeration enumeration = TopManager.getDefault().getRepository().fileSystems();
            while (enumeration.hasMoreElements()) {
                fileSystem = (FileSystem)enumeration.nextElement();
                if (fileSystem.isHidden()) continue;
                this.system = new WeakReference<FileSystem>(fileSystem);
                return fileSystem;
            }
            fileSystem = TopManager.getDefault().getRepository().getDefaultFileSystem();
            this.system = new WeakReference<FileSystem>(fileSystem);
        }
        return fileSystem;
    }

    final void setNameSystem(String string, FileSystem fileSystem) {
        this.packageName = string;
        this.system = new WeakReference<FileSystem>(fileSystem);
    }

    final void setTemplateImpl(DataObject dataObject, boolean bl) {
        DataObject dataObject2 = this.template;
        if (this.template != dataObject) {
            this.template = dataObject;
        }
        this.setTitle(MessageFormat.format(NbBundle.getBundle(class$org$openide$loaders$TemplateWizard == null ? (class$org$openide$loaders$TemplateWizard = TemplateWizard.class$("org.openide.loaders.TemplateWizard")) : class$org$openide$loaders$TemplateWizard).getString("CTL_TemplateTitle2"), dataObject.getNodeDelegate().getDisplayName()));
        if (dataObject2 != this.template) {
            Iterator iterator;
            if (dataObject == null || (iterator = TemplateWizard.getIterator(dataObject)) == null) {
                iterator = this.defaultIterator();
            }
            this.iterator.setIterator(iterator, bl);
        }
    }

    public DataObject getTemplate() {
        return this.template;
    }

    public void setTemplate(DataObject dataObject) {
        if (dataObject != null) {
            this.setTemplateImpl(dataObject, true);
        }
    }

    public void setTemplatesFolder(DataFolder dataFolder) {
        this.templatesFolder = dataFolder;
    }

    public DataFolder getTemplatesFolder() {
        DataFolder dataFolder = this.templatesFolder;
        return dataFolder == null ? TopManager.getDefault().getPlaces().folders().templates() : dataFolder;
    }

    public DataFolder getTargetFolder() throws IOException {
        if (this.packageName.length() > 0) {
            return DataFolder.findFolder(TemplateWizard.convertPackageName(this.getSystem().getRoot(), this.packageName, 0));
        }
        return DataFolder.findFolder(this.getSystem().getRoot());
    }

    private static FileObject convertPackageName(FileObject fileObject, String string, int n) throws IOException {
        if (n >= string.length()) {
            return null;
        }
        int n2 = string.indexOf(46, n);
        if (n2 == -1) {
            n2 = string.length();
        }
        while (n2 != -1) {
            FileObject fileObject2 = fileObject.getFileObject(string.substring(n, n2));
            if (fileObject2 != null) {
                if (n2 == string.length()) {
                    return fileObject2;
                }
                return TemplateWizard.convertPackageName(fileObject2, string, n2 + 1);
            }
            if (n2 != string.length()) {
                if ((n2 = string.indexOf(46, n2 + 1)) != -1) continue;
                n2 = string.length();
                continue;
            }
            n2 = -1;
        }
        return DataFolder.create(DataFolder.findFolder(fileObject), string.substring(n).replace('.', '/')).getPrimaryFile();
    }

    public void setTargetFolder(DataFolder dataFolder) {
        try {
            FileSystem fileSystem = dataFolder.getPrimaryFile().getFileSystem();
            String string = dataFolder.getPrimaryFile().getPackageNameExt('.', '.');
            this.setNameSystem(string, fileSystem);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    public String getTargetName() {
        return this.className;
    }

    public void setTargetName(String string) {
        this.className = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardDescriptor.Panel templateChooser() {
        if (this.templateChooser == null) {
            TemplateWizard templateWizard = this;
            synchronized (templateWizard) {
                if (this.templateChooser == null) {
                    this.templateChooser = this.createTemplateChooser();
                }
            }
        }
        return this.templateChooser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardDescriptor.Panel targetChooser() {
        if (this.targetChooser == null) {
            TemplateWizard templateWizard = this;
            synchronized (templateWizard) {
                if (this.targetChooser == null) {
                    this.targetChooser = this.createTargetChooser();
                }
            }
        }
        return this.targetChooser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Iterator defaultIterator() {
        if (this.targetIterator == null) {
            TemplateWizard templateWizard = this;
            synchronized (templateWizard) {
                if (this.targetIterator == null) {
                    this.targetIterator = this.createDefaultIterator();
                }
            }
        }
        return this.targetIterator;
    }

    protected WizardDescriptor.Panel createTemplateChooser() {
        return new TemplateWizard1();
    }

    protected WizardDescriptor.Panel createTargetChooser() {
        return this.showTargetChooser ? new TemplateWizard2() : new ClassNamePanel();
    }

    protected Iterator createDefaultIterator() {
        return new DefaultIterator();
    }

    public Set instantiate() throws IOException {
        this.showTargetChooser = true;
        return this.instantiateImpl(null, null);
    }

    public Set instantiate(DataObject dataObject) throws IOException {
        this.showTargetChooser = true;
        return this.instantiateImpl(dataObject, null);
    }

    public Set instantiate(DataObject dataObject, DataFolder dataFolder) throws IOException {
        this.showTargetChooser = false;
        return this.instantiateImpl(dataObject, dataFolder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set instantiateImpl(DataObject dataObject, DataFolder dataFolder) throws IOException {
        Set set;
        block13: {
            this.showTargetChooser |= dataFolder == null;
            this.targetChooser = null;
            IllegalStateException illegalStateException = null;
            try {
                Set set2;
                while (true) {
                    if (dataFolder != null) {
                        this.setTargetFolder(dataFolder);
                    }
                    if (dataObject != null) {
                        this.template = null;
                        this.setTemplate(dataObject);
                        if (this.iterator != null) {
                            this.iterator.initialize(this);
                        }
                    } else if (this.iterator != null) {
                        this.iterator.initialize(this);
                        this.iterator.first();
                    }
                    try {
                        Object object;
                        this.updateState();
                        Dialog dialog = TopManager.getDefault().createDialog(this);
                        if (illegalStateException != null) {
                            object = illegalStateException;
                            illegalStateException = null;
                            dialog.addComponentListener(new ComponentAdapter((Throwable)object, dialog){
                                private final /* synthetic */ Throwable val$t;
                                private final /* synthetic */ Dialog val$d;
                                {
                                    this.val$t = throwable;
                                    this.val$d = dialog;
                                }

                                public void componentShown(ComponentEvent componentEvent) {
                                    if (this.val$t.getMessage() != null) {
                                        TopManager.getDefault().getErrorManager().notify(256, this.val$t);
                                    } else {
                                        TopManager.getDefault().getErrorManager().notify(this.val$t);
                                    }
                                    this.val$d.removeComponentListener(this);
                                }
                            });
                        }
                        dialog.show();
                        dialog.dispose();
                        if (this.lastComp != null) {
                            this.lastComp.removePropertyChangeListener(this.propL());
                            this.lastComp = null;
                        }
                        if ((object = this.getValue()) == WizardDescriptor.FINISH_OPTION || object == NotifyDescriptor.YES_OPTION || object == NotifyDescriptor.OK_OPTION) {
                            set2 = this.handleInstantiate();
                            Object var8_9 = null;
                            if (this.iterator == null) return set2;
                            break;
                        }
                        set = null;
                        break block13;
                    }
                    catch (IllegalStateException illegalStateException2) {
                        illegalStateException = illegalStateException2;
                        continue;
                    }
                    break;
                }
                this.iterator.uninitialize();
                return set2;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (this.iterator == null) throw throwable;
                this.iterator.uninitialize();
                throw throwable;
            }
        }
        Object var8_10 = null;
        if (this.iterator == null) return set;
        this.iterator.uninitialize();
        return set;
    }

    public void setTitleFormat(MessageFormat messageFormat) {
        this.titleFormatSet = true;
        super.setTitleFormat(messageFormat);
    }

    public MessageFormat getTitleFormat() {
        if (!this.titleFormatSet) {
            this.setTitleFormat(new MessageFormat(NbBundle.getBundle(class$org$openide$loaders$TemplateWizard == null ? (class$org$openide$loaders$TemplateWizard = TemplateWizard.class$("org.openide.loaders.TemplateWizard")) : class$org$openide$loaders$TemplateWizard).getString("CTL_TemplateTitle")));
        }
        return super.getTitleFormat();
    }

    protected Set handleInstantiate() throws IOException {
        return this.iterator.getIterator().instantiate(this);
    }

    public static void setDescription(DataObject dataObject, URL uRL) throws IOException {
        dataObject.getPrimaryFile().setAttribute(EA_DESCRIPTION, uRL);
    }

    public static URL getDescription(DataObject dataObject) {
        URL uRL = (URL)dataObject.getPrimaryFile().getAttribute(EA_DESCRIPTION);
        if (uRL != null) {
            return uRL;
        }
        String string = (String)dataObject.getPrimaryFile().getAttribute(EA_DESC_RESOURCE);
        if (string != null) {
            try {
                URL uRL2 = new URL("nbresloc:/" + string);
                try {
                    TemplateWizard.setDescription(dataObject, uRL2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                TopManager.getDefault().notifyException(malformedURLException);
            }
        }
        return null;
    }

    public static void setDescriptionAsResource(DataObject dataObject, String string) throws IOException {
        if (string != null && string.startsWith("/")) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                System.err.println("Warning: auto-stripping leading slash from resource path in TemplateWizard.setDescriptionAsResource");
            }
            string = string.substring(1);
        }
        dataObject.getPrimaryFile().setAttribute(EA_DESC_RESOURCE, string);
    }

    public static String getDescriptionAsResource(DataObject dataObject) {
        return (String)dataObject.getPrimaryFile().getAttribute(EA_DESC_RESOURCE);
    }

    public static void setIterator(DataObject dataObject, Iterator iterator) throws IOException {
        dataObject.getPrimaryFile().setAttribute(EA_ITERATOR, iterator);
    }

    public static Iterator getIterator(DataObject dataObject) {
        return (Iterator)dataObject.getPrimaryFile().getAttribute(EA_ITERATOR);
    }

    protected void updateState() {
        super.updateState();
        if (this.lastComp != null) {
            this.lastComp.removePropertyChangeListener(this.propL());
        }
        this.lastComp = this.iterator.current().getComponent();
        this.lastComp.addPropertyChangeListener(this.propL());
        this.putProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(this.getContentSelectedIndex()));
        if (this.getContentData() != null) {
            this.putProperty(PROP_CONTENT_DATA, this.getContentData());
        }
    }

    private String[] getContentData() {
        Object object;
        Component component = this.templateChooser().getComponent();
        if (this.iterator.current() == this.templateChooser()) {
            return (String[])((JComponent)component).getClientProperty(PROP_CONTENT_DATA);
        }
        String[] stringArray = null;
        Component component2 = this.iterator.current().getComponent();
        if (component2 instanceof JComponent && (object = ((JComponent)component2).getClientProperty(PROP_CONTENT_DATA)) instanceof String[]) {
            String[] stringArray2 = (String[])object;
            stringArray = new String[stringArray2.length + 1];
            stringArray[0] = ((String[])((JComponent)component).getClientProperty(PROP_CONTENT_DATA))[0];
            System.arraycopy(stringArray2, 0, stringArray, 1, stringArray2.length);
        }
        return stringArray;
    }

    private int getContentSelectedIndex() {
        Object object;
        if (this.iterator.current() == this.templateChooser()) {
            return 0;
        }
        int n = 1;
        Component component = this.iterator.current().getComponent();
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty(PROP_CONTENT_SELECTED_INDEX)) instanceof Integer) {
            n += ((Integer)object).intValue();
        }
        return n;
    }

    private PropertyChangeListener propL() {
        if (this.pcl == null) {
            this.pcl = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (TemplateWizard.PROP_CONTENT_SELECTED_INDEX.equals(propertyChangeEvent.getPropertyName())) {
                        TemplateWizard.this.putProperty(TemplateWizard.PROP_CONTENT_SELECTED_INDEX, new Integer(TemplateWizard.this.getContentSelectedIndex()));
                    } else if (TemplateWizard.PROP_CONTENT_DATA.equals(propertyChangeEvent.getPropertyName()) && TemplateWizard.this.getContentData() != null) {
                        TemplateWizard.this.putProperty(TemplateWizard.PROP_CONTENT_DATA, TemplateWizard.this.getContentData());
                    }
                }
            };
        }
        return this.pcl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class DefaultIterator
    implements Iterator {
        private DefaultIterator() {
        }

        public String name() {
            return "";
        }

        public Set instantiate(TemplateWizard templateWizard) throws IOException {
            String string = templateWizard.getTargetName();
            DataFolder dataFolder = templateWizard.getTargetFolder();
            DataObject dataObject = templateWizard.getTemplate();
            DataObject dataObject2 = string == null ? dataObject.createFromTemplate(dataFolder) : dataObject.createFromTemplate(dataFolder, string);
            Node node = dataObject2.getNodeDelegate();
            SystemAction systemAction = node.getDefaultAction();
            if (systemAction != null) {
                TopManager.getDefault().getActionManager().invokeAction(systemAction, new ActionEvent(node, 1001, ""));
            }
            return Collections.singleton(dataObject2);
        }

        public void initialize(TemplateWizard templateWizard) {
        }

        public void uninitialize(TemplateWizard templateWizard) {
        }

        public WizardDescriptor.Panel current() {
            return TemplateWizard.this.targetChooser();
        }

        public boolean hasNext() {
            return false;
        }

        public boolean hasPrevious() {
            return false;
        }

        public void nextPanel() {
            throw new NoSuchElementException();
        }

        public void previousPanel() {
            throw new NoSuchElementException();
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    public static interface Iterator
    extends WizardDescriptor.Iterator,
    Serializable {
        public Set instantiate(TemplateWizard var1) throws IOException;

        public void initialize(TemplateWizard var1);

        public void uninitialize(TemplateWizard var1);
    }
}

