/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.TopManager;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.UserCancelException;

public class MultiDataObject
extends DataObject {
    static final long serialVersionUID = -7750146802134210308L;
    private static final Object cookieSetLock = new Object();
    private Entry primary;
    private HashMap secondary = new HashMap(11);
    private CookieSet cookieSet;
    boolean checked = false;
    private static EmptyRecognizer RECOGNIZER = new EmptyRecognizer();

    public MultiDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.primary = this.createPrimaryEntry(this, this.getPrimaryFile());
    }

    MultiDataObject(FileObject fileObject, DataLoader dataLoader) throws DataObjectExistsException {
        super(fileObject, dataLoader);
        this.primary = this.createPrimaryEntry(this, this.getPrimaryFile());
    }

    public final MultiFileLoader getMultiFileLoader() {
        DataLoader dataLoader = this.getLoader();
        if (!(dataLoader instanceof MultiFileLoader)) {
            return null;
        }
        return (MultiFileLoader)dataLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set files() {
        HashSet hashSet;
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            this.removeAllInvalid();
            hashSet = new HashSet(this.secondary.keySet());
            hashSet.add(this.getPrimaryFile());
        }
        return hashSet;
    }

    public boolean isDeleteAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean existReadOnlySecondary() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            Iterator iterator = this.secondary.keySet().iterator();
            while (iterator.hasNext()) {
                if (!((FileObject)iterator.next()).isReadOnly()) continue;
                return true;
            }
            return false;
        }
    }

    private HashMap getSecondary() {
        if (!this.checked) {
            this.checkFiles(this);
            this.checked = true;
        }
        return this.secondary;
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    public boolean isRenameAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    Object synchObjectSecondary() {
        return this.getSecondary();
    }

    protected Node createNodeDelegate() {
        DataNode dataNode = (DataNode)super.createNodeDelegate();
        return dataNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addSecondaryEntry(Entry entry) {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            this.secondary.put(entry.getFile(), entry);
        }
        this.firePropertyChangeLater("files", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeSecondaryEntry(Entry entry) {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            this.secondary.remove(entry.getFile());
        }
        this.firePropertyChangeLater("files", null, null);
        if (entry.isImportant()) {
            this.checkConsistency(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void markSecondaryEntriesRecognized(DataLoader.RecognizedFiles recognizedFiles) {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            Iterator iterator = this.secondary.keySet().iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = (FileObject)iterator.next();
                recognizedFiles.markRecognized(fileObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Entry registerEntry(FileObject fileObject) {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            Entry entry;
            block8: {
                block7: {
                    block6: {
                        if (fileObject != null) break block6;
                        Entry entry2 = this.primary;
                        return entry2;
                    }
                    if (!fileObject.equals(this.getPrimaryFile())) break block7;
                    Entry entry3 = this.primary;
                    return entry3;
                }
                entry = (Entry)this.secondary.get(fileObject);
                if (entry == null) break block8;
                Entry entry4 = entry;
                return entry4;
            }
            entry = this.createSecondaryEntry(this, fileObject);
            this.addSecondaryEntry(entry);
            Entry entry5 = entry;
            return entry5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeFile(FileObject fileObject) {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            Entry entry = (Entry)this.secondary.get(fileObject);
            if (entry != null) {
                this.removeSecondaryEntry(entry);
            }
        }
    }

    public final Entry getPrimaryEntry() {
        return this.primary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set secondaryEntries() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            this.removeAllInvalid();
            HashSet hashSet = new HashSet(this.secondary.values());
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Entry findSecondaryEntry(FileObject fileObject) {
        Entry entry;
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            entry = (Entry)this.secondary.get(fileObject);
        }
        return entry;
    }

    private void removeAllInvalid() {
        Iterator iterator = this.getSecondary().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            FileObject fileObject = (FileObject)entry.getKey();
            if (fileObject.isValid()) continue;
            iterator.remove();
            this.firePropertyChangeLater("files", null, null);
        }
    }

    protected FileLock takePrimaryFileLock() throws IOException {
        return this.getPrimaryEntry().takeLock();
    }

    private String existInFolder(FileObject fileObject, FileObject fileObject2) {
        if (fileObject.isFolder() && this.isMergingFolders()) {
            return "";
        }
        String string = fileObject.getName();
        String string2 = FileUtil.findFreeFileName(fileObject2, string, fileObject.getExt());
        if (string2.length() <= string.length()) {
            return "";
        }
        return string2.substring(string.length());
    }

    boolean isMergingFolders() {
        return false;
    }

    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        String string = this.existInFolder(this.getPrimaryEntry().getFile(), dataFolder.getPrimaryFile());
        if (string == null) {
            throw new UserCancelException();
        }
        FileObject fileObject = this.getPrimaryEntry().copy(dataFolder.getPrimaryFile(), string);
        Iterator iterator = this.secondaryEntries().iterator();
        while (iterator.hasNext()) {
            ((Entry)iterator.next()).copy(dataFolder.getPrimaryFile(), string);
        }
        try {
            return this.createMultiObject(fileObject);
        }
        catch (DataObjectExistsException dataObjectExistsException) {
            return dataObjectExistsException.getDataObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleDelete() throws IOException {
        Map.Entry entry;
        Iterator iterator;
        ArrayList arrayList = new ArrayList();
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            iterator = new ArrayList(this.secondary.entrySet()).iterator();
        }
        while (iterator.hasNext()) {
            entry = iterator.next();
            ((Entry)entry.getValue()).delete();
            arrayList.add(entry.getKey());
        }
        entry = this.synchObjectSecondary();
        synchronized (entry) {
            Object[] objectArray = arrayList.toArray();
            int n = 0;
            while (n < objectArray.length) {
                this.secondary.remove(objectArray[n]);
                ++n;
            }
        }
        this.getPrimaryEntry().delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FileObject handleRename(String string) throws IOException {
        Object[] objectArray;
        Map.Entry entry;
        Iterator iterator;
        this.getPrimaryEntry().changeFile(this.getPrimaryEntry().rename(string));
        HashMap<FileObject, Entry> hashMap = null;
        ArrayList arrayList = new ArrayList();
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            iterator = new ArrayList(this.secondary.entrySet()).iterator();
        }
        while (iterator.hasNext()) {
            entry = iterator.next();
            objectArray = ((Entry)entry.getValue()).rename(string);
            if (objectArray == null) {
                arrayList.add(entry.getKey());
                continue;
            }
            if (objectArray.equals(entry.getKey())) continue;
            if (hashMap == null) {
                hashMap = new HashMap<FileObject, Entry>();
            }
            Entry entry2 = (Entry)entry.getValue();
            entry2.changeFile((FileObject)objectArray);
            hashMap.put(entry2.getFile(), entry2);
            arrayList.add(entry.getKey());
        }
        if (hashMap != null || !arrayList.isEmpty()) {
            entry = this.synchObjectSecondary();
            synchronized (entry) {
                if (!arrayList.isEmpty()) {
                    objectArray = arrayList.toArray();
                    int n = 0;
                    while (n < objectArray.length) {
                        this.secondary.remove(objectArray[n]);
                        ++n;
                    }
                }
                if (hashMap != null) {
                    this.secondary.putAll(hashMap);
                }
            }
            this.firePropertyChangeLater("files", null, null);
        }
        return this.getPrimaryEntry().getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FileObject handleMove(DataFolder dataFolder) throws IOException {
        String string = this.existInFolder(this.getPrimaryEntry().getFile(), dataFolder.getPrimaryFile());
        if (string == null) {
            throw new UserCancelException();
        }
        List list = this.saveEntries();
        try {
            Object[] objectArray;
            Map.Entry entry;
            Iterator iterator;
            this.getPrimaryEntry().changeFile(this.getPrimaryEntry().move(dataFolder.getPrimaryFile(), string));
            HashMap<FileObject, Entry> hashMap = null;
            ArrayList arrayList = new ArrayList();
            Object object = this.synchObjectSecondary();
            synchronized (object) {
                iterator = new ArrayList(this.secondary.entrySet()).iterator();
            }
            while (iterator.hasNext()) {
                entry = iterator.next();
                objectArray = ((Entry)entry.getValue()).move(dataFolder.getPrimaryFile(), string);
                if (objectArray == null) {
                    arrayList.add(entry.getKey());
                    continue;
                }
                if (objectArray.equals(entry.getKey())) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<FileObject, Entry>();
                }
                Entry entry2 = (Entry)entry.getValue();
                entry2.changeFile((FileObject)objectArray);
                hashMap.put(entry2.getFile(), entry2);
                arrayList.add(entry.getKey());
            }
            if (hashMap != null || !arrayList.isEmpty()) {
                entry = this.synchObjectSecondary();
                synchronized (entry) {
                    if (!arrayList.isEmpty()) {
                        objectArray = arrayList.toArray();
                        int n = 0;
                        while (n < objectArray.length) {
                            this.secondary.remove(objectArray[n]);
                            ++n;
                        }
                    }
                    if (hashMap != null) {
                        this.secondary.putAll(hashMap);
                    }
                }
                this.firePropertyChangeLater("files", null, null);
            }
            return this.getPrimaryEntry().getFile();
        }
        catch (IOException iOException) {
            this.restoreEntries(list);
            throw iOException;
        }
    }

    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        if (string == null) {
            string = FileUtil.findFreeFileName(dataFolder.getPrimaryFile(), this.getPrimaryFile().getName(), this.getPrimaryFile().getExt());
        }
        FileObject fileObject = this.getPrimaryEntry().createFromTemplate(dataFolder.getPrimaryFile(), string);
        Iterator iterator = this.secondaryEntries().iterator();
        while (iterator.hasNext()) {
            ((Entry)iterator.next()).createFromTemplate(dataFolder.getPrimaryFile(), string);
        }
        try {
            return this.createMultiObject(fileObject);
        }
        catch (DataObjectExistsException dataObjectExistsException) {
            return dataObjectExistsException.getDataObject();
        }
    }

    protected final void setCookieSet(CookieSet cookieSet) {
        this.setCookieSet(cookieSet, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCookieSet(CookieSet cookieSet, boolean bl) {
        Object object = cookieSetLock;
        synchronized (object) {
            ChangeListener changeListener = (ChangeListener)((Object)this.getPrimaryFileListener());
            if (this.cookieSet != null) {
                this.cookieSet.removeChangeListener(changeListener);
            }
            cookieSet.addChangeListener(changeListener);
            this.cookieSet = cookieSet;
        }
        if (bl) {
            this.fireCookieChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CookieSet getCookieSet() {
        CookieSet cookieSet = this.cookieSet;
        if (cookieSet != null) {
            return cookieSet;
        }
        Object object = cookieSetLock;
        synchronized (object) {
            block5: {
                if (this.cookieSet == null) break block5;
                CookieSet cookieSet2 = this.cookieSet;
                return cookieSet2;
            }
            this.setCookieSet(new CookieSet(), false);
            CookieSet cookieSet3 = this.cookieSet;
            return cookieSet3;
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie;
        CookieSet cookieSet = this.cookieSet;
        if (cookieSet != null && (cookie = cookieSet.getCookie(clazz)) != null) {
            return cookie;
        }
        return super.getCookie(clazz);
    }

    final void fireCookieChange() {
        this.firePropertyChange("cookie", null, null);
    }

    private void firePropertyChangeLater(final String string, final Object object, final Object object2) {
        RequestProcessor.postRequest(new Runnable(){

            public void run() {
                MultiDataObject.this.firePropertyChange(string, object, object2);
            }
        });
    }

    final void recognizedByFolder() {
        this.checked = true;
    }

    final DataObject.PrimaryFileListener createPrimaryFileListener() {
        return new EntryL();
    }

    private final Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            return multiFileLoader.createPrimaryEntry(multiDataObject, fileObject);
        }
        Entry entry = fileObject.isFolder() ? new FileEntry.Folder(multiDataObject, fileObject) : new FileEntry(multiDataObject, fileObject);
        return entry;
    }

    private final Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            return multiFileLoader.createSecondaryEntryImpl(multiDataObject, fileObject);
        }
        Entry entry = fileObject.isFolder() ? new FileEntry.Folder(multiDataObject, fileObject) : new FileEntry(multiDataObject, fileObject);
        return entry;
    }

    private final MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            return multiFileLoader.createMultiObject(fileObject);
        }
        return (MultiDataObject)this.getLoader().findDataObject(fileObject, RECOGNIZER);
    }

    private final void checkConsistency(MultiDataObject multiDataObject) {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            multiFileLoader.checkConsistency(multiDataObject);
        }
    }

    private final void checkFiles(MultiDataObject multiDataObject) {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            multiFileLoader.checkFiles(multiDataObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List saveEntries() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            Serializable serializable;
            LinkedList<Pair> linkedList = new LinkedList<Pair>();
            Iterator iterator = this.secondaryEntries().iterator();
            linkedList.add(new Pair(this.getPrimaryEntry()));
            while (iterator.hasNext()) {
                serializable = (Entry)iterator.next();
                linkedList.add(new Pair((Entry)serializable));
            }
            serializable = linkedList;
            return serializable;
        }
    }

    final void restoreEntries(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (pair.entry.getFile().equals(pair.file)) continue;
            if (pair.file.isValid()) {
                pair.entry.changeFile(pair.file);
                continue;
            }
            try {
                if (pair.entry.getFile().isData()) {
                    pair.entry.changeFile(pair.entry.getFile().copy(pair.file.getParent(), pair.file.getName(), pair.file.getExt()));
                    continue;
                }
                FileObject fileObject = pair.file.getParent().createFolder(pair.file.getName());
                FileUtil.copyAttributes(pair.entry.getFile(), fileObject);
                pair.entry.changeFile(fileObject);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final class EntryReplace
    implements Serializable {
        static final long serialVersionUID = -1498798537289529182L;
        private FileObject file;
        private transient Entry entry;

        public EntryReplace(FileObject fileObject) {
            this.file = fileObject;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            try {
                DataObject dataObject = DataObject.find(this.file);
                if (dataObject instanceof MultiDataObject) {
                    MultiDataObject multiDataObject = (MultiDataObject)dataObject;
                    if (this.file.equals(multiDataObject.getPrimaryFile())) {
                        this.entry = multiDataObject.getPrimaryEntry();
                    } else {
                        Entry entry = multiDataObject.findSecondaryEntry(this.file);
                        if (entry == null) {
                            throw new InvalidObjectException(dataObject.toString());
                        }
                        this.entry = entry;
                    }
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                throw new InvalidObjectException(dataObjectNotFoundException.getMessage());
            }
        }

        public Object readResolve() {
            return this.entry;
        }
    }

    private class EntryL
    extends DataObject.PrimaryFileListener
    implements ChangeListener {
        private EntryL() {
        }

        public void fileDeleted(FileEvent fileEvent) {
            MultiDataObject.this.removeFile(fileEvent.getFile());
            if (fileEvent.getFile().equals(MultiDataObject.this.getPrimaryFile())) {
                try {
                    MultiDataObject.this.setValid(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    TopManager.getDefault().getErrorManager().notify(1, propertyVetoException);
                }
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MultiDataObject.this.fireCookieChange();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            MultiDataObject.this.checked = false;
        }
    }

    public abstract class Entry
    implements Serializable {
        static final long serialVersionUID = 6024795908818133571L;
        private FileObject file;
        private transient WeakReference lock;

        protected Entry(FileObject fileObject) {
            this.changeFile(fileObject);
        }

        final void changeFile(FileObject fileObject) {
            FileLock fileLock;
            if (fileObject.equals(this.file)) {
                return;
            }
            fileObject.setImportant(this.isImportant());
            this.file = fileObject;
            FileLock fileLock2 = fileLock = this.lock == null ? null : (FileLock)this.lock.get();
            if (fileLock != null && fileLock.isValid()) {
                fileLock.releaseLock();
            }
            this.lock = null;
        }

        public final FileObject getFile() {
            return this.file;
        }

        public final MultiDataObject getDataObject() {
            return MultiDataObject.this;
        }

        public boolean isImportant() {
            return true;
        }

        public abstract FileObject copy(FileObject var1, String var2) throws IOException;

        public abstract FileObject rename(String var1) throws IOException;

        public abstract FileObject move(FileObject var1, String var2) throws IOException;

        public abstract void delete() throws IOException;

        public abstract FileObject createFromTemplate(FileObject var1, String var2) throws IOException;

        public FileLock takeLock() throws IOException {
            FileLock fileLock;
            FileLock fileLock2 = fileLock = this.lock == null ? null : (FileLock)this.lock.get();
            if (fileLock == null || !fileLock.isValid()) {
                fileLock = this.getFile().lock();
                this.lock = new WeakReference<FileLock>(fileLock);
            }
            return fileLock;
        }

        public boolean isLocked() {
            FileLock fileLock = this.lock == null ? null : (FileLock)this.lock.get();
            return fileLock != null && fileLock.isValid();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            return this.getFile().equals(((Entry)object).getFile());
        }

        public int hashCode() {
            return this.getFile().hashCode();
        }

        protected Object writeReplace() {
            return new EntryReplace(this.getFile());
        }
    }

    private static final class Pair {
        Entry entry;
        FileObject file;

        Pair(Entry entry) {
            this.entry = entry;
            this.file = entry.getFile();
        }
    }

    private static class EmptyRecognizer
    implements DataLoader.RecognizedFiles {
        private EmptyRecognizer() {
        }

        public void markRecognized(FileObject fileObject) {
        }
    }
}

